/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.a.a.a;
import com.a.c.r;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.ConfigUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digest {
    public static final String DIGEST_FILE = "digest.txt";
    protected HashMap<String, String> _digests = new HashMap();
    protected String _metaDigest = "";

    public Digest(File object) throws IOException {
        Object[] objectArray2;
        StringBuilder stringBuilder = new StringBuilder();
        object = new File((File)object, DIGEST_FILE);
        for (Object[] objectArray2 : ConfigUtil.parsePairs((File)object, false)) {
            if (objectArray2[0].equals(DIGEST_FILE)) {
                this._metaDigest = objectArray2[1];
                break;
            }
            this._digests.put(objectArray2[0], objectArray2[1]);
            Digest.note(stringBuilder, objectArray2[0], objectArray2[1]);
        }
        object = Digest.getMessageDigest();
        objectArray2 = stringBuilder.toString().getBytes("UTF-8");
        if (!((String)(object = r.a(((MessageDigest)object).digest((byte[])objectArray2)))).equals(this._metaDigest)) {
            object = a.b("m.invalid_digest_file", new String[]{this._metaDigest, object});
            throw new IOException((String)object);
        }
    }

    public String getMetaDigest() {
        return this._metaDigest;
    }

    public boolean validateResource(Resource resource, ProgressObserver object) {
        try {
            object = resource.computeDigest(Digest.getMessageDigest(), (ProgressObserver)object);
            String string = this._digests.get(resource.getPath());
            if (((String)object).equals(string)) {
                return true;
            }
            Log.log.a("Resource failed digest check", "rsrc", resource, "computed", object, "expected", string);
        }
        catch (Throwable throwable) {
            Log.log.a("Resource failed digest check", "rsrc", resource, "error", throwable);
        }
        return false;
    }

    public static void createDigest(List<Resource> object, File object2) throws IOException {
        MessageDigest messageDigest = Digest.getMessageDigest();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), "UTF-8"));
        object = object.iterator();
        while (object.hasNext()) {
            Resource resource = (Resource)object.next();
            String string = resource.getPath();
            try {
                String string2 = resource.computeDigest(messageDigest, null);
                Digest.note(stringBuilder, string, string2);
                ((PrintWriter)object2).println(string + " = " + string2);
            }
            catch (Throwable throwable) {
                throw (IOException)new IOException("Error computing digest for: " + resource).initCause(throwable);
            }
        }
        messageDigest.reset();
        object = stringBuilder.toString().getBytes("UTF-8");
        ((PrintWriter)object2).println("digest.txt = " + r.a(messageDigest.digest((byte[])object)));
        ((PrintWriter)object2).close();
    }

    public static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("JVM does not support MD5. Gurp!");
        }
    }

    protected static void note(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append(" = ").append(string2).append("\n");
    }
}

