/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.a.a.a;
import com.a.c.r;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.b;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Resource {
    protected String _path;
    protected URL _remote;
    protected File _local;
    protected File _marker;
    protected boolean _unpack;
    protected static final Comparator<JarEntry> ENTRY_COMP = new b();
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    public Resource(String string, URL uRL, File file, boolean bl) {
        this._path = string;
        this._remote = uRL;
        this._local = file;
        this._marker = new File(this._local.getPath() + "v");
        this._unpack = bl;
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._unpack;
    }

    public String computeDigest(MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        return Resource.computeDigest(this._local, messageDigest, progressObserver);
    }

    public boolean isMarkedValid() {
        if (!this._local.exists()) {
            this.clearMarker();
            return false;
        }
        return this._marker.exists();
    }

    public void markAsValid() throws IOException {
        this._marker.createNewFile();
    }

    public void clearMarker() {
        if (this._marker.exists() && !this._marker.delete()) {
            Log.log.b("Failed to erase marker file '" + this._marker + "'.", new Object[0]);
        }
    }

    public boolean unpack() {
        if (!this._local.getPath().endsWith(".jar")) {
            Log.log.b("Requested to unpack non-jar file '" + this._local + "'.", new Object[0]);
            return false;
        }
        try {
            return a.a(new JarFile(this._local), this._local.getParentFile());
        }
        catch (IOException iOException) {
            Log.log.b("Failed to create JarFile from '" + this._local + "': " + iOException, new Object[0]);
            return false;
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !this._local.delete()) {
            Log.log.b("Failed to erase resource '" + this._local + "'.", new Object[0]);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            return this._path.equals(((Resource)object)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    public static String computeDigest(File file, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        messageDigest.reset();
        byte[] byArray = new byte[5125];
        if (file.getPath().endsWith(".jar")) {
            JarFile jarFile = new JarFile(file);
            try {
                ArrayList<JarEntry> arrayList = Collections.list(jarFile.entries());
                Collections.sort(arrayList, ENTRY_COMP);
                for (JarEntry jarEntry : arrayList) {
                    if (jarEntry.getName().startsWith("META-INF")) {
                        Resource.updateProgress(progressObserver, 0L, arrayList.size());
                        continue;
                    }
                    InputStream inputStream = null;
                    try {
                        int n2;
                        inputStream = jarFile.getInputStream(jarEntry);
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            messageDigest.update(byArray, 0, n2);
                        }
                    }
                    finally {
                        a.a(inputStream);
                    }
                    Resource.updateProgress(progressObserver, 0L, arrayList.size());
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Log.log.b("Error closing jar [path=" + file + ", error=" + iOException + "].", new Object[0]);
                }
            }
        }
        long l2 = file.length();
        long l3 = 0L;
        FileInputStream fileInputStream = null;
        try {
            int n3;
            fileInputStream = new FileInputStream(file);
            while ((n3 = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n3);
                Resource.updateProgress(progressObserver, l3 += (long)n3, l2);
            }
        }
        catch (Throwable throwable) {
            a.a(fileInputStream);
            throw throwable;
        }
        a.a(fileInputStream);
        return r.a(messageDigest.digest());
    }

    protected static void updateProgress(ProgressObserver progressObserver, long l2, long l3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(100L * l2 / l3));
        }
    }
}

