/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.a.c.q;
import com.a.c.r;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.AbortPanel;
import com.threerings.getdown.launcher.GetdownApp;
import com.threerings.getdown.launcher.ImageLoader;
import com.threerings.getdown.launcher.MultipleGetdownRunning;
import com.threerings.getdown.launcher.ProxyPanel;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.launcher.StatusPanel;
import com.threerings.getdown.launcher.a;
import com.threerings.getdown.launcher.b;
import com.threerings.getdown.launcher.c;
import com.threerings.getdown.launcher.d;
import com.threerings.getdown.launcher.e;
import com.threerings.getdown.launcher.i;
import com.threerings.getdown.launcher.j;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.net.HTTPDownloader;
import com.threerings.getdown.tools.Patcher;
import com.threerings.getdown.util.ConfigUtil;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MetaProgressObserver;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Getdown
extends Thread
implements Application.StatusDisplay,
ImageLoader {
    protected ProgressObserver _progobs = new j(this);
    protected Application _app;
    protected Application.UpdateInterface _ifc = new Application.UpdateInterface();
    protected ResourceBundle _msgs;
    protected Container _container;
    protected JLayeredPane _layers;
    protected StatusPanel _status;
    protected JButton _patchNotes;
    protected JButton _playAgain;
    protected AbortPanel _abort;
    protected RotatingBackgrounds _background;
    protected boolean _dead;
    protected boolean _silent;
    protected boolean _launchInSilent;
    protected long _startup;
    protected boolean _enableTracking = true;
    protected int _reportedProgress = 0;
    protected int _delay;
    protected int _stepMaxPercent;
    protected int _stepMinPercent;
    protected int _lastGlobalPercent;
    protected int _uiDisplayPercent;
    protected static final int MAX_LOOPS = 5;
    protected static final long MIN_EXIST_TIME = 5000L;
    protected static final long FALLBACK_CHECK_TIME = 1000L;
    protected static final long PLAY_AGAIN_TIME = 3000L;
    protected static final String PROXY_REGISTRY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";

    public static void main(String[] stringArray) {
        GetdownApp.main(stringArray);
    }

    public Getdown(File file, String string) {
        this(file, string, null, null, null);
    }

    public Getdown(File file, String string, List<Certificate> list, String[] stringArray, String[] stringArray2) {
        super("Getdown");
        try {
            this._silent = SysProps.silent();
            if (this._silent) {
                this._launchInSilent = SysProps.launchInSilent();
            }
            this._delay = SysProps.startDelay();
        }
        catch (SecurityException securityException) {}
        try {
            this._msgs = ResourceBundle.getBundle("com.threerings.getdown.messages");
        }
        catch (Exception exception) {
            String string2 = file.toString();
            if (string2.equals(".")) {
                string2 = System.getProperty("user.dir");
            }
            String string3 = "The directory in which this application is installed:\n" + string2 + "\nis invalid (" + exception.getMessage() + "). If the full path to the app directory contains the '!' character, this will trigger this error.";
            this.fail(string3);
        }
        this._app = new Application(file, string, list, stringArray, stringArray2);
        this._startup = System.currentTimeMillis();
    }

    public void preInit() {
        try {
            this._ifc = this._app.init(true);
            this.createInterface(true);
            return;
        }
        catch (Exception exception) {
            Log.log.b("Failed to preinit: " + exception, new Object[0]);
            this.createInterface(true);
            return;
        }
    }

    @Override
    public void run() {
        block10: {
            if (this._msgs == null) {
                return;
            }
            Object object = this._app.getLocalPath("");
            if (!((File)object).canWrite()) {
                if (((String)(object = ((File)object).getPath())).equals(".")) {
                    object = System.getProperty("user.dir");
                }
                this.fail(com.a.a.a.b("m.readonly_error", new String[]{object}));
                return;
            }
            try {
                this._dead = false;
                if (this.detectProxy()) {
                    this.getdown();
                    break block10;
                }
                if (this._silent) {
                    Log.log.b("Need a proxy, but we don't want to bother anyone.  Exiting.", new Object[0]);
                    break block10;
                }
                this._container = this.createContainer();
                this._container.add((Component)new ProxyPanel(this, this._msgs), "Center");
                this.showContainer();
                this._dead = true;
                return;
            }
            catch (Exception exception) {
                Log.log.b("run() failed.", exception);
                String string = exception.getMessage();
                if (string == null) {
                    string = com.a.a.a.a("m.unknown_error", this._ifc.installError);
                } else if (!string.startsWith("m.")) {
                    string = exception instanceof FileNotFoundException ? com.a.a.a.a("m.missing_resource", com.a.a.a.a((Object)string), this._ifc.installError) : com.a.a.a.a("m.init_error", com.a.a.a.a((Object)string), this._ifc.installError);
                }
                this.fail(string);
            }
        }
    }

    public void configureProxy(String string, String string2) {
        Log.log.a("User configured proxy", "host", string, "port", string2);
        if (!r.a(string)) {
            File file = this._app.getLocalPath("proxy.txt");
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(file));
                printStream.println("host = " + string);
                if (!r.a(string2)) {
                    printStream.println("port = " + string2);
                }
                printStream.close();
            }
            catch (IOException iOException) {
                Log.log.b("Error creating proxy file '" + file + "': " + iOException, new Object[0]);
            }
            this.setProxyProperties(string, string2);
        }
        this.disposeContainer();
        this._status = null;
        new Thread(this).start();
    }

    protected boolean detectProxy() {
        Object object;
        Object object2;
        Object object3;
        if (System.getProperty("http.proxyHost") != null) {
            return true;
        }
        if (q.a()) {
            try {
                object3 = null;
                object2 = null;
                boolean bl = false;
                RegistryKey.initialize();
                object = new RegistryKey(RootKey.HKEY_CURRENT_USER, PROXY_REGISTRY);
                object = ((RegistryKey)object).values();
                while (object.hasNext()) {
                    RegistryValue registryValue = (RegistryValue)object.next();
                    if (registryValue.getName().equals("ProxyEnable")) {
                        bl = registryValue.getStringValue().equals("1");
                    }
                    if (!registryValue.getName().equals("ProxyServer")) continue;
                    object3 = registryValue.getStringValue();
                    int n2 = ((String)object3).indexOf(":");
                    if (n2 == -1) continue;
                    object2 = ((String)object3).substring(n2 + 1);
                    object3 = ((String)object3).substring(0, n2);
                }
                if (bl) {
                    this.setProxyProperties((String)object3, (String)object2);
                    return true;
                }
                Log.log.a("Detected no proxy settings in the registry.", new Object[0]);
            }
            catch (Throwable throwable) {
                Log.log.a("Failed to find proxy settings in Windows registry", "error", throwable);
            }
        }
        if (((File)(object3 = this._app.getLocalPath("proxy.txt"))).exists()) {
            try {
                object2 = ConfigUtil.parseConfig((File)object3, false);
                this.setProxyProperties((String)object2.get("host"), (String)object2.get("port"));
                return true;
            }
            catch (IOException iOException) {
                Log.log.b("Failed to read '" + object3 + "': " + iOException, new Object[0]);
            }
        }
        Log.log.a("Checking whether we need to use a proxy...", new Object[0]);
        try {
            this._ifc = this._app.init(true);
        }
        catch (IOException iOException) {}
        this.updateStatus("m.detecting_proxy");
        object2 = this._app.getConfigResource().getRemote();
        try {
            URLConnection uRLConnection = ConnectionUtil.open((URL)object2);
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                try {
                    ((HttpURLConnection)object).setRequestMethod("HEAD");
                    ((URLConnection)object).connect();
                    if (((HttpURLConnection)object).getResponseCode() != 200) {
                        Log.log.b("Got a non-200 response but assuming we're OK because we got something...", "url", object2, "rsp", ((HttpURLConnection)object).getResponseCode());
                    }
                }
                finally {
                    ((HttpURLConnection)object).disconnect();
                }
            }
            Log.log.a("No proxy appears to be needed.", new Object[0]);
            try {
                ((File)object3).createNewFile();
            }
            catch (IOException iOException) {
                Log.log.b("Failed to create blank proxy file '" + object3 + "': " + iOException, new Object[0]);
            }
            return true;
        }
        catch (IOException iOException) {
            Log.log.a("Failed to HEAD " + object2 + ": " + iOException, new Object[0]);
            Log.log.a("We probably need a proxy, but auto-detection failed.", new Object[0]);
            return false;
        }
    }

    protected void setProxyProperties(String string, String string2) {
        if (!r.a(string)) {
            System.setProperty("http.proxyHost", string);
            if (!r.a(string2)) {
                System.setProperty("http.proxyPort", string2);
            }
            Log.log.a("Using proxy", "host", string, "port", string2);
        }
    }

    protected void getdown() {
        Log.log.a("---------------- Proxy Info -----------------", new Object[0]);
        Log.log.a("-- Proxy Host: " + System.getProperty("http.proxyHost"), new Object[0]);
        Log.log.a("-- Proxy Port: " + System.getProperty("http.proxyPort"), new Object[0]);
        Log.log.a("---------------------------------------------", new Object[0]);
        try {
            try {
                this._ifc = this._app.init(true);
            }
            catch (IOException iOException) {
                Log.log.b("Failed to parse 'getdown.txt': " + iOException, new Object[0]);
                this._app.attemptRecovery(this);
                this._ifc = this._app.init(true);
                this.createInterface(true);
            }
            if (!this._app.lockForUpdates()) {
                throw new MultipleGetdownRunning();
            }
            File file = this._app.getLocalPath("getdown.txt");
            if (!file.setLastModified(System.currentTimeMillis())) {
                Log.log.b("Unable to set modtime on config file, will be unable to check for another instance of getdown running while this one waits.", new Object[0]);
            }
            if (this._delay > 0) {
                this._app.releaseLock();
                long l2 = file.lastModified();
                Log.log.a("Waiting " + this._delay + " minutes before beginning actual work.", new Object[0]);
                Thread.sleep(this._delay * 60 * 1000);
                if (l2 < file.lastModified()) {
                    Log.log.b("getdown.txt was modified while getdown was waiting.", new Object[0]);
                    throw new MultipleGetdownRunning();
                }
            }
            int[] nArray = new int[1];
            HashSet<Resource> hashSet = new HashSet<Resource>();
            for (int i2 = 0; i2 < 5; ++i2) {
                if (!this._app.haveValidJavaVersion()) {
                    Log.log.a("Attempting to update Java VM...", new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.UPDATE_JAVA);
                    this._enableTracking = true;
                    try {
                        this.updateJava();
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_METADATA);
                this.setStatus("m.validating", -1, -1L, false);
                if (this._app.verifyMetadata(this)) {
                    Log.log.a("Application requires update.", new Object[0]);
                    this.update();
                    continue;
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_RESOURCES);
                this.setStatus("m.validating", -1, -1L, false);
                List<Resource> list = this._app.verifyResources(this._progobs, nArray, hashSet);
                if (list == null) {
                    Log.log.a("Resources verified.", new Object[0]);
                    if (Boolean.getBoolean("check_unpacked")) {
                        File file2 = this._app.getLocalPath("unpacked.dat");
                        long l3 = -1L;
                        long l4 = this._app.getVersion();
                        if (!file2.exists()) {
                            file2.createNewFile();
                        } else {
                            l3 = VersionUtil.readVersion(file2);
                        }
                        if (l3 < l4) {
                            Log.log.a("Performing unpack.", "version", l3, "aversion", l4);
                            this.setStep(Application.UpdateInterface.Step.UNPACK);
                            this.updateStatus("m.validating");
                            this._app.unpackResources(this._progobs, hashSet);
                            try {
                                VersionUtil.writeVersion(file2, l4);
                            }
                            catch (IOException iOException) {
                                Log.log.b("Failed to update unpacked version", iOException);
                            }
                        }
                    }
                    if (!this._silent || this._launchInSilent) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException("m.applet_stopped");
                        }
                        this._app.lockForUpdates();
                        this.launch();
                    }
                    return;
                }
                try {
                    this._enableTracking = nArray[0] == 0;
                    this.reportTrackingEvent("app_start", -1);
                    Log.log.a(list.size() + " of " + this._app.getAllActiveResources().size() + " rsrcs require update (" + nArray[0] + " assumed valid).", new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.REDOWNLOAD_RESOURCES);
                    this.download(list);
                    this.reportTrackingEvent("app_complete", -1);
                    continue;
                }
                finally {
                    this._enableTracking = false;
                }
            }
            Log.log.b("Pants! We couldn't get the job done.", new Object[0]);
            throw new IOException("m.unable_to_repair");
        }
        catch (Exception exception) {
            Log.log.b("getdown() failed.", exception);
            String string = exception.getMessage();
            if (string == null) {
                string = com.a.a.a.a("m.unknown_error", this._ifc.installError);
            } else if (!string.startsWith("m.")) {
                string = exception instanceof FileNotFoundException ? com.a.a.a.a("m.missing_resource", com.a.a.a.a((Object)string), this._ifc.installError) : com.a.a.a.a("m.init_error", com.a.a.a.a((Object)string), this._ifc.installError);
            }
            this.fail(string);
            this._app.releaseLock();
            return;
        }
    }

    @Override
    public void updateStatus(String string) {
        this.setStatus(string, -1, -1L, true);
    }

    @Override
    public BufferedImage loadImage(String string) {
        if (r.a(string)) {
            return null;
        }
        File file = null;
        try {
            String string2 = Locale.getDefault().getLanguage();
            file = this._app.getLocalPath(string.replace(".", "_" + string2 + "."));
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
            try {
                file = this._app.getLocalPath(string);
                return ImageIO.read(file);
            }
            catch (IOException iOException2) {
                Log.log.b("Failed to load image", "path", file, "error", iOException2);
                return null;
            }
        }
    }

    protected void updateJava() throws IOException, InterruptedException {
        Object object = this._app.getJavaVMResource();
        if (object == null) {
            throw new IOException("m.java_download_failed");
        }
        this.reportTrackingEvent("jvm_start", -1);
        this.updateStatus("m.downloading_java");
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.add((Resource)object);
        this.download(arrayList);
        this.reportTrackingEvent("jvm_unpack", -1);
        this.updateStatus("m.unpacking_java");
        if (!((Resource)object).unpack()) {
            throw new IOException("m.java_unpack_failed");
        }
        ((Resource)object).markAsValid();
        if (!q.a()) {
            object = "java_vm" + File.separator + "bin" + File.separator + "java";
            object = "chmod a+rx " + this._app.getLocalPath((String)object);
            try {
                Log.log.a("Please smack a Java engineer. Running: " + (String)object, new Object[0]);
                Runtime.getRuntime().exec((String)object);
            }
            catch (Exception exception) {
                Log.log.b("Failed to mark VM binary as executable", "cmd", object, "error", exception);
            }
        }
        object = LaunchUtil.getJVMPath(this._app.getLocalPath(""));
        try {
            Log.log.a("Regenerating classes.jsa for " + (String)object + "...", new Object[0]);
            Runtime.getRuntime().exec((String)object + " -Xshare:dump");
        }
        catch (Exception exception) {
            Log.log.b("Failed to regenerate .jsa dum file", "error", exception);
        }
        this.reportTrackingEvent("jvm_complete", -1);
    }

    protected void update() throws IOException, InterruptedException {
        this._app.clearValidationMarkers();
        Resource iterator2 = this._app.getPatchResource(null);
        if (iterator2 != null) {
            Object object = new ArrayList<Resource>();
            object.add(iterator2);
            for (Application.AuxGroup auxGroup : this._app.getAuxGroups()) {
                Resource resource;
                if (!this._app.isAuxGroupActive(auxGroup.name) || (resource = this._app.getPatchResource(auxGroup.name)) == null) continue;
                object.add((Resource)resource);
            }
            if (!r.a(this._ifc.patchNotesUrl)) {
                this.createInterface(false);
                EventQueue.invokeLater(new a(this));
            }
            this.setStep(Application.UpdateInterface.Step.DOWNLOAD);
            this.download((List<Resource>)object);
            this.setStep(Application.UpdateInterface.Step.PATCH);
            this.updateStatus("m.patching");
            MetaProgressObserver metaProgressObserver = new MetaProgressObserver(this._progobs, object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (Resource)iterator.next();
                metaProgressObserver.startElement(1L);
                try {
                    Patcher patcher = new Patcher();
                    patcher.patch(((Resource)object).getLocal().getParentFile(), ((Resource)object).getLocal(), metaProgressObserver);
                }
                catch (Exception exception) {
                    Log.log.b("Failed to apply patch", "prsrc", object, exception);
                }
                if (((Resource)object).getLocal().delete()) continue;
                Log.log.b("Failed to delete '" + object + "'.", new Object[0]);
                ((Resource)object).getLocal().deleteOnExit();
            }
        }
        this._app.updateMetadata();
        this._ifc = this._app.init(true);
    }

    protected void download(List<Resource> object) throws IOException, InterruptedException {
        this.createInterface(false);
        b b2 = new b(this);
        object = new HTTPDownloader((List<Resource>)object, b2);
        if (!((Downloader)object).download()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("m.applet_stopped");
            }
            throw new MultipleGetdownRunning();
        }
    }

    protected void launch() {
        this.setStep(Application.UpdateInterface.Step.LAUNCH);
        this.setStatus("m.launching", this.stepToGlobalPercent(100), -1L, false);
        try {
            Object object;
            if (this.invokeDirect()) {
                this.disposeContainer();
                this._app.releaseLock();
                this._app.invokeDirect(this.getApplet());
            } else {
                Process process;
                if (this._app.hasOptimumJvmArgs()) {
                    process = this._app.createProcess(true);
                    long l2 = System.currentTimeMillis() + 1000L;
                    boolean bl = false;
                    while (l2 > System.currentTimeMillis()) {
                        try {
                            bl = process.exitValue() != 0;
                            break;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            Thread.yield();
                        }
                    }
                    if (bl) {
                        Log.log.a("Failed to launch with optimum arguments; falling back.", new Object[0]);
                        process = this._app.createProcess(false);
                    }
                } else {
                    process = this._app.createProcess(false);
                }
                process.getInputStream().close();
                process.getOutputStream().close();
                InputStream inputStream = process.getErrorStream();
                if (LaunchUtil.mustMonitorChildren()) {
                    this.disposeContainer();
                    this._status = null;
                    Getdown.copyStream(inputStream, System.err);
                    Log.log.a("Process exited: " + process.waitFor(), new Object[0]);
                } else {
                    object = new c(this, inputStream);
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).start();
                }
            }
            long l3 = System.currentTimeMillis() - this._startup;
            if (this._container != null && l3 < 5000L) {
                try {
                    Thread.sleep(5000L - l3);
                }
                catch (Exception exception) {}
            }
            this.setStatus(null, 100, -1L, false);
            this.exit(0);
            if (this._playAgain != null && this._playAgain.isEnabled()) {
                object = new Timer("playAgain", true);
                ((Timer)object).schedule((TimerTask)new d(this), 3000L);
            }
            return;
        }
        catch (Exception exception) {
            Log.log.b("launch() failed.", exception);
            return;
        }
    }

    protected void createInterface(boolean bl) {
        if (this._silent || this._container != null && !bl) {
            return;
        }
        EventQueue.invokeLater(new e(this, bl));
    }

    protected void initInterface() {
        Object object = this.getBackground();
        if (this._background == null || ((RotatingBackgrounds)object).getNumImages() > 0) {
            this._background = object;
        }
        this._status.init(this._ifc, this._background, this.getProgressImage());
        object = this._status.getPreferredSize();
        this._status.setSize((Dimension)object);
        this._layers.setPreferredSize((Dimension)object);
        this._patchNotes.setBounds(this._ifc.patchNotes);
        this._patchNotes.setVisible(false);
        this.initPlayAgain();
        this._uiDisplayPercent = this._lastGlobalPercent;
        this._lastGlobalPercent = 0;
        this._stepMinPercent = 0;
    }

    protected void initPlayAgain() {
        if (this._playAgain != null) {
            BufferedImage bufferedImage = this.loadImage(this._ifc.playAgainImage);
            boolean bl = bufferedImage != null;
            if (bl) {
                this._playAgain.setIcon(new ImageIcon(bufferedImage));
                this._playAgain.setText("");
            } else {
                this._playAgain.setText(this._msgs.getString("m.play_again"));
                this._playAgain.setIcon(null);
            }
            this._playAgain.setBorderPainted(!bl);
            this._playAgain.setOpaque(!bl);
            this._playAgain.setContentAreaFilled(!bl);
            if (this._ifc.playAgain != null) {
                this._playAgain.setBounds(this._ifc.playAgain);
                this._playAgain.setEnabled(true);
            }
            this._playAgain.setVisible(false);
        }
    }

    protected RotatingBackgrounds getBackground() {
        if (this._ifc.rotatingBackgrounds != null) {
            if (this._ifc.backgroundImage != null) {
                Log.log.b("ui.background_image and ui.rotating_background were both specified. The rotating images are being used.", new Object[0]);
            }
            return new RotatingBackgrounds(this._ifc.rotatingBackgrounds, this._ifc.errorBackground, this);
        }
        if (this._ifc.backgroundImage != null) {
            return new RotatingBackgrounds(this.loadImage(this._ifc.backgroundImage));
        }
        return new RotatingBackgrounds();
    }

    protected Image getProgressImage() {
        return this.loadImage(this._ifc.progressImage);
    }

    protected void handleWindowClose() {
        if (this._dead) {
            this.exit(0);
            return;
        }
        if (this._abort == null) {
            this._abort = new AbortPanel(this, this._msgs);
        }
        this._abort.pack();
        com.a.b.a.a.a(this._abort);
        this._abort.setVisible(true);
        this._abort.setState(0);
        this._abort.requestFocus();
    }

    protected void fail(String string) {
        this._dead = true;
        this.setStatus(string, this.stepToGlobalPercent(0), -1L, true);
    }

    protected void setStep(Application.UpdateInterface.Step object) {
        int n2 = -1;
        for (Integer n3 : this._ifc.stepPercentages.get(object)) {
            if (n3 <= this._stepMaxPercent) continue;
            n2 = n3;
            break;
        }
        if (n2 == -1) {
            return;
        }
        this._stepMaxPercent = n2;
        this._stepMinPercent = this._lastGlobalPercent;
    }

    protected int stepToGlobalPercent(int n2) {
        int n3 = (this._stepMaxPercent - this._uiDisplayPercent) * 100 / (100 - this._uiDisplayPercent);
        this._lastGlobalPercent = Math.max(this._lastGlobalPercent, this._stepMinPercent + n2 * (n3 - this._stepMinPercent) / 100);
        return this._lastGlobalPercent;
    }

    protected void setStatus(String string, int n2, long l2, boolean bl) {
        if (this._status == null && bl) {
            this.createInterface(false);
        }
        EventQueue.invokeLater(new i(this, string, n2, l2));
    }

    protected void reportTrackingEvent(String object, int n2) {
        if (!this._enableTracking) {
            return;
        }
        if (n2 > 0) {
            do {
                if ((object = this._app.getTrackingProgressURL(++this._reportedProgress)) == null) continue;
                new ProgressReporter((URL)object).start();
            } while (this._reportedProgress <= n2);
            return;
        }
        if ((object = this._app.getTrackingURL((String)object)) != null) {
            new ProgressReporter((URL)object).start();
        }
    }

    protected abstract Container createContainer();

    protected abstract void showContainer();

    protected abstract void disposeContainer();

    protected boolean invokeDirect() {
        return SysProps.direct();
    }

    protected JApplet getApplet() {
        return null;
    }

    protected abstract void showDocument(String var1);

    protected abstract void exit(int var1);

    protected static void copyStream(InputStream inputStream, PrintStream printStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                printStream.print(string);
                printStream.flush();
            }
            return;
        }
        catch (IOException iOException) {
            Log.log.b("Failure copying", "in", inputStream, "out", printStream, "error", iOException);
            return;
        }
    }

    public class ProgressReporter
    extends Thread {
        protected URL _url;

        public ProgressReporter(URL uRL) {
            this.setDaemon(true);
            this._url = uRL;
        }

        public void run() {
            try {
                String string;
                HttpURLConnection httpURLConnection = ConnectionUtil.openHttp(this._url);
                if (Getdown.this._app.getTrackingCookieName() != null && Getdown.this._app.getTrackingCookieProperty() != null && (string = System.getProperty(Getdown.this._app.getTrackingCookieProperty())) != null) {
                    httpURLConnection.setRequestProperty("Cookie", Getdown.this._app.getTrackingCookieName() + "=" + string);
                }
                httpURLConnection.connect();
                try {
                    if (httpURLConnection.getResponseCode() != 200) {
                        Log.log.b("Failed to report tracking event", "url", this._url, "rcode", httpURLConnection.getResponseCode());
                    }
                }
                finally {
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                Log.log.b("Failed to report tracking event", "url", this._url, "error", iOException);
            }
        }
    }
}

