/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.JarDiffCodes;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarDiffPatcher
implements JarDiffCodes {
    protected static final int DEFAULT_READ_SIZE = 2048;
    protected static byte[] newBytes = new byte[2048];
    protected static byte[] oldBytes = new byte[2048];

    public void patchJar(String object, String object2, OutputStream outputStream, ProgressObserver progressObserver) throws IOException {
        int n2;
        object = new File((String)object);
        object2 = new File((String)object2);
        outputStream = new JarOutputStream(outputStream);
        object = new JarFile((File)object);
        object2 = new JarFile((File)object2);
        Object object3 = new HashSet<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.determineNameMapping((JarFile)object2, (Set<String>)object3, (Map<String, String>)hashMap);
        Object object4 = hashMap.keySet().toArray(new String[hashMap.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        Object object5 = ((JarFile)object).entries();
        if (object5 != null) {
            while (object5.hasMoreElements()) {
                hashSet.add(object5.nextElement().getName());
            }
        }
        double d2 = hashSet.size() + ((String[])object4).length + ((ZipFile)object2).size();
        double d3 = 0.0;
        hashSet.removeAll((Collection<?>)object3);
        d2 -= (double)object3.size();
        object3 = ((JarFile)object2).entries();
        if (object3 != null) {
            while (object3.hasMoreElements()) {
                object5 = (JarEntry)object3.nextElement();
                if (!"META-INF/INDEX.JD".equals(((ZipEntry)object5).getName())) {
                    this.updateObserver(progressObserver, d3, d2);
                    d3 += 1.0;
                    this.writeEntry((JarOutputStream)outputStream, (JarEntry)object5, (JarFile)object2);
                    boolean bl = hashSet.remove(((ZipEntry)object5).getName());
                    n2 = bl ? 1 : 0;
                    if (!bl) continue;
                    d2 -= 1.0;
                    continue;
                }
                d2 -= 1.0;
            }
        }
        object5 = object4;
        n2 = ((String[])object4).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object3 = object5[i2];
            object4 = (String)hashMap.get(object3);
            JarEntry jarEntry = ((JarFile)object).getJarEntry((String)object4);
            if (jarEntry == null) {
                object3 = "move" + (String)object4 + " " + (String)object3;
                throw new IOException("error.badmove: " + (String)object3);
            }
            object3 = new JarEntry((String)object3);
            ((ZipEntry)object3).setTime(jarEntry.getTime());
            ((ZipEntry)object3).setSize(jarEntry.getSize());
            ((ZipEntry)object3).setCompressedSize(jarEntry.getCompressedSize());
            ((ZipEntry)object3).setCrc(jarEntry.getCrc());
            ((ZipEntry)object3).setMethod(jarEntry.getMethod());
            ((ZipEntry)object3).setExtra(jarEntry.getExtra());
            ((ZipEntry)object3).setComment(jarEntry.getComment());
            this.updateObserver(progressObserver, d3, d2);
            d3 += 1.0;
            this.writeEntry((JarOutputStream)outputStream, (JarEntry)object3, ((JarFile)object).getInputStream(jarEntry));
            boolean bl = hashSet.remove(object4);
            if (!bl) continue;
            d2 -= 1.0;
        }
        object5 = hashSet.iterator();
        if (object5 != null) {
            while (object5.hasNext()) {
                String string = (String)object5.next();
                JarEntry jarEntry = ((JarFile)object).getJarEntry(string);
                this.updateObserver(progressObserver, d3, d2);
                d3 += 1.0;
                this.writeEntry((JarOutputStream)outputStream, jarEntry, (JarFile)object);
            }
        }
        this.updateObserver(progressObserver, d3, d2);
        ((ZipOutputStream)outputStream).finish();
    }

    protected void updateObserver(ProgressObserver progressObserver, double d2, double d3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(d2 * 100.0 / d3));
        }
    }

    protected void determineNameMapping(JarFile closeable, Set<String> set, Map<String, String> map) throws IOException {
        if ((closeable = ((JarFile)closeable).getInputStream(((JarFile)closeable).getEntry("META-INF/INDEX.JD"))) == null) {
            throw new IOException("error.noindex");
        }
        String string = ((LineNumberReader)(closeable = new LineNumberReader(new InputStreamReader((InputStream)closeable, "UTF-8")))).readLine();
        if (string == null || !string.equals("version 1.0")) {
            throw new IOException("jardiff.error.badheader: " + string);
        }
        while ((string = ((LineNumberReader)closeable).readLine()) != null) {
            List<String> list;
            if (string.startsWith("remove")) {
                list = this.getSubpaths(string.substring(6));
                if (list.size() != 1) {
                    throw new IOException("error.badremove: " + string);
                }
                set.add(list.get(0));
                continue;
            }
            if (string.startsWith("move")) {
                list = this.getSubpaths(string.substring(4));
                if (list.size() != 2) {
                    throw new IOException("error.badmove: " + string);
                }
                if (map.put(list.get(1), list.get(0)) == null) continue;
                throw new IOException("error.badmove: " + string);
            }
            if (string.length() <= 0) continue;
            throw new IOException("error.badcommand: " + string);
        }
    }

    protected List<String> getSubpaths(String string) {
        int n2 = 0;
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n3) continue;
            int n4 = n2;
            String string2 = null;
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (c2 == '\\' && n2 + 1 < n3 && string.charAt(n2 + 1) == ' ') {
                    string2 = string2 == null ? string.substring(n4, n2) : string2 + string.substring(n4, n2);
                    n4 = ++n2;
                } else if (Character.isWhitespace(c2)) break;
                ++n2;
            }
            if (n4 != n2) {
                string2 = string2 == null ? string.substring(n4, n2) : string2 + string.substring(n4, n2);
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, JarFile jarFile) throws IOException {
        this.writeEntry(jarOutputStream, jarEntry, jarFile.getInputStream(jarEntry));
    }

    protected void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, InputStream inputStream) throws IOException {
        jarOutputStream.putNextEntry(new JarEntry(jarEntry.getName()));
        int n2 = inputStream.read(newBytes);
        while (n2 != -1) {
            jarOutputStream.write(newBytes, 0, n2);
            n2 = inputStream.read(newBytes);
        }
        inputStream.close();
    }
}

