/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.Log;
import com.threerings.getdown.tools.JarDiffPatcher;
import com.threerings.getdown.tools.a;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Patcher {
    public static final String CREATE = ".create";
    public static final String PATCH = ".patch";
    public static final String DELETE = ".delete";
    protected ProgressObserver _obs;
    protected long _complete;
    protected long _plength;
    protected byte[] _buffer;
    protected static final int COPY_BUFFER_SIZE = 4096;

    public void patch(File file, File object, ProgressObserver object2) throws IOException {
        this._obs = object2;
        this._plength = ((File)object).length();
        object = new JarFile((File)object);
        object2 = ((JarFile)object).entries();
        while (object2.hasMoreElements()) {
            Object object3 = (JarEntry)object2.nextElement();
            String string = ((ZipEntry)object3).getName();
            long l2 = ((ZipEntry)object3).getCompressedSize();
            if (string.endsWith(CREATE)) {
                string = this.strip(string, CREATE);
                System.out.println("Creating " + string + "...");
                this.createFile((JarFile)object, (ZipEntry)object3, new File(file, string));
            } else if (string.endsWith(PATCH)) {
                string = this.strip(string, PATCH);
                System.out.println("Patching " + string + "...");
                this.patchFile((JarFile)object, (ZipEntry)object3, file, string);
            } else if (string.endsWith(DELETE)) {
                string = this.strip(string, DELETE);
                System.out.println("Removing " + string + "...");
                object3 = new File(file, string);
                if (!((File)object3).delete()) {
                    System.err.println("Failure deleting '" + object3 + "'.");
                }
            } else {
                System.err.println("Skipping bogus patch file entry: " + string);
            }
            this._complete += l2;
        }
        ((ZipFile)object).close();
    }

    protected String strip(String string, String string2) {
        return string.substring(0, string.length() - string2.length());
    }

    protected void createFile(JarFile jarFile, ZipEntry zipEntry, File file) {
        Object object;
        if (this._buffer == null) {
            this._buffer = new byte[4096];
        }
        if (!((File)(object = file.getParentFile())).exists() && !((File)object).mkdirs()) {
            Log.log.b("Failed to create parent for '" + file + "'.", new Object[0]);
        }
        object = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            object = jarFile.getInputStream(zipEntry);
            fileOutputStream = new FileOutputStream(file);
            int n3 = 0;
            while ((n2 = ((InputStream)object).read(this._buffer)) != -1) {
                fileOutputStream.write(this._buffer, 0, n2);
                this.updateProgress(n3 += n2);
            }
        }
        catch (IOException iOException) {
            try {
                System.err.println("Error creating '" + file + "': " + iOException);
            }
            catch (Throwable throwable) {
                com.a.a.a.a((InputStream)object);
                com.a.a.a.a(fileOutputStream);
                throw throwable;
            }
            com.a.a.a.a((InputStream)object);
            com.a.a.a.a(fileOutputStream);
            return;
        }
        com.a.a.a.a((InputStream)object);
        com.a.a.a.a(fileOutputStream);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void patchFile(JarFile object, ZipEntry zipEntry, File file, String object2) {
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        File file2;
        File file3;
        block10: {
            file3 = new File(file, (String)object2);
            file2 = new File(file, zipEntry.getName());
            file = new File(file, (String)object2 + ".old");
            object2 = null;
            file.delete();
            inputStream = null;
            fileOutputStream = null;
            inputStream = ((JarFile)object).getInputStream(zipEntry);
            fileOutputStream = new FileOutputStream(file2);
            com.a.a.a.a(inputStream, fileOutputStream);
            com.a.a.a.a(fileOutputStream);
            fileOutputStream = null;
            if (FileUtil.renameTo(file3, file)) break block10;
            System.err.println("Failed to .oldify '" + file3 + "'.");
            com.a.a.a.a(null);
            com.a.a.a.a(inputStream);
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
            if (file.delete()) return;
            file.deleteOnExit();
            return;
        }
        try {
            long l2 = zipEntry.getCompressedSize();
            object = new a(this, l2);
            object2 = new JarDiffPatcher();
            fileOutputStream = new FileOutputStream(file3);
            ((JarDiffPatcher)object2).patchJar(file.getPath(), file2.getPath(), fileOutputStream, (ProgressObserver)object);
        }
        catch (IOException iOException) {
            block11: {
                try {
                    if (object2 == null) {
                        System.err.println("Failed to write patch file '" + file2 + "': " + iOException);
                        break block11;
                    }
                    System.err.println("Error patching '" + file3 + "': " + iOException);
                }
                catch (Throwable throwable) {
                    com.a.a.a.a(fileOutputStream);
                    com.a.a.a.a(inputStream);
                    if (!file2.delete()) {
                        file2.deleteOnExit();
                    }
                    if (file.delete()) throw throwable;
                    file.deleteOnExit();
                    throw throwable;
                }
            }
            com.a.a.a.a(fileOutputStream);
            com.a.a.a.a(inputStream);
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
            if (file.delete()) return;
            file.deleteOnExit();
            return;
        }
        com.a.a.a.a(fileOutputStream);
        com.a.a.a.a(inputStream);
        if (!file2.delete()) {
            file2.deleteOnExit();
        }
        if (file.delete()) return;
        file.deleteOnExit();
        return;
    }

    protected void updateProgress(int n2) {
        if (this._obs != null) {
            this._obs.progress((int)(100L * (this._complete + (long)n2) / this._plength));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: Patcher appdir patch_file");
            System.exit(-1);
        }
        Patcher patcher = new Patcher();
        try {
            patcher.patch(new File(stringArray[0]), new File(stringArray[1]), null);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
            System.exit(-1);
            return;
        }
    }
}

