/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.DialogTaskMonitorImpl;
import com.istech21.snpanalyzer2free.ExternalFilePathProvider;
import com.istech21.snpanalyzer2free.Preference;
import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.TaskMonitorAdoptor;
import com.istech21.snpanalyzer2free.WebstartMain;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;

public class AppletViewer
extends JFrame
implements ActionListener,
AppletStub,
AppletContext {
    private String defaultTitle = "ISTECH::AppletViewer";

    AppletViewer() {
        this.setTitle(this.defaultTitle);
        this.setLayout(new BorderLayout());
        Menu m = new Menu("File");
        MenuItem mi = new MenuItem("Quit");
        mi.addActionListener(this);
        m.add(mi);
        MenuBar mb = new MenuBar();
        mb.add(m);
        this.setMenuBar(mb);
        this.registerMemoryReporterTask();
    }

    public URL getDocumentBase() {
        URL url = null;
        try {
            File file = new File(System.getProperty("user.dir"));
            url = file.toURL();
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL");
            url = null;
        }
        return url;
    }

    public URL getCodeBase() {
        URL url = null;
        try {
            File file = new File(System.getProperty("user.dir"));
            url = file.toURL();
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL");
            url = null;
        }
        return url;
    }

    public boolean isActive() {
        return true;
    }

    public String getParameter(String name) {
        return "";
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public void appletResize(int width, int height) {
    }

    public Image getImage(URL url) {
        String imgName = url.getFile();
        return Toolkit.getDefaultToolkit().getImage(imgName);
    }

    public AudioClip getAudioClip(URL url) {
        return null;
    }

    public Applet getApplet(String name) {
        return null;
    }

    public Enumeration getApplets() {
        return null;
    }

    public void showDocument(URL url) {
    }

    public void showDocument(URL url, String target) {
    }

    public void showStatus(String status) {
    }

    public Iterator getStreamKeys() {
        return null;
    }

    public InputStream getStream(String key) {
        return null;
    }

    public void setStream(String key, InputStream is) {
    }

    public static void main(String[] args) {
        AppletViewer h = new AppletViewer();
        Snpanalyzer2 myApplet = new Snpanalyzer2();
        myApplet.setStub(h);
        myApplet.init();
        h.add("Center", myApplet);
        h.setDefaultCloseOperation(3);
        h.pack();
        h.setExtendedState(6);
        h.setVisible(true);
        System.err.println("try to download engine ");
        TaskMonitorAdoptor progressMonitor = new TaskMonitorAdoptor();
        progressMonitor.addTaskMonitor(new DialogTaskMonitorImpl(myApplet));
        WebstartMain.DownloadEnginesIfNeed(progressMonitor);
        Preference.InitFromFile(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(0));
        Snpanalyzer2.pref = new Preference();
        myApplet.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Quit")) {
            this.dispose();
        }
        System.exit(0);
    }

    private void registerMemoryReporterTask() {
        int delay = 5000;
        int period = 1000;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            DecimalFormat formatter = new DecimalFormat("0.00");
            final int WindowSize = 5;
            float[] usedWindow = new float[5];
            int nextWindow = -1;

            public void run() {
                float used;
                if (this.nextWindow == -1) {
                    Arrays.fill(this.usedWindow, 0.0f);
                    this.nextWindow = 0;
                }
                float delta = 0.0f;
                for (int i = 0; i < 5; ++i) {
                    delta += this.usedWindow[i];
                }
                delta *= 5.0f;
                this.usedWindow[this.nextWindow] = used = (float)((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000.0);
                delta = used - delta;
                String newTitle = AppletViewer.this.defaultTitle + " Used(" + this.formatter.format(used) + "M) ";
                if ((double)delta > 1.0E-4) {
                    newTitle = newTitle + this.formatter.format(delta) + "M";
                }
                AppletViewer.this.setTitle(newTitle);
                ++this.nextWindow;
                if (this.nextWindow >= 5) {
                    this.nextWindow = 0;
                }
            }
        }, delay, (long)period);
    }
}

