/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.SpringUtilities;
import com.istech21.snpanalyzer2free.TaskMonitor;
import com.istech21.snpanalyzer2free.TaskMonitorAdoptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class DialogTaskMonitorImpl
implements TaskMonitor {
    JApplet parent = null;
    ProgressDialog dlg = null;
    TaskMonitorAdoptor adoptor = null;
    TaskMonitorAdoptor.Task[] tasks = null;

    public DialogTaskMonitorImpl(JApplet _parent) {
        this.parent = _parent;
    }

    public void startMonitor(TaskMonitorAdoptor _adoptor, TaskMonitorAdoptor.Task[] tasks) {
        this.adoptor = _adoptor;
        this.tasks = tasks;
        if (this.dlg == null) {
            Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.parent);
            this.dlg = new ProgressDialog(f);
        }
        this.dlg.RemakePaneStatus(tasks);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension componentSize = this.dlg.getSize();
        this.dlg.setLocation(screenSize.width / 2 - componentSize.width / 2, screenSize.height / 2 - componentSize.height / 2);
        this.dlg.setVisible(true);
        this.dlg.requestFocus();
    }

    public void statusChanged() {
        if (this.tasks != null) {
            this.dlg.UpdatePaneStatus(this.tasks);
        }
    }

    public void stopMonitor() {
        try {
            boolean response = this.dlg.isBtnOkPressed();
            Thread.currentThread();
            Thread.sleep(800L);
            this.dlg.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTaskTitle(String title) {
        if (this.adoptor != null) {
            this.adoptor.setTaskTitle(title);
        }
    }

    static class ProgressDialog
    extends JDialog {
        private boolean bBtnOkPressed = false;
        JPanel panelStatus = null;
        JLabel[] labelProgress = new JLabel[0];
        JProgressBar[] progress = new JProgressBar[0];
        Dimension dmProgress = new Dimension(200, 20);

        public ProgressDialog(Frame parent) {
            super(parent);
            this.setModal(false);
            this.setContentPane(this.MakeGUI());
        }

        public boolean isBtnOkPressed() {
            return this.bBtnOkPressed;
        }

        private JPanel MakeGUI() {
            JPanel root = new JPanel();
            root.setBackground(Color.white);
            root.setLayout(new BorderLayout());
            JLabel panelWait = new JLabel("<html><table border=0><tr><td><img src='http://snp.istech21.com/snpanalyzer/2.0/progress.gif'></td><td> <H4>SNPAnalyzer2 / Computing...</H4></td></tr></table><HR></html>", 10);
            panelWait.setVerticalAlignment(1);
            panelWait.setPreferredSize(new Dimension(250, 40));
            root.add((Component)panelWait, "North");
            JButton btnOK = new JButton("OK");
            btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.bBtnOkPressed = true;
                    ProgressDialog.this.dispose();
                }
            });
            JButton btnCancel = new JButton("Cancel");
            btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.bBtnOkPressed = false;
                    ProgressDialog.this.dispose();
                }
            });
            JPanel panelControl = new JPanel();
            panelControl.add(btnOK);
            panelControl.add(btnCancel);
            this.panelStatus = new JPanel();
            this.panelStatus.setLayout(new SpringLayout());
            root.add((Component)this.panelStatus, "Center");
            return root;
        }

        public void UpdatePaneStatus(TaskMonitorAdoptor.Task[] tasks) {
            for (int i = 0; i < this.progress.length; ++i) {
                this.progress[i].setMaximum(tasks[i].max);
                this.progress[i].setValue(tasks[i].value);
                if (tasks[i].max < 0) {
                    if (!this.progress[i].isIndeterminate()) {
                        this.progress[i].setIndeterminate(true);
                    }
                    this.progress[i].setString("...");
                    continue;
                }
                if (this.progress[i].isIndeterminate()) {
                    this.progress[i].setIndeterminate(false);
                }
                this.progress[i].setString(String.valueOf(tasks[i].value) + "/" + String.valueOf(tasks[i].max));
            }
        }

        public void RemakePaneStatus(TaskMonitorAdoptor.Task[] tasks) {
            this.panelStatus.removeAll();
            this.labelProgress = new JLabel[tasks.length];
            this.progress = new JProgressBar[tasks.length];
            for (int i = 0; i < this.progress.length; ++i) {
                this.labelProgress[i] = new JLabel(tasks[i].name, 2);
                this.progress[i] = new JProgressBar();
                this.progress[i].setStringPainted(true);
                this.panelStatus.add(this.labelProgress[i]);
                this.panelStatus.add(this.progress[i]);
            }
            SpringUtilities.makeCompactGrid(this.panelStatus, tasks.length, 2, 6, 6, 6, 6);
            this.pack();
        }
    }
}

