/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.io.File;
import java.net.URLDecoder;

public class ExternalFilePathProvider {
    public static final int FILE_GOSNP_CONF = 0;
    public static final int FILE_GOSNP_EXE = 1;
    public static final int FILE_CRSSSNP_EXE = 2;
    public static final int FILE_CRSSHAP_EXE = 3;
    public static final int FILE_FDR_EXE = 4;
    protected static final String[] ENGINE_EXE_NAMES = new String[]{"snpanalyzer.conf", "snpanalyzer.exe", "cross_tabulation.exe", "hapcross_analysis.exe", "fdr_calculation.exe"};
    protected static String[] CACHED_ENGINE_EXE_NAMES = new String[]{null, null, null, null, null};
    private static final String issuer_file = "snpanalyzer2.copy";
    private static String enforced_runtime_base = null;

    private ExternalFilePathProvider() {
    }

    protected static String Find_JRE_LIB_APPLET() {
        try {
            String jre_home = System.getProperty("java.home", "NA");
            if ("NA".equals(jre_home)) {
                return null;
            }
            String res = new File(jre_home).getCanonicalPath() + File.separator + "lib" + File.separator + "applet" + File.separator;
            if (new File(res).exists()) {
                return res;
            }
            System.out.println("Not exist dir " + res);
            return null;
        }
        catch (Exception e) {
            System.out.println("no permission");
            return null;
        }
    }

    public static String GET_NATIVE_FILE_PATH(int whichExe) {
        if (CACHED_ENGINE_EXE_NAMES[whichExe] != null) {
            return CACHED_ENGINE_EXE_NAMES[whichExe];
        }
        String thisExeName = ENGINE_EXE_NAMES[whichExe].replaceAll("\\/", "\\" + File.separator);
        String found = ExternalFilePathProvider.GET_NATIVE_FILE_PATH(thisExeName);
        if (found != null) {
            ExternalFilePathProvider.CACHED_ENGINE_EXE_NAMES[whichExe] = found;
        }
        return CACHED_ENGINE_EXE_NAMES[whichExe];
    }

    public static void SetEnforedRuntimeBase(String path) {
        System.out.println("SetEnforedRuntimeBase to " + path);
        enforced_runtime_base = path;
    }

    public static String GET_NATIVE_FILE_PATH(String thisExeName) {
        if (enforced_runtime_base != null) {
            return enforced_runtime_base + File.separator + thisExeName;
        }
        String resourcePath = null;
        String exePath = null;
        int found_result = 0;
        String[] found_result_s = new String[]{"not found", "jar dir", "classes dir", "jre/lib/applet", "user input"};
        try {
            resourcePath = ExternalFilePathProvider.class.getClassLoader().getResource(issuer_file).getPath();
            String defaultEncoding = "utf8";
            resourcePath = URLDecoder.decode(resourcePath, defaultEncoding);
            if (resourcePath.indexOf("jar!") >= 0) {
                found_result = 1;
                resourcePath = resourcePath.substring(6);
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("jar!"));
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
                exePath = new File(resourcePath).getCanonicalPath() + File.separator + thisExeName;
            } else {
                found_result = 2;
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf(issuer_file));
                exePath = new File(resourcePath).getCanonicalPath() + File.separator + thisExeName;
            }
            if (!new File(exePath).exists()) {
                throw new Exception("exe file not exist:" + exePath);
            }
            exePath = new File(exePath).getCanonicalPath();
        }
        catch (Exception e) {
            found_result = 0;
            try {
                found_result = 3;
                exePath = ExternalFilePathProvider.Find_JRE_LIB_APPLET() + File.separator + thisExeName;
                if (!new File(exePath).exists()) {
                    throw new Exception("exe file not exist");
                }
            }
            catch (Exception e2) {
                found_result = 0;
                exePath = null;
            }
        }
        return exePath;
    }

    public static void main(String[] args) {
        String gosnp_exe = ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1);
    }
}

