/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.FileLoopWorker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class FileLooper {
    private int skipCount = 0;
    private File file;

    public FileLooper(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(FileLoopWorker worker) throws Exception {
        BufferedReader br = this.getBufferedReader();
        long fsize = this.file.length();
        long readSize = 0L;
        try {
            String line;
            int LOOP_MONITOR = 500;
            int cnt = 0;
            while ((line = br.readLine()) != null) {
                boolean interrupted;
                if (this.skipCount > cnt) {
                    ++cnt;
                    continue;
                }
                worker.processLine(line);
                readSize += (long)line.length();
                ++readSize;
                if (++cnt > 500) {
                    cnt = 0;
                }
                if (cnt != 500 || !(interrupted = Thread.currentThread().isInterrupted())) continue;
                throw new StopException("User Canceled");
            }
        }
        catch (StopException ignore) {
        }
        finally {
            br.close();
        }
    }

    private BufferedReader getBufferedReader() throws FileNotFoundException {
        return new BufferedReader(new FileReader(this.file));
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public static class StopException
    extends Exception {
        public StopException() {
        }

        public StopException(String msg) {
            super(msg);
        }
    }
}

