/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class FixedColumnScrollPane
extends JScrollPane {
    public FixedColumnScrollPane(JTable main, int fixedColumns) {
        super(main);
        JTable fixed = new JTable(main.getModel());
        fixed.setFocusable(false);
        fixed.setSelectionModel(main.getSelectionModel());
        fixed.getTableHeader().setReorderingAllowed(false);
        fixed.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        main.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        for (int i = 0; i < fixedColumns; ++i) {
            TableColumnModel columnModel = main.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        while (fixed.getColumnCount() > fixedColumns) {
            TableColumnModel columnModel = fixed.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(fixedColumns));
        }
        fixed.setPreferredScrollableViewportSize(fixed.getPreferredSize());
        this.setRowHeaderView(fixed);
        this.setCorner("UPPER_LEFT_CORNER", fixed.getTableHeader());
    }

    public static void main(String[] args) {
        JTable table = new JTable(10, 8);
        table.setAutoResizeMode(0);
        FixedColumnScrollPane scrollPane = new FixedColumnScrollPane(table, 1);
        JFrame frame = new JFrame("Table Fixed Column Demo");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(scrollPane);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }
}

