/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class GenoTableModelLimited
extends AbstractTableModel {
    public static final int FIXED_COLHEADER_SIZE = 1;
    static final int MAX_COLUMN = 2200;
    static final int MAX_ROW = 1200;
    protected String[][] data = null;
    int startColumnSize = 40;
    int startRowSize = 100;
    int activeColumnSize = this.startColumnSize;
    int activeRowSize = this.startRowSize;
    boolean isDirty = true;
    protected String datafile;
    String separator = "\t";
    int columnSize = 0;
    int rowSize = 0;
    private long lastModified = 0L;
    boolean bDoingUpdate = false;
    static final String[] columnIndexNames = new String[]{"SNP ID", "Locus", "Position", "DBSNP"};

    public boolean saveFile(String fpath) {
        try {
            String this_data;
            int j;
            int maxValidRowSize = 0;
            int maxValidColumnSize = 0;
            for (int i = 0; i < this.activeRowSize; ++i) {
                boolean valid_line = false;
                for (j = 0; j < this.activeColumnSize; ++j) {
                    this_data = this.data[i][j];
                    if (this_data == null || this_data.length() == 0 || "-".equals(this_data)) continue;
                    maxValidColumnSize = Math.max(maxValidColumnSize, j + 1);
                    valid_line = true;
                }
                if (!valid_line) continue;
                maxValidRowSize = Math.max(maxValidRowSize, i + 1);
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(fpath));
            for (int i = 0; i < maxValidRowSize; ++i) {
                for (j = 0; j < maxValidColumnSize; ++j) {
                    if (j != 0) {
                        out.write("\t");
                    }
                    if ((this_data = this.data[i][j]) == null) {
                        this_data = "";
                    }
                    if (j >= 1 && j <= 3 && this_data.length() == 0) {
                        this_data = "-";
                    }
                    out.write(this_data);
                }
                out.newLine();
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSize(int rowSize, int colSize) {
        this.activeColumnSize = colSize;
        this.activeRowSize = rowSize;
        this.fireTableStructureChanged();
    }

    public void setInitSize() {
        this.setSize(this.startRowSize, this.startColumnSize);
    }

    public GenoTableModelLimited(String f) {
        this.datafile = f;
        if (this.data == null) {
            this.data = new String[1200][2200];
        }
        if (this.datafile == null) {
            this.setInitSize();
        } else {
            this.readFile(this.datafile);
        }
    }

    private boolean isFileUpdated() {
        if (this.datafile == null) {
            return false;
        }
        long curr = new File(this.datafile).lastModified();
        return curr != this.lastModified;
    }

    private void updateFromFile() {
        if (this.bDoingUpdate) {
            return;
        }
        this.bDoingUpdate = true;
        System.out.println("update !");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GenoTableModelLimited.this.readFile(GenoTableModelLimited.this.datafile);
                GenoTableModelLimited.this.fireTableDataChanged();
                GenoTableModelLimited.this.fireTableStructureChanged();
                GenoTableModelLimited.this.bDoingUpdate = false;
            }
        });
    }

    public void readFile(String thisfile) {
        this.datafile = thisfile;
        if (thisfile == null) {
            return;
        }
        System.out.println("read " + this.datafile);
        if (this.data == null) {
            this.data = new String[1200][2200];
        }
        try {
            String aLine;
            File f = new File(thisfile);
            this.lastModified = f.lastModified();
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            int thisRowCnt = 0;
            int max_col = -1000000;
            int max_row = -1000000;
            boolean bEnoughStorage = true;
            while ((aLine = br.readLine()) != null) {
                String[] tok = (aLine + this.separator + "-").split(this.separator);
                for (int i = 0; i < tok.length - 1; ++i) {
                    if (i >= 2200) {
                        bEnoughStorage = false;
                        break;
                    }
                    this.data[thisRowCnt][i] = tok[i];
                    max_col = Math.max(max_col, i);
                }
                if (++thisRowCnt >= 1200) {
                    bEnoughStorage = false;
                    break;
                }
                max_row = Math.max(max_row, thisRowCnt);
            }
            this.activeColumnSize = max_col + 1;
            this.activeRowSize = max_row;
            System.out.println("activeColumnSize=" + this.activeColumnSize);
            System.out.println("activeRowSize=" + this.activeRowSize);
            if (!bEnoughStorage) {
                JOptionPane.showMessageDialog(null, "Genotype file dimension is too large to *show* in a table.\nMAX=1200X2200");
            }
            br.close();
            this.isDirty = false;
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRowCount() {
        return this.activeRowSize;
    }

    public int getColumnCount() {
        return this.activeColumnSize;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < columnIndexNames.length) {
            return columnIndexNames[columnIndex];
        }
        return String.valueOf(columnIndex - columnIndexNames.length + 1);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex > 1 || columnIndex > 3;
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        try {
            String res;
            if (this.isFileUpdated()) {
                this.updateFromFile();
            }
            if ((res = this.data[rowIndex][columnIndex]) == null) {
                res = "";
            }
            if (res.length() == 0 && rowIndex >= 2 && columnIndex >= 1 && columnIndex <= 3 && this.getValueAt(rowIndex, 0).toString().length() > 0) {
                res = "-";
            }
            return res;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this.data[rowIndex][columnIndex] = (String)aValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static class ContentsSubTableModelWithHeader
    extends AbstractTableModel
    implements TableModelListener {
        private AbstractTableModel parent = null;
        int colHeaderSize = 0;

        public ContentsSubTableModelWithHeader(AbstractTableModel _pa, int _colHeaderSize) {
            this.parent = _pa;
            this.colHeaderSize = _colHeaderSize;
            this.parent.addTableModelListener(this);
        }

        public int getRowCount() {
            return this.parent.getRowCount();
        }

        public int getColumnCount() {
            return this.parent.getColumnCount() - this.colHeaderSize + 1;
        }

        public String getColumnName(int columnIndex) {
            return this.parent.getColumnName(this.colHeaderSize + columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.parent.getColumnClass(this.colHeaderSize + columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.parent.isCellEditable(rowIndex, this.colHeaderSize + columnIndex);
        }

        public synchronized Object getValueAt(int rowIndex, int columnIndex) {
            return this.parent.getValueAt(rowIndex, this.colHeaderSize + columnIndex);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.parent.setValueAt(aValue, rowIndex, this.colHeaderSize + columnIndex);
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableStructureChanged();
        }
    }

    public static class ContentsSubTableModel
    extends AbstractTableModel
    implements TableModelListener {
        private AbstractTableModel parent = null;
        int colHeaderSize = 0;

        public ContentsSubTableModel(AbstractTableModel _pa, int _colHeaderSize) {
            this.parent = _pa;
            this.colHeaderSize = _colHeaderSize;
            this.parent.addTableModelListener(this);
        }

        public int getRowCount() {
            return this.parent.getRowCount();
        }

        public int getColumnCount() {
            return this.parent.getColumnCount() - this.colHeaderSize + 1;
        }

        public String getColumnName(int columnIndex) {
            return this.parent.getColumnName(this.colHeaderSize + columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.parent.getColumnClass(this.colHeaderSize + columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.parent.isCellEditable(rowIndex, this.colHeaderSize + columnIndex);
        }

        public synchronized Object getValueAt(int rowIndex, int columnIndex) {
            return this.parent.getValueAt(rowIndex, this.colHeaderSize + columnIndex);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.parent.setValueAt(aValue, rowIndex, this.colHeaderSize + columnIndex);
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableStructureChanged();
        }
    }

    public static class NumberHeaderSubTableModel
    extends AbstractTableModel
    implements TableModelListener {
        private AbstractTableModel parent = null;

        public NumberHeaderSubTableModel(AbstractTableModel _pa) {
            this.parent = _pa;
            this.parent.addTableModelListener(this);
        }

        public int getRowCount() {
            return this.parent.getRowCount();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int columnIndex) {
            return "*";
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public synchronized Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 2) {
                return "";
            }
            return String.valueOf(rowIndex - 1);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableDataChanged();
        }
    }

    public static class HeaderSubTableModel
    extends AbstractTableModel
    implements TableModelListener {
        private AbstractTableModel parent = null;
        int colHeaderSize = 0;

        public HeaderSubTableModel(AbstractTableModel _pa, int _colHeaderSize) {
            this.parent = _pa;
            this.colHeaderSize = _colHeaderSize;
            this.parent.addTableModelListener(this);
        }

        public int getRowCount() {
            return this.parent.getRowCount();
        }

        public int getColumnCount() {
            return this.colHeaderSize;
        }

        public String getColumnName(int columnIndex) {
            return this.parent.getColumnName(columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.parent.getColumnClass(columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.parent.isCellEditable(rowIndex, columnIndex);
        }

        public synchronized Object getValueAt(int rowIndex, int columnIndex) {
            return this.parent.getValueAt(rowIndex, columnIndex);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.parent.setValueAt(aValue, rowIndex, columnIndex);
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableDataChanged();
        }
    }
}

