/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GradientPanel
extends JPanel {
    private Color color1;
    private Color color2;

    public GradientPanel() {
        this(Color.white, Color.black);
    }

    public GradientPanel(Color c1, Color c2) {
        this.color1 = c1;
        this.color2 = c2;
    }

    public void setColor1(Color c1) {
        this.color1 = c1;
        this.repaint();
    }

    public void setColor2(Color c2) {
        this.color2 = c2;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.color1, w, h, this.color2, true);
        g2.setPaint(gradient);
        g2.fillRect(0, 0, w, h);
        g.setColor(Color.LIGHT_GRAY);
        g.draw3DRect(0, 0, this.getWidth() - 2, this.getHeight() - 2, true);
    }

    public static void main(String[] args) {
        final GradientPanel pGradient = new GradientPanel();
        Color[] colors = new Color[]{GradientPanel.createColor("Black", Color.black), GradientPanel.createColor("Blue", Color.blue), GradientPanel.createColor("Green", Color.green), GradientPanel.createColor("yellow", Color.yellow), GradientPanel.createColor("orange", Color.orange), GradientPanel.createColor("red", Color.red), GradientPanel.createColor("white", Color.white)};
        JComboBox<Color> c1 = new JComboBox<Color>(colors);
        c1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                Color c = (Color)combo.getSelectedItem();
                pGradient.setColor1(c);
            }
        });
        JComboBox<Color> c2 = new JComboBox<Color>(colors);
        c2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                Color c = (Color)combo.getSelectedItem();
                pGradient.setColor2(c);
            }
        });
        JPanel pColors = new JPanel(new GridLayout(0, 2));
        pColors.add(c1);
        pColors.add(c2);
        pGradient.add(new JButton("A button"));
        pGradient.add(new JTextField("A text field"));
        c1.setSelectedItem(colors[1]);
        c2.setSelectedItem(colors[2]);
        JFrame f = new JFrame("Gradient test");
        f.setSize(300, 200);
        f.getContentPane().add((Component)pColors, "North");
        f.getContentPane().add((Component)pGradient, "Center");
        f.setVisible(true);
    }

    private static Color createColor(String name, Color c) {
        final String colorname = name;
        Color color = new Color(c.getRed(), c.getGreen(), c.getBlue()){
            private String name;
            {
                super(x0, x1, x2);
                this.name = colorname;
            }

            public String toString() {
                return this.name;
            }
        };
        return color;
    }
}

