/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconPool
extends Component {
    private static String[] names = new String[]{"java-logo.gif", "bld.jpg", "boat.png", "box.gif", "boxwave.gif", "clouds.jpg", "duke.gif", "duke.running.gif", "dukeplug.gif", "fight.gif", "globe.gif", "java_logo.png", "jumptojavastrip.png", "magnify.gif", "painting.gif", "remove.gif", "snooze.gif", "star7.gif", "surfing.gif", "thumbsup.gif", "tip.gif", "duke.png", "print.gif", "loop.gif", "looping.gif", "start.gif", "start2.gif", "stop.gif", "stop2.gif", "clone.gif"};
    private static Hashtable cache = new Hashtable(names.length);
    private static Hashtable cacheIcon = new Hashtable(names.length);
    private static IconPool instance = new IconPool();

    private IconPool() {
        for (int i = 0; i < names.length; ++i) {
            IconPool.getImage(names[i], this);
        }
    }

    public static Icon getImageIcon(String name) {
        return IconPool.getImageIcon(name, instance);
    }

    public static Icon getImageIcon(String name, Component cmp) {
        Icon icon = null;
        if (cacheIcon != null && (icon = (Icon)cacheIcon.get(name)) != null) {
            return icon;
        }
        try {
            Image img = IconPool.getImage(name, cmp);
            icon = new ImageIcon(img);
        }
        catch (Exception e) {
            icon = new ColoredSquare();
        }
        cacheIcon.put(name, icon);
        return icon;
    }

    private static Image getImage(String name, Component cmp) {
        Image img = null;
        if (cache != null && (img = (Image)cache.get(name)) != null) {
            return img;
        }
        img = ImageLoader.loadImage(name);
        if (img != null) {
            cache.put(name, img);
        }
        return img;
    }

    static class ImageLoader {
        ImageLoader() {
        }

        public static Image loadImage(String imageName) {
            ClassLoader loader = ImageLoader.class.getClassLoader();
            Image image = null;
            System.out.println("Loading " + imageName);
            InputStream is = ImageLoader.class.getResourceAsStream("images/" + imageName);
            if (is == null) {
                is = loader.getResourceAsStream("images/" + imageName);
            }
            if (is != null) {
                try {
                    int len;
                    int BlockLen = 256;
                    int offset = 0;
                    byte[] imageData = new byte[256];
                    while ((len = is.read(imageData, offset, imageData.length - offset)) > 0) {
                        if (len == imageData.length - offset) {
                            byte[] newData = new byte[imageData.length * 2];
                            System.arraycopy(imageData, 0, newData, 0, imageData.length);
                            imageData = newData;
                            newData = null;
                        }
                        offset += len;
                    }
                    image = Toolkit.getDefaultToolkit().createImage(imageData);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return image;
        }
    }

    static class ColoredSquare
    implements Icon {
        Color color;
        static Color[] ColorLoop = new Color[]{Color.white, Color.yellow, Color.blue, Color.magenta, Color.black};
        static int ColorLoopCurrent = 0;

        public ColoredSquare() {
            this(ColorLoop[ColorLoopCurrent]);
            if (++ColorLoopCurrent >= ColorLoop.length) {
                ColorLoopCurrent = 0;
            }
        }

        public ColoredSquare(Color c) {
            this.color = c;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fill3DRect(x, y, this.getIconWidth(), this.getIconHeight(), true);
            g.setColor(oldColor);
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }
}

