/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.ExternalFilePathProvider;
import com.istech21.snpanalyzer2free.SampleFlagger;
import com.istech21.snpanalyzer2free.TaskMonitorAdoptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class NativeEngineWrapper {
    public static final int MAX_SNP_IMPORT = 510000;
    public static final int MAX_SAMPLE_IMPORT = 1000;
    public static final int MAX_SNP_EM = 24;
    public static final int MAX_SNP_PLEM = 200;
    public static final String NEW_FLAGGED_GENO_EXTENSION = ".newflagged";

    private static void banner(String title) {
        System.out.flush();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("###########################################################");
        System.out.println("###  " + title);
        System.out.println("###########################################################");
    }

    private static String NVL(Hashtable h, String key, String def) {
        try {
            String r = (String)h.get(key);
            if (r == null) {
                return def;
            }
            return r;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static int run_general(Vector cmd, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        String[] cmdA = new String[cmd.size()];
        cmdA = cmd.toArray(cmdA);
        NativeEngineWrapper.run_general(cmdA, out, monitor);
        return 0;
    }

    public static int run_general(final String[] cmd, final PrintStream out_maybe_null, final TaskMonitorAdoptor monitor) throws Exception {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    PrintStream out = null;
                    out = out_maybe_null == null ? System.out : out_maybe_null;
                    cmd[0] = cmd[0].replaceAll("/", "\\\\");
                    String cmdPrint = "### EXEC  ";
                    for (int i = 0; i < cmd.length; ++i) {
                        cmdPrint = cmdPrint + " " + cmd[i];
                    }
                    System.out.println(cmdPrint);
                    Process p = Runtime.getRuntime().exec(cmd);
                    InputStream pis = null;
                    InputStream pes = null;
                    pis = p.getInputStream();
                    pes = p.getErrorStream();
                    StreamGobbler errorGobbler = new StreamGobbler(pes, out, true, monitor);
                    errorGobbler.start();
                    StreamGobbler outGobbler = new StreamGobbler(pis, out, false, null);
                    outGobbler.start();
                    p.waitFor();
                    out.flush();
                }
                catch (Exception rte) {
                    rte.printStackTrace();
                }
            }
        };
        r.run();
        return 0;
    }

    public static int run_flagging(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("flagging");
        String sampleMissingLimitString = NativeEngineWrapper.NVL(option, "flagging.sampleMgf", "0.5");
        SampleFlagger sampleFlagger = new SampleFlagger(new File[]{new File(fname)}, Double.parseDouble(sampleMissingLimitString));
        sampleFlagger.calculateFreq();
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1));
        cmd.add("PREFLAG");
        cmd.add(fname);
        cmd.add("/PROGRESS");
        cmd.add("/SAMPLE" + NativeEngineWrapper.NVL(option, "flagging.sampleMgf", "0.5"));
        cmd.add("/SNP" + NativeEngineWrapper.NVL(option, "flagging.snpMgf", "0.1"));
        cmd.add("/MAF" + NativeEngineWrapper.NVL(option, "flagging.maf", "0.0"));
        cmd.add("/HWE" + NativeEngineWrapper.NVL(option, "flagging.hwe", "0.0"));
        String multicorr = NativeEngineWrapper.NVL(option, "flagging.hwemulticorrection", "OFF").toUpperCase();
        if ("ON".equals(multicorr)) {
            cmd.add("/MUL");
        }
        cmd.add("/OUTFILE:" + fname + NEW_FLAGGED_GENO_EXTENSION);
        cmd.add("/CLASS:0");
        cmd.add("/PROGRESS");
        cmd.add("/DEBUG0");
        cmd.add("/SAMPLE_HINT:" + fname + ".sampleFlagInfo");
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_imputation(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("imputation");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1));
        cmd.add("PREIMPU");
        cmd.add(fname);
        String replace = NativeEngineWrapper.NVL(option, "imputation.replace", "1");
        replace = "1";
        if ("1".equals(replace)) {
            cmd.add("/A");
        } else if ("2".equals(replace)) {
            cmd.add("/B");
        } else if ("3".equals(replace)) {
            cmd.add("/C");
        }
        cmd.add("/PROGRESS");
        cmd.add("/DEBUG0");
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_haplotypeestimation(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("haplotype estimation");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1));
        String hap_estimation_method = NativeEngineWrapper.NVL(option, "haplotype.estimation.method", "EM").toUpperCase();
        if (hap_estimation_method.equals("PLEM")) {
            cmd.add("PLEM");
        } else {
            cmd.add("EM");
        }
        cmd.add(fname);
        cmd.add("/PROGRESS");
        cmd.add("/EPS" + NativeEngineWrapper.NVL(option, "haplotype.em.convergence", "1.0"));
        String em_init_method = NativeEngineWrapper.NVL(option, "haplotype.em.initmethod", "UNION").toUpperCase();
        if (em_init_method.equals("RANDOM")) {
            cmd.add("/RANDOM");
        }
        if (hap_estimation_method.equals("PLEM")) {
            cmd.add("/BL" + NativeEngineWrapper.NVL(option, "haplotype.plem.partitionno", "10"));
            cmd.add("/PLEMEPS" + NativeEngineWrapper.NVL(option, "haplotype.plem.freqlimit", "0.00001"));
        }
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_pairwiseld(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        String ld_segmentlimit;
        NativeEngineWrapper.banner("pairwise ld");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1));
        cmd.add("PWLD");
        cmd.add(fname);
        cmd.add("/PROGRESS");
        cmd.add("/DEBUG0");
        cmd.add("/4GMT" + NativeEngineWrapper.NVL(option, "ld.4gamete.mhf", "0.01"));
        if (option.containsKey("ld.segmentlimit") && !(ld_segmentlimit = NativeEngineWrapper.NVL(option, "ld.segmentlimit", "500000").toUpperCase()).equals("NO LIMIT")) {
            int ld_segmentlimit_value = 0;
            if (ld_segmentlimit.endsWith("K")) {
                ld_segmentlimit = ld_segmentlimit.substring(0, ld_segmentlimit.length() - 1);
                ld_segmentlimit_value = Integer.parseInt(ld_segmentlimit);
                ld_segmentlimit_value *= 1000;
            } else if (ld_segmentlimit.endsWith("M")) {
                ld_segmentlimit = ld_segmentlimit.substring(0, ld_segmentlimit.length() - 1);
                ld_segmentlimit_value = Integer.parseInt(ld_segmentlimit);
                ld_segmentlimit_value *= 1000000;
            }
            cmd.add("/ANNO" + String.valueOf(ld_segmentlimit_value));
            cmd.add("/SKIPANNO");
        }
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_ldbasedtagger(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("LD based tagger");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1));
        cmd.add("TAG1");
        cmd.add(fname + ".pwld");
        cmd.add("/PROGRESS");
        cmd.add("/DEBUG0");
        if (option.containsKey("ld.ldtag.r2")) {
            cmd.add("/R=" + NativeEngineWrapper.NVL(option, "ld.ldtag.r2", "0.7"));
        }
        if (option.containsKey("ld.ldtag.maf")) {
            cmd.add("/MAF" + NativeEngineWrapper.NVL(option, "ld.ldtag.maf", "0.05"));
        }
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_fdr_snp(String crssfname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("FDR");
        String pvaluemethod = (String)option.get("pvaluemethod");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(4));
        cmd.add("0");
        cmd.add(crssfname);
        cmd.add(pvaluemethod);
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_fdr_hap(String crssfname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("FDR");
        String pvaluemethod = (String)option.get("pvaluemethod");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(4));
        cmd.add("1");
        cmd.add(crssfname);
        cmd.add(pvaluemethod);
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_ldblocking(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        String blk_method;
        String ld_segmentlimit;
        NativeEngineWrapper.banner("ld blocking");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(1));
        cmd.add("PWLD");
        cmd.add(fname);
        cmd.add("/PROGRESS");
        cmd.add("/DEBUG0");
        cmd.add("/4GMT" + NativeEngineWrapper.NVL(option, "ld.4gamete.mhf", "0.01"));
        if (option.containsKey("ld.segmentlimit") && !(ld_segmentlimit = NativeEngineWrapper.NVL(option, "ld.segmentlimit", "500000").toUpperCase()).equals("NO LIMIT")) {
            int ld_segmentlimit_value = 0;
            if (ld_segmentlimit.endsWith("K")) {
                ld_segmentlimit = ld_segmentlimit.substring(0, ld_segmentlimit.length() - 1);
                ld_segmentlimit_value = Integer.parseInt(ld_segmentlimit);
                ld_segmentlimit_value *= 1000;
            } else if (ld_segmentlimit.endsWith("M")) {
                ld_segmentlimit = ld_segmentlimit.substring(0, ld_segmentlimit.length() - 1);
                ld_segmentlimit_value = Integer.parseInt(ld_segmentlimit);
                ld_segmentlimit_value *= 1000000;
            }
            cmd.add("/ANNO" + String.valueOf(ld_segmentlimit_value));
            cmd.add("/SKIPANNO");
        }
        cmd.add("/EPS" + NativeEngineWrapper.NVL(option, "EPS", "0.01"));
        String RANDOM = NativeEngineWrapper.NVL(option, "EM_INIT", "DEFAULF");
        if (RANDOM.equals("RANDOM")) {
            cmd.add("/RANDOM");
        }
        if ((blk_method = NativeEngineWrapper.NVL(option, "ld.blocking.method", "GABRIEL").toUpperCase()).equals("ZHU")) {
            cmd.add("/LDBLK1");
        } else if (blk_method.equals("MANUAL")) {
            String range = NativeEngineWrapper.NVL(option, "@BLK_METHOD_MANUAL_INDEXLIST", "begin-end");
            cmd.add("/LDBLKM" + range);
        } else {
            cmd.add("/LDBLK2");
        }
        cmd.add("/CRSOVR");
        cmd.add("/UTH" + NativeEngineWrapper.NVL(option, "ld.gabriel.uth", "0.98"));
        cmd.add("/LTH" + NativeEngineWrapper.NVL(option, "ld.gabriel.lth", "0.7"));
        cmd.add("/THF" + NativeEngineWrapper.NVL(option, "ld.gabriel.maf", "0.05"));
        cmd.add("/E" + NativeEngineWrapper.NVL(option, "ld.gabriel.strongld", "0.95"));
        if (option.containsKey("ld.gabriel.bst")) {
            String bst = NativeEngineWrapper.NVL(option, "ld.gabriel.bst", "0");
            if (bst.equals("Estimation")) {
                bst = "0";
            }
            cmd.add("/BST" + bst);
        }
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_crss_snp(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("cross tabulation /snp");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(2));
        cmd.add(fname);
        cmd.add(NativeEngineWrapper.NVL(option, "snp count", "0"));
        cmd.add(NativeEngineWrapper.NVL(option, "casecontrol.snp.pvalue", "0.001"));
        String liskAllele = NativeEngineWrapper.NVL(option, "casecontrol.snp.liskallele", "MINOR").toUpperCase();
        if ("MINOR".equals(liskAllele)) {
            cmd.add("0");
        } else {
            cmd.add("1");
        }
        boolean bCodominantSelected = false;
        String liskModel = NativeEngineWrapper.NVL(option, "casecontrol.snp.model", "ADDITIVE").toUpperCase();
        if ("ADDITIVE".equals(liskModel)) {
            liskModel = "0";
        } else if ("CODOMINANT".equals(liskModel)) {
            liskModel = "1";
            bCodominantSelected = true;
        } else {
            liskModel = "DOMINANT".equals(liskModel) ? "3" : "4";
        }
        cmd.add(liskModel);
        String multicorr = NativeEngineWrapper.NVL(option, "casecontrol.snp.bonfcorrection", "OFF").toUpperCase();
        multicorr = "OFF".equals(multicorr) ? "N" : "Y";
        System.out.println("BFCorrection= " + multicorr);
        cmd.add(multicorr);
        cmd.add(fname + ".snp.crss");
        if (!bCodominantSelected) {
            return NativeEngineWrapper.run_general(cmd, out, monitor);
        }
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static int run_crss_haplotype(String fname, Hashtable option, PrintStream out, TaskMonitorAdoptor monitor) throws Exception {
        NativeEngineWrapper.banner("cross tabulation /haplotype");
        Vector<String> cmd = new Vector<String>();
        cmd.add(ExternalFilePathProvider.GET_NATIVE_FILE_PATH(3));
        cmd.add(fname);
        cmd.add(NativeEngineWrapper.NVL(option, "casecontrol.haplotype.pvalue", "0.1"));
        boolean bCodominantSelected = false;
        String liskModel = NativeEngineWrapper.NVL(option, "casecontrol.haplotype.model", "ADDITIVE").toUpperCase();
        if ("ADDITIVE".equals(liskModel)) {
            liskModel = "0";
        } else if ("CODOMINANT".equals(liskModel)) {
            liskModel = "1";
            bCodominantSelected = true;
        } else {
            liskModel = "DOMINANT".equals(liskModel) ? "3" : "4";
        }
        cmd.add(liskModel);
        String multicorr = NativeEngineWrapper.NVL(option, "casecontrol.haplotype.bonfcorrection", "OFF").toUpperCase();
        multicorr = "OFF".equals(multicorr) ? "N" : "Y";
        cmd.add(multicorr);
        String outfile = fname.substring(0, fname.lastIndexOf(".")) + ".hap.crss";
        cmd.add(outfile);
        if (!bCodominantSelected) {
            return NativeEngineWrapper.run_general(cmd, out, monitor);
        }
        return NativeEngineWrapper.run_general(cmd, out, monitor);
    }

    public static void main(String[] args) {
        Hashtable<String, String> option;
        String testGeno = "C:\\Documents and Settings\\yblee\\My Documents\\72.n.geno";
        HashSet<String> test_set = new HashSet<String>();
        test_set.add("flagging");
        test_set.add("imputation");
        test_set.add("haplotype/em");
        test_set.add("haplotype/plem");
        test_set.add("ld");
        test_set.add("blocking/gabriel");
        test_set.add("blocking/manual");
        test_set.add("crss/snp");
        test_set.add("crss/hap");
        if (test_set.contains("flagging")) {
            try {
                option = new Hashtable<String, String>();
                option.put("SAMPLE", "0.5");
                option.put("SNP", "0.1");
                option.put("MAF", "0.0");
                option.put("HWE", "0.0");
                option.put("MUL", "N");
                NativeEngineWrapper.run_flagging(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("imputation")) {
            try {
                option = new Hashtable();
                option.put("replace", "0");
                NativeEngineWrapper.run_imputation(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("haplotype/em")) {
            try {
                option = new Hashtable();
                option.put("EM_METHOD", "EM");
                option.put("EPS", "1.0");
                option.put("EM_INIT", "DEFAULF");
                NativeEngineWrapper.run_haplotypeestimation(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("haplotype/plem")) {
            try {
                option = new Hashtable();
                option.put("EM_METHOD", "PLEM");
                option.put("EPS", "1.0");
                option.put("EM_INIT", "DEFAULF");
                option.put("BL", "10");
                option.put("PLEMEPS", "0.00001");
                NativeEngineWrapper.run_haplotypeestimation(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("ld")) {
            try {
                option = new Hashtable();
                option.put("ANNO", "500000");
                option.put("EPS", "0.1");
                option.put("EM_INIT", "DEFAULF");
                NativeEngineWrapper.run_pairwiseld(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("blocking/manual")) {
            try {
                option = new Hashtable();
                option.put("ANNO", "500000");
                option.put("EPS", "0.1");
                option.put("EM_INIT", "DEFAULF");
                option.put("BLK_METHOD", "MANUAL");
                option.put("BLK_METHOD_MANUAL_INDEXLIST", "begin-end");
                NativeEngineWrapper.run_ldblocking(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("blocking/gabriel")) {
            try {
                option = new Hashtable();
                option.put("ANNO", "500000");
                option.put("EPS", "0.1");
                option.put("EM_INIT", "DEFAULF");
                option.put("BLK_METHOD", "GABRIEL");
                option.put("UTH", "0.98");
                option.put("LTH", "0.7");
                option.put("THF", "0.05");
                option.put("E", "0.95");
                option.put("BST", "0");
                NativeEngineWrapper.run_ldblocking(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("crss/snp")) {
            try {
                option = new Hashtable();
                option.put("snp count", "0");
                option.put("sig level", "0.001");
                option.put("risk allele", "0");
                option.put("model", "0");
                option.put("multi corr", "N");
                NativeEngineWrapper.run_crss_snp(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
        if (test_set.contains("crss/hap")) {
            try {
                option = new Hashtable();
                option.put("sig level", "0.01");
                option.put("model", "0");
                option.put("multi corr", "N");
                NativeEngineWrapper.run_crss_haplotype(testGeno, option, null, null);
            }
            catch (Exception ig) {
                ig.printStackTrace();
                return;
            }
        }
    }

    static class StreamGobbler
    extends Thread {
        InputStream is;
        PrintStream out = null;
        private boolean redirect = true;
        private boolean bProgressStream = false;
        private TaskMonitorAdoptor monitor = null;
        final String S_tasklist = "#tasklist=";
        final String S_taskvalue = "#v=";
        final String S_taskmax = "#m=";

        StreamGobbler(InputStream is, PrintStream out, boolean _bProgressStream, TaskMonitorAdoptor _monitor) {
            this.is = is;
            this.out = out;
            this.monitor = _monitor;
            this.bProgressStream = _bProgressStream;
            if (this.bProgressStream) {
                this.redirect = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block19: {
                try {
                    if (this.bProgressStream) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(this.is));
                        String line = null;
                        try {
                            while ((line = r.readLine()) != null) {
                                int i;
                                String[] tasks;
                                if (this.monitor == null) continue;
                                if (line.startsWith("#v=")) {
                                    line = line.substring("#v=".length());
                                    tasks = line.split(",");
                                    int whichTask = Integer.parseInt(tasks[0]);
                                    int whichValue = Integer.parseInt(tasks[1]);
                                    this.monitor.setProgressValue(whichTask, whichValue);
                                    continue;
                                }
                                if (line.startsWith("#m=")) {
                                    line = line.substring("#m=".length());
                                    tasks = line.split(",");
                                    int whichTask = Integer.parseInt(tasks[0]);
                                    int whichValue = Integer.parseInt(tasks[1]);
                                    this.monitor.setProgressMax(whichTask, whichValue);
                                    continue;
                                }
                                if (!line.startsWith("#tasklist=")) continue;
                                line = line.substring("#tasklist=".length());
                                tasks = line.split(";");
                                String[] taskListAry = new String[tasks.length];
                                int[] taskListMax = new int[tasks.length];
                                for (i = 0; i < tasks.length; ++i) {
                                    String[] items = tasks[i].split(",");
                                    taskListAry[i] = items[0];
                                    taskListMax[i] = Integer.parseInt(items[1]);
                                }
                                this.monitor.ProgressStart(taskListAry);
                                for (i = 0; i < tasks.length; ++i) {
                                    if (taskListMax[i] == 100) continue;
                                    this.monitor.setProgressMax(i, taskListMax[i]);
                                }
                            }
                            break block19;
                        }
                        catch (Exception igg) {
                            igg.printStackTrace();
                            break block19;
                        }
                        finally {
                            if (this.monitor != null) {
                                this.monitor.ProgressStop();
                            }
                        }
                    }
                    InputStreamReader isr = new InputStreamReader(this.is);
                    int bytes = 0;
                    char[] buff = new char[10240];
                    int nRead = 0;
                    while ((nRead = isr.read(buff)) >= 0) {
                        if (nRead == 0) continue;
                        bytes += nRead;
                        for (int i = 0; i < nRead; ++i) {
                            this.out.write(buff[i]);
                        }
                    }
                    isr.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(this.out);
                }
                finally {
                    this.out.flush();
                }
            }
        }
    }
}

