/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;

public class NumericColoredJLabel
extends JLabel {
    private static NumericColoredJLabel singleton = new NumericColoredJLabel();
    boolean isSelected = false;
    static final Color color1_default;
    static final Color color2_default;
    static final Color colorText_default;
    static final Color color1_default_select;
    static final Color color2_default_select;
    static final Color colorText_default_select;
    static Color color1;
    static Color color2;
    static Color colorText;
    double rate = 0.0;

    public static NumericColoredJLabel getInstance(String txt, boolean isSelected) {
        return NumericColoredJLabel.getInstance(txt, isSelected, false);
    }

    public static NumericColoredJLabel getInstance(String txt, boolean isSelected, boolean bScale100) {
        double r = 0.0;
        try {
            r = Double.parseDouble(txt);
            if (bScale100) {
                r *= 100.0;
            }
        }
        catch (Exception ig) {
            r = 0.0;
        }
        singleton.setText(txt);
        singleton.setRate(r);
        NumericColoredJLabel.singleton.isSelected = isSelected;
        if (isSelected) {
            color1 = color1_default_select;
            color2 = color2_default_select;
            colorText = colorText_default_select;
        } else {
            color1 = color1_default;
            color2 = color2_default;
            colorText = colorText_default;
        }
        return singleton;
    }

    public void setRate(double r) {
        this.rate = r;
    }

    public void paint(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        g.setColor(color1);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.rate > 0.01) {
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.isSelected ? Color.black : Color.white, (int)((double)(this.getWidth() - 1) * this.rate), 0.0f, color2);
            g.setPaint(gradient);
            g.fillRect(0, 0, (int)((double)(this.getWidth() - 1) * this.rate), this.getHeight() - 1);
        }
        this.setForeground(colorText);
        super.paint(g);
    }

    static {
        singleton.setHorizontalAlignment(0);
        color1_default = Color.white;
        color2_default = Color.green;
        colorText_default = Color.black;
        color1_default_select = Color.black;
        color2_default_select = Color.red;
        colorText_default_select = Color.yellow;
        color1 = color1_default;
        color2 = color2_default;
        colorText = colorText_default;
    }
}

