/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;

public class Preference {
    public static final String S_preference_name = "preference_name";
    public static final String S_preference_help = "preference_help_short";
    public static final String S_preference_value = "value";
    public static final String S_preference_nomorenotify = "nomorenotify";
    public static final String S_preference_idx_or_item_or_tf = "idx_or_item_or_tf";
    public static String S_preference_filename = "gosnp.conf";
    static final Hashtable ListOfComboboxItems = new Hashtable();
    static boolean isDirty = false;
    private static String[] ParameterCategoryNames = null;
    private static Map ParameterNameMap = new HashMap();
    LinkedList stackProp = new LinkedList();
    Properties prop = null;
    private Map propListeningJComponents = new HashMap();
    private static Font smallFont = new Font("Verdana", 0, 9);
    private static DecimalFormat df = null;
    private static DecimalFormat dfE = null;
    private static int df_asInt = -1;
    private static int df_asIntE = -1;

    private static void addParameterNameMap(String varname) {
        String[] tok = varname.split("\\.");
        ArrayList<String> l = (ArrayList<String>)ParameterNameMap.get(tok[0]);
        if (l == null) {
            l = new ArrayList<String>();
            ParameterNameMap.put(tok[0], l);
        }
        l.add(varname);
    }

    public static int GetParameterCategorySize() {
        return ParameterCategoryNames.length;
    }

    public static String GetParameterCategoryName(int category) {
        return ParameterCategoryNames[category];
    }

    public static int GetParameterItemSize(int category) {
        List l = (List)ParameterNameMap.get(ParameterCategoryNames[category]);
        return l.size();
    }

    public static String GetParameterItemName(int category, int item) {
        List l = (List)ParameterNameMap.get(ParameterCategoryNames[category]);
        return (String)l.get(item);
    }

    public void makeBackup() {
        this.stackProp.addFirst(this.prop);
        this.prop = (Properties)this.prop.clone();
    }

    public void restoreBackup() {
        if (this.stackProp.size() == 0) {
            System.err.println("cannot restore pref. no more stack");
            return;
        }
        this.prop = (Properties)this.stackProp.getFirst();
        this.notifyAllComponents();
    }

    public void forgetBackup() {
        if (this.stackProp.size() == 0) {
            return;
        }
        this.stackProp.getFirst();
    }

    public static void InitFromFile(String newConfPath) {
        S_preference_filename = newConfPath;
        Preference.InitFromFile();
    }

    public void WriteValuesToFile(String fpath) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fpath));
            this.prop.store(out, "SNPAnalyzer Pro Configuration per Project");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ReadValuesFromFile(String fpath) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fpath));
            this.prop.load(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void InitFromFile() {
        ParameterNameMap.clear();
        Hashtable rawHash = new Hashtable();
        Preference.ReadPropertyFile(rawHash, S_preference_filename);
        Enumeration it = rawHash.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            key = key.trim();
            String value = (String)rawHash.get(key);
            value = value.trim();
            if (key.endsWith(".items")) {
                String[] items = value.split(",");
                for (int i = 0; i < items.length; ++i) {
                    items[i] = items[i].trim();
                }
                ListOfComboboxItems.put(key, items);
                String defKey = key.substring(0, key.length() - 6) + ".default";
                if (!ListOfComboboxItems.containsKey(defKey)) {
                    ListOfComboboxItems.put(defKey, items[0]);
                }
                Preference.addParameterNameMap(key.substring(0, key.length() - 6));
                continue;
            }
            ListOfComboboxItems.put(key, value);
        }
        isDirty = false;
        ParameterCategoryNames = new String[ParameterNameMap.size()];
        ParameterNameMap.keySet().toArray(ParameterCategoryNames);
    }

    private static void ReadPropertyFile(Hashtable save, String fpath) {
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(fpath);
            prop.load(fis);
            fis.close();
            save.putAll(prop);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static String[] getCandidates(String varname) {
        String[] items = (String[])ListOfComboboxItems.get(varname + ".items");
        return items;
    }

    public static String getDefault(String varname) {
        String def = (String)ListOfComboboxItems.get(varname + ".default");
        return def;
    }

    public static String getDescription(String varname) {
        String desc = (String)ListOfComboboxItems.get(varname + ".desc");
        return desc;
    }

    public String getValue(String varname) {
        String value = (String)this.prop.get(varname);
        return value;
    }

    public Preference() {
        this.prop = new Properties();
        Enumeration it = ListOfComboboxItems.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            if (!key.endsWith(".default")) continue;
            String varname = key.substring(0, key.length() - 8);
            String value = (String)ListOfComboboxItems.get(key);
            this.prop.put(varname, value);
        }
    }

    public Preference(Preference other) {
        this.prop = (Properties)other.prop.clone();
    }

    private void addPropListener(String varname, JComponent c) {
        ArrayList<JComponent> l = (ArrayList<JComponent>)this.propListeningJComponents.get(varname);
        if (l == null) {
            l = new ArrayList<JComponent>();
            this.propListeningJComponents.put(varname, l);
        }
        l.add(c);
    }

    private void notifyAllComponents() {
        Set keySet = this.propListeningJComponents.keySet();
        for (String varname : keySet) {
            String value = (String)this.prop.get(varname);
            this.notifyOthers(varname, value, null);
        }
    }

    private void notifyOthers(String varname, String newValue, JComponent me) {
        JComponent c;
        int i;
        List l = (List)this.propListeningJComponents.get(varname);
        for (i = 0; i < l.size(); ++i) {
            c = (JComponent)l.get(i);
            if (c.equals(me)) continue;
            c.putClientProperty(S_preference_nomorenotify, "true");
        }
        for (i = 0; i < l.size(); ++i) {
            c = (JComponent)l.get(i);
            if (c.equals(me)) continue;
            if (c instanceof JTextField) {
                ((JTextField)c).setText(newValue);
                continue;
            }
            if (c instanceof JRadioButton) {
                JRadioButton radio = (JRadioButton)c;
                if (!radio.getActionCommand().equals(newValue)) continue;
                radio.setSelected(true);
                continue;
            }
            if (!(c instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)c;
            String idx_or_item_or_tf = (String)c.getClientProperty(S_preference_idx_or_item_or_tf);
            if ("tf".equals(idx_or_item_or_tf)) {
                if ("true".equalsIgnoreCase(newValue)) {
                    combo.setSelectedIndex(0);
                    continue;
                }
                combo.setSelectedIndex(1);
                continue;
            }
            if ("idx".equals(idx_or_item_or_tf)) {
                combo.setSelectedIndex(Integer.parseInt(newValue));
                continue;
            }
            combo.setSelectedItem(newValue);
        }
    }

    public JFormattedTextField Create_JTextField_Format(String paramKey, MaskFormatter formatter1) {
        String itemsKey = paramKey + ".items";
        JFormattedTextField res = null;
        res = formatter1 == null ? new JFormattedTextField() : new JFormattedTextField(formatter1);
        res.setText(this.getValue(paramKey));
        res.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (Preference.S_preference_value.equals(e.getPropertyName())) {
                    JFormattedTextField src = (JFormattedTextField)e.getSource();
                    if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                        src.putClientProperty(Preference.S_preference_nomorenotify, null);
                        return;
                    }
                    String name = (String)src.getClientProperty(Preference.S_preference_name);
                    String value = src.getText();
                    Preference.this.prop.put(name, value);
                    Preference.this.notifyOthers(name, value, src);
                }
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        this.addPropListener(paramKey, res);
        return res;
    }

    public JTextField Create_JTextField_Int3(String paramKey) {
        MaskFormatter formatter1 = null;
        try {
            formatter1 = new MaskFormatter("###");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JFormattedTextField res = this.Create_JTextField_Format(paramKey, formatter1);
        return res;
    }

    public JTextField Create_JTextField_Percent(String paramKey) {
        MaskFormatter formatter1 = null;
        try {
            formatter1 = new MaskFormatter("##.#%");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JFormattedTextField res = this.Create_JTextField_Format(paramKey, formatter1);
        return res;
    }

    public JTextField Create_JTextField_Double2(String paramKey) {
        MaskFormatter formatter1 = null;
        try {
            formatter1 = new MaskFormatter("#.##");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JFormattedTextField res = this.Create_JTextField_Format(paramKey, formatter1);
        return res;
    }

    public JTextField Create_JTextField_Double5(String paramKey) {
        MaskFormatter formatter1 = null;
        try {
            formatter1 = new MaskFormatter("#.#####");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JFormattedTextField res = this.Create_JTextField_Format(paramKey, formatter1);
        return res;
    }

    public JCheckBox Create_JCheckBoxReturnsText(String paramKey, String title) {
        String itemsKey = paramKey + ".items";
        String[] items = (String[])ListOfComboboxItems.get(itemsKey);
        if (items == null || items.length == 0) {
            items = new String[]{"OFF", "ON"};
            ListOfComboboxItems.put(itemsKey, items);
        }
        JCheckBox res = new JCheckBox(title);
        String currValue = this.getValue(paramKey);
        if (items[items.length - 1].equals(currValue)) {
            res.setSelected(true);
        }
        res.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
                if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                    src.putClientProperty(Preference.S_preference_nomorenotify, null);
                    return;
                }
                String key = (String)src.getClientProperty(Preference.S_preference_name);
                String[] items = (String[])ListOfComboboxItems.get(key + ".items");
                String value = src.isSelected() ? items[items.length - 1] : items[0];
                Preference.this.prop.put(key, value);
                Preference.this.notifyOthers(key, value, src);
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        this.addPropListener(paramKey, res);
        return res;
    }

    public JCheckBox Create_JCheckBoxReturnsIndex(String paramKey, String title) {
        String itemsKey = paramKey + ".items";
        String[] items = (String[])ListOfComboboxItems.get(itemsKey);
        if (items == null || items.length == 0) {
            items = new String[]{"OFF", "ON"};
            ListOfComboboxItems.put(itemsKey, items);
        }
        JCheckBox res = new JCheckBox(title);
        int currValue = Integer.parseInt(this.getValue(paramKey));
        if (currValue == items.length - 1) {
            res.setSelected(true);
        }
        res.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("action");
                JCheckBox src = (JCheckBox)e.getSource();
                if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                    src.putClientProperty(Preference.S_preference_nomorenotify, null);
                    return;
                }
                String key = (String)src.getClientProperty(Preference.S_preference_name);
                String[] items = (String[])ListOfComboboxItems.get(key + ".items");
                int value = src.isSelected() ? items.length - 1 : 0;
                Preference.this.prop.put(key, String.valueOf(value));
                Preference.this.notifyOthers(key, String.valueOf(value), src);
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        this.addPropListener(paramKey, res);
        return res;
    }

    public JRadioButton[] Create_JRadioButtonReturnsIndex(String paramKey) {
        String itemsKey = paramKey + ".items";
        String[] items = (String[])ListOfComboboxItems.get(itemsKey);
        JRadioButton[] res = new JRadioButton[items.length];
        ButtonGroup group = new ButtonGroup();
        String currValue = this.getValue(paramKey);
        int whichSelected = Integer.parseInt(currValue);
        for (int i = 0; i < items.length; ++i) {
            res[i] = new JRadioButton(items[i], i == whichSelected);
            res[i].setActionCommand(String.valueOf(i));
            group.add(res[i]);
            res[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadioButton src = (JRadioButton)e.getSource();
                    if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                        src.putClientProperty(Preference.S_preference_nomorenotify, null);
                        return;
                    }
                    String key = (String)src.getClientProperty(Preference.S_preference_name);
                    String idx = e.getActionCommand();
                    Preference.this.prop.put(key, idx);
                    Preference.this.notifyOthers(key, idx, src);
                }
            });
            res[i].putClientProperty(S_preference_name, paramKey);
            this.addPropListener(paramKey, res[i]);
        }
        return res;
    }

    public JRadioButton[] Create_JRadioButtonReturnsText(String paramKey) {
        String itemsKey = paramKey + ".items";
        String[] items = (String[])ListOfComboboxItems.get(itemsKey);
        JRadioButton[] res = new JRadioButton[items.length];
        ButtonGroup group = new ButtonGroup();
        String currValue = this.getValue(paramKey);
        for (int i = 0; i < items.length; ++i) {
            res[i] = new JRadioButton(items[i], items[i].equals(currValue));
            res[i].setActionCommand(items[i]);
            group.add(res[i]);
            res[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadioButton src = (JRadioButton)e.getSource();
                    if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                        src.putClientProperty(Preference.S_preference_nomorenotify, null);
                        return;
                    }
                    String key = (String)src.getClientProperty(Preference.S_preference_name);
                    String idx = e.getActionCommand();
                    Preference.this.prop.put(key, idx);
                    Preference.this.notifyOthers(key, idx, src);
                }
            });
            res[i].putClientProperty(S_preference_name, paramKey);
            this.addPropListener(paramKey, res[i]);
        }
        return res;
    }

    public JComboBox Create_JComboBoxReturnsTFText(String paramKey) {
        String itemsKey = paramKey + ".items";
        String[] items = null;
        try {
            items = (String[])ListOfComboboxItems.get(paramKey);
        }
        catch (Exception e) {
            items = null;
        }
        JComboBox<Object> res = null;
        res = items == null ? new JComboBox() : new JComboBox<String>(items);
        String curr = this.getValue(paramKey);
        curr = curr.toLowerCase();
        if (curr.equals("true")) {
            res.setSelectedIndex(0);
        } else {
            res.setSelectedIndex(1);
        }
        res.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                    src.putClientProperty(Preference.S_preference_nomorenotify, null);
                    return;
                }
                int which = src.getSelectedIndex();
                String item = (String)src.getSelectedItem();
                if (which == 0) {
                    Preference.this.prop.put(src.getClientProperty(Preference.S_preference_name), "true");
                    Preference.this.notifyOthers((String)src.getClientProperty(Preference.S_preference_name), "true", src);
                } else {
                    Preference.this.prop.put(src.getClientProperty(Preference.S_preference_name), "false");
                    Preference.this.notifyOthers((String)src.getClientProperty(Preference.S_preference_name), "false", src);
                }
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        res.putClientProperty(S_preference_idx_or_item_or_tf, "tf");
        this.addPropListener(paramKey, res);
        return res;
    }

    public JComboBox Create_JComboBoxReturnsIndex(String paramKey) {
        String itemsKey = paramKey + ".items";
        String[] items = null;
        try {
            items = (String[])ListOfComboboxItems.get(itemsKey);
        }
        catch (Exception e) {
            items = null;
        }
        JComboBox<Object> res = null;
        res = items == null ? new JComboBox() : new JComboBox<String>(items);
        if (items == null) {
            System.err.println("No such parameter definition:" + paramKey);
            return res;
        }
        res.setSelectedIndex(Integer.parseInt(this.getValue(paramKey)));
        res.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                    src.putClientProperty(Preference.S_preference_nomorenotify, null);
                    return;
                }
                int which = src.getSelectedIndex();
                String item = (String)src.getSelectedItem();
                Preference.this.prop.put(src.getClientProperty(Preference.S_preference_name), String.valueOf(which));
                Preference.this.notifyOthers((String)src.getClientProperty(Preference.S_preference_name), String.valueOf(which), src);
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        res.putClientProperty(S_preference_idx_or_item_or_tf, "idx");
        this.addPropListener(paramKey, res);
        return res;
    }

    public JComboBox Create_JComboBoxReturnsText(String paramKey) {
        String itemsKey = paramKey + ".items";
        String[] items = null;
        try {
            items = (String[])ListOfComboboxItems.get(itemsKey);
        }
        catch (Exception e) {
            items = null;
            e.printStackTrace();
        }
        JComboBox<Object> res = null;
        res = items == null ? new JComboBox() : new JComboBox<String>(items);
        res.setSelectedItem(this.getValue(paramKey));
        res.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                    src.putClientProperty(Preference.S_preference_nomorenotify, null);
                    return;
                }
                int which = src.getSelectedIndex();
                String item = (String)src.getSelectedItem();
                Preference.this.prop.put(src.getClientProperty(Preference.S_preference_name), item);
                Preference.this.notifyOthers((String)src.getClientProperty(Preference.S_preference_name), item, src);
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        res.putClientProperty(S_preference_idx_or_item_or_tf, "item");
        this.addPropListener(paramKey, res);
        return res;
    }

    public JComboBox Create_JComboBoxReturnsText(String paramKey, String[] args) {
        String itemsKey = paramKey + ".items";
        JComboBox<String> res = null;
        res = new JComboBox<String>(args);
        res.setSelectedItem(this.getValue(paramKey));
        res.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                if (src.getClientProperty(Preference.S_preference_nomorenotify) != null) {
                    src.putClientProperty(Preference.S_preference_nomorenotify, null);
                    return;
                }
                int which = src.getSelectedIndex();
                String item = (String)src.getSelectedItem();
                Preference.this.prop.put(src.getClientProperty(Preference.S_preference_name), item);
                Preference.this.notifyOthers((String)src.getClientProperty(Preference.S_preference_name), item, src);
            }
        });
        res.putClientProperty(S_preference_name, paramKey);
        res.putClientProperty(S_preference_idx_or_item_or_tf, "item");
        this.addPropListener(paramKey, res);
        return res;
    }

    public static DecimalFormat GetDecimalFormat() {
        int df_asIntValue = 3;
        if (df == null || df_asInt != df_asIntValue) {
            String decimalDef = "#,##0";
            if (df_asIntValue > 0) {
                decimalDef = decimalDef + ".";
                for (int i = 0; i < df_asIntValue; ++i) {
                    decimalDef = decimalDef + "#";
                }
            }
            df = new DecimalFormat(decimalDef);
            df_asInt = df_asIntValue;
        }
        return df;
    }

    public static DecimalFormat GetDecimalFormatE() {
        int df_asIntValue = 3;
        if (dfE == null || df_asIntE != df_asIntValue) {
            String decimalDef = "0";
            if (df_asIntValue > 0) {
                decimalDef = decimalDef + ".";
                for (int i = 0; i < df_asIntValue; ++i) {
                    decimalDef = decimalDef + "0";
                }
                decimalDef = decimalDef + "E0";
            }
            dfE = new DecimalFormat(decimalDef);
            df_asIntE = df_asIntValue;
        }
        return dfE;
    }

    public static String htmlString(double v) {
        return Preference.htmlString(v, Double.NaN);
    }

    public static String htmlString(double v, double threshold) {
        if (Double.isNaN(v)) {
            return "NaN";
        }
        if (0.0 == v) {
            return "0";
        }
        Double decimalTest = Math.log10(Math.abs(v));
        String res = !Double.isInfinite(decimalTest) && Math.log10(v) < (double)(-1 * Preference.GetDecimalFormat().getMaximumFractionDigits()) || v > 1000000.0 ? Preference.GetDecimalFormatE().format(v) : Preference.GetDecimalFormat().format(v);
        if (v <= threshold) {
            return res + " *";
        }
        return res;
    }
}

