/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.TaskMonitorAdoptor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;

public class ProgramFilesInstaller {
    private static String proframFilesFolder = null;
    private static String[] files2Download = new String[]{"cross_tabulation.exe", "hapcross_analysis.exe", "snpanalyzer.exe", "dllLib.dll", "snpanalyzer.conf", "engine.version", "fdr_calculation.exe"};

    private ProgramFilesInstaller() {
    }

    public static String GetMyZombiePath() {
        String MyZombiePath = System.getProperty("user.home");
        if (!new File(MyZombiePath = MyZombiePath + File.separator + "My Documents" + File.separator + "My SNPStudio").exists()) {
            if (!new File(MyZombiePath).mkdirs()) {
                System.out.println("Cannot create(init) MyZombiePath folder :" + MyZombiePath);
            } else {
                System.out.println("Success to create(init) MyZombiePath folder :" + MyZombiePath);
            }
        }
        return MyZombiePath;
    }

    public static String GetProgramFilesPath() {
        if (proframFilesFolder == null) {
            proframFilesFolder = System.getProperty("user.home");
            if (!new File(proframFilesFolder = proframFilesFolder + File.separator + "My Documents" + File.separator + "My SNPAnalyzer2" + File.separator + "Common" + File.separator + "runtime").exists()) {
                if (!new File(proframFilesFolder).mkdirs()) {
                    System.out.println("Cannot create(init) engine folder :" + proframFilesFolder);
                } else {
                    System.out.println("Success to create(init) engine folder :" + proframFilesFolder);
                }
            }
        }
        return proframFilesFolder;
    }

    private static String GetNewEngineVersion() {
        try {
            ClassLoader cl = ProgramFilesInstaller.class.getClassLoader();
            InputStream fbuff = cl.getResourceAsStream("engine.version");
            if (fbuff == null || fbuff.available() <= 0) {
                throw new Exception("Cannot locate engine.version from jar");
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(fbuff));
            String line = null;
            String version = null;
            while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                version = line;
            }
            r.close();
            fbuff.close();
            version = version.split("=")[1];
            return version;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String GetOldEngineVersion() {
        try {
            String filePath = ProgramFilesInstaller.GetProgramFilesPath() + File.separator + "engine.version";
            System.out.println(filePath);
            BufferedReader r = new BufferedReader(new FileReader(filePath));
            r.readLine();
            r.readLine();
            String version = r.readLine();
            version = version.split("=")[1];
            return version;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean IsEngineExtractNeed() {
        System.err.println("ProgramFilesInstaller.IsEngineExtractNeed ");
        String oldVersionS = ProgramFilesInstaller.GetOldEngineVersion();
        System.err.println("\toldVersionS=" + oldVersionS);
        String newVersionS = ProgramFilesInstaller.GetNewEngineVersion();
        System.err.println("\tnewVersionS=" + newVersionS);
        int oldVersion = 0;
        int newVersion = 0;
        try {
            oldVersion = Integer.parseInt(oldVersionS);
        }
        catch (Exception e) {
            oldVersion = -100;
        }
        try {
            newVersion = Integer.parseInt(newVersionS);
        }
        catch (Exception e) {
            newVersion = -99;
        }
        System.err.println("\toldVersion=" + oldVersion);
        System.err.println("\tnewVersion=" + newVersion);
        if (newVersion < 0) {
            return false;
        }
        return newVersion > oldVersion;
    }

    public static void ExtractEnginesIfNeed(TaskMonitorAdoptor progress) {
        System.err.println("ProgramFilesInstaller.ExtractEnginesIfNeed");
        if (!ProgramFilesInstaller.IsEngineExtractNeed()) {
            return;
        }
        progress.setTaskTitle("Application Loading");
        progress.ProgressStart(new String[]{"Update Analysis Engine"});
        progress.setProgressMax(0, files2Download.length * 2);
        for (int i = 0; i < files2Download.length; ++i) {
            try {
                System.out.println("Extracting " + files2Download[i] + " ...");
                ClassLoader cl = ProgramFilesInstaller.class.getClassLoader();
                InputStream fbuff = cl.getResourceAsStream(files2Download[i]);
                if (fbuff == null || fbuff.available() <= 0) {
                    JOptionPane.showMessageDialog(null, "Cannot extract " + files2Download[i]);
                    continue;
                }
                FileOutputStream fout = new FileOutputStream(ProgramFilesInstaller.GetProgramFilesPath() + File.separator + files2Download[i]);
                progress.ProgressSetValue(0, i * 2);
                int c = fbuff.read();
                while (c != -1) {
                    fout.write(c);
                    c = fbuff.read();
                }
                fbuff.close();
                fout.close();
                System.err.println("Success to extract " + ProgramFilesInstaller.GetProgramFilesPath() + File.separator + files2Download[i]);
                progress.ProgressSetValue(0, i * 2 + 1);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        progress.ProgressStop();
    }

    private static ByteArrayOutputStream getByteOutputFromFileInput(BufferedInputStream bufferedInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int c = bufferedInputStream.read();
            while (c != -1) {
                byteArrayOutputStream.write(c);
                c = bufferedInputStream.read();
            }
        }
        catch (IOException e) {
            return null;
        }
        return byteArrayOutputStream;
    }
}

