/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class SNPContentsParser {
    static final String[] alleleList = new String[]{"A", "C", "G", "T"};
    public static final String HEADER_CRSS_SNP_LISK = "Risk_Factor";
    public static final String HEADER_CRSS_SNP_MODEL = "Model";
    public static final String HEADER_CRSS_SNP_MCORRECTION = "Multi_Correction";
    public static final int CRSS_TESTMETHOD_GFT_PVALUE = 0;
    public static final int CRSS_TESTMETHOD_LIKELIHOOD_PVALUE = 1;
    public static final int CRSS_TESTMETHOD_MIN_PVALUE = 2;
    public static final int CRSS_TESTMETHOD_MAX_PVALUE = 3;
    public static final String HEADER_CRSS_HAP_MODEL = "Model";
    public static final String HEADER_CRSS_HAP_MCORRECTION = "Multi_Correction";
    static final String Wrong_Value = "-1.000";

    private SNPContentsParser() {
    }

    public static DefaultTableModel ReadFileAndReturnAlleleFrequencyTableModel(String flagPath, String IWillWaitThisSampleType) {
        DefaultTableModel res = new DefaultTableModel();
        res.addColumn((Object)"", new String[]{"Allele/SNP ID", "A", "C", "G", "T"});
        try {
            HashSet snp_id_list = new HashSet();
            BufferedReader r = null;
            String line = null;
            if (flagPath == null || !new File(flagPath).exists()) {
                return res;
            }
            r = new BufferedReader(new FileReader(flagPath));
            line = null;
            String IWillWaitThisHeader = "!Sample_Type:" + IWillWaitThisSampleType;
            while (!((line = r.readLine()) == null || line.length() != 0 && line.charAt(0) == '!' && (line = line.trim()).equals(IWillWaitThisHeader))) {
            }
            int tstart = 0;
            int tstop = 0;
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') break;
                tstart = 0;
                tstop = 0;
                tstop = line.indexOf("\t", tstart);
                String token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                if (line.trim().endsWith("1")) continue;
                String this_snp_id = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String[] allele = new String[]{token.substring(0, 1), token.substring(2, 3)};
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String[] freqS = token.split("/");
                Object[] colData = new String[5];
                colData[0] = this_snp_id;
                for (int i = 0; i < alleleList.length; ++i) {
                    for (int j = 0; j < allele.length; ++j) {
                        if (!alleleList[i].equals(allele[j])) continue;
                        colData[i + 1] = freqS[j];
                    }
                }
                res.addColumn((Object)"", colData);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static DefaultTableModel ReadFileAndReturnHaplotypeFrequencyTableModel(String phapPath, String IWillWaitThisSampleType, double min_hap_freq) {
        DefaultTableModel res = new DefaultTableModel(new String[]{"Haplotype", "Freq", "Sequence"}, 0);
        try {
            if (phapPath == null || !new File(phapPath).exists()) {
                return res;
            }
            BufferedReader r = new BufferedReader(new FileReader(phapPath));
            String line = null;
            String IWillWaitThisHeader = "!Sample_Type:" + IWillWaitThisSampleType;
            while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) != '!' || !(line = line.trim()).equals(IWillWaitThisHeader)) continue;
                r.readLine();
                break;
            }
            int tstart = 0;
            int tstop = 0;
            while ((line = r.readLine()) != null) {
                double this_hap_freq_d;
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') break;
                tstart = 0;
                tstop = 0;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                String token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_hap_id = token;
                this_hap_id = this_hap_id.substring(this_hap_id.lastIndexOf("_") + 1);
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_hap_seq = token;
                token = line.substring(tstart, line.length());
                String this_hap_freq = token;
                if ("-1.#IND0".equals(this_hap_freq)) {
                    this_hap_freq = "0";
                }
                if ((this_hap_freq_d = Double.parseDouble(this_hap_freq)) < min_hap_freq) break;
                res.addRow(new String[]{this_hap_id, this_hap_freq, this_hap_seq});
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static DefaultTableModel ReadFileAndIndividualReturnHaplotypeTableModel(String ihapPath) {
        DefaultTableModel res = new DefaultTableModel(new String[]{"Individual ID", "Haplotype1", "Haplotype1", "Accuracy", "Sample Type"}, 0);
        try {
            if (ihapPath == null || !new File(ihapPath).exists()) {
                return res;
            }
            BufferedReader r = new BufferedReader(new FileReader(ihapPath));
            String line = null;
            r.readLine();
            r.readLine();
            r.readLine();
            int tstart = 0;
            int tstop = 0;
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') break;
                tstart = 0;
                tstop = 0;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                String token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_ind_id = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String hap1 = token = token.substring(token.lastIndexOf("_") + 1);
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String hap2 = token = token.substring(token.lastIndexOf("_") + 1);
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String accuracy = token;
                String sample = line.substring(tstart);
                res.addRow(new String[]{this_ind_id, hap1, hap2, accuracy, sample});
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static int ApplyTest(String gft, String lik, int method) {
        if (gft.charAt(0) == '-') {
            if (lik.charAt(0) == '-') {
                return -1;
            }
            return 1;
        }
        if (lik.charAt(0) == '-') {
            return 0;
        }
        if (method == 0) {
            return 0;
        }
        if (method == 1) {
            return 1;
        }
        double p_gft = Double.parseDouble(gft);
        double p_lik = Double.parseDouble(lik);
        if (method == 2) {
            if (p_gft == Math.min(p_gft, p_lik)) {
                return 0;
            }
            return 1;
        }
        if (method == 3) {
            if (p_gft == Math.max(p_gft, p_lik)) {
                return 0;
            }
            return 1;
        }
        System.out.println("unknown test method");
        return 0;
    }

    public static DefaultTableModel ReadFileSNPCaseControlTableModel(String crssPath, Hashtable options, String thisLiskFactor, String thisModel, int testMethod, Vector listLiskFactor, Vector listModel) {
        DefaultTableModel res = new DefaultTableModel(new String[]{"<html>Individual<br>ID</html>", "<html>X<sup>2</sup></html>", "<html><i>p</i>-value</html>", "OR", "<html>Lower CI<br>of OR</html>", "<html>Upper CI<br>of OR</html>", "AR", "PAR", "IDX"}, 0);
        try {
            if (crssPath == null || !new File(crssPath).exists()) {
                return res;
            }
            BufferedReader r = new BufferedReader(new FileReader(crssPath));
            String line = null;
            boolean returnThisBlock = false;
            String lastLiskFactor = null;
            String lastModel = null;
            boolean foundBlock = false;
            int tstart = 0;
            int tstop = 0;
            int lineCnt = 0;
            Hashtable<String, String> tmpOption = new Hashtable<String, String>();
            while ((line = r.readLine()) != null) {
                if (line.charAt(0) == '!') {
                    if (foundBlock) {
                        returnThisBlock = false;
                    }
                    String[] tok = line.split(":");
                    String key = tok[0].substring(1).trim();
                    String val = null;
                    val = tok.length == 2 ? tok[1].trim() : "";
                    if ("additive".equalsIgnoreCase(val)) {
                        val = "Multiplicative";
                    }
                    tmpOption.put(key, val);
                    if (key.equalsIgnoreCase(HEADER_CRSS_SNP_LISK)) {
                        lastLiskFactor = val;
                        if (!listLiskFactor.contains(val)) {
                            listLiskFactor.add(val);
                        }
                    }
                    if (!key.equalsIgnoreCase("Model")) continue;
                    lastModel = val;
                    if (listModel.contains(val)) continue;
                    listModel.add(val);
                    continue;
                }
                if (!foundBlock) {
                    if (thisLiskFactor == null || thisModel == null) {
                        returnThisBlock = true;
                        foundBlock = true;
                    } else if (thisLiskFactor.equalsIgnoreCase(lastLiskFactor) && thisModel.equalsIgnoreCase(lastModel)) {
                        returnThisBlock = true;
                        foundBlock = true;
                    } else {
                        returnThisBlock = false;
                    }
                    if (returnThisBlock) {
                        options.putAll(tmpOption);
                    }
                    tmpOption = new Hashtable();
                    continue;
                }
                if (!returnThisBlock || line.length() == 0) continue;
                ++lineCnt;
                tstart = 0;
                tstop = 0;
                tstop = line.indexOf("\t", tstart);
                String token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_snp_id = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_OR = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_OR_CI = token;
                String[] tok2 = SNPContentsParser.splitByMinusSeparator(this_OR_CI);
                String this_OR_LO = tok2[0];
                String this_OR_HI = tok2[1];
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_AR = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_PAR = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_x2 = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_pvalue = token;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_x2_lrt = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_pvalue_lrt = token;
                int which = SNPContentsParser.ApplyTest(this_pvalue, this_pvalue_lrt, testMethod);
                if (which < 0 || (which != 0 ? this_pvalue_lrt.startsWith("-1") : this_pvalue.startsWith("-1"))) continue;
                if (this_AR == "-") {
                    this_AR = "0";
                }
                if (this_PAR == "-") {
                    this_PAR = "0";
                }
                if (Double.parseDouble(this_PAR) > 100.0) {
                    this_PAR = "100";
                }
                res.addRow(new Object[]{this_snp_id, Double.valueOf(which == 0 ? this_x2 : this_x2_lrt), Double.valueOf(which == 0 ? this_pvalue : this_pvalue_lrt), Double.valueOf(this_OR), Double.valueOf(this_OR_LO), Double.valueOf(this_OR_HI), Double.valueOf(this_AR), Double.valueOf(this_PAR), lineCnt});
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static DefaultTableModel ReadFileHaplotypeCaseControlTableModel(String crssPath, String whichBlock, int testMethod, HashSet blockList, Hashtable options, String thisModel, Vector listModel) {
        return SNPContentsParser.ReadFileHaplotypeCaseControlTableModel(crssPath, whichBlock, testMethod, blockList, options, thisModel, listModel, true);
    }

    private static String[] splitByMinusSeparator(String tok) {
        int found = tok.indexOf("-");
        if (found == 0) {
            found = tok.indexOf("-", found + 1);
        }
        String pre = tok.substring(0, found);
        String post = tok.substring(found + 1);
        return new String[]{pre.trim(), post.trim()};
    }

    public static DefaultTableModel ReadFileHaplotypeCaseControlTableModel(String crssPath, String whichBlock, int testMethod, HashSet blockList, Hashtable options, String thisModel, Vector listModel, boolean bRemoveInvalid) {
        DefaultTableModel res = new DefaultTableModel(new String[]{"<html>H-ID</html>", "<html>X<sup>2</sup></html>", "<html><i>p</i>-value</html>", "OR", "<html>Lower CI<br>of OR</html>", "<html>Upper CI<br>of OR</html>", "AR", "PAR", "IDX"}, 0);
        try {
            if (crssPath == null || !new File(crssPath).exists()) {
                return res;
            }
            BufferedReader r = new BufferedReader(new FileReader(crssPath));
            String line = null;
            boolean returnThisBlock = false;
            String lastModel = null;
            boolean foundBlock = false;
            int tstart = 0;
            int tstop = 0;
            int lineCnt = 0;
            Hashtable<String, String> tmpOption = new Hashtable<String, String>();
            while ((line = r.readLine()) != null) {
                if (line.charAt(0) == '!') {
                    if (foundBlock) {
                        returnThisBlock = false;
                    }
                    String[] tok = line.split(":");
                    String key = tok[0].substring(1).trim();
                    String val = null;
                    val = tok.length == 2 ? tok[1].trim() : "";
                    if ("additive".equalsIgnoreCase(val)) {
                        val = "Multiplicative";
                    }
                    tmpOption.put(key, val);
                    if (!key.equalsIgnoreCase("Model")) continue;
                    lastModel = val;
                    if (listModel.contains(val)) continue;
                    listModel.add(val);
                    continue;
                }
                if (!foundBlock) {
                    if (thisModel == null) {
                        returnThisBlock = true;
                        foundBlock = true;
                    } else if (thisModel.equalsIgnoreCase(lastModel)) {
                        returnThisBlock = true;
                        foundBlock = true;
                    } else {
                        returnThisBlock = false;
                    }
                    if (returnThisBlock) {
                        System.out.println("### found1!!");
                        options.putAll(tmpOption);
                    }
                    tmpOption = new Hashtable();
                    continue;
                }
                if (!returnThisBlock || line.length() == 0) continue;
                ++lineCnt;
                tstart = 0;
                tstop = 0;
                tstop = line.indexOf("\t", tstart);
                String token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_hap_id = token;
                String[] tok2 = this_hap_id.split("_");
                String blockno = tok2[2];
                this_hap_id = "h" + tok2[3];
                if (blockList != null) {
                    blockList.add(blockno);
                }
                if (whichBlock != null && !whichBlock.equals(blockno)) continue;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_OR = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_OR_CI = token;
                String[] tok22 = SNPContentsParser.splitByMinusSeparator(this_OR_CI);
                String this_OR_LO = tok22[0];
                String this_OR_HI = tok22[1];
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_AR = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_PAR = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_x2 = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_pvalue = token;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_x2_lrt = token;
                tstop = line.indexOf("\t", tstart);
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                String this_pvalue_lrt = token;
                int which = SNPContentsParser.ApplyTest(this_pvalue, this_pvalue_lrt, testMethod);
                if (which < 0 || (which != 0 ? this_pvalue_lrt.startsWith("-1") : this_pvalue.startsWith("-1"))) continue;
                if (this_AR == "-") {
                    this_AR = "0";
                }
                if (this_PAR == "-") {
                    this_PAR = "0";
                }
                res.addRow(new Object[]{this_hap_id, Double.valueOf(which == 0 ? this_x2 : this_x2_lrt), Double.valueOf(which == 0 ? this_pvalue : this_pvalue_lrt), Double.valueOf(this_OR), Double.valueOf(this_OR_LO), Double.valueOf(this_OR_HI), Double.valueOf(this_AR), Double.valueOf(this_PAR), lineCnt});
            }
            while ((line = r.readLine()) != null && (line.length() == 0 || line.charAt(0) != '!')) {
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Object[] ReadFileLDBlockTableModel(String hblkPath, String whichSample) {
        try {
            if (hblkPath == null || !new File(hblkPath).exists()) {
                return new Object[]{new int[0][0], new int[0]};
            }
            BufferedReader r = new BufferedReader(new FileReader(hblkPath));
            String line = null;
            Vector<int[]> block_ary = new Vector<int[]>();
            Vector<String> tagger_ary = new Vector<String>();
            String IWillWaitThisHeader = "!Sample_Type:" + whichSample;
            block2: while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) != '!' || !line.equals(IWillWaitThisHeader)) continue;
                while ((line = r.readLine()) != null) {
                    if (line.length() == 0 || !line.startsWith("SNP_List")) continue;
                    line = line.trim();
                    String[] tok = line.split("\t");
                    int from = Integer.parseInt(tok[1]);
                    int to = Integer.parseInt(tok[tok.length - 1]);
                    block_ary.add(new int[]{from, to});
                    r.readLine();
                    line = r.readLine();
                    int tstart = 0;
                    int tstop = 0;
                    for (int i = 0; i < tok.length; ++i) {
                        tstop = line.indexOf("\t", tstart);
                        String token = line.substring(tstart, tstop);
                        tstart = tstop + 1;
                        if (i == 0 || token.charAt(0) != 'Y') continue;
                        tagger_ary.add(tok[i]);
                    }
                    continue block2;
                }
            }
            r.close();
            int[][] res_block = new int[block_ary.size()][];
            block_ary.toArray((Object[])res_block);
            int[] res_tag = new int[tagger_ary.size()];
            for (int i = 0; i < res_tag.length; ++i) {
                res_tag[i] = Integer.parseInt((String)tagger_ary.get(i));
            }
            return new Object[]{res_block, res_tag};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object[]{new int[0][0], new int[0]};
        }
    }

    public static int[] ReadFileLDTagAndReturnIndex(String tagPath, String whichSample) {
        try {
            if (tagPath == null || !new File(tagPath).exists()) {
                return new int[0];
            }
            BufferedReader r = new BufferedReader(new FileReader(tagPath));
            String line = null;
            Vector<String> tagger_ary = new Vector<String>();
            String IWillWaitThisHeader = "!Sample_Type:" + whichSample;
            block2: while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) != '!' || !line.equals(IWillWaitThisHeader)) continue;
                r.readLine();
                while ((line = r.readLine()) != null) {
                    if (line.length() == 0) continue;
                    if (line.charAt(0) == '!') break block2;
                    line = line.trim();
                    int tstart = 0;
                    int tstop = 0;
                    tstop = line.indexOf("\t", tstart);
                    tstart = tstop + 1;
                    tstop = line.indexOf("\t", tstart);
                    tstart = tstop + 1;
                    tstop = line.indexOf("\t", tstart);
                    String this_snp_idx = line.substring(tstart, tstop);
                    tstart = tstop + 1;
                    if (line.charAt(tstart) == 's') continue;
                    tagger_ary.add(this_snp_idx);
                }
                break block2;
            }
            r.close();
            int[] res_tag = new int[tagger_ary.size()];
            for (int i = 0; i < res_tag.length; ++i) {
                res_tag[i] = Integer.parseInt((String)tagger_ary.get(i)) + 1;
            }
            Arrays.sort(res_tag);
            return res_tag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[0];
        }
    }

    public static int[][] ReadFileAndReturnInValidSNPIndex(String flagPath, String whichSample) {
        try {
            if (flagPath == null || !new File(flagPath).exists()) {
                return new int[][]{new int[0], new int[0]};
            }
            BufferedReader r = new BufferedReader(new FileReader(flagPath));
            String line = null;
            String IWillWaitThisHeader = "!Sample_Type:" + whichSample;
            while (!((line = r.readLine()) == null || line.length() != 0 && line.charAt(0) == '!' && line.startsWith(IWillWaitThisHeader))) {
            }
            Integer snp_idx = 0;
            Vector<Integer> snp_idx_list = new Vector<Integer>();
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') break;
                if (line.charAt(line.length() - 1) == '1') {
                    snp_idx_list.add(snp_idx);
                }
                Integer n = snp_idx;
                Integer n2 = snp_idx = Integer.valueOf(snp_idx + 1);
            }
            int[] res = new int[snp_idx_list.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (Integer)snp_idx_list.get(i);
            }
            String IWillWaitThisHeader2 = "!Sample_Index";
            while (!((line = r.readLine()) == null || line.length() != 0 && line.charAt(0) == '!' && line.startsWith("!Sample_Index"))) {
            }
            int sample_idx = 0;
            Vector<Integer> sample_idx_list = new Vector<Integer>();
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') break;
                if (line.charAt(line.length() - 1) == '1') {
                    sample_idx_list.add(new Integer(sample_idx));
                }
                ++sample_idx;
            }
            int[] res2 = new int[sample_idx_list.size()];
            for (int i = 0; i < res2.length; ++i) {
                res2[i] = (Integer)sample_idx_list.get(i);
            }
            r.close();
            return new int[][]{res, res2};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[][]{new int[0], new int[0]};
        }
    }

    public static void SortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        model.fireTableStructureChanged();
    }

    protected static class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            Vector v1 = (Vector)a;
            Vector v2 = (Vector)b;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }
}

