/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.FileLoopWorker;
import com.istech21.snpanalyzer2free.FileLooper;
import com.istech21.snpanalyzer2free.LineCounter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import javax.swing.JOptionPane;

public class SampleFlagger {
    public String LIMIT_HEADER = "!sample_missing_limit:";
    public String COLUMN_NAME_HEADER = "!Sample_Index\tMissing_Rate\tclass\tsample_missing_flag";
    public static final String SAMPLE_FLAG_INFO = ".sampleFlagInfo";
    public static final int GENOTYPE_COLUMN = 4;
    private File[] files = new File[0];
    private double limit;
    private int snpCount = 0;
    private int[] missingCounter;
    private String[] sampleNames;
    private String[] affections;
    private File reportFile;

    public SampleFlagger(File[] files, double limit) {
        this.files = files;
        this.limit = limit;
        try {
            this.reportFile = File.createTempFile(this.getClass().getName(), this.getClass().getName());
        }
        catch (IOException e) {
            this.reportFile = null;
            e.printStackTrace();
        }
    }

    public boolean calculateFreq() {
        int i;
        for (i = 0; i < this.files.length; ++i) {
            FileLooper looper = new FileLooper(this.files[i]);
            try {
                looper.loop(new FileLoopWorker(){
                    LineCounter lineCounter = new LineCounter();

                    public void processLine(String line) throws Exception {
                        String[] toks = line.split("\t");
                        if (this.lineCounter.isNotHeader()) {
                            SampleFlagger.this.calculate(toks);
                        } else if (SampleFlagger.this.sampleNames == null) {
                            SampleFlagger.this.setSampleNames(line);
                        } else {
                            SampleFlagger.this.setAffections(line);
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.makeReport();
        for (i = 0; i < this.files.length; ++i) {
            try {
                this.copy(this.reportFile.getAbsolutePath(), this.files[i].getAbsolutePath() + SAMPLE_FLAG_INFO);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean successDelete = this.reportFile.delete();
        if (!successDelete) {
            JOptionPane.showMessageDialog(null, "Cannot delete temp file :" + this.reportFile.getName());
        }
        return true;
    }

    protected void setAffections(String line) {
        String[] toks = line.split("\t");
        this.affections = new String[toks.length - 4];
        for (int i = 4; i < toks.length; ++i) {
            this.affections[i - 4] = toks[i];
        }
    }

    protected void setSampleNames(String line) {
        String[] toks = line.split("\t");
        this.sampleNames = new String[toks.length - 4];
        for (int i = 4; i < toks.length; ++i) {
            this.sampleNames[i - 4] = toks[i];
        }
    }

    public int[] getCounter() {
        return this.missingCounter;
    }

    public double[] getFrequency() {
        double[] freq = new double[this.missingCounter.length];
        for (int i = 0; i < this.missingCounter.length; ++i) {
            freq[i] = (double)this.missingCounter[i] / (double)this.snpCount;
        }
        return freq;
    }

    public boolean[] getFlaggedList() {
        boolean[] list = new boolean[this.missingCounter.length];
        for (int i = 0; i < this.missingCounter.length; ++i) {
            if (!((double)this.missingCounter[i] / (double)this.snpCount > this.limit)) continue;
            list[i] = true;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFlagFile(File[] flagFiles, File reportFile) {
        if (reportFile == null) {
            return;
        }
        RandomAccessFile raf = null;
        RandomAccessFile bos = null;
        try {
            raf = new RandomAccessFile(reportFile.getAbsoluteFile(), "r");
        }
        catch (FileNotFoundException e) {
            return;
        }
        byte[] buf = new byte[4098];
        for (int i = 0; i < flagFiles.length; ++i) {
            try {
                raf.seek(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
            try {
                int bytesRead;
                bos = this.getFlagRandomAccessFile(flagFiles[i]);
                while ((bytesRead = raf.read(buf)) > 0) {
                    bos.write(buf, 0, bytesRead);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private RandomAccessFile getFlagRandomAccessFile(File file) throws IOException {
        String line;
        int lineDelimiterLen = SampleFlagger.getLineDelimiterLen(file);
        BufferedReader br = new BufferedReader(new FileReader(file));
        long fpos = 0L;
        while ((line = br.readLine()) != null && !line.startsWith(this.LIMIT_HEADER)) {
            fpos += (long)(line.length() + lineDelimiterLen);
        }
        br.close();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.seek(fpos);
        return raf;
    }

    private void makeReport() {
        try {
            if (this.check()) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.reportFile));
                bw.write(this.LIMIT_HEADER + this.limit + "\n" + this.COLUMN_NAME_HEADER + "\n");
                for (int i = 0; i < this.sampleNames.length; ++i) {
                    double rate = (double)this.missingCounter[i] / (double)this.snpCount;
                    bw.write(this.sampleNames[i] + "\t" + rate + "\t" + this.affections[i] + "\t" + this.calcFlag(rate, this.limit) + "\n");
                }
                try {
                    bw.close();
                    bw = null;
                }
                catch (Exception ignore) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int calcFlag(double rate, double limit) {
        if (rate == 0.0) {
            return 0;
        }
        return rate < limit ? 0 : 1;
    }

    private boolean check() {
        if (this.missingCounter.length != this.sampleNames.length) {
            return false;
        }
        if (this.missingCounter.length != this.affections.length) {
            return false;
        }
        return this.sampleNames.length == this.affections.length;
    }

    protected void calculate(String[] toks) {
        if (this.missingCounter == null) {
            this.missingCounter = new int[toks.length - 4];
        }
        for (int i = 4; i < toks.length; ++i) {
            if (!this.isMissingGenotype(toks[i])) continue;
            int n = i - 4;
            this.missingCounter[n] = this.missingCounter[n] + 1;
        }
        ++this.snpCount;
    }

    private boolean isMissingGenotype(String token) {
        return token.toUpperCase().equals("N/N");
    }

    private void printCounter() {
        for (int i = 0; i < this.missingCounter.length; ++i) {
            System.out.println(i + " : " + this.missingCounter[i] + " : " + (double)this.missingCounter[i] / (double)this.snpCount);
        }
        System.out.println();
    }

    public void copy(String srcFileName, String dstFileName) throws Exception {
        FileChannel srcChannel = new FileInputStream(srcFileName).getChannel();
        FileChannel dstChannel = new FileOutputStream(dstFileName).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    public static int getLineDelimiterLen(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[4096];
        int lineDelimiterLen = 0;
        while (fis.read(buf) > 0 && (lineDelimiterLen = SampleFlagger.getLineDelimiterLen(buf)) <= 0) {
        }
        fis.close();
        return lineDelimiterLen;
    }

    private static int getLineDelimiterLen(byte[] buf) {
        int lineDelimiterLen = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 10) continue;
            lineDelimiterLen = 1;
            if (i <= 0 || buf[i - 1] != 13) break;
            lineDelimiterLen = 2;
            break;
        }
        return lineDelimiterLen;
    }
}

