/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.DialogTaskMonitorImpl;
import com.istech21.snpanalyzer2free.IconPool;
import com.istech21.snpanalyzer2free.MenuResponsable;
import com.istech21.snpanalyzer2free.NativeEngineWrapper;
import com.istech21.snpanalyzer2free.Preference;
import com.istech21.snpanalyzer2free.TaskMonitorAdoptor;
import com.istech21.snpanalyzer2free.ViewLog;
import com.l2fprod.common.swing.JLinkButton;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Snpanalyzer2
extends JApplet {
    public String htmlBase = null;
    public String demoUrl = null;
    public String htmlGenotypeFormatURL = null;
    public String PathGeno = null;
    public String PathFlag = null;
    public static final int DefaultAppletWidth = 924;
    public static final int DefaultAppletHeight = 618;
    public static int WidthSplitter = 4;
    public static int HeightDocument = 618;
    public static int WidthMenu = 245;
    public static int WidthDocument = 924 - WidthMenu - WidthSplitter - 10;
    private static Dimension defaultPreferredSize = new Dimension(WidthDocument + WidthSplitter + WidthMenu, HeightDocument);
    JSplitPane splitter = null;
    JPanel panelMenu = null;
    JPanel panelDocument = null;
    JPanel panelDocumentOption = null;
    JPanel panelDocumentView = null;
    public MenuResponsable menuListener = null;
    Font small = null;
    public ViewLog viewLog = null;
    public JPanel viewLogPanel = null;
    TaskMonitorAdoptor monitor = new TaskMonitorAdoptor();
    public static final int CMD_FLAGGING_AND_IMPUTATION = 0;
    public static final int CMD_IMPUTATON = 1;
    public static final int CMD_HAPLOTYPE_EM = 2;
    public static final int CMD_HAPLOTYPE_PLEM = 3;
    public static final int CMD_LD = 4;
    public static final int CMD_LD_TAGGER = 5;
    public static final int CMD_LDBLOCK_GABRIEL = 6;
    public static final int CMD_CASECONTROL_SNP = 7;
    public static final int CMD_CASECONTROL_HAPLOTYPE = 8;
    public static final int CMD_FDR_SNP = 9;
    public static final int CMD_FDR_HAP = 10;
    boolean bAnyManualFlaggingApplied = false;
    static Preference pref = null;
    JLinkButton taskImportEdit = null;
    public String genoPathForCaseControl = null;
    public String hblkPathForCaseControl = null;
    public String PathSrc = null;
    private String LastHome = null;
    public HyperlinkListener hLinkManger = null;
    public int snpCount = 0;
    public int sampleCount = 0;

    public void ResizeWindow() {
        this.ResizeWindow(this.getWidth(), this.getHeight());
    }

    public void ResizeWindow(int w, int h) {
        System.out.println("ResizeWindow " + w + "," + h);
        WidthSplitter = 4;
        HeightDocument = h;
        WidthMenu = 245;
        WidthDocument = w - WidthMenu - WidthSplitter - 10;
    }

    public Dimension getPreferredSize() {
        return defaultPreferredSize;
    }

    public static void CopyFile(String srcFile, String dstFile) {
        if (new File(srcFile).equals(new File(dstFile))) {
            return;
        }
        try {
            System.out.println("copy " + new File(srcFile).getName() + " to " + new File(dstFile).getName());
            FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
            FileChannel dstChannel = new FileOutputStream(dstFile).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAnyManualFlaggingApplied() {
        return this.bAnyManualFlaggingApplied;
    }

    public void run_external(int CMD, String[] opt) {
        try {
            Hashtable<String, String> option;
            if (CMD == 0) {
                option = new Hashtable<String, String>();
                if (opt.length >= 1 && "init".equals(opt[0])) {
                    this.bAnyManualFlaggingApplied = false;
                    option.put("flagging.sampleMgf", "0.5");
                    option.put("flagging.snpMgf", "0.1");
                    option.put("flagging.maf", "0.0");
                    option.put("flagging.hwe", "0.0");
                    option.put("flagging.hwemulticorrection", "N");
                    NativeEngineWrapper.run_flagging(this.PathGeno, option, null, this.monitor);
                    new File(this.PathGeno).delete();
                    new File(this.PathGeno + ".newflagged").renameTo(new File(this.PathGeno));
                } else {
                    this.bAnyManualFlaggingApplied = true;
                    Snpanalyzer2.CopyFile(this.PathSrc, this.PathGeno);
                    String sample_missinggf = pref.getValue("flagging.sample.missinggf");
                    String marker_missinggf = pref.getValue("flagging.marker.missinggf");
                    String maf = pref.getValue("flagging.marker.maf");
                    String hwe_pvalue = pref.getValue("flagging.marker.hwe.pvalue");
                    this.CopyOptionValueFromPref(option, "flagging.sampleMgf");
                    this.CopyOptionValueFromPref(option, "flagging.snpMgf");
                    this.CopyOptionValueFromPref(option, "flagging.maf");
                    this.CopyOptionValueFromPref(option, "flagging.hwe");
                    this.CopyOptionValueFromPref(option, "flagging.hwemulticorrection");
                    NativeEngineWrapper.run_flagging(this.PathGeno, option, null, this.monitor);
                    new File(this.PathGeno).delete();
                    new File(this.PathGeno + ".newflagged").renameTo(new File(this.PathGeno));
                    option = new Hashtable();
                    this.CopyOptionValueFromPref(option, "imputation.replace");
                    if (!"0".equals(option.get("imputation.replace"))) {
                        NativeEngineWrapper.run_imputation(this.PathGeno, option, null, this.monitor);
                    }
                }
            }
            if (CMD == 2) {
                this.monitor.ProgressStart(new String[]{"Haplotype Estimation"});
                this.monitor.ProgressSetMax(0, -1);
                this.monitor.ProgressSetValue(0, -1);
                option = new Hashtable();
                option.put("haplotype.estimation.method", "EM");
                this.CopyOptionValueFromPref(option, "haplotype.estimation.minfreq");
                this.CopyOptionValueFromPref(option, "haplotype.em.convergence");
                this.CopyOptionValueFromPref(option, "haplotype.em.initmethod");
                NativeEngineWrapper.run_haplotypeestimation(this.PathGeno, option, null, this.monitor);
                this.monitor.ProgressSetMax(0, 100);
                this.monitor.ProgressSetValue(0, 100);
                this.monitor.ProgressStop();
            }
            if (CMD == 3) {
                this.monitor.ProgressStart(new String[]{"Haplotype Estimation"});
                this.monitor.ProgressSetMax(0, -1);
                this.monitor.ProgressSetValue(0, -1);
                option = new Hashtable();
                option.put("haplotype.estimation.method", "PLEM");
                this.CopyOptionValueFromPref(option, "haplotype.estimation.minfreq");
                this.CopyOptionValueFromPref(option, "haplotype.em.convergence");
                this.CopyOptionValueFromPref(option, "haplotype.em.initmethod");
                this.CopyOptionValueFromPref(option, "haplotype.plem.partitionno");
                this.CopyOptionValueFromPref(option, "haplotype.plem.freqlimit");
                NativeEngineWrapper.run_haplotypeestimation(this.PathGeno, option, null, this.monitor);
                this.monitor.ProgressSetMax(0, 100);
                this.monitor.ProgressSetValue(0, 100);
                this.monitor.ProgressStop();
            }
            if (CMD == 4) {
                option = new Hashtable();
                option.put("ld.segmentlimit", pref.getValue("ld.segmentlimit"));
                option.put("ld.4gamete.mhf", pref.getValue("ld.4gamete.mhf"));
                NativeEngineWrapper.run_pairwiseld(this.PathGeno, option, null, this.monitor);
            }
            if (CMD == 5) {
                option = new Hashtable();
                option.put("ld.ldtag.maf", pref.getValue("ld.ldtag.maf"));
                option.put("ld.ldtag.r2", pref.getValue("ld.ldtag.r2"));
                NativeEngineWrapper.run_ldbasedtagger(this.PathGeno, option, null, this.monitor);
            }
            if (CMD == 6) {
                option = new Hashtable();
                this.CopyOptionValueFromPref(option, "ld.segmentlimit");
                option.put("ld.4gamete.mhf", pref.getValue("ld.4gamete.mhf"));
                option.put("ld.blocking.method", "Gabriel");
                this.CopyOptionValueFromPref(option, "ld.gabriel.lth");
                this.CopyOptionValueFromPref(option, "ld.gabriel.uth");
                this.CopyOptionValueFromPref(option, "ld.gabriel.maf");
                this.CopyOptionValueFromPref(option, "ld.gabriel.strongld");
                option.put("ld.gabriel.bst", "0");
                this.CopyOptionValueFromPref(option, "ld.gabriel.strongrecombrate");
                NativeEngineWrapper.run_ldblocking(this.PathGeno, option, null, this.monitor);
            }
            if (CMD == 7) {
                option = new Hashtable();
                this.CopyOptionValueFromPref(option, "casecontrol.snp.liskallele");
                this.CopyOptionValueFromPref(option, "casecontrol.snp.model");
                this.CopyOptionValueFromPref(option, "casecontrol.snp.pvalue");
                this.CopyOptionValueFromPref(option, "casecontrol.snp.bonfcorrection");
                NativeEngineWrapper.run_crss_snp(this.genoPathForCaseControl, option, null, this.monitor);
            }
            if (CMD == 8) {
                option = new Hashtable();
                this.CopyOptionValueFromPref(option, "casecontrol.haplotype.model");
                this.CopyOptionValueFromPref(option, "casecontrol.haplotype.pvalue");
                this.CopyOptionValueFromPref(option, "casecontrol.haplotype.bonfcorrection");
                NativeEngineWrapper.run_crss_haplotype(this.hblkPathForCaseControl, option, null, this.monitor);
            }
            if (CMD == 9) {
                option = new Hashtable();
                option.put("pvaluemethod", opt[0]);
                NativeEngineWrapper.run_fdr_snp(this.genoPathForCaseControl + ".snp.crss", option, null, this.monitor);
            }
            if (CMD == 10) {
                option = new Hashtable();
                option.put("pvaluemethod", opt[0]);
                String crssPath = this.hblkPathForCaseControl.substring(0, this.hblkPathForCaseControl.lastIndexOf(".")) + ".hap.crss";
                NativeEngineWrapper.run_fdr_hap(crssPath, option, null, this.monitor);
            }
        }
        catch (Exception ig) {
            ig.printStackTrace();
        }
    }

    private void CopyOptionValueFromPref(Hashtable option, String key) {
        option.put(key, pref.getValue(key));
    }

    private void request_windows_lnf() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (InstantiationException e) {
                }
                catch (ClassNotFoundException e) {
                }
                catch (UnsupportedLookAndFeelException e) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        });
    }

    public void init() {
        this.htmlBase = this.getCodeBase() == null || this.getCodeBase().getProtocol().equals("file") ? "http://snp.istech21.com/snpanalyzer/2.0/webstart" : this.getCodeBase().toString();
        this.demoUrl = this.htmlBase + "/intro.html";
        this.htmlGenotypeFormatURL = this.htmlBase + "/help/genotype-format.html";
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hLinkManger = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        System.err.println("try to open " + evt.getURL());
                        try {
                            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                            bs.showDocument(evt.getURL());
                        }
                        catch (UnavailableServiceException ue) {
                            JOptionPane.showMessageDialog(Snpanalyzer2.this, "Could not open URL " + evt.getURL());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.small = new Font("Dialog", 0, 10);
        this.menuListener = new MenuResponsable(this);
        this.panelMenu = this.makePanelMenu();
        this.panelDocument = new JPanel();
        this.panelDocument.setBorder(BorderFactory.createRaisedBevelBorder());
        this.panelDocumentOption = new JPanel();
        this.panelDocumentView = new JPanel();
        this.ShowHTML(this.demoUrl);
        this.panelDocument.setLayout(new BorderLayout());
        this.panelDocument.add((Component)this.panelDocumentView, "Center");
        this.splitter = new JSplitPane(1, new JScrollPane(this.panelMenu), new JScrollPane(this.panelDocument));
        this.splitter.setDividerSize(WidthSplitter);
        this.splitter.setDividerLocation(WidthMenu);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.splitter);
        this.monitor.addTaskMonitor(new DialogTaskMonitorImpl(this));
        this.viewLog = new ViewLog();
        this.viewLogPanel = this.viewLog.FillJPanel(this, new String[]{null});
    }

    private void setGenotypeNameText(String fpath) {
        if (fpath == null || !new File(fpath).exists()) {
            this.taskImportEdit.setText("Genotype Data");
        } else {
            this.taskImportEdit.setText(new File(fpath).getName());
        }
    }

    private JPanel makePanelMenu() {
        JPanel root = new JPanel();
        root.setLayout(new BorderLayout());
        JTaskPane taskPane = new JTaskPane();
        root.add("Center", new JScrollPane((Component)taskPane));
        JTaskPaneGroup tgImport = new JTaskPaneGroup();
        tgImport.setTitle("Data Import");
        tgImport.setExpanded(true);
        taskPane.add(tgImport);
        this.taskImportEdit = new JLinkButton("Genotype Data");
        this.taskImportEdit.setIcon(IconPool.getImageIcon("edit.png", this));
        this.taskImportEdit.setActionCommand("open_no_flagging");
        this.taskImportEdit.addActionListener((ActionListener)this.menuListener);
        tgImport.add((Component)this.taskImportEdit);
        JLinkButton taskPreprocessingOption = new JLinkButton("Preprocessing");
        taskPreprocessingOption.setIcon(IconPool.getImageIcon("preprocess.png", this));
        taskPreprocessingOption.setActionCommand("open_prep");
        taskPreprocessingOption.addActionListener((ActionListener)this.menuListener);
        tgImport.add((Component)taskPreprocessingOption);
        JTaskPaneGroup tgHaplotype = new JTaskPaneGroup();
        tgHaplotype.setTitle("Haplotype Estimation");
        tgHaplotype.setExpanded(false);
        taskPane.add(tgHaplotype);
        JLinkButton taskHaplotypeEM = new JLinkButton("EM Algorithm");
        taskHaplotypeEM.setIcon(IconPool.getImageIcon("haplotype.png", this));
        taskHaplotypeEM.setActionCommand("open_em");
        taskHaplotypeEM.addActionListener((ActionListener)this.menuListener);
        tgHaplotype.add((Component)taskHaplotypeEM);
        JLinkButton taskHaplotypePLEM = new JLinkButton("PL-EM Algorithm");
        taskHaplotypePLEM.setIcon(IconPool.getImageIcon("haplotype.png", this));
        taskHaplotypePLEM.setActionCommand("open_plem");
        taskHaplotypePLEM.addActionListener((ActionListener)this.menuListener);
        tgHaplotype.add((Component)taskHaplotypePLEM);
        JTaskPaneGroup tgLD = new JTaskPaneGroup();
        tgLD.setTitle("LD Blocking");
        tgLD.setExpanded(false);
        taskPane.add(tgLD);
        JLinkButton taskLDPairwise = new JLinkButton("Pairwise LD Calculation");
        taskLDPairwise.setIcon(IconPool.getImageIcon("ldblock.png", this));
        taskLDPairwise.setActionCommand("open_ld");
        taskLDPairwise.addActionListener((ActionListener)this.menuListener);
        tgLD.add((Component)taskLDPairwise);
        JLinkButton taskLDGabriel = new JLinkButton("<html>LD Blocking with Gabriel's Method</html>");
        taskLDGabriel.setPreferredSize(new Dimension(WidthMenu - 100, 40));
        taskLDGabriel.setIcon(IconPool.getImageIcon("ldblock.png", this));
        taskLDGabriel.setVerticalTextPosition(1);
        taskLDGabriel.setActionCommand("open_gabriel");
        taskLDGabriel.addActionListener((ActionListener)this.menuListener);
        tgLD.add((Component)taskLDGabriel);
        JTaskPaneGroup tgCaseControl = new JTaskPaneGroup();
        tgCaseControl.setTitle("Case-Control Study");
        tgCaseControl.setExpanded(false);
        taskPane.add(tgCaseControl);
        JLinkButton taskCaseControlSNP = new JLinkButton("SNP Analysis");
        taskCaseControlSNP.setIcon(IconPool.getImageIcon("crss_snp.png", this));
        taskCaseControlSNP.setActionCommand("open_ccsnp");
        taskCaseControlSNP.addActionListener((ActionListener)this.menuListener);
        tgCaseControl.add((Component)taskCaseControlSNP);
        JLinkButton taskCaseControlHaplotype = new JLinkButton("Haplotype Analysis");
        taskCaseControlHaplotype.setIcon(IconPool.getImageIcon("crss_hap.png", this));
        taskCaseControlHaplotype.setActionCommand("open_cchap");
        taskCaseControlHaplotype.addActionListener((ActionListener)this.menuListener);
        tgCaseControl.add((Component)taskCaseControlHaplotype);
        JTaskPaneGroup tgDummy = new JTaskPaneGroup();
        tgDummy.setTitle("Property");
        tgDummy.setExpanded(false);
        taskPane.add(tgDummy);
        JLinkButton taskLog = new JLinkButton("Log File");
        taskLog.setIcon(IconPool.getImageIcon("run.png", this));
        taskLog.setActionCommand("open_log");
        taskLog.addActionListener((ActionListener)this.menuListener);
        tgDummy.add((Component)taskLog);
        JLinkButton taskDir = new JLinkButton("Working Directory");
        taskDir.setIcon(IconPool.getImageIcon("workset.gif", this));
        taskDir.setActionCommand("dir");
        taskDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Snpanalyzer2.this.navigateTo(Snpanalyzer2.this.GetWorkDir());
            }
        });
        tgDummy.add((Component)taskDir);
        JLinkButton taskAbout = new JLinkButton("About");
        taskAbout.setIcon(IconPool.getImageIcon("linkto_help.gif", this));
        taskAbout.setActionCommand("about");
        taskAbout.addActionListener((ActionListener)this.menuListener);
        tgDummy.add((Component)taskAbout);
        return root;
    }

    private void navigateTo(String url) {
        try {
            System.out.println("# Navigate to " + url);
            Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + url + "\"");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void resizeComponent(JComponent c, Dimension d) {
        c.setSize(d.width, d.height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setAlignmentX(0.0f);
        c.setFont(this.small);
        if (c instanceof JButton) {
            ((JButton)c).setHorizontalAlignment(2);
        }
    }

    public String GetWorkDir() {
        if (this.LastHome != null) {
            return this.LastHome;
        }
        String home = System.getProperty("java.io.tmpdir", "c:/temp/") + "snpanalyzer" + File.separator;
        try {
            new File(home).mkdirs();
            this.LastHome = home;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.LastHome;
    }

    String getImportedPath(String srcPath) {
        if (srcPath.startsWith(this.GetWorkDir())) {
            return srcPath;
        }
        String timestamp = new SimpleDateFormat("yyMMdd.HHmmss").format(new Date());
        timestamp = "." + timestamp;
        String nameOnly = new File(srcPath).getName();
        int find = nameOnly.indexOf(".geno");
        String newNameOnly = null;
        newNameOnly = find > 0 ? nameOnly.substring(0, find) + timestamp + ".geno" : nameOnly + "." + timestamp + ".geno";
        return this.GetWorkDir() + newNameOnly;
    }

    String getImportedPathAsIs(String srcPath) {
        if (srcPath.startsWith(this.GetWorkDir())) {
            return srcPath;
        }
        String nameOnly = new File(srcPath).getName();
        if (!nameOnly.toLowerCase().endsWith(".geno")) {
            nameOnly = nameOnly + ".geno";
        }
        return this.GetWorkDir() + nameOnly;
    }

    public void ImportGenotype(String srcPath) {
        this.PathSrc = srcPath;
        String importedPath = this.getImportedPath(this.PathSrc);
        Snpanalyzer2.CopyFile(this.PathSrc, importedPath);
        this.PathGeno = importedPath;
        this.PathFlag = this.PathGeno + ".flag";
        System.out.println("### Import Genotype \"" + srcPath + "\" to \"" + this.PathGeno + "\"");
        this.setGenotypeNameText(this.PathSrc);
    }

    public void ShowHTML(final String url) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Snpanalyzer2.this.panelDocumentView.removeAll();
                    JEditorPane htmlDemo = new JEditorPane(url);
                    htmlDemo.setEditable(false);
                    Snpanalyzer2.this.panelDocumentView.add(htmlDemo);
                    Snpanalyzer2.this.panelDocumentView.updateUI();
                    htmlDemo.addHyperlinkListener(Snpanalyzer2.this.hLinkManger);
                }
                catch (Exception ig) {
                    ig.printStackTrace();
                }
            }
        });
    }

    public int[] getSNPSampleSize(String genoPath) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(genoPath));
            String line = null;
            line = r.readLine();
            String[] tok = line.split("\t");
            int nSample = tok.length - 4;
            r.readLine();
            int nSNP = 0;
            while ((line = r.readLine()) != null) {
                ++nSNP;
            }
            r.close();
            return new int[]{nSNP, nSample};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{0, 0};
        }
    }
}

