/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.TaskMonitor;
import java.util.Vector;

public class TaskMonitorAdoptor {
    Task[] tasks = new Task[0];
    Vector listTaskMonitor = new Vector();

    public void setTaskTitle(String title) {
        for (int i = 0; i < this.listTaskMonitor.size(); ++i) {
            TaskMonitor tm = (TaskMonitor)this.listTaskMonitor.get(i);
            tm.setTaskTitle(title);
        }
    }

    public void notifyStartTasks(String[] taskName) {
        int i;
        if (this.tasks.length != 0) {
            System.out.println("Warn!!! try to clear tasks.length = " + this.tasks.length);
        }
        this.tasks = new Task[taskName.length];
        for (i = 0; i < taskName.length; ++i) {
            this.tasks[i] = new Task(taskName[i]);
        }
        for (i = 0; i < this.listTaskMonitor.size(); ++i) {
            TaskMonitor tm = (TaskMonitor)this.listTaskMonitor.get(i);
            tm.startMonitor(this, this.tasks);
        }
    }

    private void notifyMonitors() {
        for (int i = 0; i < this.listTaskMonitor.size(); ++i) {
            TaskMonitor tm = (TaskMonitor)this.listTaskMonitor.get(i);
            tm.statusChanged();
        }
    }

    public void setProgressMax(int taskIdx, int max) {
        try {
            this.tasks[taskIdx].max = max;
            this.notifyMonitors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProgressValue(int taskIdx, int value) {
        try {
            this.tasks[taskIdx].value = value;
            this.notifyMonitors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getProgressValue(int taskIdx) {
        return this.tasks[taskIdx].value;
    }

    public void notifyStopTasks() {
        int i;
        for (i = 0; i < this.listTaskMonitor.size(); ++i) {
            TaskMonitor tm = (TaskMonitor)this.listTaskMonitor.get(i);
            tm.stopMonitor();
        }
        for (i = 0; i < this.tasks.length; ++i) {
            this.tasks[i] = null;
        }
        this.tasks = new Task[0];
    }

    public void addTaskCallback(Runnable r) {
    }

    public void clearTaskCallback(Runnable r) {
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.listTaskMonitor.add(tm);
    }

    public void clearTaskMonitor() {
        this.listTaskMonitor.clear();
    }

    public void ProgressStart(String[] tasks) {
        this.notifyStartTasks(tasks);
    }

    public void ProgressSetMax(int idx, int max) {
        this.setProgressMax(idx, max);
    }

    public void ProgressSetValue(int idx, int value) {
        this.setProgressValue(idx, value);
    }

    public void ProgressStop() {
        this.notifyStopTasks();
    }

    public static class Task {
        static final int STATE_NONE = 0;
        static final int STATE_RUNNING = 1;
        static final int STATE_DONE = 2;
        static final int STATE_ERROR = 3;
        public String name = null;
        public int max = 100;
        public int value = 0;
        public int status = 0;

        public Task(String taskName) {
            this.name = taskName;
        }
    }
}

