/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalFlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            dim.width = Math.max(dim.width, d.width);
            if (i > 0) {
                dim.height += this.vgap;
            }
            dim.height += d.height;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            try {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int colStart, int colEnd) {
        switch (this.align) {
            case 0: {
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += width;
            }
        }
        for (int i = colStart; i < colEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            m.setLocation(x + (width - m.getSize().width) / 2, y);
            y += this.vgap + m.getSize().height;
        }
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int nmembers = target.getComponentCount();
        int x = insets.left + this.hgap;
        int y = 0;
        int colw = 0;
        int start = 0;
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            m.setSize(d.width, d.height);
            if (y == 0 || y + d.height <= maxheight) {
                if (y > 0) {
                    y += this.vgap;
                }
                y += d.height;
                colw = Math.max(colw, d.width);
                continue;
            }
            this.moveComponents(target, x, insets.top + this.vgap, colw, maxheight - y, start, i);
            y = d.height;
            x += this.hgap + colw;
            colw = d.width;
            start = i;
        }
        this.moveComponents(target, x, insets.top + this.vgap, colw, maxheight - y, start, nmembers);
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

