/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.GradientPanel;
import com.istech21.snpanalyzer2free.IconPool;
import com.istech21.snpanalyzer2free.Preference;
import com.istech21.snpanalyzer2free.SNPContentsParser;
import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.SpringUtilities;
import com.istech21.snpanalyzer2free.ViewGenerator;
import com.istech21.snpanalyzer2free.tdf.ViewTDF;
import com.istech21.widget.chart.Chart;
import com.istech21.widget.chart.ChartWithScrollBar;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ViewCaseControlHaplotype
implements ViewGenerator {
    static final boolean bSort = true;
    static final boolean bLog10 = true;
    Snpanalyzer2 applet;
    static final Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.gray, Color.DARK_GRAY, Color.magenta};
    static int nextColor = 0;
    private DefaultTableModel dm = null;
    Hashtable runtime_option = new Hashtable();
    HashSet blockList = new HashSet();

    private static void resizeComponent(JComponent c, int w, int h) {
        Dimension d = new Dimension(w, h);
        c.setSize(d.width, d.height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setAlignmentX(0.0f);
        if (c instanceof JButton) {
            ((JButton)c).setHorizontalAlignment(2);
        }
        if (++nextColor >= colors.length) {
            nextColor = 0;
        }
    }

    private JPanel FillOptionPane() {
        JPanel opt = new JPanel();
        opt.setOpaque(false);
        opt.setLayout(new BorderLayout());
        JLabel label = null;
        JComboBox combo = null;
        Object fill = null;
        Font small10Font = new Font("verdana", 0, 10);
        JPanel RunPane = new JPanel();
        RunPane.setOpaque(false);
        RunPane.setLayout(new FlowLayout());
        JButton btnOpen = new JButton("Open Haplotype", IconPool.getImageIcon("open.png", this.applet));
        btnOpen.setPreferredSize(new Dimension(150, 24));
        RunPane.add(btnOpen);
        btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String fpath;
                    JButton thisBtn = (JButton)e.getSource();
                    Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, ViewCaseControlHaplotype.this.applet);
                    JFileChooser fc = new JFileChooser(ViewCaseControlHaplotype.this.applet.GetWorkDir());
                    fc.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String filename = file.getName();
                            return filename.endsWith(".hblk");
                        }

                        public String getDescription() {
                            return "*.hblk";
                        }
                    });
                    int res = fc.showOpenDialog(f);
                    if (res != 0) {
                        return;
                    }
                    ViewCaseControlHaplotype.this.applet.hblkPathForCaseControl = fpath = fc.getSelectedFile().getCanonicalPath();
                    thisBtn.setText(new File(fpath).getName());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        JButton btnExecute = new JButton("Execute", IconPool.getImageIcon("run.png", this.applet));
        btnExecute.setPreferredSize(new Dimension(150, 24));
        RunPane.add(btnExecute);
        btnExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewCaseControlHaplotype.this.applet.menuListener.action_cchap();
            }
        });
        opt.add((Component)RunPane, "North");
        JPanel CCOpt = new JPanel();
        CCOpt.setOpaque(false);
        CCOpt.setLayout(new SpringLayout());
        opt.add((Component)CCOpt, "Center");
        label = new JLabel("<html>&nbsp;&nbsp;<b>Model:</b></html>");
        label.setFont(small10Font);
        CCOpt.add(label);
        JRadioButton[] radioModels = Snpanalyzer2.pref.Create_JRadioButtonReturnsText("casecontrol.haplotype.model");
        radioModels[0].setText("Multiplicative");
        radioModels[0].setFont(small10Font);
        CCOpt.add(radioModels[0]);
        radioModels[0].setOpaque(false);
        radioModels[1].setText("Dominant");
        radioModels[1].setFont(small10Font);
        CCOpt.add(radioModels[1]);
        radioModels[1].setOpaque(false);
        radioModels[2].setText("Recessive");
        radioModels[2].setFont(small10Font);
        CCOpt.add(radioModels[2]);
        radioModels[2].setOpaque(false);
        radioModels[3].setText("Codominant");
        radioModels[3].setFont(small10Font);
        CCOpt.add(radioModels[3]);
        radioModels[3].setOpaque(false);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Sig. Level:</b></html>");
        label.setFont(small10Font);
        CCOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("casecontrol.haplotype.pvalue");
        combo.setFont(small10Font);
        CCOpt.add(combo);
        combo.setEditable(true);
        combo.setSelectedItem(Snpanalyzer2.pref.getValue("casecontrol.haplotype.pvalue"));
        label = new JLabel();
        CCOpt.add(label);
        JCheckBox checkBonferroni = Snpanalyzer2.pref.Create_JCheckBoxReturnsText("casecontrol.haplotype.bonfcorrection", "<html>Bonferroni Correction<html>");
        checkBonferroni.setFont(small10Font);
        checkBonferroni.setOpaque(false);
        CCOpt.add(checkBonferroni);
        label = new JLabel();
        CCOpt.add(label);
        SpringUtilities.makeCompactGrid(CCOpt, 2, 5, 6, 6, 6, 1);
        return opt;
    }

    public JPanel FillJPanel(Snpanalyzer2 _applet, String[] filePath) {
        this.applet = _applet;
        this.applet.ResizeWindow();
        String genoPath = filePath[0];
        String flagPath = filePath[1];
        Font small10Font = new Font("verdana", 0, 10);
        JPanel s_root = new JPanel();
        s_root.setLayout(new BorderLayout());
        GradientPanel logoPane = new GradientPanel();
        logoPane.setColor1(Color.white);
        logoPane.setColor2(Color.DARK_GRAY);
        logoPane.setLayout(new BorderLayout());
        JLabel logoPaneTitle = new JLabel("<html><h3>Case-Control Study - Haplotype Analysis</h3></html>", IconPool.getImageIcon("crss_hap.png", this.applet), 2);
        logoPaneTitle.setVerticalAlignment(1);
        logoPane.add((Component)logoPaneTitle, "North");
        logoPane.setAlignmentX(0.0f);
        s_root.add((Component)logoPane, "North");
        JTaskPane root = new JTaskPane();
        s_root.add((Component)root, "Center");
        JTaskPaneGroup tgOption = new JTaskPaneGroup();
        tgOption.setTitle("Case Control Analysis Option");
        tgOption.setExpanded(true);
        tgOption.add((Component)this.FillOptionPane());
        tgOption.setAlignmentX(0.0f);
        tgOption.setScrollOnExpand(true);
        root.add(tgOption);
        JTaskPaneGroup tgResult = new JTaskPaneGroup();
        tgResult.setTitle("Cross Tabulation Result");
        tgResult.setExpanded(true);
        tgResult.setAlignmentX(0.0f);
        tgResult.setScrollOnExpand(true);
        root.add(tgResult);
        String outfile = null;
        if (this.applet.hblkPathForCaseControl != null) {
            outfile = this.applet.hblkPathForCaseControl.substring(0, this.applet.hblkPathForCaseControl.lastIndexOf(".")) + ".hap.crss";
        }
        this.dm = SNPContentsParser.ReadFileHaplotypeCaseControlTableModel(outfile, "1", 0, this.blockList, this.runtime_option, null, new Vector());
        if (this.dm.getRowCount() == 0) {
            tgResult.setExpanded(false);
            tgResult.add((Component)new JLabel("Cannot find Analysis result"));
            return s_root;
        }
        JPanel resultView = new JPanel();
        resultView.setOpaque(false);
        ViewCaseControlHaplotype.resizeComponent(resultView, Snpanalyzer2.WidthDocument - 60, 345);
        tgResult.add((Component)resultView);
        JPanel figure = new JPanel();
        figure.setBackground(Color.yellow);
        JPanel vflow = new JPanel();
        vflow.setOpaque(false);
        vflow.setLayout(new SpringLayout());
        JLabel label = new JLabel("Block:");
        vflow.add(label);
        String[] strBlockListAry = new String[this.blockList.size()];
        this.blockList.toArray(strBlockListAry);
        Object[] blockListAry = new Integer[this.blockList.size()];
        for (int i = 0; i < blockListAry.length; ++i) {
            blockListAry[i] = Integer.valueOf(strBlockListAry[i]);
        }
        Arrays.sort(blockListAry);
        JComboBox<Object> comboBlock = new JComboBox<Object>(blockListAry);
        comboBlock.setFont(small10Font);
        vflow.add(comboBlock);
        comboBlock.setSelectedIndex(0);
        label = new JLabel("Sig.Level:");
        vflow.add(label);
        JComboBox comboPValue = Snpanalyzer2.pref.Create_JComboBoxReturnsText("casecontrol.haplotype.pvalue");
        comboPValue.setFont(small10Font);
        comboPValue.setEditable(true);
        comboPValue.setSelectedItem(Snpanalyzer2.pref.getValue("casecontrol.haplotype.pvalue"));
        vflow.add(comboPValue);
        SpringUtilities.makeCompactGrid(vflow, 2, 2, 1, 1, 1, 1);
        resultView.add(vflow);
        final JTable tableOR = new JTable(new Object[][]{{"ID", "<html>x<sup>2</sup></html>", "<html><i>p</i>-value</html>", "OR", "<html>Lower CI<br> of OR</html>", "<html>Higher CI<br> of OR</html>"}, {"-", "-", "-", "-", "-", "-"}}, new Object[]{"ID", "<html>x<sup>2</sup></html>", "<html><i>p</i>-value</html>", "OR", "<html>Lower CI<br> of OR</html>", "<html>Higher CI<br> of OR</html>"});
        int tablecellwidth = 90;
        int tablecellwidth2 = 90;
        tableOR.setBounds(4, 45, tablecellwidth * 5, 48);
        tableOR.setBorder(BorderFactory.createLineBorder(Color.black));
        tableOR.setFont(new Font("verdana", 0, 9));
        tableOR.setRowHeight(24);
        tableOR.setAutoResizeMode(0);
        tableOR.getColumnModel().getColumn(0).setPreferredWidth(tablecellwidth);
        tableOR.getColumnModel().getColumn(1).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(2).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(3).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(4).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(5).setPreferredWidth(tablecellwidth2);
        resultView.add(tableOR);
        tableOR.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel asLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    asLabel.setToolTipText(null);
                } else if (value instanceof Number) {
                    String asText = Preference.htmlString((Double)value);
                    asLabel.setText(asText);
                    asLabel.setToolTipText(value.toString());
                } else if (column == 0) {
                    asLabel.setToolTipText("<html>chrom_sampletype_blockno_hapno<br>\n<b>" + value.toString() + "</b></html>");
                } else {
                    asLabel.setToolTipText(value.toString());
                }
                asLabel.setHorizontalAlignment(0);
                return asLabel;
            }
        });
        label = new JLabel("<html><b>Single Haplotype Analysis using Cross Tabulation: <i>p</i>-value</b></html>");
        label.setFont(new Font("verdana", 0, 9));
        resultView.add(label);
        JButton btnSavePvalue = new JButton("p-value", IconPool.getImageIcon("save.png", this.applet));
        resultView.add(btnSavePvalue);
        btnSavePvalue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ViewCaseControlHaplotype.this.applet.hblkPathForCaseControl == null) {
                    return;
                }
                String crssPath = ViewCaseControlHaplotype.this.applet.hblkPathForCaseControl.substring(0, ViewCaseControlHaplotype.this.applet.hblkPathForCaseControl.lastIndexOf(".")) + ".hap.crss";
                if (!new File(crssPath).exists()) {
                    JOptionPane.showMessageDialog(ViewCaseControlHaplotype.this.applet, "Analysis Result Not Available");
                    return;
                }
                ViewTDF.MakeReadonlyWindow(crssPath, ViewCaseControlHaplotype.this.applet);
            }
        });
        final JComboBox<String> comboFDR = new JComboBox<String>(new String[]{"GFT-pvalue", "LRT-pvalue"});
        resultView.add(comboFDR);
        JButton btnSaveFDR = new JButton("FDR", IconPool.getImageIcon("save.png", this.applet));
        resultView.add(btnSaveFDR);
        btnSaveFDR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewCaseControlHaplotype.this.applet.menuListener.action_fdr_hap(comboFDR.getSelectedIndex());
                String crssPath = ViewCaseControlHaplotype.this.applet.hblkPathForCaseControl.substring(0, ViewCaseControlHaplotype.this.applet.hblkPathForCaseControl.lastIndexOf(".")) + ".hap.crss";
                String fdrPath = crssPath + ".fdr";
                if (!new File(fdrPath).exists()) {
                    System.err.println("ff=[" + fdrPath + "]");
                    JOptionPane.showMessageDialog(ViewCaseControlHaplotype.this.applet, "Analysis Result Not Available");
                    return;
                }
                ViewTDF.MakeReadonlyWindow(fdrPath, ViewCaseControlHaplotype.this.applet);
            }
        });
        SNPContentsParser.SortAllRowsBy(this.dm, 2, true);
        boolean isBFCorrection = false;
        if ("On".equalsIgnoreCase(Snpanalyzer2.pref.getValue("casecontrol.haplotype.bonfcorrection"))) {
            isBFCorrection = true;
        }
        String[] hap_id_list = new String[this.dm.getRowCount()];
        double[] hap_pvalue_list = new double[this.dm.getRowCount()];
        for (int i = 0; i < hap_pvalue_list.length; ++i) {
            hap_id_list[i] = (String)this.dm.getValueAt(i, 0);
            hap_pvalue_list[i] = (Double)this.dm.getValueAt(i, 2);
            if (isBFCorrection) {
                int n = i;
                hap_pvalue_list[n] = hap_pvalue_list[n] * (double)hap_pvalue_list.length;
                this.dm.setValueAt(hap_pvalue_list[i], i, 2);
            }
            if (hap_pvalue_list[i] > 1.0) {
                hap_pvalue_list[i] = 1.0;
                this.dm.setValueAt(hap_pvalue_list[i], i, 2);
            }
            hap_pvalue_list[i] = -Math.log10(hap_pvalue_list[i]);
        }
        String runtime_name = new File(this.applet.hblkPathForCaseControl).getName();
        runtime_name = runtime_name.substring(0, runtime_name.lastIndexOf("."));
        String runtime_model = (String)this.runtime_option.get("Model");
        String runtime_multi = (String)this.runtime_option.get("Multi_Correction");
        String chart_title = runtime_name + " (Sample M,Block 1," + runtime_model;
        chart_title = "Y".equals(runtime_multi) ? chart_title + ",With correction)" : chart_title + ")";
        final ChartWithScrollBar chart = new ChartWithScrollBar(hap_id_list, hap_pvalue_list, 0, 20);
        chart.getChart().setTitle(chart_title);
        chart.getChart().setXTitle("");
        chart.getChart().setYTitle("-log10(p-value)");
        chart.getChart().setBaseLineValue(-Math.log10(Double.parseDouble((String)comboPValue.getSelectedItem())));
        chart.getChart().setIsUpSpecial(false);
        chart.getChart().setToolTiper(new Chart.ToolTipInterface(){

            public String process(Object[] objects) {
                String id = (String)objects[0];
                Double value = (Double)objects[1];
                StringBuffer res = new StringBuffer();
                res.append("<html>");
                res.append("<table border=0>");
                res.append("<tr><td colspan='2'>").append(id).append("</td></tr>");
                res.append("<tr><td bgcolor=#f2f2ff align='right'>-log<sub>10</sub>(p-value):</td><td bgcolor=#f2f2ff>").append(value).append("</td></tr>");
                res.append("<tr><td bgcolor=#f2f2ff align='right'>p-value</td><td bgcolor=#f2f2ff>").append(Math.pow(10.0, -value.doubleValue())).append("</td></tr>");
                res.append("</table>");
                res.append("</html>");
                return res.toString();
            }
        });
        chart.setBorder(BorderFactory.createLineBorder(Color.black));
        ViewCaseControlHaplotype.resizeComponent(chart, Snpanalyzer2.WidthDocument - 90 + 20 + 5 + 5, 200);
        resultView.add(chart);
        comboBlock.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                String new_block = combo.getSelectedItem().toString();
                ViewCaseControlHaplotype.this.ReadFileAndRedrawChart(new_block, (ChartWithScrollBar)chart);
            }
        });
        chart.getChart().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int found = ((ChartWithScrollBar)chart).getChart().getClickableAt(x, y);
                if (found < 0) {
                    tableOR.setValueAt("-", 1, 0);
                    tableOR.setValueAt("-", 1, 1);
                    tableOR.setValueAt("-", 1, 2);
                    tableOR.setValueAt("-", 1, 3);
                    tableOR.setValueAt("-", 1, 4);
                    tableOR.setValueAt("-", 1, 5);
                    return;
                }
                tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 0), 1, 0);
                tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 1), 1, 1);
                tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 2), 1, 2);
                Snpanalyzer2 cfr_ignored_0 = ViewCaseControlHaplotype.this.applet;
                if ("Codominant".equalsIgnoreCase(Snpanalyzer2.pref.getValue("casecontrol.haplotype.model"))) {
                    tableOR.setValueAt("-", 1, 3);
                    tableOR.setValueAt("-", 1, 4);
                    tableOR.setValueAt("-", 1, 5);
                } else {
                    tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 3), 1, 3);
                    tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 4), 1, 4);
                    tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 5), 1, 5);
                }
            }
        });
        comboPValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                double newLevel = 0.0;
                newLevel = -Math.log10(Double.parseDouble((String)combo.getSelectedItem()));
                ((ChartWithScrollBar)chart).getChart().setBaseLineValue(newLevel);
                ((ChartWithScrollBar)chart).getChart().repaint();
            }
        });
        if (hap_id_list != null && hap_id_list.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        int found = 0;
                        tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 0), 1, 0);
                        tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 1), 1, 1);
                        tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 2), 1, 2);
                        Snpanalyzer2 cfr_ignored_0 = ViewCaseControlHaplotype.this.applet;
                        if ("Codominant".equalsIgnoreCase(Snpanalyzer2.pref.getValue("casecontrol.haplotype.model"))) {
                            tableOR.setValueAt("-", 1, 3);
                            tableOR.setValueAt("-", 1, 4);
                            tableOR.setValueAt("-", 1, 5);
                        } else {
                            tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 3), 1, 3);
                            tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 4), 1, 4);
                            tableOR.setValueAt(ViewCaseControlHaplotype.this.dm.getValueAt(found, 5), 1, 5);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return s_root;
    }

    private void ReadFileAndRedrawChart(String newBlock, ChartWithScrollBar chart) {
        this.runtime_option.clear();
        this.blockList.clear();
        this.dm = null;
        String outfile = null;
        if (this.applet.hblkPathForCaseControl != null) {
            outfile = this.applet.hblkPathForCaseControl.substring(0, this.applet.hblkPathForCaseControl.lastIndexOf(".")) + ".hap.crss";
        }
        this.dm = SNPContentsParser.ReadFileHaplotypeCaseControlTableModel(outfile, newBlock, 0, this.blockList, this.runtime_option, null, new Vector());
        SNPContentsParser.SortAllRowsBy(this.dm, 2, true);
        String[] hap_id_list = new String[this.dm.getRowCount()];
        double[] hap_pvalue_list = new double[this.dm.getRowCount()];
        for (int i = 0; i < hap_pvalue_list.length; ++i) {
            hap_id_list[i] = (String)this.dm.getValueAt(i, 0);
            hap_pvalue_list[i] = (Double)this.dm.getValueAt(i, 2);
            hap_pvalue_list[i] = -Math.log10(hap_pvalue_list[i]);
        }
        chart.getChart().setXYvalues(hap_id_list, hap_pvalue_list);
        String runtime_name = new File(this.applet.hblkPathForCaseControl).getName();
        runtime_name = runtime_name.substring(0, runtime_name.lastIndexOf("."));
        String runtime_model = (String)this.runtime_option.get("Model");
        String runtime_multi = (String)this.runtime_option.get("Multi_Correction");
        String chart_title = runtime_name + " (Sample M,Block " + newBlock + "," + runtime_model;
        chart_title = "Y".equals(runtime_multi) ? chart_title + ",With correction)" : chart_title + ")";
        chart.getChart().setTitle(chart_title);
    }
}

