/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.GradientPanel;
import com.istech21.snpanalyzer2free.IconPool;
import com.istech21.snpanalyzer2free.Preference;
import com.istech21.snpanalyzer2free.SNPContentsParser;
import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.SpringUtilities;
import com.istech21.snpanalyzer2free.ViewGenerator;
import com.istech21.snpanalyzer2free.tdf.ViewTDF;
import com.istech21.widget.chart.Chart;
import com.istech21.widget.chart.ChartWithScrollBar;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ViewCaseControlSNP
implements ViewGenerator {
    static final boolean bSort = true;
    static final boolean bLog10 = true;
    Snpanalyzer2 applet;
    static final Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.gray, Color.DARK_GRAY, Color.magenta};
    static int nextColor = 0;

    private static void resizeComponent(JComponent c, int w, int h) {
        Dimension d = new Dimension(w, h);
        c.setSize(d.width, d.height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setAlignmentX(0.0f);
        if (c instanceof JButton) {
            ((JButton)c).setHorizontalAlignment(2);
        }
        if (++nextColor >= colors.length) {
            nextColor = 0;
        }
    }

    private JPanel FillOptionPane() {
        JPanel opt = new JPanel();
        opt.setOpaque(false);
        opt.setLayout(new BorderLayout());
        JLabel label = null;
        JComboBox combo = null;
        Object fill = null;
        Font small10Font = new Font("verdana", 0, 10);
        JPanel RunPane = new JPanel();
        RunPane.setOpaque(false);
        RunPane.setLayout(new FlowLayout());
        JButton btnOpen = new JButton("Open Genotype", IconPool.getImageIcon("open.png", this.applet));
        btnOpen.setPreferredSize(new Dimension(150, 24));
        RunPane.add(btnOpen);
        btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JButton thisBtn = (JButton)e.getSource();
                    Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, ViewCaseControlSNP.this.applet);
                    JFileChooser fc = new JFileChooser(ViewCaseControlSNP.this.applet.GetWorkDir());
                    fc.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String filename = file.getName();
                            return filename.endsWith(".geno");
                        }

                        public String getDescription() {
                            return "*.geno";
                        }
                    });
                    int res = fc.showOpenDialog(f);
                    if (res != 0) {
                        return;
                    }
                    String fpath = fc.getSelectedFile().getCanonicalPath();
                    System.out.println("Selected case control genotype file=");
                    System.out.println("\t" + fpath);
                    String importedPath = ViewCaseControlSNP.this.applet.getImportedPathAsIs(fpath);
                    Snpanalyzer2 cfr_ignored_0 = ViewCaseControlSNP.this.applet;
                    Snpanalyzer2.CopyFile(fpath, importedPath);
                    ViewCaseControlSNP.this.applet.genoPathForCaseControl = fpath = importedPath;
                    thisBtn.setText(new File(fpath).getName());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        JButton btnExecute = new JButton("Execute", IconPool.getImageIcon("run.png", this.applet));
        btnExecute.setPreferredSize(new Dimension(150, 24));
        RunPane.add(btnExecute);
        btnExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewCaseControlSNP.this.applet.menuListener.action_ccsnp();
            }
        });
        opt.add((Component)RunPane, "North");
        JPanel CCOpt = new JPanel();
        CCOpt.setOpaque(false);
        CCOpt.setLayout(new SpringLayout());
        opt.add((Component)CCOpt, "Center");
        label = new JLabel("<html>&nbsp;&nbsp;<b>Risk Allele:</b></html>");
        label.setFont(small10Font);
        CCOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("casecontrol.snp.liskallele");
        combo.setFont(small10Font);
        CCOpt.add(combo);
        label = new JLabel();
        CCOpt.add(label);
        label = new JLabel();
        CCOpt.add(label);
        label = new JLabel();
        CCOpt.add(label);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Model:</b></html>");
        label.setFont(small10Font);
        CCOpt.add(label);
        JRadioButton[] radioModels = Snpanalyzer2.pref.Create_JRadioButtonReturnsText("casecontrol.snp.model");
        radioModels[0].setText("Multiplicative");
        radioModels[0].setFont(small10Font);
        CCOpt.add(radioModels[0]);
        radioModels[0].setOpaque(false);
        radioModels[1].setText("Dominant");
        radioModels[1].setFont(small10Font);
        CCOpt.add(radioModels[1]);
        radioModels[1].setOpaque(false);
        radioModels[2].setText("Recessive");
        radioModels[2].setFont(small10Font);
        CCOpt.add(radioModels[2]);
        radioModels[2].setOpaque(false);
        radioModels[3].setText("Codominant");
        radioModels[3].setFont(small10Font);
        CCOpt.add(radioModels[3]);
        radioModels[3].setOpaque(false);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Sig. Level:</b></html>");
        label.setFont(small10Font);
        CCOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("casecontrol.snp.pvalue");
        combo.setFont(small10Font);
        CCOpt.add(combo);
        combo.setEditable(true);
        combo.setSelectedItem(Snpanalyzer2.pref.getValue("casecontrol.snp.pvalue"));
        label = new JLabel();
        CCOpt.add(label);
        JCheckBox checkBonferroni = Snpanalyzer2.pref.Create_JCheckBoxReturnsText("casecontrol.snp.bonfcorrection", "<html>Bonferroni Correction<html>");
        checkBonferroni.setFont(small10Font);
        checkBonferroni.setOpaque(false);
        CCOpt.add(checkBonferroni);
        label = new JLabel();
        CCOpt.add(label);
        SpringUtilities.makeCompactGrid(CCOpt, 3, 5, 6, 6, 6, 1);
        return opt;
    }

    public JPanel FillJPanel(Snpanalyzer2 _applet, String[] filePath) {
        this.applet = _applet;
        this.applet.ResizeWindow();
        String genoPath = filePath[0];
        String flagPath = filePath[1];
        Font small10Font = new Font("verdana", 0, 10);
        JPanel s_root = new JPanel();
        s_root.setLayout(new BorderLayout());
        GradientPanel logoPane = new GradientPanel();
        logoPane.setColor1(Color.white);
        logoPane.setColor2(Color.DARK_GRAY);
        logoPane.setLayout(new BorderLayout());
        JLabel logoPaneTitle = new JLabel("<html><h3>Case-Control Study - SNP Analysis</h3></html>", IconPool.getImageIcon("crss_snp.png", this.applet), 2);
        logoPaneTitle.setVerticalAlignment(1);
        logoPane.add((Component)logoPaneTitle, "North");
        logoPane.setAlignmentX(0.0f);
        s_root.add((Component)logoPane, "North");
        JTaskPane root = new JTaskPane();
        s_root.add((Component)root, "Center");
        JTaskPaneGroup tgOption = new JTaskPaneGroup();
        tgOption.setTitle("Case Control Analysis Option");
        tgOption.setExpanded(true);
        tgOption.add((Component)this.FillOptionPane());
        tgOption.setAlignmentX(0.0f);
        tgOption.setScrollOnExpand(true);
        root.add(tgOption);
        JTaskPaneGroup tgResult = new JTaskPaneGroup();
        tgResult.setTitle("Cross Tabulation Result");
        tgResult.setExpanded(true);
        tgResult.setAlignmentX(0.0f);
        tgResult.setScrollOnExpand(true);
        root.add(tgResult);
        Hashtable runtime_option = new Hashtable();
        final DefaultTableModel dm = SNPContentsParser.ReadFileSNPCaseControlTableModel(this.applet.genoPathForCaseControl + ".snp.crss", runtime_option, null, null, 0, new Vector(), new Vector());
        if (dm.getRowCount() == 0) {
            tgResult.setExpanded(false);
            tgResult.add((Component)new JLabel("Cannot find Analysis result"));
            return s_root;
        }
        JPanel resultView = new JPanel();
        resultView.setOpaque(false);
        ViewCaseControlSNP.resizeComponent(resultView, Snpanalyzer2.WidthDocument - 60, 345);
        tgResult.add((Component)resultView);
        JPanel figure = new JPanel();
        figure.setBackground(Color.yellow);
        JPanel vflow = new JPanel();
        vflow.setOpaque(false);
        vflow.setLayout(new SpringLayout());
        JLabel label = new JLabel("Sig.Level:");
        vflow.add(label);
        JComboBox comboPValue = Snpanalyzer2.pref.Create_JComboBoxReturnsText("casecontrol.snp.pvalue");
        comboPValue.setFont(small10Font);
        comboPValue.setEditable(true);
        comboPValue.setSelectedItem(Snpanalyzer2.pref.getValue("casecontrol.snp.pvalue"));
        vflow.add(comboPValue);
        label = new JLabel(" ");
        vflow.add(label);
        label = new JLabel(" ");
        vflow.add(label);
        SpringUtilities.makeCompactGrid(vflow, 2, 2, 1, 1, 1, 1);
        resultView.add(vflow);
        final JTable tableOR = new JTable(new Object[][]{{"ID", "<html>x<sup>2</sup></html>", "<html><i>p</i>-value</html>", "OR", "<html>Lower CI<br> of OR</html>", "<html>Higher CI<br> of OR</html>"}, {"-", "-", "-", "-", "-", "-"}}, new Object[]{"ID", "<html>x<sup>2</sup></html>", "<html><i>p</i>-value</html>", "OR", "<html>Lower CI<br> of OR</html>", "<html>Higher CI<br> of OR</html>"});
        int tablecellwidth = 90;
        int tablecellwidth2 = 90;
        tableOR.setBounds(4, 45, tablecellwidth * 5, 48);
        tableOR.setBorder(BorderFactory.createLineBorder(Color.black));
        tableOR.setFont(new Font("verdana", 0, 9));
        tableOR.setRowHeight(24);
        tableOR.setAutoResizeMode(0);
        tableOR.getColumnModel().getColumn(0).setPreferredWidth(tablecellwidth);
        tableOR.getColumnModel().getColumn(1).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(2).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(3).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(4).setPreferredWidth(tablecellwidth2);
        tableOR.getColumnModel().getColumn(5).setPreferredWidth(tablecellwidth2);
        resultView.add(tableOR);
        tableOR.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel asLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    asLabel.setToolTipText(null);
                } else if (value instanceof Number) {
                    String asText = Preference.htmlString((Double)value);
                    asLabel.setText(asText);
                    asLabel.setToolTipText(value.toString());
                } else {
                    asLabel.setToolTipText(value.toString());
                }
                asLabel.setHorizontalAlignment(0);
                return asLabel;
            }
        });
        label = new JLabel("<html><b>Single SNP Analysis using Cross Tabulation: <i>p</i>-value</b></html>");
        label.setFont(new Font("verdana", 0, 9));
        resultView.add(label);
        JButton btnSavePvalue = new JButton("p-value", IconPool.getImageIcon("save.png", this.applet));
        resultView.add(btnSavePvalue);
        btnSavePvalue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ViewCaseControlSNP.this.applet.genoPathForCaseControl == null) {
                    return;
                }
                String crssPath = ViewCaseControlSNP.this.applet.genoPathForCaseControl + ".snp.crss";
                if (!new File(crssPath).exists()) {
                    JOptionPane.showMessageDialog(ViewCaseControlSNP.this.applet, "Analysis Result Not Available");
                    return;
                }
                ViewTDF.MakeReadonlyWindow(crssPath, ViewCaseControlSNP.this.applet);
            }
        });
        final JComboBox<String> comboFDR = new JComboBox<String>(new String[]{"GFT-pvalue", "LRT-pvalue"});
        resultView.add(comboFDR);
        JButton btnSaveFDR = new JButton("FDR", IconPool.getImageIcon("save.png", this.applet));
        resultView.add(btnSaveFDR);
        btnSaveFDR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewCaseControlSNP.this.applet.menuListener.action_fdr_snp(comboFDR.getSelectedIndex());
                String crssPath = ViewCaseControlSNP.this.applet.genoPathForCaseControl + ".snp.crss";
                String fdrPath = crssPath + ".fdr";
                if (!new File(fdrPath).exists()) {
                    JOptionPane.showMessageDialog(ViewCaseControlSNP.this.applet, "Analysis Result Not Available");
                    return;
                }
                ViewTDF.MakeReadonlyWindow(fdrPath, ViewCaseControlSNP.this.applet);
            }
        });
        SNPContentsParser.SortAllRowsBy(dm, 2, true);
        boolean isBFCorrection = false;
        if ("On".equalsIgnoreCase(Snpanalyzer2.pref.getValue("casecontrol.snp.bonfcorrection"))) {
            isBFCorrection = true;
        }
        String[] snp_id_list = new String[dm.getRowCount()];
        double[] snp_pvalue_list = new double[dm.getRowCount()];
        for (int i = 0; i < snp_pvalue_list.length; ++i) {
            snp_id_list[i] = (String)dm.getValueAt(i, 0);
            snp_pvalue_list[i] = (Double)dm.getValueAt(i, 2);
            if (isBFCorrection) {
                int n = i;
                snp_pvalue_list[n] = snp_pvalue_list[n] * (double)snp_id_list.length;
                dm.setValueAt(snp_pvalue_list[i], i, 2);
            }
            if (snp_pvalue_list[i] > 1.0) {
                snp_pvalue_list[i] = 1.0;
                dm.setValueAt(snp_pvalue_list[i], i, 2);
            }
            snp_pvalue_list[i] = -Math.log10(snp_pvalue_list[i]);
        }
        String runtime_name = new File(this.applet.genoPathForCaseControl).getName();
        runtime_name = runtime_name.substring(0, runtime_name.lastIndexOf("."));
        String runtime_risk = (String)runtime_option.get("Risk_Factor");
        String runtime_model = (String)runtime_option.get("Model");
        String runtime_multi = (String)runtime_option.get("Multi_Correction");
        String chart_title = runtime_name + " (" + runtime_risk + "," + runtime_model;
        chart_title = "Y".equals(runtime_multi) ? chart_title + ",With correction)" : chart_title + ")";
        final ChartWithScrollBar chart = new ChartWithScrollBar(snp_id_list, snp_pvalue_list, 0, 20);
        chart.getChart().setTitle(chart_title);
        chart.getChart().setXTitle("");
        chart.getChart().setYTitle("-log10(p-value)");
        chart.getChart().setBaseLineValue(-Math.log10(Double.parseDouble((String)comboPValue.getSelectedItem())));
        chart.getChart().setIsUpSpecial(false);
        chart.getChart().setToolTiper(new Chart.ToolTipInterface(){

            public String process(Object[] objects) {
                String id = (String)objects[0];
                Double value = (Double)objects[1];
                StringBuffer res = new StringBuffer();
                res.append("<html>");
                res.append("<table border=0>");
                res.append("<tr><td colspan=2>").append(id).append("</td></tr>");
                res.append("<tr><td bgcolor=#f2f2ff align='right'>-log<sub>10</sub>(p-value):</td><td bgcolor=#f2f2ff>").append(value).append("</td></tr>");
                res.append("<tr><td bgcolor=#f2f2ff align='right'>p-value</td><td bgcolor=#f2f2ff>").append(Math.pow(10.0, -value.doubleValue())).append("</td></tr>");
                res.append("</table>");
                res.append("</html>");
                return res.toString();
            }
        });
        chart.setBorder(BorderFactory.createLineBorder(Color.black));
        ViewCaseControlSNP.resizeComponent(chart, Snpanalyzer2.WidthDocument - 90 + 20 + 5 + 5, 200);
        resultView.add(chart);
        chart.getChart().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int found = ((ChartWithScrollBar)chart).getChart().getClickableAt(x, y);
                if (found < 0) {
                    tableOR.setValueAt("-", 1, 0);
                    tableOR.setValueAt("-", 1, 1);
                    tableOR.setValueAt("-", 1, 2);
                    tableOR.setValueAt("-", 1, 3);
                    tableOR.setValueAt("-", 1, 4);
                    tableOR.setValueAt("-", 1, 5);
                    return;
                }
                tableOR.setValueAt(dm.getValueAt(found, 0), 1, 0);
                tableOR.setValueAt(dm.getValueAt(found, 1), 1, 1);
                tableOR.setValueAt(dm.getValueAt(found, 2), 1, 2);
                Snpanalyzer2 cfr_ignored_0 = ViewCaseControlSNP.this.applet;
                if ("Codominant".equalsIgnoreCase(Snpanalyzer2.pref.getValue("casecontrol.snp.model"))) {
                    tableOR.setValueAt("-", 1, 3);
                    tableOR.setValueAt("-", 1, 4);
                    tableOR.setValueAt("-", 1, 5);
                } else {
                    tableOR.setValueAt(dm.getValueAt(found, 3), 1, 3);
                    tableOR.setValueAt(dm.getValueAt(found, 4), 1, 4);
                    tableOR.setValueAt(dm.getValueAt(found, 5), 1, 5);
                }
            }
        });
        comboPValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                double newLevel = 0.0;
                newLevel = -Math.log10(Double.parseDouble((String)combo.getSelectedItem()));
                ((ChartWithScrollBar)chart).getChart().setBaseLineValue(newLevel);
                ((ChartWithScrollBar)chart).getChart().repaint();
            }
        });
        if (snp_id_list != null && snp_id_list.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        int found = 0;
                        tableOR.setValueAt(dm.getValueAt(found, 0), 1, 0);
                        tableOR.setValueAt(dm.getValueAt(found, 1), 1, 1);
                        tableOR.setValueAt(dm.getValueAt(found, 2), 1, 2);
                        Snpanalyzer2 cfr_ignored_0 = ViewCaseControlSNP.this.applet;
                        if ("Codominant".equalsIgnoreCase(Snpanalyzer2.pref.getValue("casecontrol.snp.model"))) {
                            tableOR.setValueAt("-", 1, 3);
                            tableOR.setValueAt("-", 1, 4);
                            tableOR.setValueAt("-", 1, 5);
                        } else {
                            tableOR.setValueAt(dm.getValueAt(found, 3), 1, 3);
                            tableOR.setValueAt(dm.getValueAt(found, 4), 1, 4);
                            tableOR.setValueAt(dm.getValueAt(found, 5), 1, 5);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return s_root;
    }
}

