/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.ExcelAdapter;
import com.istech21.snpanalyzer2free.GenoTableModelLimited;
import com.istech21.snpanalyzer2free.GradientPanel;
import com.istech21.snpanalyzer2free.IconPool;
import com.istech21.snpanalyzer2free.SNPContentsParser;
import com.istech21.snpanalyzer2free.SearchFlagFile;
import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.ViewGenerator;
import com.istech21.snpanalyzer2free.tdf.ViewTDF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ViewEditor
implements ViewGenerator {
    protected String selectedSampleType = "0";
    protected JComboBox comboSampleType = null;
    GenoTableModelLimited genoModel = null;
    AbstractTableModel headerModel = null;
    AbstractTableModel contentsModel = null;
    JTable table = null;
    JTable tableAlleleFrequency = null;
    JTable tableGenotypeFrequency = null;
    JTable tableHWE = null;
    Snpanalyzer2 applet;
    static final boolean bBorder = true;
    static final Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.gray, Color.DARK_GRAY, Color.magenta};
    static int nextColor = 0;
    private float sample_missing_rate = 0.5f;
    private float snp_missing_rate = 0.1f;
    private float snp_maf = 0.0f;
    private float snp_hwep = 0.0f;
    private boolean snp_hwem = false;
    JTextField textPrepMethodDesc = null;
    private int[] flaggedSNPIdx = new int[0];
    private int[] invalid_sample = new int[0];
    private DecimalFormat formatter = new DecimalFormat("#.#");
    private int this_sample_count = 0;
    private int this_sample_type_count = 0;
    private int this_snp_count = 0;

    private static void resizeComponent(JComponent c, int w, int h) {
        Dimension d = new Dimension(w, h);
        c.setSize(d.width, d.height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setAlignmentX(0.0f);
        if (c instanceof JButton) {
            ((JButton)c).setHorizontalAlignment(2);
        }
        if (++nextColor >= colors.length) {
            nextColor = 0;
        }
    }

    public void decorateJTable(JTable table) {
    }

    private void recalc_analysis_param() {
        StringBuffer descString = new StringBuffer();
        if (this.applet.PathSrc == null) {
            descString.append("* Genotype not defined\n");
        } else {
            boolean bAnyManualFlaggingApplied = this.applet.isAnyManualFlaggingApplied();
            this.sample_missing_rate = Float.parseFloat(bAnyManualFlaggingApplied ? "0.5" : Snpanalyzer2.pref.getValue("flagging.sampleMgf"));
            this.snp_missing_rate = Float.parseFloat(!bAnyManualFlaggingApplied ? "0.1" : Snpanalyzer2.pref.getValue("flagging.snpMgf"));
            this.snp_maf = Float.parseFloat(!bAnyManualFlaggingApplied ? "0.0" : Snpanalyzer2.pref.getValue("flagging.maf"));
            this.snp_hwep = Float.parseFloat(!bAnyManualFlaggingApplied ? "0.0" : Snpanalyzer2.pref.getValue("flagging.hwe"));
            this.snp_hwem = "On".equalsIgnoreCase(Snpanalyzer2.pref.getValue("flagging.hwemulticorrection"));
            descString.append("* Flag out condition: ");
            descString.append(String.valueOf(this.sample_missing_rate));
            descString.append(" < Sample Missing, ");
            descString.append(String.valueOf(this.snp_missing_rate));
            descString.append(" < SNP Missing, ");
            descString.append("  ");
            descString.append(String.valueOf(this.snp_maf));
            descString.append(" > SNP MAF, ");
            if (this.snp_hwem) {
                descString.append(String.valueOf(this.snp_hwep));
                descString.append("/");
                descString.append(String.valueOf(this.applet.snpCount));
                descString.append("=");
                descString.append(String.valueOf(this.snp_hwep / (float)this.applet.snpCount));
                descString.append(" > SNP HWE p-value");
                descString.append(", with Multiple correction.");
            } else {
                descString.append(String.valueOf(this.snp_hwep));
                descString.append(" > SNP HWE p-value.");
            }
        }
        this.textPrepMethodDesc.setText(descString.toString());
    }

    private void updateEditorShade() {
        int[][] invalids = SNPContentsParser.ReadFileAndReturnInValidSNPIndex(this.applet.PathFlag, "M");
        if (invalids != null && invalids.length != 0) {
            this.flaggedSNPIdx = invalids[0];
            this.invalid_sample = invalids[1];
        }
        if (this.table != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ViewEditor.this.table.repaint();
                }
            });
        }
    }

    public JPanel FillJPanel(Snpanalyzer2 _applet, String[] filePath) {
        this.applet = _applet;
        this.applet.ResizeWindow();
        JPanel root = new JPanel();
        root.setPreferredSize(new Dimension(400, 500));
        root.setLayout(new BorderLayout());
        root.setOpaque(false);
        GradientPanel logoPane = new GradientPanel();
        logoPane.setColor1(Color.white);
        logoPane.setColor2(Color.DARK_GRAY);
        logoPane.setLayout(new BorderLayout());
        JLabel logoPaneTitle = new JLabel("<html><h3>Data Import</h3></html>", IconPool.getImageIcon("edit.png", this.applet), 2);
        logoPaneTitle.setVerticalAlignment(1);
        logoPane.add((Component)logoPaneTitle, "North");
        root.add((Component)logoPane, "North");
        JSplitPane split = new JSplitPane(0);
        split.setOpaque(false);
        split.setDividerLocation(350);
        split.setOneTouchExpandable(true);
        final JPanel editor = new JPanel();
        editor.setOpaque(false);
        editor.setLayout(new BorderLayout());
        JButton btnOpen = new JButton("Open Genotype", IconPool.getImageIcon("open.png", this.applet));
        JButton btnSave = new JButton("Save", IconPool.getImageIcon("save.png", this.applet));
        JButton btnResize = new JButton("Resize", IconPool.getImageIcon("resize.png", this.applet));
        JPanel panelBtnGroup = new JPanel(new FlowLayout(2));
        panelBtnGroup.setOpaque(false);
        panelBtnGroup.add(btnOpen);
        editor.add((Component)panelBtnGroup, "North");
        this.updateEditorShade();
        this.genoModel = new GenoTableModelLimited(this.applet.PathSrc);
        if (this.applet.PathSrc == null) {
            this.genoModel.setValueAt("No", 0, 0);
            this.genoModel.setValueAt("Chr_No", 0, 1);
            this.genoModel.setValueAt("Chr_Pos", 0, 2);
            this.genoModel.setValueAt("dbSNP_rs", 0, 3);
            this.genoModel.setValueAt("indv1", 0, 4);
            this.genoModel.setValueAt("indv2", 0, 5);
            this.genoModel.setValueAt("Sample_Type", 1, 0);
            this.genoModel.setValueAt("#", 1, 1);
            this.genoModel.setValueAt("#", 1, 2);
            this.genoModel.setValueAt("#", 1, 3);
            this.genoModel.setValueAt("0", 1, 4);
            this.genoModel.setValueAt("0", 1, 5);
            this.genoModel.setValueAt("snp1", 2, 0);
            this.genoModel.setValueAt("-", 2, 1);
            this.genoModel.setValueAt("-", 2, 2);
            this.genoModel.setValueAt("-", 2, 3);
            this.genoModel.setValueAt("N/N", 2, 4);
            this.genoModel.setValueAt("N/N", 2, 5);
            this.genoModel.setValueAt("snp2", 3, 0);
            this.genoModel.setValueAt("-", 3, 1);
            this.genoModel.setValueAt("-", 3, 2);
            this.genoModel.setValueAt("-", 3, 3);
            this.genoModel.setValueAt("N/N", 3, 4);
            this.genoModel.setValueAt("N/N", 3, 5);
        }
        this.headerModel = new GenoTableModelLimited.NumberHeaderSubTableModel(this.genoModel);
        this.contentsModel = this.genoModel;
        this.table = new JTable(this.contentsModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Object value;
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                boolean bSelected = this.isCellSelected(rowIndex, vColIndex);
                int whichSNP = rowIndex - 2;
                int whichSample = vColIndex - 4 + 1 - 1;
                boolean bThisIsFlagged = false;
                if (ViewEditor.this.flaggedSNPIdx.length > 0 && Arrays.binarySearch(ViewEditor.this.flaggedSNPIdx, whichSNP + 1) >= 0) {
                    bThisIsFlagged = true;
                }
                if (ViewEditor.this.invalid_sample.length > 0 && Arrays.binarySearch(ViewEditor.this.invalid_sample, whichSample) >= 0) {
                    bThisIsFlagged = true;
                }
                if (bSelected) {
                    c.setBackground(Color.blue);
                    c.setForeground(Color.white);
                    if (bThisIsFlagged) {
                        c.setBackground(Color.LIGHT_GRAY);
                        c.setForeground(Color.blue);
                    }
                } else {
                    c.setBackground(ViewEditor.this.table.getBackground());
                    c.setForeground(ViewEditor.this.table.getForeground());
                    if (bThisIsFlagged) {
                        c.setBackground(Color.LIGHT_GRAY);
                    }
                }
                if ((value = this.getValueAt(rowIndex, vColIndex)) != null && value instanceof String && "N/N".equals((String)value)) {
                    c.setBackground(Color.red);
                    c.setForeground(Color.white);
                }
                return c;
            }
        };
        this.decorateJTable(this.table);
        this.table.setFont(new Font("verdana", 0, 11));
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        ExcelAdapter xls = new ExcelAdapter(this.table);
        final JScrollPane scrollTable = new JScrollPane(this.table);
        JTable fixed = new JTable(this.headerModel);
        fixed.setSelectionModel(this.table.getSelectionModel());
        fixed.setPreferredScrollableViewportSize(fixed.getPreferredSize());
        scrollTable.setRowHeaderView(fixed);
        scrollTable.setCorner("UPPER_LEFT_CORNER", fixed.getTableHeader());
        JEditorPane htmlHelp = new JEditorPane();
        htmlHelp.setContentType("text/html");
        htmlHelp.setEditable(false);
        try {
            htmlHelp.setPage(this.applet.htmlGenotypeFormatURL);
        }
        catch (Exception ig) {
            ig.printStackTrace();
        }
        final JScrollPane scrollHtmlHelp = new JScrollPane(htmlHelp);
        if (this.applet.PathSrc == null) {
            editor.add((Component)scrollHtmlHelp, "Center");
        } else {
            editor.add((Component)scrollTable, "Center");
        }
        split.setTopComponent(editor);
        btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, ViewEditor.this.applet);
                    JFileChooser fc = new JFileChooser();
                    fc.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String filename = file.getName();
                            return filename.endsWith(".geno");
                        }

                        public String getDescription() {
                            return "*.geno";
                        }
                    });
                    int res = fc.showOpenDialog(f);
                    if (res != 0) {
                        return;
                    }
                    String fpath = fc.getSelectedFile().getCanonicalPath();
                    int[] snpSampleSize = ViewEditor.this.applet.getSNPSampleSize(fpath);
                    if (snpSampleSize[0] > 510000) {
                        JOptionPane.showMessageDialog(ViewEditor.this.applet, "Too many SNP(" + snpSampleSize[0] + ">" + 510000 + "), Cannot  import.");
                        return;
                    }
                    if (snpSampleSize[1] > 1000) {
                        JOptionPane.showMessageDialog(ViewEditor.this.applet, "Too many Sample(" + snpSampleSize[1] + ">" + 1000 + "), Cannot import.");
                        return;
                    }
                    ViewEditor.this.applet.snpCount = snpSampleSize[0];
                    ViewEditor.this.applet.sampleCount = snpSampleSize[0];
                    ViewEditor.this.applet.ImportGenotype(fpath);
                    Snpanalyzer2 cfr_ignored_0 = ViewEditor.this.applet;
                    ViewEditor.this.applet.run_external(0, new String[]{"init"});
                    ViewEditor.this.updateEditorShade();
                    ViewEditor.this.genoModel.readFile(fpath);
                    ViewEditor.this.decorateJTable(ViewEditor.this.table);
                    ViewEditor.this.recalc_analysis_param();
                    editor.remove(scrollHtmlHelp);
                    editor.add((Component)scrollTable, "Center");
                    editor.updateUI();
                }
                catch (Exception ig) {
                    ig.printStackTrace();
                }
            }
        });
        btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    boolean success = false;
                    if (ViewEditor.this.applet.PathSrc == null) {
                        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, ViewEditor.this.applet);
                        JFileChooser fc = new JFileChooser();
                        fc.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                String filename = file.getName();
                                return filename.endsWith(".geno");
                            }

                            public String getDescription() {
                                return "*.geno";
                            }
                        });
                        int res = fc.showSaveDialog(f);
                        if (res != 0) {
                            return;
                        }
                        String fpath = fc.getSelectedFile().getCanonicalPath();
                        if (!fpath.endsWith(".geno")) {
                            fpath = fpath + ".geno";
                        }
                        scrollTable.setVisible(false);
                        success = ViewEditor.this.genoModel.saveFile(fpath);
                        ViewEditor.this.applet.ImportGenotype(fpath);
                    } else {
                        scrollTable.setVisible(false);
                        success = ViewEditor.this.genoModel.saveFile(ViewEditor.this.applet.PathSrc);
                        Snpanalyzer2 cfr_ignored_0 = ViewEditor.this.applet;
                        Snpanalyzer2.CopyFile(ViewEditor.this.applet.PathSrc, ViewEditor.this.applet.PathGeno);
                    }
                    if (!success) {
                        JOptionPane.showMessageDialog(null, "Cannot write  file " + ViewEditor.this.applet.PathGeno);
                        scrollTable.setVisible(true);
                        return;
                    }
                    scrollTable.setVisible(true);
                    ViewEditor.this.decorateJTable(ViewEditor.this.table);
                    Snpanalyzer2 cfr_ignored_1 = ViewEditor.this.applet;
                    ViewEditor.this.applet.run_external(0, new String[]{"init"});
                    ViewEditor.this.updateEditorShade();
                }
                catch (Exception ig) {
                    ig.printStackTrace();
                }
            }
        });
        btnResize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int newSNPSize = ViewEditor.this.genoModel.activeRowSize - 2;
                    int newSampleSize = ViewEditor.this.genoModel.activeColumnSize - 4;
                    JResizeDialog dlg = new JResizeDialog(ViewEditor.this.applet, newSNPSize, newSampleSize);
                    dlg.setModal(true);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension componentSize = dlg.getSize();
                    dlg.setLocation(screenSize.width / 2 - componentSize.width / 2, screenSize.height / 2 - componentSize.height / 2);
                    dlg.setVisible(true);
                    if (!dlg.isOk) {
                        return;
                    }
                    GenoTableModelLimited cfr_ignored_0 = ViewEditor.this.genoModel;
                    if (2200 <= dlg.sizeSample + 4) {
                        GenoTableModelLimited cfr_ignored_1 = ViewEditor.this.genoModel;
                        JOptionPane.showMessageDialog(ViewEditor.this.applet, "Too many sample size. MAX=" + (2200 - 4));
                        GenoTableModelLimited cfr_ignored_2 = ViewEditor.this.genoModel;
                        dlg.sizeSample = 2200 - 4 - 1;
                        return;
                    }
                    GenoTableModelLimited cfr_ignored_3 = ViewEditor.this.genoModel;
                    if (1200 <= dlg.sizeSample + 2) {
                        GenoTableModelLimited cfr_ignored_4 = ViewEditor.this.genoModel;
                        JOptionPane.showMessageDialog(ViewEditor.this.applet, "Too many Marker size. MAX=" + (1200 - 2));
                        GenoTableModelLimited cfr_ignored_5 = ViewEditor.this.genoModel;
                        dlg.sizeSNP = 1200 - 2 - 1;
                        return;
                    }
                    ViewEditor.this.genoModel.setSize(dlg.sizeSNP + 2, dlg.sizeSample + 4);
                    ViewEditor.this.decorateJTable(ViewEditor.this.table);
                }
                catch (Exception ig) {
                    ig.printStackTrace();
                }
            }
        });
        JPanel panelTables = new JPanel();
        panelTables.setLayout(null);
        JLabel label = null;
        label = new JLabel("Allele Frequency");
        label.setBounds(4, 4, 100, 24);
        panelTables.add(label);
        this.tableAlleleFrequency = new JTable(new Object[][]{{"Allele", "A", "a", "Total"}, {"Count", "-", "-", "-"}, {"Frequency", "-", "-", "-"}}, new Object[]{"Allele", "Allele1", "Allele2", "Total"});
        this.tableAlleleFrequency.setBounds(4, 29, 220, 54);
        this.tableAlleleFrequency.setBorder(BorderFactory.createLineBorder(Color.black));
        this.tableAlleleFrequency.setFont(new Font("verdana", 0, 11));
        this.tableAlleleFrequency.setRowHeight(18);
        this.tableAlleleFrequency.setAutoResizeMode(0);
        this.tableAlleleFrequency.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableAlleleFrequency.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.tableAlleleFrequency.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.tableAlleleFrequency.getColumnModel().getColumn(3).setPreferredWidth(40);
        panelTables.add(this.tableAlleleFrequency);
        ((DefaultTableCellRenderer)this.tableAlleleFrequency.getDefaultRenderer(String.class)).setHorizontalAlignment(0);
        label = new JLabel("Genotype Frequency");
        label.setBounds(230, 4, 340, 24);
        panelTables.add(label);
        this.tableGenotypeFrequency = new JTable(new Object[][]{{"Genotype", "A/A", "A/a", "a/a", "N/N", "Total"}, {"Obs.Count", "-", "-", "-", "-", "-"}, {"Exp.Count", "-", "-", "-", "-", "-"}}, new Object[]{"", "MajorH", "Hetero", "MinorH", "N/N", "Total"});
        this.tableGenotypeFrequency.setBounds(230, 29, 280, 54);
        this.tableGenotypeFrequency.setBorder(BorderFactory.createLineBorder(Color.black));
        this.tableGenotypeFrequency.setFont(new Font("verdana", 0, 11));
        this.tableGenotypeFrequency.setRowHeight(18);
        this.tableGenotypeFrequency.setAutoResizeMode(0);
        this.tableGenotypeFrequency.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableGenotypeFrequency.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.tableGenotypeFrequency.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.tableGenotypeFrequency.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.tableGenotypeFrequency.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.tableGenotypeFrequency.getColumnModel().getColumn(5).setPreferredWidth(50);
        panelTables.add(this.tableGenotypeFrequency);
        ((DefaultTableCellRenderer)this.tableGenotypeFrequency.getDefaultRenderer(String.class)).setHorizontalAlignment(0);
        label = new JLabel("HWE Test");
        label.setBounds(4, 90, 300, 24);
        panelTables.add(label);
        this.tableHWE = new JTable(new Object[][]{{"Chi Square", "DOF", "P-value", "Call rate"}, {"-", "-", "-", "-"}}, new Object[]{"Chi Square", "DOF", "P-value", "Call rate"});
        this.tableHWE.setBounds(4, 115, 400, 36);
        this.tableHWE.setBorder(BorderFactory.createLineBorder(Color.black));
        this.tableHWE.setFont(new Font("verdana", 0, 11));
        this.tableHWE.setRowHeight(18);
        this.tableHWE.setAutoResizeMode(0);
        this.tableHWE.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableHWE.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.tableHWE.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.tableHWE.getColumnModel().getColumn(3).setPreferredWidth(100);
        panelTables.add(this.tableHWE);
        ((DefaultTableCellRenderer)this.tableHWE.getDefaultRenderer(String.class)).setHorizontalAlignment(0);
        this.comboSampleType = new JComboBox<String>(new String[]{"0", "1", "M"});
        this.comboSampleType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String newSampletype;
                JComboBox combo = (JComboBox)e.getSource();
                ViewEditor.this.selectedSampleType = newSampletype = (String)combo.getSelectedItem();
                ViewEditor.this.UpdateSNPTable(ViewEditor.this.table.getSelectedRow(), ViewEditor.this.selectedSampleType);
            }
        });
        JLabel labelST = new JLabel("<html><b>Sample Type:</b></html>");
        labelST.setBounds(358, 5, 80, 24);
        panelTables.add(labelST);
        this.comboSampleType.setBounds(438, 5, 70, 20);
        panelTables.add(this.comboSampleType);
        JButton btnNotepad = new JButton("Flagging Result", IconPool.getImageIcon("save.png", this.applet));
        btnNotepad.setBounds((int)this.comboSampleType.getBounds().getMaxX() + 15, this.comboSampleType.getBounds().y, 160, 30);
        panelTables.add(btnNotepad);
        btnNotepad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String flagPath = ViewEditor.this.applet.PathFlag;
                if (flagPath == null) {
                    return;
                }
                ViewTDF.MakeReadonlyWindow(flagPath, ViewEditor.this.applet);
            }
        });
        this.textPrepMethodDesc = new JTextField();
        this.textPrepMethodDesc.setBounds(4, (int)this.tableHWE.getBounds().getMaxY() + 2 + 3, 680, 20);
        this.textPrepMethodDesc.setEditable(false);
        panelTables.add(this.textPrepMethodDesc);
        this.recalc_analysis_param();
        panelTables.setPreferredSize(new Dimension(400, 150));
        split.setBottomComponent(new JScrollPane(panelTables));
        root.add((Component)split, "Center");
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        ListSelectionListener myLSL = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ViewEditor.this.applet.PathGeno == null) {
                    return;
                }
                if (e.getSource() == ViewEditor.this.table.getSelectionModel() && ViewEditor.this.table.getRowSelectionAllowed()) {
                    int first = e.getFirstIndex();
                    int last = e.getLastIndex();
                    int selectedRow = first;
                    for (int i = first; i <= last; ++i) {
                        if (!ViewEditor.this.table.isRowSelected(i)) continue;
                        selectedRow = i;
                        break;
                    }
                    ViewEditor.this.UpdateSNPTable(selectedRow, ViewEditor.this.selectedSampleType);
                }
            }
        };
        this.table.getSelectionModel().addListSelectionListener(myLSL);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(myLSL);
        return root;
    }

    private void UpdateSNPTable(int whichRow, String selectedSampleType) {
        if (whichRow < 2) {
            return;
        }
        try {
            String[] tok;
            String snp_id = (String)this.genoModel.getValueAt(whichRow, 0);
            String[] found = SearchFlagFile.ReadLine(this.applet.PathFlag, snp_id, selectedSampleType);
            if (found.length >= 1 && found[0].length() > 0) {
                tok = found[0].split("\t");
                String allele1 = String.valueOf(tok[1].charAt(0));
                String allele2 = tok[1].length() > 1 ? String.valueOf(tok[1].charAt(2)) : "-";
                this.tableAlleleFrequency.setValueAt(allele1, 0, 1);
                this.tableAlleleFrequency.setValueAt(allele2, 0, 2);
                String[] freqs = tok[6].split("/");
                double[] freq = new double[2];
                try {
                    freq[0] = Double.parseDouble(freqs[0]);
                }
                catch (Exception noallele) {
                    freq[0] = 0.0;
                }
                try {
                    freq[1] = Double.parseDouble(freqs[1]);
                }
                catch (Exception noallele) {
                    freq[1] = 0.0;
                }
                int nValidAllele = Integer.parseInt(tok[4]);
                this.tableAlleleFrequency.setValueAt((int)(2.0 * Math.rint((double)nValidAllele * freq[0])), 1, 1);
                this.tableAlleleFrequency.setValueAt((int)(2.0 * Math.rint((double)nValidAllele * freq[1])), 1, 2);
                this.tableAlleleFrequency.setValueAt(2 * nValidAllele, 1, 3);
                if (Float.parseFloat(freqs[0]) >= this.snp_maf) {
                    this.tableAlleleFrequency.setValueAt(freqs[0], 2, 1);
                } else {
                    this.tableAlleleFrequency.setValueAt("<html><font color='red'>" + freqs[0] + "</font></html>", 2, 1);
                }
                if (freqs.length <= 1) {
                    this.tableAlleleFrequency.setValueAt("<html><font color='red'>-</font></html>", 2, 2);
                } else if (Float.parseFloat(freqs[1]) >= this.snp_maf) {
                    this.tableAlleleFrequency.setValueAt(freqs[1], 2, 2);
                } else {
                    this.tableAlleleFrequency.setValueAt("<html><font color='red'>" + freqs[1] + "</font></html>", 2, 2);
                }
                this.tableAlleleFrequency.setValueAt("1", 2, 3);
                String[] genos = new String[]{allele1 + "/" + allele1, allele1 + "/" + allele2, allele2 + "/" + allele1, allele2 + "/" + allele2, "N/N"};
                int[] genosCount = new int[genos.length];
                this.tableGenotypeFrequency.setValueAt(genos[0], 0, 1);
                this.tableGenotypeFrequency.setValueAt(genos[1], 0, 2);
                this.tableGenotypeFrequency.setValueAt(genos[3], 0, 3);
                this.tableGenotypeFrequency.setValueAt(genos[4], 0, 4);
                for (int j = 0; j < genos.length; ++j) {
                    genosCount[j] = 0;
                }
                for (int i = 4; i < this.genoModel.getColumnCount(); ++i) {
                    String thisSampleType = (String)this.genoModel.getValueAt(1, i);
                    if (!selectedSampleType.equals("M") && !selectedSampleType.equals(thisSampleType)) continue;
                    String thisGenotype = (String)this.genoModel.getValueAt(whichRow, i);
                    for (int j = 0; j < genos.length; ++j) {
                        if (!thisGenotype.equals(genos[j])) continue;
                        int n = j;
                        genosCount[n] = genosCount[n] + 1;
                    }
                }
                this.tableGenotypeFrequency.setValueAt(genosCount[0], 1, 1);
                this.tableGenotypeFrequency.setValueAt(genosCount[1] + genosCount[2], 1, 2);
                this.tableGenotypeFrequency.setValueAt(genosCount[3], 1, 3);
                if ((float)genosCount[4] / (float)(genosCount[0] + genosCount[1] + genosCount[2] + genosCount[3] + genosCount[4]) > this.snp_missing_rate) {
                    this.tableGenotypeFrequency.setValueAt("<html><font color='red'>" + genosCount[4] + "</font></html>", 1, 4);
                } else {
                    this.tableGenotypeFrequency.setValueAt(genosCount[4], 1, 4);
                }
                this.tableGenotypeFrequency.setValueAt(genosCount[0] + genosCount[1] + genosCount[2] + genosCount[3] + genosCount[4], 1, 5);
                this.tableGenotypeFrequency.setValueAt(this.formatter.format(freq[0] * freq[0] * (double)nValidAllele), 2, 1);
                this.tableGenotypeFrequency.setValueAt(this.formatter.format(freq[0] * freq[1] * (double)nValidAllele * 2.0), 2, 2);
                this.tableGenotypeFrequency.setValueAt(this.formatter.format(freq[1] * freq[1] * (double)nValidAllele), 2, 3);
                this.tableGenotypeFrequency.setValueAt("(" + genosCount[4] + ")", 2, 4);
                this.tableGenotypeFrequency.setValueAt((int)Math.rint(freq[0] * freq[0] * (double)nValidAllele + freq[0] * freq[1] * (double)nValidAllele * 2.0 + freq[1] * freq[1] * (double)nValidAllele + (double)genosCount[4]), 2, 5);
                this.tableHWE.setValueAt(tok[7], 1, 0);
                this.tableHWE.setValueAt("1", 1, 1);
                float f = Float.parseFloat(tok[8]);
                float f2 = this.snp_hwem ? this.snp_hwep / (float)this.applet.snpCount : this.snp_hwep;
                if (f < f2) {
                    this.tableHWE.setValueAt("<html><font color='red'>" + tok[8] + "</font></html>", 1, 2);
                } else {
                    this.tableHWE.setValueAt(tok[8], 1, 2);
                }
            } else {
                throw new Exception();
            }
            this.tableHWE.setValueAt(tok[4], 1, 3);
        }
        catch (Exception e) {
            int j;
            int i;
            for (i = 0; i < this.tableAlleleFrequency.getRowCount(); ++i) {
                for (j = 1; j < this.tableAlleleFrequency.getColumnCount(); ++j) {
                    if (i == 0 && j == 3) continue;
                    this.tableAlleleFrequency.setValueAt("-", i, j);
                }
            }
            for (i = 0; i < this.tableGenotypeFrequency.getRowCount(); ++i) {
                for (j = 1; j < this.tableGenotypeFrequency.getColumnCount(); ++j) {
                    if (i == 0 && j == 5) continue;
                    this.tableGenotypeFrequency.setValueAt("-", i, j);
                }
            }
            for (i = 1; i < this.tableHWE.getRowCount(); ++i) {
                for (j = 0; j < this.tableHWE.getColumnCount(); ++j) {
                    this.tableHWE.setValueAt("-", i, j);
                }
            }
            System.out.println("error at ViewEditor:UpdateSNPTable " + e.toString());
            e.printStackTrace();
        }
    }

    protected boolean ValidateGenoFormatFromTableModel() {
        int rc = this.genoModel.getRowCount();
        int cc = this.genoModel.getColumnCount();
        return true;
    }

    static class JResizeDialog
    extends JDialog {
        private int oldSizeSNP = 1;
        private int oldSizeSample = 1;
        public int sizeSNP = 1;
        public int sizeSample = 1;
        public boolean isOk = false;
        private JTextField field1 = null;
        private JTextField field2 = null;
        static Dimension dm = new Dimension(180, 120);

        JResizeDialog(JApplet parent, int _sizeSNP, int _sizeSample) {
            super((Frame)null);
            this.oldSizeSNP = this.sizeSNP = _sizeSNP;
            this.oldSizeSample = this.sizeSample = _sizeSample;
            this.setPreferredSize(dm);
            this.MakeGUI();
            this.setResizable(false);
            this.pack();
        }

        private void MakeGUI() {
            JPanel root = new JPanel();
            root.setLayout(null);
            JLabel label = null;
            Object text = null;
            JButton btn = null;
            label = new JLabel("Size of Marker:");
            label.setBounds(4, 4, 100, 25);
            this.field1 = new JTextField(String.valueOf(this.sizeSNP));
            this.field1.setBounds(110, 4, 60, 25);
            root.add(label);
            root.add(this.field1);
            label = new JLabel("Size of Sample:");
            label.setBounds(4, 34, 100, 25);
            this.field2 = new JTextField(String.valueOf(this.sizeSample));
            this.field2.setBounds(110, 34, 60, 25);
            root.add(label);
            root.add(this.field2);
            btn = new JButton("OK");
            btn.setBounds(4, 64, 80, 25);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JResizeDialog.this.isOk = true;
                    try {
                        JResizeDialog.this.sizeSNP = Integer.parseInt(JResizeDialog.this.field1.getText());
                    }
                    catch (Exception nfe) {
                        JResizeDialog.this.sizeSNP = JResizeDialog.this.oldSizeSNP;
                    }
                    try {
                        JResizeDialog.this.sizeSample = Integer.parseInt(JResizeDialog.this.field2.getText());
                    }
                    catch (Exception nfe) {
                        JResizeDialog.this.sizeSample = JResizeDialog.this.oldSizeSample;
                    }
                    JResizeDialog.this.dispose();
                }
            });
            root.add(btn);
            btn = new JButton("Cancel");
            btn.setBounds(90, 64, 80, 25);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JResizeDialog.this.isOk = false;
                    JResizeDialog.this.dispose();
                }
            });
            root.add(btn);
            this.getContentPane().add(root);
        }
    }
}

