/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.GradientPanel;
import com.istech21.snpanalyzer2free.IconPool;
import com.istech21.snpanalyzer2free.NumericColoredJLabel;
import com.istech21.snpanalyzer2free.SNPContentsParser;
import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.SpringUtilities;
import com.istech21.snpanalyzer2free.ViewGenerator;
import com.istech21.snpanalyzer2free.tdf.ViewTDF;
import com.istech21.widget.chart.ChartWithScrollBar;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ViewHaplotype
implements ViewGenerator {
    private static final Color IVORY = new Color(0xFFFFF0);
    Snpanalyzer2 applet;
    private boolean bThisIsPLEM = false;
    static final Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.gray, Color.DARK_GRAY, Color.magenta};
    static int nextColor = 0;
    private JComboBox comboFrequency = null;
    protected String IWillWaitThisSampleType = "M";

    public ViewHaplotype(boolean _bThisIsPLEM) {
        this.bThisIsPLEM = _bThisIsPLEM;
    }

    private static void resizeComponent(JComponent c, int w, int h) {
        Dimension d = new Dimension(w, h);
        c.setSize(d.width, d.height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setAlignmentX(0.0f);
        if (c instanceof JButton) {
            ((JButton)c).setHorizontalAlignment(2);
        }
        if (++nextColor >= colors.length) {
            nextColor = 0;
        }
    }

    private JPanel FillOptionPane() {
        JPanel opt = new JPanel();
        opt.setOpaque(false);
        opt.setLayout(new BorderLayout());
        JLabel label = null;
        JComboBox combo = null;
        Object fill = null;
        Font small10Font = new Font("verdana", 0, 10);
        JPanel RunPane = new JPanel();
        RunPane.setOpaque(false);
        RunPane.setLayout(new FlowLayout());
        JButton btnOk = new JButton("Execute", IconPool.getImageIcon("run.png", this.applet));
        RunPane.add(btnOk);
        btnOk.setPreferredSize(new Dimension(280, 24));
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ViewHaplotype.this.bThisIsPLEM) {
                    if (ViewHaplotype.this.applet.snpCount > 200) {
                        JOptionPane.showMessageDialog(ViewHaplotype.this.applet, "Too may SNP for PLEM Haplotype Estimation.\n(" + ViewHaplotype.this.applet.snpCount + ">" + 200 + ")");
                        return;
                    }
                    ViewHaplotype.this.applet.menuListener.action_plem();
                } else {
                    if (ViewHaplotype.this.applet.snpCount > 24) {
                        JOptionPane.showMessageDialog(ViewHaplotype.this.applet, "Too may SNP for EM Haplotype Estimation.\n(" + ViewHaplotype.this.applet.snpCount + ">" + 24 + ")");
                        return;
                    }
                    ViewHaplotype.this.applet.menuListener.action_em();
                }
            }
        });
        opt.add((Component)RunPane, "North");
        if (!this.bThisIsPLEM) {
            JPanel EMOpt = new JPanel();
            EMOpt.setOpaque(false);
            EMOpt.setBorder(BorderFactory.createTitledBorder("EM Algorithm: Up to 24 SNPs applicable."));
            EMOpt.setLayout(new SpringLayout());
            opt.add((Component)EMOpt, "Center");
            label = new JLabel("<html>&nbsp;&nbsp;<b>Convergence:</b></html>");
            label.setFont(small10Font);
            EMOpt.add(label);
            combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("haplotype.em.convergence");
            combo.setFont(small10Font);
            EMOpt.add(combo);
            label = new JLabel("<html>&nbsp;&nbsp;<b>Min Frequency:</b></html>");
            label.setFont(small10Font);
            EMOpt.add(label);
            combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("haplotype.estimation.minfreq");
            combo.setFont(small10Font);
            EMOpt.add(combo);
            this.comboFrequency = combo;
            SpringUtilities.makeCompactGrid(EMOpt, 1, 4, 6, 6, 6, 1);
        }
        if (this.bThisIsPLEM) {
            JPanel PLEMOpt = new JPanel();
            PLEMOpt.setOpaque(false);
            PLEMOpt.setBorder(BorderFactory.createTitledBorder("PL-EM Algorithm: Up to 200 SNPs applicable."));
            PLEMOpt.setLayout(new SpringLayout());
            opt.add((Component)PLEMOpt, "Center");
            label = new JLabel("<html>&nbsp;&nbsp;<b>Partition No:</b></html>");
            label.setFont(small10Font);
            PLEMOpt.add(label);
            combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("haplotype.plem.partitionno");
            combo.setFont(small10Font);
            PLEMOpt.add(combo);
            label = new JLabel("<html>&nbsp;&nbsp;<b>Frequency Limit:</b></html>");
            label.setFont(small10Font);
            PLEMOpt.add(label);
            combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("haplotype.plem.freqlimit");
            combo.setFont(small10Font);
            PLEMOpt.add(combo);
            label = new JLabel("<html>&nbsp;&nbsp;<b>EM Convergence:</b></html>");
            label.setFont(small10Font);
            PLEMOpt.add(label);
            combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("haplotype.em.convergence");
            combo.setFont(small10Font);
            PLEMOpt.add(combo);
            label = new JLabel("<html>&nbsp;&nbsp;<b>Min Frequency:</b></html>");
            label.setFont(small10Font);
            PLEMOpt.add(label);
            combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("haplotype.estimation.minfreq");
            combo.setFont(small10Font);
            PLEMOpt.add(combo);
            this.comboFrequency = combo;
            SpringUtilities.makeCompactGrid(PLEMOpt, 2, 4, 6, 6, 6, 1);
        }
        return opt;
    }

    public JPanel FillJPanel(Snpanalyzer2 _applet, String[] filePath) {
        this.applet = _applet;
        this.applet.ResizeWindow();
        final String genoPath = filePath[0];
        String flagPath = filePath[1];
        JPanel s_root = new JPanel();
        s_root.setLayout(new BorderLayout());
        GradientPanel logoPane = new GradientPanel();
        logoPane.setColor1(Color.white);
        logoPane.setColor2(Color.DARK_GRAY);
        logoPane.setLayout(new BorderLayout());
        JLabel logoPaneTitle = new JLabel("<html><h3>Haplotype Estimation</h3></html>", IconPool.getImageIcon("haplotype.png", this.applet), 2);
        logoPaneTitle.setVerticalAlignment(1);
        logoPane.add((Component)logoPaneTitle, "North");
        logoPane.setAlignmentX(0.0f);
        s_root.add((Component)logoPane, "North");
        JTaskPane root = new JTaskPane();
        s_root.add((Component)root, "Center");
        JTaskPaneGroup tgOption = new JTaskPaneGroup();
        tgOption.setTitle("Haplotype Estimation Option");
        tgOption.setExpanded(true);
        tgOption.add((Component)this.FillOptionPane());
        tgOption.setAlignmentX(0.0f);
        tgOption.setScrollOnExpand(true);
        root.add(tgOption);
        JTaskPaneGroup tgAlleleFreq = new JTaskPaneGroup();
        tgAlleleFreq.setTitle("Allele Frequency");
        tgAlleleFreq.setExpanded(false);
        tgAlleleFreq.setAlignmentX(0.0f);
        tgAlleleFreq.setScrollOnExpand(true);
        root.add(tgAlleleFreq);
        DefaultTableModel modelAlleleFrequency = SNPContentsParser.ReadFileAndReturnAlleleFrequencyTableModel(genoPath + ".flag", this.IWillWaitThisSampleType);
        if (modelAlleleFrequency.getColumnCount() <= 1) {
            tgAlleleFreq.add((Component)new JLabel("Cannot find Analysis result"));
            tgAlleleFreq.setExpanded(false);
        } else {
            JTable tableAlleleFrequency = new JTable(modelAlleleFrequency);
            tableAlleleFrequency.setColumnSelectionAllowed(true);
            tableAlleleFrequency.setRowSelectionAllowed(false);
            tableAlleleFrequency.getTableHeader().setVisible(false);
            tableAlleleFrequency.setTableHeader(null);
            tableAlleleFrequency.setBorder(BorderFactory.createLineBorder(Color.black));
            tableAlleleFrequency.setFont(new Font("verdana", 0, 9));
            tableAlleleFrequency.setRowHeight(18);
            tableAlleleFrequency.setAutoResizeMode(0);
            tableAlleleFrequency.getColumnModel().getColumn(0).setPreferredWidth(80);
            for (int i = 1; i < tableAlleleFrequency.getColumnCount(); ++i) {
                tableAlleleFrequency.getColumnModel().getColumn(i).setPreferredWidth(50);
            }
            ((DefaultTableCellRenderer)tableAlleleFrequency.getDefaultRenderer(String.class)).setHorizontalAlignment(0);
            JScrollPane scroll = new JScrollPane(tableAlleleFrequency);
            scroll.setVerticalScrollBarPolicy(21);
            ViewHaplotype.resizeComponent(scroll, Snpanalyzer2.WidthDocument - 60 + 20 - 10 - 100, 108);
            scroll.setBorder(BorderFactory.createLineBorder(Color.black));
            tgAlleleFreq.add((Component)scroll);
        }
        JTaskPaneGroup tgHaplotypeFreq = new JTaskPaneGroup();
        tgHaplotypeFreq.setTitle("Haplotype Frequency");
        tgHaplotypeFreq.setExpanded(true);
        tgHaplotypeFreq.setAlignmentX(0.0f);
        tgHaplotypeFreq.setScrollOnExpand(true);
        root.add(tgHaplotypeFreq);
        String this_min_hap_freq = Snpanalyzer2.pref.getValue("haplotype.estimation.minfreq");
        if (this_min_hap_freq == null || this_min_hap_freq.length() == 0) {
            this_min_hap_freq = "0.01";
        }
        double this_min_hap_freq_d = Double.parseDouble(this_min_hap_freq);
        String phapPath = genoPath + ".em.phap";
        if (this.bThisIsPLEM) {
            phapPath = genoPath + ".plem.phap";
        }
        DefaultTableModel modelHapFreq = SNPContentsParser.ReadFileAndReturnHaplotypeFrequencyTableModel(phapPath, this.IWillWaitThisSampleType, this_min_hap_freq_d);
        System.out.println("for class 'M', modelHapFreq.getRowCount()=" + modelHapFreq.getRowCount());
        if (modelHapFreq.getRowCount() == 0) {
            modelHapFreq = SNPContentsParser.ReadFileAndReturnHaplotypeFrequencyTableModel(phapPath, "0", this_min_hap_freq_d);
            System.out.println("for class '0', modelHapFreq.getRowCount()=" + modelHapFreq.getRowCount());
        }
        if (modelHapFreq.getRowCount() == 0) {
            modelHapFreq = SNPContentsParser.ReadFileAndReturnHaplotypeFrequencyTableModel(phapPath, "1", this_min_hap_freq_d);
            System.out.println("for class '1', modelHapFreq.getRowCount()=" + modelHapFreq.getRowCount());
        }
        if (modelHapFreq.getRowCount() == 0) {
            tgHaplotypeFreq.add((Component)new JLabel("Cannot find Analysis result"));
            tgHaplotypeFreq.setExpanded(false);
        } else {
            JPanel vg = new JPanel();
            vg.setOpaque(false);
            vg.setLayout(null);
            ViewHaplotype.resizeComponent(vg, Snpanalyzer2.WidthDocument - 60 + 20 - 300, 450);
            JLabel label = new JLabel("<html><h3>Haplotype Frequency in Population</h3></html>");
            label.setBounds(0, 0, label.getPreferredSize().width, label.getPreferredSize().height);
            vg.add(label);
            JButton btnSavePHAP = new JButton("PHAP", IconPool.getImageIcon("save.png", this.applet));
            btnSavePHAP.setBounds(label.getPreferredSize().width + 10, 0, 100, 25);
            vg.add(btnSavePHAP);
            btnSavePHAP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String phapPath = genoPath + ".em.phap";
                    if (ViewHaplotype.this.bThisIsPLEM) {
                        phapPath = genoPath + ".plem.phap";
                    }
                    if (phapPath == null) {
                        return;
                    }
                    ViewTDF.MakeReadonlyWindow(phapPath, ViewHaplotype.this.applet);
                }
            });
            String[] chartLabels = new String[modelHapFreq.getRowCount()];
            double[] chartValues = new double[modelHapFreq.getRowCount()];
            for (int i = 0; i < chartLabels.length; ++i) {
                chartLabels[i] = modelHapFreq.getValueAt(i, 0).toString();
                chartValues[i] = Double.parseDouble(modelHapFreq.getValueAt(i, 1).toString());
            }
            final ChartWithScrollBar chart = new ChartWithScrollBar(chartLabels, chartValues, 0);
            chart.getChart().setTitle("");
            chart.getChart().setXTitle("");
            chart.getChart().setYTitle("");
            chart.getChart().setBaseLineValue(this_min_hap_freq_d);
            chart.getChart().setIsUpSpecial(false);
            chart.setBounds(0, 30, 376, 200);
            chart.setBorder(BorderFactory.createLineBorder(Color.black));
            vg.add(chart);
            double maxY = 0.0;
            for (int i = 0; i < chartValues.length; ++i) {
                maxY = Math.max(maxY, chartValues[i]);
            }
            chart.getChart().setMaxY(maxY *= 1.1);
            JTable tableHapFreq = new JTable(modelHapFreq){

                public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                    Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                    boolean bSelected = this.isCellSelected(rowIndex, vColIndex);
                    if (vColIndex == 1) {
                        try {
                            String vCnow = this.getModel().getValueAt(rowIndex, vColIndex).toString();
                            return NumericColoredJLabel.getInstance(vCnow, bSelected);
                        }
                        catch (Exception ig) {
                            // empty catch block
                        }
                    }
                    if (!bSelected) {
                        if (rowIndex % 2 == 0 && !bSelected) {
                            c.setBackground(IVORY);
                        } else {
                            c.setBackground(this.getBackground());
                        }
                    }
                    return c;
                }
            };
            tableHapFreq.setBorder(BorderFactory.createLineBorder(Color.black));
            tableHapFreq.setFont(new Font("verdana", 0, 9));
            tableHapFreq.setRowHeight(20);
            tableHapFreq.setAutoResizeMode(0);
            tableHapFreq.getColumnModel().getColumn(0).setPreferredWidth(50);
            tableHapFreq.getColumnModel().getColumn(1).setPreferredWidth(80);
            int haplotypeLength = 3;
            try {
                haplotypeLength = modelHapFreq.getValueAt(0, 2).toString().length();
            }
            catch (Exception ig) {
                haplotypeLength = 3;
            }
            tableHapFreq.getColumnModel().getColumn(2).setPreferredWidth(haplotypeLength * 10);
            ((DefaultTableCellRenderer)tableHapFreq.getDefaultRenderer(String.class)).setHorizontalAlignment(2);
            JScrollPane scrollHapFreq = new JScrollPane(tableHapFreq);
            scrollHapFreq.setBounds(0, 235, 376, 200);
            scrollHapFreq.setBorder(BorderFactory.createLineBorder(Color.black));
            vg.add(scrollHapFreq);
            label = new JLabel("<html><h3>Individual Haplotypes</h3></html>");
            label.setBounds(400, 0, label.getPreferredSize().width, label.getPreferredSize().height);
            vg.add(label);
            JButton btnSaveIHAP = new JButton("IHAP", IconPool.getImageIcon("save.png", this.applet));
            btnSaveIHAP.setBounds((int)label.getBounds().getMaxX() + 10, 0, 100, 25);
            vg.add(btnSaveIHAP);
            btnSaveIHAP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String phapPath = genoPath + ".em.ihap";
                    if (ViewHaplotype.this.bThisIsPLEM) {
                        phapPath = genoPath + ".plem.ihap";
                    }
                    if (phapPath == null) {
                        return;
                    }
                    ViewTDF.MakeReadonlyWindow(phapPath, ViewHaplotype.this.applet);
                }
            });
            String ihapPath = genoPath + ".em.ihap";
            if (this.bThisIsPLEM) {
                ihapPath = genoPath + ".plem.ihap";
            }
            DefaultTableModel modelIndHaplotype = SNPContentsParser.ReadFileAndIndividualReturnHaplotypeTableModel(ihapPath);
            JTable tableIndHap = new JTable(modelIndHaplotype){

                public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                    Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                    boolean bSelected = this.isCellSelected(rowIndex, vColIndex);
                    if (vColIndex == 3) {
                        String vCnow = this.getModel().getValueAt(rowIndex, vColIndex).toString();
                        return NumericColoredJLabel.getInstance(vCnow, bSelected);
                    }
                    if (!bSelected) {
                        if (rowIndex % 2 == 0 && !bSelected) {
                            c.setBackground(IVORY);
                        } else {
                            c.setBackground(this.getBackground());
                        }
                    }
                    return c;
                }
            };
            tableIndHap.setBorder(BorderFactory.createLineBorder(Color.black));
            tableIndHap.setFont(new Font("verdana", 0, 9));
            tableIndHap.setRowHeight(20);
            tableIndHap.setAutoResizeMode(0);
            tableIndHap.getColumnModel().getColumn(0).setPreferredWidth(95);
            tableIndHap.getColumnModel().getColumn(1).setPreferredWidth(35);
            tableIndHap.getColumnModel().getColumn(2).setPreferredWidth(35);
            tableIndHap.getColumnModel().getColumn(3).setPreferredWidth(30);
            ((DefaultTableCellRenderer)tableIndHap.getDefaultRenderer(String.class)).setHorizontalAlignment(0);
            JScrollPane scroll = new JScrollPane(tableIndHap);
            scroll.setBounds(380, 30, 275, 405);
            scroll.setBorder(BorderFactory.createLineBorder(Color.black));
            vg.add(scroll);
            tgHaplotypeFreq.add((Component)vg);
            if (this.comboFrequency != null) {
                this.comboFrequency.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JComboBox combo = (JComboBox)e.getSource();
                        double newLevel = 0.0;
                        newLevel = Double.parseDouble((String)combo.getSelectedItem());
                        ((ChartWithScrollBar)chart).getChart().setBaseLineValue(newLevel);
                        ((ChartWithScrollBar)chart).getChart().repaint();
                    }
                });
            }
        }
        return s_root;
    }
}

