/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free;

import com.istech21.snpanalyzer2free.GradientPanel;
import com.istech21.snpanalyzer2free.IconPool;
import com.istech21.snpanalyzer2free.SNPContentsParser;
import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.SpringUtilities;
import com.istech21.snpanalyzer2free.ViewGenerator;
import com.istech21.snpanalyzer2free.drawld.DrawableLD;
import com.istech21.snpanalyzer2free.drawld.DrawableLDWidthDistanceAndLabel;
import com.istech21.snpanalyzer2free.drawrblk.BlockRelationView;
import com.istech21.snpanalyzer2free.tdf.ViewTDF;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;

public class ViewLDBlocking
implements ViewGenerator {
    private boolean bContainsBlockingInfo = false;
    Snpanalyzer2 applet;
    static final Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.gray, Color.DARK_GRAY, Color.magenta};
    static int nextColor = 0;

    public ViewLDBlocking(boolean _bContainsBlockingInfo) {
        this.bContainsBlockingInfo = _bContainsBlockingInfo;
    }

    private static void resizeComponent(JComponent c, int w, int h) {
        Dimension d = new Dimension(w, h);
        c.setSize(d.width, d.height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setAlignmentX(0.0f);
        if (c instanceof JButton) {
            ((JButton)c).setHorizontalAlignment(2);
        }
        if (++nextColor >= colors.length) {
            nextColor = 0;
        }
    }

    private JPanel FillOptionPane() {
        JPanel opt = new JPanel();
        opt.setOpaque(false);
        opt.setLayout(new BorderLayout());
        JLabel label = null;
        JComboBox combo = null;
        Object fill = null;
        Font small10Font = new Font("verdana", 0, 10);
        JPanel RunPane = new JPanel();
        RunPane.setOpaque(false);
        RunPane.setLayout(new FlowLayout());
        JButton btnOk = new JButton("Execute", IconPool.getImageIcon("run.png", this.applet));
        RunPane.add(btnOk);
        btnOk.setPreferredSize(new Dimension(280, 24));
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ViewLDBlocking.this.bContainsBlockingInfo) {
                    ViewLDBlocking.this.applet.menuListener.action_gabriel();
                } else {
                    ViewLDBlocking.this.applet.menuListener.action_ld();
                }
            }
        });
        opt.add((Component)RunPane, "North");
        JPanel LDOpt = new JPanel();
        LDOpt.setOpaque(false);
        LDOpt.setBorder(BorderFactory.createTitledBorder("LD Analysis"));
        LDOpt.setLayout(new SpringLayout());
        opt.add((Component)LDOpt, "Center");
        label = new JLabel("<html>Pairwise LD:</html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        label = new JLabel();
        LDOpt.add(label);
        label = new JLabel("<html>SNP Tagging</html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        label = new JLabel();
        LDOpt.add(label);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Max Segment Limit</b></html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.segmentlimit");
        combo.setFont(small10Font);
        LDOpt.add(combo);
        label = new JLabel("<html>&nbsp;&nbsp;<b>MAF Threshold</b></html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.ldtag.maf");
        combo.setFont(small10Font);
        LDOpt.add(combo);
        label = new JLabel("<html>Four Gamete Rule:</html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        label = new JLabel();
        LDOpt.add(label);
        label = new JLabel("<html>&nbsp;&nbsp;<b>r2 Threshold</b></html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.ldtag.r2");
        combo.setFont(small10Font);
        LDOpt.add(combo);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Min Haplotype Frequency</b></html>");
        label.setFont(small10Font);
        LDOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.4gamete.mhf");
        combo.setFont(small10Font);
        LDOpt.add(combo);
        label = new JLabel();
        LDOpt.add(label);
        label = new JLabel();
        LDOpt.add(label);
        SpringUtilities.makeCompactGrid(LDOpt, 4, 4, 6, 6, 6, 1);
        if (!this.bContainsBlockingInfo) {
            return opt;
        }
        JPanel BLOCKOpt = new JPanel();
        BLOCKOpt.setOpaque(false);
        BLOCKOpt.setBorder(BorderFactory.createTitledBorder("LD Block Analysis"));
        BLOCKOpt.setLayout(new SpringLayout());
        opt.add((Component)BLOCKOpt, "South");
        label = new JLabel("<html>Gabriel Method:</html>");
        label.setFont(small10Font);
        BLOCKOpt.add(label);
        label = new JLabel();
        BLOCKOpt.add(label);
        label = new JLabel();
        BLOCKOpt.add(label);
        label = new JLabel();
        BLOCKOpt.add(label);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Lower |D'|</b></html>");
        label.setFont(small10Font);
        BLOCKOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.gabriel.lth");
        combo.setFont(small10Font);
        BLOCKOpt.add(combo);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Strong LD Fraction</b></html>");
        label.setFont(small10Font);
        BLOCKOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.gabriel.strongld");
        combo.setFont(small10Font);
        BLOCKOpt.add(combo);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Upper |D'|</b></html>");
        label.setFont(small10Font);
        BLOCKOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.gabriel.uth");
        combo.setFont(small10Font);
        BLOCKOpt.add(combo);
        label = new JLabel("<html>&nbsp;&nbsp;<b>Minor Allele Freq.</b></html>");
        label.setFont(small10Font);
        BLOCKOpt.add(label);
        combo = Snpanalyzer2.pref.Create_JComboBoxReturnsText("ld.gabriel.maf");
        combo.setFont(small10Font);
        BLOCKOpt.add(combo);
        SpringUtilities.makeCompactGrid(BLOCKOpt, 3, 4, 6, 6, 6, 1);
        return opt;
    }

    public JPanel FillJPanel(Snpanalyzer2 _applet, String[] filePath) {
        JTaskPaneGroup tg;
        this.applet = _applet;
        this.applet.ResizeWindow();
        String genoPath = filePath[0];
        String flagPath = filePath[1];
        JPanel s_root = new JPanel();
        s_root.setLayout(new BorderLayout());
        GradientPanel logoPane = new GradientPanel();
        logoPane.setColor1(Color.white);
        logoPane.setColor2(Color.DARK_GRAY);
        logoPane.setLayout(new BorderLayout(6, 6));
        JLabel logoPaneTitle = new JLabel(this.bContainsBlockingInfo ? "<html><h3>LD Blocking</h3></html>" : "<html><h3>LD Analysis</h3></html>", IconPool.getImageIcon("ldblock.png", this.applet), 2);
        logoPaneTitle.setVerticalAlignment(1);
        logoPane.add((Component)logoPaneTitle, "North");
        logoPane.setAlignmentX(0.0f);
        s_root.add((Component)logoPane, "North");
        JTaskPane root = new JTaskPane();
        s_root.add((Component)root, "Center");
        JTaskPaneGroup tgOption = tg = new JTaskPaneGroup();
        tg.setTitle("LD Blocking Option");
        tg.setAnimated(false);
        tg.setExpanded(false);
        tg.add((Component)this.FillOptionPane());
        tg.setAlignmentX(0.0f);
        tg.setScrollOnExpand(true);
        root.add(tg);
        tg = new JTaskPaneGroup();
        tg.setTitle("LD Map & LD Block");
        tg.setAnimated(false);
        tg.setExpanded(true);
        tg.setScrollOnExpand(true);
        root.add(tg);
        if (!new File(this.applet.PathGeno + ".pwld").exists()) {
            tg.setExpanded(false);
            tg.add((Component)new JLabel("Cannot find Analysis result"));
            tgOption.setExpanded(true);
        } else {
            JPanel ldmap = new JPanel();
            ldmap.setOpaque(false);
            ViewLDBlocking.resizeComponent(ldmap, Snpanalyzer2.WidthDocument - 60, Math.max(Snpanalyzer2.HeightDocument - 300 + 70, 500));
            tg.add((Component)ldmap);
            int[][] blocks = new int[0][0];
            int[] tagsnps = new int[]{};
            if (this.bContainsBlockingInfo) {
                Object[] blk_out = SNPContentsParser.ReadFileLDBlockTableModel(this.applet.PathGeno + ".ld.hblk", "M");
                blocks = (int[][])blk_out[0];
            }
            int[] tag_idx = SNPContentsParser.ReadFileLDTagAndReturnIndex(this.applet.PathGeno + ".pwld.tag", "M");
            tagsnps = tag_idx;
            final DrawableLDWidthDistanceAndLabel figure = new DrawableLDWidthDistanceAndLabel(this.applet.PathGeno, "D'", this.applet.PathGeno + ".pwld", blocks, tagsnps);
            JPanel vflow = new JPanel();
            vflow.setOpaque(false);
            vflow.setLayout(new SpringLayout());
            JLabel label = new JLabel("Sample:");
            JComboBox<String> comboSample = new JComboBox<String>(new String[]{"0", "1", "M"});
            comboSample.setSelectedIndex(2);
            vflow.add(label);
            vflow.add(comboSample);
            comboSample.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    String newSampletype = (String)combo.getSelectedItem();
                    int[][] blk_idx = new int[0][0];
                    if (ViewLDBlocking.this.bContainsBlockingInfo) {
                        Object[] blk_out = SNPContentsParser.ReadFileLDBlockTableModel(ViewLDBlocking.this.applet.PathGeno + ".ld.hblk", newSampletype);
                        blk_idx = (int[][])blk_out[0];
                    }
                    int[] tag_idx = SNPContentsParser.ReadFileLDTagAndReturnIndex(ViewLDBlocking.this.applet.PathGeno + ".pwld.tag", newSampletype);
                    figure.SetBlockAndTagDataButNoRedraw(blk_idx, tag_idx);
                    figure.SetSampleType(newSampletype);
                }
            });
            label = new JLabel("LD Index:");
            JComboBox<String> comboMetric = new JComboBox<String>(new String[]{"|D'|", "r2"});
            vflow.add(label);
            vflow.add(comboMetric);
            comboMetric.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    figure.SetMetricMode(combo.getSelectedIndex());
                }
            });
            label = new JLabel("Scale:");
            JComboBox<String> comboScale = new JComboBox<String>(new String[]{"1", "2", "4", "6", "8", "10", "12", "14", "16"});
            comboScale.setSelectedItem("6");
            vflow.add(label);
            vflow.add(comboScale);
            comboScale.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    int rescale = Integer.parseInt(combo.getSelectedItem().toString());
                    figure.setScale(rescale);
                }
            });
            label = new JLabel("Label");
            JComboBox<String> comboLabel = new JComboBox<String>(new String[]{"Hide", "Show", "Hide All"});
            vflow.add(label);
            vflow.add(comboLabel);
            comboLabel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    int newMode = combo.getSelectedIndex();
                    figure.SetLabelMode(newMode);
                }
            });
            SpringUtilities.makeCompactGrid(vflow, 2, 4, 1, 1, 1, 1);
            ldmap.add(vflow);
            final JTable tableLD = new JTable(new Object[][]{{"|D'|", "r2", "LOD score", "Four Gamete", "p-value"}, {"-", "-", "-", "-", "-"}}, new Object[]{"|D'|", "r2", "LOD score", "Four Gamete", "p-value"});
            int tablecellwidth = 70;
            tableLD.setBounds(4, 45, tablecellwidth * 5, 48);
            tableLD.setBorder(BorderFactory.createLineBorder(Color.black));
            tableLD.setFont(new Font("verdana", 0, 11));
            tableLD.setRowHeight(24);
            tableLD.setAutoResizeMode(0);
            tableLD.getColumnModel().getColumn(0).setPreferredWidth(tablecellwidth);
            tableLD.getColumnModel().getColumn(1).setPreferredWidth(tablecellwidth);
            tableLD.getColumnModel().getColumn(2).setPreferredWidth(tablecellwidth);
            tableLD.getColumnModel().getColumn(3).setPreferredWidth(tablecellwidth);
            tableLD.getColumnModel().getColumn(4).setPreferredWidth(tablecellwidth);
            ldmap.add(tableLD);
            ((DefaultTableCellRenderer)tableLD.getDefaultRenderer(String.class)).setHorizontalAlignment(0);
            figure.SetSampleType("M");
            figure.SetGridMode(1);
            figure.SetBorderMode(0);
            figure.setScale(6);
            figure.addMouseListener(new MouseListener(){

                public void mouseExited(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                    int y;
                    int x = e.getX();
                    DrawableLD.ClickableItemAndDetail found = figure.getClickableAt(x, y = e.getY());
                    if (found == null) {
                        tableLD.setValueAt("-", 1, 0);
                        tableLD.setValueAt("-", 1, 1);
                        tableLD.setValueAt("-", 1, 2);
                        tableLD.setValueAt("-", 1, 3);
                        tableLD.setValueAt("-", 1, 4);
                        return;
                    }
                    tableLD.setValueAt(String.valueOf(found.dPrimeAbs), 1, 0);
                    tableLD.setValueAt(String.valueOf(found.r2), 1, 1);
                    tableLD.setValueAt(String.valueOf(found.LOD), 1, 2);
                    tableLD.setValueAt(String.valueOf(found.FourGamete), 1, 3);
                    tableLD.setValueAt(String.valueOf(found.PValue), 1, 4);
                }
            });
            JScrollPane scrollMatrix = new JScrollPane(figure);
            ViewLDBlocking.resizeComponent(scrollMatrix, Snpanalyzer2.WidthDocument - 90 + 20 + 5 + 5, Math.max(Snpanalyzer2.HeightDocument - 355, 400));
            scrollMatrix.getHorizontalScrollBar().addAdjustmentListener(figure);
            scrollMatrix.getVerticalScrollBar().addAdjustmentListener(figure);
            ldmap.add(scrollMatrix);
            tg.setAlignmentX(0.0f);
            JPanel panelSave = new JPanel(new FlowLayout());
            panelSave.setPreferredSize(new Dimension(Snpanalyzer2.WidthDocument - 100, 40));
            panelSave.setOpaque(false);
            ldmap.add(panelSave);
            JButton btnSavePWLD = new JButton("Pairwise-LD", IconPool.getImageIcon("save.png", this.applet));
            panelSave.add(btnSavePWLD);
            btnSavePWLD.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String pwldPath = ViewLDBlocking.this.applet.PathGeno + ".pwld";
                    if (!new File(pwldPath).exists()) {
                        JOptionPane.showMessageDialog(ViewLDBlocking.this.applet, "Analysis result not exists.");
                        return;
                    }
                    ViewTDF.MakeReadonlyWindow(pwldPath, ViewLDBlocking.this.applet);
                }
            });
            JButton btnSaveImage = new JButton("PNG");
            btnSaveImage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    fc.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            String filename = file.getName();
                            return filename.endsWith(".png");
                        }

                        public String getDescription() {
                            return "*.png";
                        }
                    });
                    int res = fc.showSaveDialog(ViewLDBlocking.this.applet);
                    if (res != 0) {
                        return;
                    }
                    try {
                        figure.exportPNG(fc.getSelectedFile().getCanonicalPath());
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            });
            if (this.bContainsBlockingInfo) {
                JButton btnSaveHBLK = new JButton("Haplotype", IconPool.getImageIcon("save.png", this.applet));
                panelSave.add(btnSaveHBLK);
                btnSaveHBLK.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String hblkPath = ViewLDBlocking.this.applet.PathGeno + ".ld.hblk";
                        if (!new File(hblkPath).exists()) {
                            JOptionPane.showMessageDialog(ViewLDBlocking.this.applet, "Analysis result not exists.");
                            return;
                        }
                        ViewTDF.MakeReadonlyWindow(hblkPath, ViewLDBlocking.this.applet);
                    }
                });
                JButton btnSaveRBLK = new JButton("Block-Relationship", IconPool.getImageIcon("save.png", this.applet));
                panelSave.add(btnSaveRBLK);
                btnSaveRBLK.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String rblkPath = ViewLDBlocking.this.applet.PathGeno + ".ld.rblk";
                        if (!new File(rblkPath).exists()) {
                            JOptionPane.showMessageDialog(ViewLDBlocking.this.applet, "Analysis result not exists.");
                            return;
                        }
                        ViewTDF.MakeReadonlyWindow(rblkPath, ViewLDBlocking.this.applet);
                    }
                });
                JButton btnSaveTAG = new JButton("Tagger", IconPool.getImageIcon("save.png", this.applet));
                panelSave.add(btnSaveTAG);
                btnSaveTAG.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String tagPath = ViewLDBlocking.this.applet.PathGeno + ".pwld.tag";
                        if (!new File(tagPath).exists()) {
                            JOptionPane.showMessageDialog(ViewLDBlocking.this.applet, "Analysis result not exists.");
                            return;
                        }
                        ViewTDF.MakeReadonlyWindow(tagPath, ViewLDBlocking.this.applet);
                    }
                });
            }
        }
        if (this.bContainsBlockingInfo) {
            tg = new JTaskPaneGroup();
            tg.setAnimated(false);
            tg.setTitle("Haplotype Block");
            tg.setExpanded(true);
            root.add(tg);
            if (!new File(this.applet.PathGeno + ".ld.rblk").exists()) {
                tg.setExpanded(false);
                tg.add((Component)new JLabel("Cannot find Analysis result"));
            } else {
                BlockRelationView app = null;
                try {
                    app = new BlockRelationView(this.applet.PathGeno);
                    app.setOpaque(false);
                }
                catch (Exception ig) {
                    ig.printStackTrace();
                }
                JScrollPane scrollHap = new JScrollPane(app);
                ViewLDBlocking.resizeComponent(scrollHap, Snpanalyzer2.WidthDocument - 60, 400);
                tg.add((Component)scrollHap);
                tg.setAlignmentX(0.0f);
                tg.setScrollOnExpand(true);
            }
        }
        root.add((Component)new JLabel());
        return s_root;
    }
}

