/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.drawld;

import com.istech21.snpanalyzer2free.drawld.ColorCalculator;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DrawableLD
extends JComponent
implements AdjustmentListener {
    protected static final int UNIT = 2;
    protected static final int UNIT_HALF = 1;
    protected static final Color UNIT_GRID_COLOR = Color.LIGHT_GRAY;
    protected int FACTOR = 1;
    protected String genoPath = null;
    protected String metricPath = null;
    protected String metricName = null;
    public static final int CM_Red = 0;
    public static final int CM_MoreRed = 1;
    public static final int CM_Blue = 2;
    public static final int CM_Green = 3;
    protected int ColorMode = 0;
    protected ColorCalculator colorCalculatorRed;
    protected ColorCalculator colorCalculator = this.colorCalculatorRed = new ColorCalculator(){

        public Color getColor(double intensity) {
            intensity = Math.abs(intensity);
            if ((intensity *= intensity) >= 0.999) {
                return Color.red;
            }
            return new Color(255, 255 - (int)(intensity * 255.0), 255 - (int)(intensity * 255.0));
        }
    };
    protected ColorCalculator colorCalculatorMoreRed = new ColorCalculator(){

        public Color getColor(double intensity) {
            intensity *= 1000.0;
            intensity = Math.abs(intensity);
            if ((intensity *= intensity) >= 0.999) {
                return Color.red;
            }
            return new Color(255, 255 - (int)(intensity * 255.0), 255 - (int)(intensity * 255.0));
        }
    };
    protected ColorCalculator colorCalculatorBlue = new ColorCalculator(){

        public Color getColor(double intensity) {
            intensity = Math.abs(intensity);
            if ((intensity *= intensity) >= 0.999) {
                return Color.blue;
            }
            return new Color(255 - (int)(intensity * 255.0), 255 - (int)(intensity * 255.0), 255);
        }
    };
    protected ColorCalculator colorCalculatorGreen = new ColorCalculator(){

        public Color getColor(double intensity) {
            intensity = Math.abs(intensity);
            if ((intensity *= intensity) >= 0.999) {
                return Color.green;
            }
            return new Color(255 - (int)(intensity * 255.0), 255, 255 - (int)(intensity * 255.0));
        }
    };
    protected int markerSize = 5000;
    protected static final int DRAWING_REQUESTED = 1;
    protected static final int DRAWING_PROCEEDING = 2;
    protected static final int DRAWING_COMPLETED = 3;
    protected int DrawingState = 1;
    protected Rectangle clip_R = null;
    public static final int BM_AUTO = 0;
    public static final int BM_YES = 1;
    public static final int BM_NO = 2;
    protected int BorderMode = 0;
    public Color BorderColor = Color.black;
    public static final int GM_AUTO = 0;
    public static final int GM_YES = 1;
    public static final int GM_NO = 2;
    protected int GridMode = 0;
    protected HashSet drawingPool = new HashSet();
    protected ClickableItemAndDetail[] clickableObjects = null;
    protected boolean bFileIsPWLDS = false;
    protected int drawingStep = 0;
    protected int drawingCompleteStep = 0;
    protected String SeeThisSampleType = "0";
    public static final int MM_DPRIME = 0;
    public static final int MM_R2 = 1;
    protected int SelectedMetric = 0;
    protected BufferedImage bimg = null;
    protected BufferedImage bImgNew = null;
    protected String[] markerIDList = null;
    protected long[] markerPosList = null;

    public void SetColorMode(int newMode) {
        this.ColorMode = newMode;
        switch (this.ColorMode) {
            case 1: {
                this.colorCalculator = this.colorCalculatorMoreRed;
                break;
            }
            case 2: {
                this.colorCalculator = this.colorCalculatorBlue;
                break;
            }
            case 3: {
                this.colorCalculator = this.colorCalculatorGreen;
                break;
            }
            default: {
                this.colorCalculator = this.colorCalculatorRed;
            }
        }
        this.RequestBufferedImageShouldRedraw();
    }

    public void setColorCalculator(ColorCalculator newColCal) {
        this.colorCalculator = newColCal;
        this.repaint();
    }

    public DrawableLD(String genoPath, String metricName, String metricPath) {
        this.genoPath = genoPath;
        this.bFileIsPWLDS = metricPath.endsWith("pwlds");
        this.metricPath = metricPath;
        this.metricName = metricName;
        this.setPreferredSize(this.calcPreferredSize());
        new Thread(new Runnable(){

            public void run() {
                DrawableLD.this.ReadGenoFile();
            }
        }).start();
    }

    protected Dimension calcPreferredSize() {
        return new Dimension(this.markerSize * this.FACTOR * 2, this.markerSize * this.FACTOR * 1);
    }

    private boolean CompareRectEquality(Rectangle a, Rectangle maybeNull) {
        if (maybeNull == null) {
            return false;
        }
        if (a.x != maybeNull.x) {
            return false;
        }
        if (a.y != maybeNull.y) {
            return false;
        }
        if (a.width > maybeNull.width) {
            return false;
        }
        return a.height <= maybeNull.height;
    }

    public void paintComponent(Graphics g) {
        Rectangle newClipR = this.getVisibleRect();
        if (!this.CompareRectEquality(newClipR, this.clip_R)) {
            this.clip_R = newClipR;
            this.RequestBufferedImageShouldRedraw();
            return;
        }
        if (this.bimg != null) {
            g.drawImage(this.bimg, this.clip_R.x, this.clip_R.y, this);
        }
        if (this.DrawingState == 1) {
            this.requestPaintOffscreen();
        }
        if (this.DrawingState != 3 || this.drawingPool.size() != 0) {
            g.setColor(Color.LIGHT_GRAY);
            g.fill3DRect(this.clip_R.x + this.clip_R.width / 2 - 100, this.clip_R.y + this.clip_R.height / 2 - 12, 200, 24, true);
            g.setColor(Color.DARK_GRAY);
            g.drawString("Drawing " + this.drawingStep + "/" + this.drawingCompleteStep, this.clip_R.x + this.clip_R.width / 2 - 100 + 4, this.clip_R.y + this.clip_R.height / 2 - 12 + 15);
            int numberOfMillisecondsInTheFuture = 500;
            Date timeToRun = new Date(System.currentTimeMillis() + (long)numberOfMillisecondsInTheFuture);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    DrawableLD.this.repaint();
                }
            }, timeToRun);
        }
    }

    public void SetBorderMode(int newMode) {
        this.BorderMode = newMode;
        this.RequestBufferedImageShouldRedraw();
    }

    public void SetGridMode(int newMode) {
        this.GridMode = newMode;
        this.RequestBufferedImageShouldRedraw();
    }

    protected void drawClippedRect(Graphics2D g, int i, int j, Shape shape, Color c) {
        g.setColor(c);
        g.fill(shape);
        if (this.BorderMode == 1 || this.BorderMode == 0 && this.FACTOR > 4) {
            g.setColor(this.BorderColor);
            g.draw(shape);
        }
    }

    protected synchronized void stopAllOtherDrawings() {
        if (this.drawingPool.size() != 0) {
            this.drawingPool.clear();
        }
    }

    protected Point DAxisPoint(int i, int j) {
        int point_i = this.FACTOR * 2 * i;
        int point_j = this.FACTOR * 2 * j;
        int axis_x = (point_i + point_j) / 2;
        int axis_y = (point_j - point_i) / 2;
        return new Point(axis_x, axis_y);
    }

    protected Shape getVisibleDShape(int i, int j) {
        Point[] p = null;
        p = new Point[]{this.DAxisPoint(i + 1, j - 1), this.DAxisPoint(i + 1, j), this.DAxisPoint(i, j), this.DAxisPoint(i, j - 1)};
        Polygon poly = new Polygon();
        for (int k = 0; k < p.length; ++k) {
            poly.addPoint(p[k].x, p[k].y);
        }
        Rectangle bound = poly.getBounds();
        if (this.clip_R.contains(bound.x, bound.y)) {
            return poly;
        }
        if (this.clip_R.contains(bound.x + bound.width, bound.y)) {
            return poly;
        }
        if (this.clip_R.contains(bound.x, bound.y + bound.height)) {
            return poly;
        }
        if (this.clip_R.contains(bound.x + bound.width, bound.y + bound.height)) {
            return poly;
        }
        return null;
    }

    public ClickableItemAndDetail getClickableAt(int x, int y) {
        if (this.clickableObjects == null) {
            return null;
        }
        for (int i = 0; i < this.clickableObjects.length; ++i) {
            if (!this.clickableObjects[i].shape.contains(x, y)) continue;
            return this.clickableObjects[i];
        }
        return null;
    }

    public void paintSomeOthersOffscreen(Graphics g) {
    }

    public void paintSomeOthersOffscreenPost(Graphics g) {
    }

    protected void requestPaintOffscreen() {
        this.stopAllOtherDrawings();
        new Thread(new Runnable(){

            public synchronized void run() {
                if (DrawableLD.this.bFileIsPWLDS) {
                    DrawableLD.this.runnable_drawing_offline_pwlds();
                } else {
                    DrawableLD.this.runnable_drawing_offline_pwld();
                }
            }
        }).start();
    }

    public void SetSampleType(String newSampleType) {
        this.SeeThisSampleType = newSampleType;
        this.RequestBufferedImageShouldRedraw();
    }

    protected void runnable_drawing_offline_pwlds() {
        long start = System.currentTimeMillis();
        this.stopAllOtherDrawings();
        this.drawingPool.add(start);
        this.DrawingState = 2;
        this.bImgNew = this.createBufferedImage();
        Graphics2D g = this.bImgNew.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawWhite(g);
        g.translate(-this.clip_R.x, -this.clip_R.y);
        this.paintSomeOthersOffscreen(g);
        if (this.GridMode == 1 || this.GridMode == 0 && this.FACTOR >= 4) {
            this.drawGrid(g);
        }
        this.drawingStep = 0;
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.metricPath));
            String line = null;
            if (this.SeeThisSampleType != null) {
                String ImWaitingThisHeader = "!Sample_Type:" + this.SeeThisSampleType;
                while (!((line = r.readLine()) == null || line.charAt(0) == '!' && (line = line.trim()).equals(ImWaitingThisHeader))) {
                }
            }
            int pos1 = 0;
            int pos2 = 0;
            int pos3 = 0;
            int pos4 = 0;
            int Marker1 = 0;
            int Marker2 = 0;
            Vector<ClickableItemAndDetail> clickableObjectsV = new Vector<ClickableItemAndDetail>();
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.startsWith("!")) break;
                if (line.startsWith("Marker1") || line.startsWith("No")) continue;
                if (!this.drawingPool.contains(start)) {
                    try {
                        r.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    return;
                }
                pos1 = line.indexOf("\t", 0);
                pos2 = line.indexOf("\t", pos1 + 1);
                Shape thisShape = null;
                try {
                    Marker1 = Integer.parseInt(line.substring(0, pos1));
                    Marker2 = Integer.parseInt(line.substring(pos1 + 1, pos2));
                    thisShape = this.getVisibleDShape(Marker1, Marker2);
                    if (thisShape == null) {
                        continue;
                    }
                }
                catch (Exception nfe) {
                    System.out.println("line=[" + line + "]");
                    nfe.printStackTrace();
                    try {
                        r.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    return;
                }
                pos3 = line.indexOf("\t", pos2 + 1);
                pos4 = line.indexOf("\t", pos3 + 1);
                String DPrimeS = new String(line.substring(pos3 + 1, pos4));
                String r2S = new String(line.substring(pos4 + 1, line.length()));
                double DPrime = Double.parseDouble(DPrimeS);
                double r2 = Double.parseDouble(r2S);
                ClickableItemAndDetail thisObj = new ClickableItemAndDetail();
                thisObj.dPrimeAbs = DPrime;
                thisObj.r2 = r2;
                thisObj.shape = thisShape;
                clickableObjectsV.add(thisObj);
                this.drawClippedRect(g, Marker1, Marker2, thisShape, this.colorCalculator.getColor(r2));
                ++this.drawingStep;
            }
            r.close();
            this.drawingCompleteStep = this.drawingStep;
            this.paintSomeOthersOffscreenPost(g);
            this.clickableObjects = new ClickableItemAndDetail[clickableObjectsV.size()];
            clickableObjectsV.toArray(this.clickableObjects);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        g.translate(this.clip_R.x, this.clip_R.y);
        this.bimg = this.bImgNew;
        this.DrawingState = 3;
        this.drawingPool.remove(start);
        this.repaint();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    public void SetMetricMode(int newMetricMode) {
        this.SelectedMetric = newMetricMode;
        this.RequestBufferedImageShouldRedraw();
    }

    protected void runnable_drawing_offline_pwld() {
        long start = System.currentTimeMillis();
        this.stopAllOtherDrawings();
        this.drawingPool.add(start);
        this.DrawingState = 2;
        this.bImgNew = this.createBufferedImage();
        Graphics2D g = this.bImgNew.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawWhite(g);
        g.translate(-this.clip_R.x, -this.clip_R.y);
        this.paintSomeOthersOffscreen(g);
        if (this.GridMode == 1 || this.GridMode == 0 && this.FACTOR >= 4) {
            this.drawGrid(g);
        }
        this.drawingStep = 0;
        String line = null;
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.metricPath));
            if (this.SeeThisSampleType != null) {
                String ImWaitingThisHeader = "!Sample_Type:" + this.SeeThisSampleType;
                while (!((line = r.readLine()) == null || line.charAt(0) == '!' && (line = line.trim()).equals(ImWaitingThisHeader))) {
                }
            }
            int tstart = 0;
            int tstop = 0;
            String token = null;
            int Marker1 = 0;
            int Marker2 = 0;
            Vector<ClickableItemAndDetail> clickableObjectsV = new Vector<ClickableItemAndDetail>();
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.startsWith("!")) break;
                if (line.startsWith("Marker1") || line.startsWith("No")) continue;
                if (!this.drawingPool.contains(start)) {
                    try {
                        r.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    return;
                }
                tstart = 0;
                tstop = line.indexOf("\t", tstart);
                tstart = tstop + 1;
                Shape thisShape = null;
                try {
                    tstop = line.indexOf("\t", tstart);
                    token = line.substring(tstart, tstop);
                    tstart = tstop + 1;
                    Marker1 = Integer.parseInt(token);
                    tstop = line.indexOf("\t", tstart);
                    token = line.substring(tstart, tstop);
                    tstart = tstop + 1;
                    Marker2 = Integer.parseInt(token);
                    thisShape = this.getVisibleDShape(Marker1, Marker2);
                    if (thisShape == null) {
                        continue;
                    }
                }
                catch (Exception nfe) {
                    System.out.println("line=[" + line + "]");
                    nfe.printStackTrace();
                    try {
                        r.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    return;
                }
                tstop = line.indexOf("\t", tstart);
                if (tstop < 0 || (tstop = line.indexOf("\t", tstart = tstop + 1)) < 0) break;
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                double DPrime = Double.parseDouble(token);
                tstop = line.indexOf("\t", tstart);
                if (tstop < 0) break;
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                double r2 = this.parseDouble(token, 0.0);
                tstop = line.indexOf("\t", tstart);
                if (tstop < 0) break;
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                double LOD = this.parseDouble(token, 0.0);
                tstop = line.indexOf("\t", tstart);
                if (tstop < 0 || (tstop = line.indexOf("\t", tstart = tstop + 1)) < 0 || (tstop = line.indexOf("\t", tstart = tstop + 1)) < 0) break;
                token = line.substring(tstart, tstop);
                tstart = tstop + 1;
                double PValue = this.parseDouble(token, 0.0);
                String FourGameteS = token = line.substring(tstart, line.length());
                ClickableItemAndDetail thisObj = new ClickableItemAndDetail();
                thisObj.dPrimeAbs = DPrime;
                thisObj.r2 = r2;
                thisObj.LOD = LOD;
                thisObj.PValue = PValue;
                thisObj.FourGamete = FourGameteS;
                thisObj.shape = thisShape;
                clickableObjectsV.add(thisObj);
                Color fillColor = null;
                fillColor = this.SelectedMetric == 0 ? this.colorCalculator.getColor(DPrime) : this.colorCalculator.getColor(r2);
                this.drawClippedRect(g, Marker1, Marker2, thisShape, fillColor);
                ++this.drawingStep;
            }
            this.drawingCompleteStep = this.drawingStep;
            r.close();
            this.paintSomeOthersOffscreenPost(g);
            this.clickableObjects = new ClickableItemAndDetail[clickableObjectsV.size()];
            clickableObjectsV.toArray(this.clickableObjects);
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
            return;
        }
        g.translate(this.clip_R.x, this.clip_R.y);
        this.bimg = this.bImgNew;
        this.DrawingState = 3;
        this.drawingPool.remove(start);
        this.repaint();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    double parseDouble(String s, double na) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return na;
        }
    }

    protected void drawWhite(Graphics2D g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.clip_R.width, this.clip_R.height);
    }

    protected void drawGrid(Graphics2D g) {
        int count_x = this.markerSize;
        int grid_x = this.FACTOR * 2;
        int grid_y = this.FACTOR * 1;
        int w = (count_x - 1) * grid_x;
        int h = (count_x - 1) * grid_y;
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(grid_x * (count_x - 1), 0.0f);
        path.lineTo((int)((double)(grid_x * (count_x - 1)) / 2.0), grid_y * (count_x - 1));
        path.closePath();
        g.setColor(Color.yellow);
        g.fill(path);
        g.setClip(path);
        g.setColor(UNIT_GRID_COLOR);
        for (int i = 0; i < count_x; ++i) {
            g.drawLine(i * grid_x, 0, i * grid_x + (int)Math.rint((double)((count_x - i - 1) * grid_x) / 2.0), (count_x - i - 1) * grid_y);
            g.drawLine(i * grid_x, 0, i * grid_x - (int)Math.rint((double)(i * grid_x) / 2.0), i * grid_y);
        }
    }

    protected BufferedImage createBufferedImage() {
        BufferedImage res = new BufferedImage(this.clip_R.width, this.clip_R.height, 1);
        return res;
    }

    protected BufferedImage brighterImage(BufferedImage bufferedImage) {
        float scaleFactor = 1.1f;
        RescaleOp op = new RescaleOp(scaleFactor, 0.0f, null);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    protected BufferedImage darkerImage(BufferedImage bufferedImage) {
        float scaleFactor = 0.9f;
        RescaleOp op = new RescaleOp(scaleFactor, 0.0f, null);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    protected void ReadGenoFile() {
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.genoPath));
            String line = null;
            r.readLine();
            r.readLine();
            Vector<String> markerIDV = new Vector<String>();
            Vector<String> markerPosV = new Vector<String>();
            int pos1 = 0;
            int pos2 = 0;
            int pos3 = 0;
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) continue;
                try {
                    pos1 = line.indexOf("\t", 0);
                    pos2 = line.indexOf("\t", pos1 + 1);
                    pos3 = line.indexOf("\t", pos2 + 1);
                    markerIDV.add(new String(line.substring(0, pos1)));
                    markerPosV.add(new String(line.substring(pos2 + 1, pos3)));
                }
                catch (Exception ig) {
                    System.out.println("line=[" + line + "]");
                    System.out.println("pos1=" + pos1);
                    System.out.println("pos2=" + pos2);
                    System.out.println("pos3=" + pos3);
                    ig.printStackTrace();
                    return;
                }
            }
            r.close();
            this.markerIDList = new String[markerIDV.size()];
            markerIDV.toArray(this.markerIDList);
            this.markerPosList = new long[markerIDV.size()];
            for (int i = 0; i < this.markerPosList.length; ++i) {
                try {
                    this.markerPosList[i] = Long.parseLong((String)markerPosV.get(i));
                    continue;
                }
                catch (Exception ig) {
                    this.markerPosList[i] = 0L;
                }
            }
            this.markerSize = this.markerPosList.length;
            this.setPreferredSize(this.calcPreferredSize());
            try {
                ((JViewport)this.getParent()).updateUI();
            }
            catch (Exception ig) {
                // empty catch block
            }
            try {
                ((JScrollPane)((JViewport)this.getParent()).getParent()).getVerticalScrollBar().setUnitIncrement(2 * this.FACTOR);
            }
            catch (Exception ig) {
                // empty catch block
            }
            try {
                ((JScrollPane)((JViewport)this.getParent()).getParent()).getHorizontalScrollBar().setUnitIncrement(1 * this.FACTOR);
            }
            catch (Exception ig) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Adjustable source = evt.getAdjustable();
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int orient = source.getOrientation();
        if (orient == 0) {
            // empty if block
        }
        int type = evt.getAdjustmentType();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
        }
        int value = evt.getValue();
        this.DrawingState = 1;
        this.repaint();
    }

    public void setScale(int factor) {
        this.FACTOR = factor;
        this.RequestBufferedImageShouldRedraw();
        try {
            ((JViewport)this.getParent()).updateUI();
        }
        catch (Exception ig) {
            // empty catch block
        }
        try {
            ((JScrollPane)((JViewport)this.getParent()).getParent()).getVerticalScrollBar().setUnitIncrement(2 * this.FACTOR);
        }
        catch (Exception ig) {
            // empty catch block
        }
        try {
            ((JScrollPane)((JViewport)this.getParent()).getParent()).getHorizontalScrollBar().setUnitIncrement(1 * this.FACTOR);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void RequestBufferedImageShouldRedraw() {
        this.setPreferredSize(this.calcPreferredSize());
        this.DrawingState = 1;
        this.repaint();
    }

    public void OpenGenoFile(String newGenoPath) {
        this.genoPath = newGenoPath;
        this.metricPath = this.bFileIsPWLDS ? this.genoPath + ".pwlds" : this.genoPath + ".pwld";
        new Thread(new Runnable(){

            public void run() {
                DrawableLD.this.ReadGenoFile();
                DrawableLD.this.RequestBufferedImageShouldRedraw();
            }
        }).start();
    }

    public void exportPNG(String imagePath) {
        try {
            String ext = imagePath.substring(imagePath.lastIndexOf(".") + 1);
            this.setVisible(false);
            Dimension imageSize = this.getSize();
            this.clip_R = new Rectangle(0, 0, imageSize.width, imageSize.height);
            this.RequestBufferedImageShouldRedraw();
            this.runnable_drawing_offline_pwld();
            ImageIO.write((RenderedImage)this.bimg, ext, new File(imagePath));
            this.clip_R = null;
            this.setVisible(true);
            this.repaint();
            System.gc();
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ClickableItemAndDetail {
        public Shape shape = null;
        public double dPrimeAbs = 0.0;
        public double r2 = 0.0;
        public double LOD = 0.0;
        public double PValue = 0.0;
        public String FourGamete = "-";
    }
}

