/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.drawld;

import com.istech21.snpanalyzer2free.drawld.DrawableLD;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DrawableLDWidthDistance
extends DrawableLD {
    protected double[] screen_x = null;
    public static final int DM_UNIFORM = 0;
    public static final int DM_PHYSICAL = 1;
    int DistanceMode = 0;
    public static final int TS_REVERSE_TRIANGLE = 0;
    public static final int TS_LEFT_AXIS = 1;
    public static final int TS_RIGHT_AXIS = 2;
    int TriangleShape = 0;

    public DrawableLDWidthDistance(String genoPath, String metricName, String metricPath) {
        super(genoPath, metricName, metricPath);
    }

    protected void ReadGenoFile() {
        super.ReadGenoFile();
        this.screen_x = new double[this.markerSize];
        long screen_min = this.markerPosList[0];
        long screen_max = this.markerPosList[this.markerPosList.length - 1];
        long screen_width = screen_max - screen_min;
        for (int i = 0; i < this.markerSize; ++i) {
            this.screen_x[i] = (double)(this.markerPosList[i] - screen_min) / (double)screen_width;
            this.screen_x[i] = this.screen_x[i] * 2.0 * (double)this.markerSize;
        }
    }

    public void SetDistanceMode(int newMode) {
        this.DistanceMode = newMode;
        this.RequestBufferedImageShouldRedraw();
    }

    protected double getScreenX(int which) {
        switch (this.DistanceMode) {
            case 1: {
                return this.screen_x[which];
            }
        }
        return which * 2;
    }

    protected void drawGrid(Graphics2D g) {
        try {
            int count_x = this.markerSize;
            int grid_x = this.FACTOR * 2;
            int grid_y = this.FACTOR * 1;
            int w = (count_x - 1) * grid_x;
            int h = (count_x - 1) * grid_y;
            Point[] clip = new Point[]{this.DAxisPoint(0, 0), this.DAxisPoint(this.markerSize - 1, this.markerSize - 1), this.DAxisPoint(0, this.markerSize - 1)};
            GeneralPath path = new GeneralPath();
            path.moveTo(clip[0].x, clip[0].y);
            path.lineTo(clip[1].x, clip[1].y);
            path.lineTo(clip[2].x, clip[2].y);
            path.closePath();
            g.setColor(Color.yellow);
            g.fill(path);
            g.setColor(UNIT_GRID_COLOR);
            for (int i = 0; i < this.markerSize; ++i) {
                Point pFrom = this.DAxisPoint(i, i);
                Point pTo1 = this.DAxisPoint(i, this.markerSize - 1);
                Point pTo2 = this.DAxisPoint(0, i);
                g.drawLine(pFrom.x, pFrom.y, pTo1.x, pTo1.y);
                g.drawLine(pFrom.x, pFrom.y, pTo2.x, pTo2.y);
            }
        }
        catch (Exception ig) {
            ig.printStackTrace();
        }
    }

    public void setTriangleShape(int newShape) {
        this.TriangleShape = newShape;
        this.RequestBufferedImageShouldRedraw();
        try {
            ((JViewport)this.getParent()).updateUI();
        }
        catch (Exception ig) {
            // empty catch block
        }
        try {
            ((JScrollPane)((JViewport)this.getParent()).getParent()).getVerticalScrollBar().setUnitIncrement(2 * this.FACTOR);
        }
        catch (Exception ig) {
            // empty catch block
        }
        try {
            ((JScrollPane)((JViewport)this.getParent()).getParent()).getHorizontalScrollBar().setUnitIncrement(1 * this.FACTOR);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Dimension calcPreferredSize() {
        switch (this.TriangleShape) {
            case 1: {
                return new Dimension(this.markerSize * this.FACTOR * 2, this.markerSize * this.FACTOR * 2);
            }
            case 2: {
                return new Dimension(this.markerSize * this.FACTOR * 2, this.markerSize * this.FACTOR * 2);
            }
        }
        return super.calcPreferredSize();
    }

    protected Point DAxisPoint(int i, int j) {
        switch (this.TriangleShape) {
            case 1: {
                return this.DAxisPointL(i, j);
            }
            case 2: {
                return this.DAxisPointR(i, j);
            }
        }
        return this.DAxisPointReverseTriangle(i, j);
    }

    protected Point DAxisPointReverseTriangle(int i, int j) {
        if (i == j) {
            return new Point((int)(this.getScreenX(i) * (double)this.FACTOR), 0);
        }
        int point_i = (int)(this.getScreenX(i) * (double)this.FACTOR);
        int point_j = (int)(this.getScreenX(j) * (double)this.FACTOR);
        int axis_x = (point_i + point_j) / 2;
        int axis_y = (point_j - point_i) / 2;
        return new Point(axis_x, axis_y);
    }

    protected Point DAxisPointL(int i, int j) {
        int point_i = (int)(this.getScreenX(i) * (double)this.FACTOR);
        int point_j = (int)(this.getScreenX(j) * (double)this.FACTOR);
        int axis_x = point_i;
        int axis_y = point_j;
        return new Point(axis_x, axis_y);
    }

    protected Point DAxisPointR(int i, int j) {
        int point_i = (int)(this.getScreenX(i) * (double)this.FACTOR);
        int point_j = (int)(this.getScreenX(j) * (double)this.FACTOR);
        int axis_x = this.markerSize * this.FACTOR * 2 - point_i;
        int axis_y = point_j;
        return new Point(axis_x, axis_y);
    }

    protected Shape getVisibleDShape(int i, int j) {
        int diff;
        if (this.DistanceMode == 0) {
            return super.getVisibleDShape(i, j);
        }
        Point[] p = null;
        p = new Point[]{this.DAxisPoint(i + 1, j - 1), this.DAxisPoint(i + 1, j), this.DAxisPoint(i, j), this.DAxisPoint(i, j - 1)};
        if (j - i == 1 && (diff = p[0].x - p[3].x) > this.FACTOR / 2) {
            diff = this.FACTOR / 2;
            Point[] p2 = new Point[]{new Point(p[3].x + diff, p[3].y - diff), new Point(p[1].x - diff, p[3].y - diff), p[1], p[2], p[3]};
            p = p2;
        }
        Polygon poly = new Polygon();
        for (int k = 0; k < p.length; ++k) {
            poly.addPoint(p[k].x, p[k].y);
        }
        Rectangle bound = poly.getBounds();
        if (this.clip_R.contains(bound.x, bound.y)) {
            return poly;
        }
        if (this.clip_R.contains(bound.x + bound.width, bound.y)) {
            return poly;
        }
        if (this.clip_R.contains(bound.x, bound.y + bound.height)) {
            return poly;
        }
        if (this.clip_R.contains(bound.x + bound.width, bound.y + bound.height)) {
            return poly;
        }
        return null;
    }
}

