/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.drawld;

import com.istech21.snpanalyzer2free.drawld.DrawableLDWidthDistance;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Arrays;

public class DrawableLDWidthDistanceAndLabel
extends DrawableLDWidthDistance {
    int[][] blocks = null;
    int[] tags = null;
    public static final int LM_HIDE = 0;
    public static final int LM_SHOW = 1;
    public static final int LM_HIDE_ALL = 2;
    protected int labelMode = 0;
    int leftrightinset = 10;
    int labelheight = 80;
    static final double D90 = Math.toRadians(90.0);

    public void SetBlockAndTagDataButNoRedraw(int[][] _blocks, int[] _tags) {
        this.blocks = _blocks;
        this.tags = _tags;
    }

    public DrawableLDWidthDistanceAndLabel(String genoPath, String metricName, String metricPath, int[][] _blocks, int[] _tags) {
        super(genoPath, metricName, metricPath);
        this.blocks = _blocks;
        this.tags = _tags;
    }

    public void SetLabelMode(int newLM) {
        this.labelMode = newLM;
        this.RequestBufferedImageShouldRedraw();
    }

    protected Dimension calcPreferredSize() {
        Dimension dm = super.calcPreferredSize();
        dm.height += this.labelheight;
        dm.width += this.leftrightinset;
        dm.width += this.leftrightinset;
        return dm;
    }

    protected Point DAxisPoint(int i, int j) {
        Point res = super.DAxisPoint(i, j);
        res.y += this.labelheight;
        res.x += this.leftrightinset;
        return res;
    }

    private void drawLeftString(Graphics g, String s, int x, int y) {
        int w = g.getFontMetrics().stringWidth(s);
        int h = g.getFontMetrics().getHeight();
        int k = g.getFontMetrics().getDescent();
        g.translate(x + h, y + w);
        ((Graphics2D)g).rotate(-D90);
        g.drawString(s, -5, -k - h / 2);
        ((Graphics2D)g).rotate(D90);
        g.translate(-(x + h), -(y + w));
    }

    public void paintSomeOthersOffscreen(Graphics g) {
        int shiftedPrePosition;
        boolean bShifted;
        int thisX;
        boolean isTagSNP;
        int i;
        if (this.labelMode == 2) {
            this.labelheight = 20;
            return;
        }
        g.setFont(new Font("verdana", 0, 11));
        int lastX = -200;
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight() / 2 + 4;
        int max_label_width = 0;
        g.setColor(Color.gray);
        for (int i2 = 0; i2 < this.screen_x.length; ++i2) {
            if (!this.clip_R.contains(this.getScreenX(i2) * (double)this.FACTOR, (double)this.labelheight)) continue;
            boolean isTagSNP2 = false;
            if (Arrays.binarySearch(this.tags, i2 + 1) >= 0) {
                isTagSNP2 = true;
            }
            int thisX2 = (int)(this.getScreenX(i2) * (double)this.FACTOR + 5.0);
            boolean bShifted2 = false;
            int shiftedPrePosition2 = 0;
            if (thisX2 - lastX < fontHeight) {
                if (!isTagSNP2) continue;
                bShifted2 = true;
                shiftedPrePosition2 = thisX2;
                lastX = thisX2 = lastX + fontHeight;
            } else {
                lastX = thisX2;
            }
            if (i2 < 18 || i2 < 24) {
                // empty if block
            }
            int thisLabelWidth = fm.stringWidth(this.markerIDList[i2]);
            max_label_width = Math.max(max_label_width, thisLabelWidth);
        }
        g.setColor(Color.black);
        int snpIndexYPosition = 3 + max_label_width;
        snpIndexYPosition = this.labelMode == 1 ? 3 + max_label_width + fontHeight : 3;
        this.labelheight = this.labelMode == 1 ? snpIndexYPosition + 40 : 40;
        this.labelheight += this.FACTOR * 2 / 2;
        lastX = -200;
        for (i = 0; i < this.screen_x.length; ++i) {
            if (!this.clip_R.contains(this.getScreenX(i) * (double)this.FACTOR, (double)this.labelheight)) continue;
            isTagSNP = false;
            if (Arrays.binarySearch(this.tags, i + 1) >= 0) {
                isTagSNP = true;
            }
            thisX = (int)(this.getScreenX(i) * (double)this.FACTOR + 5.0);
            bShifted = false;
            shiftedPrePosition = 0;
            if (thisX - lastX < fontHeight) {
                if (!isTagSNP) continue;
                bShifted = true;
                shiftedPrePosition = thisX;
                lastX = thisX = lastX + fontHeight;
            } else {
                lastX = thisX;
            }
            if (!isTagSNP) continue;
            g.setColor(Color.cyan);
            g.fillRect(thisX - 3, 0, this.FACTOR * 2, this.labelheight);
        }
        lastX = -200;
        for (i = 0; i < this.screen_x.length; ++i) {
            if (!this.clip_R.contains(this.getScreenX(i) * (double)this.FACTOR, (double)this.labelheight)) continue;
            isTagSNP = false;
            if (Arrays.binarySearch(this.tags, i + 1) >= 0) {
                isTagSNP = true;
            }
            thisX = (int)(this.getScreenX(i) * (double)this.FACTOR + 5.0);
            bShifted = false;
            shiftedPrePosition = 0;
            if (thisX - lastX < fontHeight) {
                if (!isTagSNP) continue;
                bShifted = true;
                shiftedPrePosition = thisX;
                lastX = thisX = lastX + fontHeight;
            } else {
                lastX = thisX;
            }
            g.setColor(Color.black);
            String thisLabel = String.valueOf(i + 1);
            if (isTagSNP) {
                thisLabel = thisLabel + "*";
            }
            int thisLabelWidth = fm.stringWidth(thisLabel);
            this.drawLeftString(g, thisLabel, thisX + 3, snpIndexYPosition + 25 - thisLabelWidth);
            if (this.labelMode == 1) {
                if (isTagSNP) {
                    g.setColor(Color.black);
                    this.drawLeftString(g, this.markerIDList[i], thisX + 3, 3);
                } else {
                    g.setColor(Color.gray);
                    this.drawLeftString(g, this.markerIDList[i], thisX + 3, 3);
                }
            }
            if (!bShifted) continue;
            g.setColor(Color.gray);
            g.drawLine(shiftedPrePosition + fontHeight / 2, snpIndexYPosition + 45, shiftedPrePosition + fontHeight / 2, snpIndexYPosition + 45 - 3);
            g.drawLine(shiftedPrePosition + fontHeight / 2, snpIndexYPosition + 45 - 3, thisX + fontHeight / 2, snpIndexYPosition + 30 + 3);
            g.drawLine(thisX + fontHeight / 2, snpIndexYPosition + 30, thisX + fontHeight / 2, snpIndexYPosition + 30 + 3);
        }
    }

    public void paintSomeOthersOffscreenPost(Graphics g) {
        if (this.blocks == null || this.blocks.length == 0) {
            return;
        }
        g.setColor(Color.black);
        BasicStroke stroke = null;
        stroke = this.FACTOR < 5 ? new BasicStroke(1.0f) : new BasicStroke(3.5f);
        Stroke old = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(stroke);
        for (int i = 0; i < this.blocks.length; ++i) {
            Object a = null;
            Point A = this.DAxisPoint(this.blocks[i][0] - 1, this.blocks[i][0] - 1);
            Point B = this.DAxisPoint(this.blocks[i][1] - 1, this.blocks[i][1] - 1);
            Point C = this.DAxisPoint(this.blocks[i][0] - 1, this.blocks[i][1] - 1);
            g.drawLine(A.x, A.y - 2 * this.FACTOR / 2, B.x, B.y - 2 * this.FACTOR / 2);
            g.drawLine(B.x, B.y, C.x, C.y);
            g.drawLine(C.x, C.y, A.x, A.y);
            g.drawLine(A.x, A.y - 2 * this.FACTOR / 2, A.x, A.y);
            g.drawLine(B.x, B.y - 2 * this.FACTOR / 2, B.x, B.y);
        }
        ((Graphics2D)g).setStroke(old);
    }
}

