/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.drawld;

import com.istech21.snpanalyzer2free.drawld.DrawableLD;
import com.istech21.snpanalyzer2free.drawld.DrawableLDWidthDistanceAndLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class Main
extends JFrame {
    private String defaultTitle = null;

    public Main(String s) {
        super(s);
        this.defaultTitle = s;
    }

    public static void main(String[] args) {
        final Main f = new Main("test pwld");
        f.setDefaultCloseOperation(3);
        f.setSize(600, 600);
        final DrawableLDWidthDistanceAndLabel figure = new DrawableLDWidthDistanceAndLabel("../test/test_A_900.geno", "D'", "../test/test_A_900.geno.pwld", new int[0][0], new int[0]);
        figure.addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                int y;
                int x = e.getX();
                DrawableLD.ClickableItemAndDetail found = figure.getClickableAt(x, y = e.getY());
                if (found == null) {
                    return;
                }
                System.out.println("click " + x + "," + y + "dp=" + found.dPrimeAbs);
            }
        });
        JScrollPane scroll = new JScrollPane(figure);
        scroll.getHorizontalScrollBar().addAdjustmentListener(figure);
        scroll.getVerticalScrollBar().addAdjustmentListener(figure);
        f.getContentPane().add((Component)scroll, "Center");
        JPanel control = new JPanel(new FlowLayout(0));
        JButton btn1 = new JButton("btn1");
        control.add(btn1);
        JComboBox<String> comboTriangle = new JComboBox<String>(new String[]{"Reverse Triangle", "Left Axis", "Right Axis"});
        comboTriangle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox b = (JComboBox)e.getSource();
                int which = b.getSelectedIndex();
                figure.setTriangleShape(which);
            }
        });
        control.add(comboTriangle);
        JComboBox<String> comboDistance = new JComboBox<String>(new String[]{"Union Distance", "Physical Distance"});
        comboDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox b = (JComboBox)e.getSource();
                int which = b.getSelectedIndex();
                figure.SetDistanceMode(which);
            }
        });
        control.add(comboDistance);
        JComboBox<String> comboColor = new JComboBox<String>(new String[]{"red", "more red", "blue", "green"});
        comboColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox b = (JComboBox)e.getSource();
                int which = b.getSelectedIndex();
                figure.SetColorMode(which);
            }
        });
        control.add(comboColor);
        JComboBox<String> comboBorder = new JComboBox<String>(new String[]{"Border Auto", "On", "Off"});
        comboBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox b = (JComboBox)e.getSource();
                int which = b.getSelectedIndex();
                figure.SetBorderMode(which);
            }
        });
        control.add(comboBorder);
        JComboBox<String> comboGrid = new JComboBox<String>(new String[]{"Grid Auto", "On", "Off"});
        comboGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox b = (JComboBox)e.getSource();
                int which = b.getSelectedIndex();
                figure.SetGridMode(which);
            }
        });
        control.add(comboGrid);
        JComboBox<String> comboScale = new JComboBox<String>(new String[]{"1", "2", "4", "8", "16"});
        comboScale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox b = (JComboBox)e.getSource();
                int which = Integer.parseInt((String)b.getSelectedItem());
                figure.setScale(which);
            }
        });
        control.add(comboScale);
        f.getContentPane().add((Component)new JScrollPane(control), "North");
        f.setVisible(true);
        f.registerMemoryReporterTask();
        btn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser open = new JFileChooser();
                    open.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            String filename = file.getName();
                            return filename.endsWith(".geno");
                        }

                        public String getDescription() {
                            return "*.geno";
                        }
                    });
                    int res = open.showOpenDialog(f);
                    if (res != 0) {
                        return;
                    }
                    String genoPath = open.getSelectedFile().getCanonicalPath();
                    figure.OpenGenoFile(genoPath);
                }
                catch (Exception unknown) {
                    unknown.printStackTrace();
                }
            }
        });
    }

    private void registerMemoryReporterTask() {
        int delay = 5000;
        int period = 1000;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            DecimalFormat formatter = new DecimalFormat("0.00");
            final int WindowSize = 5;
            float[] usedWindow = new float[5];
            int nextWindow = -1;

            public void run() {
                float used;
                if (this.nextWindow == -1) {
                    Arrays.fill(this.usedWindow, 0.0f);
                    this.nextWindow = 0;
                }
                float delta = 0.0f;
                for (int i = 0; i < 5; ++i) {
                    delta += this.usedWindow[i];
                }
                delta /= 5.0f;
                this.usedWindow[this.nextWindow] = used = (float)((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000.0);
                delta = used - delta;
                String newTitle = Main.this.defaultTitle + " Used(" + this.formatter.format(used) + "M) ";
                if ((double)delta > 1.0E-4) {
                    newTitle = newTitle + this.formatter.format(delta) + "M";
                }
                Main.this.setTitle(newTitle);
                ++this.nextWindow;
                if (this.nextWindow >= 5) {
                    this.nextWindow = 0;
                }
            }
        }, delay, (long)period);
    }
}

