/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.drawrblk;

import com.istech21.snpanalyzer2free.drawrblk.tame.AttributiveCellTableModel;
import com.istech21.snpanalyzer2free.drawrblk.tame.CellSpan;
import com.istech21.snpanalyzer2free.drawrblk.tame.MultiSpanCellTable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BlockRelationView
extends JPanel {
    String genoName = null;
    MyJTable[] imgList = null;
    double v1 = 0.3;
    double v2 = 0.1;
    double v3 = 0.01;

    public void enableDrawCellBackground(boolean a) {
        for (int i = 0; i < this.imgList.length; ++i) {
            this.imgList[i].enableDrawCellBackground(a);
        }
        this.repaint();
    }

    public BlockRelationView(String _genoName) {
        this.setBackground(Color.white);
        this.genoName = _genoName;
        System.out.println("BlockRelationView::genoName=" + this.genoName);
        Box box = new Box(1);
        int w = 0;
        int h = 0;
        Block[] blkAll = this.readHBLK(this.genoName + ".ld.hblk");
        Hashtable<String, Block> hashBlkAll = new Hashtable<String, Block>();
        for (int i = 0; i < blkAll.length; ++i) {
            hashBlkAll.put(blkAll[i].sample_type + "." + blkAll[i].blkId, blkAll[i]);
        }
        System.out.println("## Blk size=" + blkAll.length);
        RBlock[] rBlkAll = this.readRBLK(this.genoName + ".ld.rblk");
        this.imgList = new MyJTable[rBlkAll.length];
        for (int i = 0; i < rBlkAll.length; ++i) {
            Block blkA = (Block)hashBlkAll.get(rBlkAll[i].sample_type + "." + rBlkAll[i].blk1_no);
            Block blkB = (Block)hashBlkAll.get(rBlkAll[i].sample_type + "." + rBlkAll[i].blk2_no);
            double[][] CRMatrix = rBlkAll[i].CRMatrix;
            String multi_dprime = rBlkAll[i].multi_dprime;
            MyJTable thisTable = this.populateTable(blkA, blkB, CRMatrix, multi_dprime);
            w = Math.max(w, (int)thisTable.getPreferredSize().getWidth());
            h = (int)((double)h + thisTable.getPreferredSize().getHeight());
            box.setAlignmentX(0.0f);
            box.add(thisTable);
            this.imgList[i] = thisTable;
        }
        System.out.println("## rBlk size=" + rBlkAll.length);
        if (blkAll.length * rBlkAll.length == 0) {
            this.setLayout(new BorderLayout());
            this.add(new JButton("No Block-Relationship found."));
            return;
        }
        box.setBackground(Color.yellow);
        this.add(new JScrollPane(box));
        Dimension d = new Dimension(w + 30, h + 30);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setSize(d);
    }

    public static void main(String[] args) {
        String pathGeno = "C:\\yblee\\snapshot\\native_engine_wait\\data\\sk3.geno.impu";
        pathGeno = "C:\\yblee\\snapshot2006winter\\engine\\gosnp\\test\\largetest\\genotype.1_1000.geno";
        if (args.length >= 1 && new File(args[0]).exists()) {
            pathGeno = args[0];
        }
        JFrame mainFrame = new JFrame();
        mainFrame.setSize(400, 400);
        mainFrame.setTitle("BlockRelationView");
        mainFrame.setDefaultCloseOperation(3);
        BlockRelationView app = new BlockRelationView(pathGeno);
        mainFrame.getContentPane().add(new JScrollPane(app));
        mainFrame.setVisible(true);
    }

    private Block pBlk1() {
        Block blk = new Block();
        blk.blkId = "Block1";
        blk.genotype = new String[]{"AGGT", "AGGG", "CTTT", "ATTG"};
        blk.majorAlleles = new String[]{"A", "G", "G", "T"};
        blk.alleleId = new String[]{"1", "2", "3", "4"};
        blk.isTag = new boolean[]{true, false, true, true};
        blk.freq = new String[]{"0.452", "0.277", "0.232", "0.046"};
        return blk;
    }

    private Block pBlk2() {
        Block blk = new Block();
        blk.blkId = "Block2";
        blk.genotype = new String[]{"CAG", "TAG", "CCT"};
        blk.majorAlleles = new String[]{"C", "A", "G"};
        blk.alleleId = new String[]{"6", "7", "8"};
        blk.isTag = new boolean[]{true, false, true};
        blk.freq = new String[]{"0.554", "0.372", "0.174"};
        return blk;
    }

    private double[][] pRel() {
        return new double[][]{{this.v1, this.v2, this.v3}, {this.v3, this.v3, this.v1}, {this.v2, this.v3, this.v3}, {this.v3, this.v1, this.v3}};
    }

    private String[][] pAll(Block b1, Block b2, String dprime) {
        int i;
        String[][] res = new String[7 + Math.max(b1.genotype.length, b2.genotype.length)][7 + b1.majorAlleles.length + b2.majorAlleles.length];
        for (i = 0; i < res.length; ++i) {
            for (int k = 0; k < res[i].length; ++k) {
                res[i][k] = "";
            }
        }
        res[0][0] = "Sample Type: " + b1.sample_type;
        res[2][2 + b1.majorAlleles.length] = "D'=" + dprime;
        res[2][1] = "Block " + b1.blkId;
        for (i = 0; i < b1.majorAlleles.length; ++i) {
            res[4][1 + i] = b1.alleleId[i];
        }
        for (int k = 0; k < b1.genotype.length; ++k) {
            for (int i2 = 0; i2 < b1.majorAlleles.length; ++i2) {
                res[6 + k][1 + i2] = b1.genotype[k].substring(i2, i2 + 1);
            }
            res[6 + k][1 + b1.majorAlleles.length + 0] = ":";
            res[6 + k][1 + b1.majorAlleles.length + 1] = b1.freq[k];
        }
        int dprimebase = 4 + b1.majorAlleles.length - 1;
        res[3][dprimebase] = "D'=" + dprime;
        int rbase = 4 + b1.majorAlleles.length;
        res[2][rbase] = "Block " + b2.blkId;
        for (int i3 = 0; i3 < b2.majorAlleles.length; ++i3) {
            res[4][rbase + i3] = b2.alleleId[i3];
        }
        for (int k = 0; k < b2.genotype.length; ++k) {
            for (int i4 = 0; i4 < b2.majorAlleles.length; ++i4) {
                res[6 + k][i4 + rbase] = b2.genotype[k].substring(i4, i4 + 1);
            }
            res[6 + k][b2.majorAlleles.length + 0 + rbase] = ":";
            res[6 + k][b2.majorAlleles.length + 1 + rbase] = b2.freq[k];
        }
        return res;
    }

    public MyJTable populateTable(Block b1, Block b2, double[][] rel, String dprime) {
        int k;
        int i;
        Object[][] cellData = null;
        Object[] columnNames = null;
        cellData = this.pAll(b1, b2, dprime);
        columnNames = new String[cellData[0].length];
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            columnNames[i2] = "L" + i2;
        }
        AttributiveCellTableModel ml = new AttributiveCellTableModel(cellData, columnNames);
        CellSpan cellAtt = (CellSpan)((Object)ml.getCellAttribute());
        MyJTable table = new MyJTable(ml);
        int[] cols = this.closedInterval(0, columnNames.length - 1);
        this.merge(table, cellAtt, new int[]{0}, cols);
        this.merge(table, cellAtt, new int[]{2}, this.closedInterval(1, 1 + b1.majorAlleles.length - 1 + 2));
        int rbase = 1 + b1.majorAlleles.length - 1 + 2 + 2;
        this.merge(table, cellAtt, new int[]{2}, this.closedInterval(rbase, rbase + b2.majorAlleles.length - 1 + 2));
        table.setAutoResizeMode(0);
        this.setColumnWidth(table, 0, 10);
        for (i = 0; i < b1.majorAlleles.length; ++i) {
            this.setColumnWidth(table, 1 + i, 18);
        }
        this.setColumnWidth(table, 1 + b1.majorAlleles.length, 10);
        this.setColumnWidth(table, 2 + b1.majorAlleles.length, 60);
        this.setColumnWidth(table, 3 + b1.majorAlleles.length, 70);
        for (i = 0; i < b2.majorAlleles.length; ++i) {
            this.setColumnWidth(table, rbase + i, 18);
        }
        this.setColumnWidth(table, rbase + 0 + b2.majorAlleles.length, 10);
        this.setColumnWidth(table, rbase + 1 + b2.majorAlleles.length, 60);
        this.setColumnWidth(table, rbase + 2 + b2.majorAlleles.length, 10);
        table.setTableHeader(null);
        table.setGridColor(Color.white);
        table.setCellBgColor(2, 1, Color.cyan);
        for (i = 0; i < b1.isTag.length; ++i) {
            if (!b1.isTag[i]) continue;
            table.setCellBgColor(4, 1 + i, Color.green);
        }
        for (i = 0; i < b1.genotype.length; ++i) {
            for (k = 0; k < b1.majorAlleles.length; ++k) {
                if (b1.majorAlleles[k].equalsIgnoreCase(b1.genotype[i].substring(k, k + 1))) {
                    table.setCellBgColor(6 + i, 1 + k, Color.magenta);
                    continue;
                }
                table.setCellBgColor(6 + i, 1 + k, Color.orange);
            }
        }
        table.setCellBgColor(2, 0 + rbase, Color.cyan);
        for (i = 0; i < b2.isTag.length; ++i) {
            if (!b2.isTag[i]) continue;
            table.setCellBgColor(4, rbase + i, Color.green);
        }
        for (i = 0; i < b2.genotype.length; ++i) {
            for (k = 0; k < b2.majorAlleles.length; ++k) {
                if (b2.majorAlleles[k].equalsIgnoreCase(b2.genotype[i].substring(k, k + 1))) {
                    table.setCellBgColor(6 + i, rbase + k, Color.magenta);
                    continue;
                }
                table.setCellBgColor(6 + i, rbase + k, Color.orange);
            }
        }
        table.setCellBgColor(0, 0, Color.LIGHT_GRAY);
        Dimension d = table.getPreferredSize();
        table.setPreferredSize(d);
        table.setMaximumSize(d);
        table.setSize(d);
        table.setPreferredScrollableViewportSize(d);
        table.setLineRelationColumn(rbase - 1);
        Vector<int[]> tmp = new Vector<int[]>();
        Vector<int[]> tmp2 = new Vector<int[]>();
        for (int i3 = 0; i3 < rel.length; ++i3) {
            for (int k2 = 0; k2 < rel[i3].length; ++k2) {
                if (rel[i3][k2] >= this.v1) {
                    tmp.add(new int[]{6 + i3, 6 + k2});
                    continue;
                }
                if (!(rel[i3][k2] >= this.v2)) continue;
                tmp2.add(new int[]{6 + i3, 6 + k2});
            }
        }
        int[][] boldRelations = new int[tmp.size()][];
        tmp.toArray((T[])boldRelations);
        table.setBordLineRelationList(boldRelations);
        int[][] normalRelations = new int[tmp2.size()][];
        tmp2.toArray((T[])normalRelations);
        table.setNormalLineRelationList(normalRelations);
        return table;
    }

    private void setColumnWidth(JTable table, int vColIndex, int width) {
        TableColumn col = table.getColumnModel().getColumn(vColIndex);
        col.setPreferredWidth(width);
    }

    private int[] closedInterval(int from, int to) {
        int[] res = new int[to - from + 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = from + i;
        }
        return res;
    }

    private void merge(MultiSpanCellTable table, CellSpan cellAtt, int[] rows, int[] cols) {
        cellAtt.combine(rows, cols);
        table.clearSelection();
        table.revalidate();
        table.repaint();
    }

    public Block[] readHBLK(String fname) {
        try {
            String line;
            Vector<Block> vres = new Vector<Block>();
            BufferedReader r = new BufferedReader(new FileReader(fname));
            String sample_type = null;
            String block_no = null;
            String[] snp_id = null;
            String[] snp_list = null;
            boolean[] tag_snp = null;
            String[] majorAllele = null;
            String[] minorAllele = null;
            Vector<String> tmpHaplotypes = null;
            Vector<String> tmpFrequency = null;
            boolean isInHaplotypeBlock = false;
            int total_snp_count = 0;
            int sample_count = 0;
            long[] location = null;
            while ((line = r.readLine()) != null) {
                String[] tok;
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') {
                    tok = line.split(":");
                    if (tok.length != 2) continue;
                    if ("!Sample_Type".equalsIgnoreCase(tok[0])) {
                        sample_type = tok[1];
                        continue;
                    }
                    if ("!Block_No".equalsIgnoreCase(tok[0])) {
                        block_no = tok[1];
                        continue;
                    }
                    if ("!Total_SNP_Count".equalsIgnoreCase(tok[0])) {
                        total_snp_count = Integer.parseInt(tok[1]);
                        continue;
                    }
                    if (!"!Sample_Count".equalsIgnoreCase(tok[0])) continue;
                    sample_count = Integer.parseInt(tok[1]);
                    continue;
                }
                tok = line.split("\t");
                if (tok[0].equalsIgnoreCase("SNP_List")) {
                    int i;
                    Vector<String> vsnp_list = new Vector<String>();
                    for (i = 0; i < total_snp_count; ++i) {
                        vsnp_list.add(tok[i + 1]);
                    }
                    snp_list = new String[total_snp_count];
                    for (i = 0; i < total_snp_count; ++i) {
                        snp_list[i] = (String)vsnp_list.get(i);
                    }
                    vsnp_list.clear();
                    vsnp_list = null;
                    continue;
                }
                if (tok[0].equalsIgnoreCase("SNP_ID")) {
                    Vector<String> vsnp_id = new Vector<String>();
                    for (int i = 0; i < total_snp_count; ++i) {
                        vsnp_id.add(tok[i + 1]);
                    }
                    snp_id = new String[total_snp_count];
                    vsnp_id.toArray(snp_id);
                    continue;
                }
                if (tok[0].equalsIgnoreCase("Tag_SNP")) {
                    int i;
                    tag_snp = new boolean[total_snp_count];
                    for (i = 1; i < total_snp_count; ++i) {
                        tag_snp[i] = tok[i].equalsIgnoreCase("Y");
                    }
                    for (i = 0; i < sample_count; ++i) {
                        String this_sample_type = tok[total_snp_count + 2 + i];
                    }
                    continue;
                }
                if (tok[0].equalsIgnoreCase("Allele")) {
                    int i;
                    majorAllele = new String[total_snp_count];
                    minorAllele = new String[total_snp_count];
                    for (i = 0; i < total_snp_count; ++i) {
                        majorAllele[i] = tok[i + 1].substring(0, 1);
                        minorAllele[i] = tok[i + 1].substring(tok[i + 1].length() - 1, tok[i + 1].length());
                    }
                    isInHaplotypeBlock = true;
                    tmpHaplotypes = new Vector<String>();
                    tmpFrequency = new Vector<String>();
                    for (i = 0; i < sample_count; ++i) {
                        String this_sample_id = tok[total_snp_count + 2 + i];
                    }
                    continue;
                }
                if (tok[0].equalsIgnoreCase("Location")) {
                    int i;
                    location = new long[total_snp_count];
                    for (i = 0; i < total_snp_count; ++i) {
                        location[i] = Long.parseLong(tok[i + 1]);
                    }
                    for (i = 0; i < sample_count; ++i) {
                        String this_sample_accuracy = tok[total_snp_count + 2 + i];
                    }
                    isInHaplotypeBlock = false;
                    Block newBlock = new Block();
                    newBlock.blkId = block_no;
                    newBlock.alleleId = snp_list;
                    String[] freq = new String[tmpFrequency.size()];
                    tmpFrequency.toArray(freq);
                    newBlock.freq = freq;
                    String[] hap = new String[tmpHaplotypes.size()];
                    tmpHaplotypes.toArray(hap);
                    newBlock.genotype = hap;
                    newBlock.isTag = tag_snp;
                    newBlock.majorAlleles = majorAllele;
                    newBlock.sample_type = sample_type;
                    vres.add(newBlock);
                    continue;
                }
                if (!isInHaplotypeBlock) continue;
                StringBuffer this_haplotype = new StringBuffer();
                for (int i = 0; i < total_snp_count; ++i) {
                    this_haplotype.append(tok[i + 1]);
                }
                String this_haplotype_frequency = tok[total_snp_count + 1];
                String this_haplotype_id = tok[0];
                for (int i = 0; i < sample_count; ++i) {
                    String this_sample_haplotype_asso = tok[total_snp_count + 2 + i];
                }
                tmpHaplotypes.add(this_haplotype.toString());
                tmpFrequency.add(this_haplotype_frequency);
            }
            r.close();
            Block[] res = new Block[vres.size()];
            vres.toArray(res);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Block[0];
        }
    }

    public RBlock[] readRBLK(String fname) {
        try {
            String line;
            Vector<RBlock> vres = new Vector<RBlock>();
            BufferedReader r = new BufferedReader(new FileReader(fname));
            String sample_type = null;
            String block_no = null;
            String multi_dprime = null;
            int nHap1 = 0;
            int nHap2 = 0;
            double[][] CRMatrix = null;
            while ((line = r.readLine()) != null) {
                String[] tok2;
                if (line.length() == 0) continue;
                if (line.charAt(0) == '!') {
                    String[] tok = line.split(":");
                    if (tok.length != 2) continue;
                    if ("!Sample_Type".equalsIgnoreCase(tok[0])) {
                        sample_type = tok[1];
                        continue;
                    }
                    if ("!Block_No".equalsIgnoreCase(tok[0])) {
                        block_no = tok[1];
                        continue;
                    }
                    if ("!Multi_Dprime".equalsIgnoreCase(tok[0])) {
                        multi_dprime = tok[1];
                        continue;
                    }
                    if (!"!Haplotype_Count".equalsIgnoreCase(tok[0])) continue;
                    tok2 = tok[1].split(",");
                    nHap1 = Integer.parseInt(tok2[0]);
                    nHap2 = Integer.parseInt(tok2[1]);
                    CRMatrix = new double[nHap1][nHap2];
                    continue;
                }
                if (line.toUpperCase().startsWith("NO")) {
                    for (int i = 0; i < nHap1; ++i) {
                        for (int k = 0; k < nHap2; ++k) {
                            line = r.readLine();
                            String[] tok = line.split("\t");
                            CRMatrix[i][k] = Double.parseDouble(tok[3]);
                        }
                    }
                    RBlock newBlock = new RBlock();
                    tok2 = block_no.split(",");
                    newBlock.blk1_no = tok2[0];
                    newBlock.blk2_no = tok2[1];
                    newBlock.CRMatrix = CRMatrix;
                    newBlock.sample_type = sample_type;
                    newBlock.multi_dprime = multi_dprime;
                    vres.add(newBlock);
                    continue;
                }
                System.out.println("Ignore extra line:" + line);
            }
            r.close();
            RBlock[] res = new RBlock[vres.size()];
            vres.toArray(res);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RBlock[0];
        }
    }

    static class RBlock {
        String sample_type = null;
        String blk1_no = null;
        String blk2_no = null;
        double[][] CRMatrix = null;
        String multi_dprime = null;

        RBlock() {
        }
    }

    private static class MyJTable
    extends MultiSpanCellTable {
        private int lineColumn = 7;
        int[][] boldLineRelation = null;
        int[][] normalLineRelation = null;
        BasicStroke stroke_bold = new BasicStroke(2.0f);
        BasicStroke stroke_normal = new BasicStroke(0.7f);
        public Hashtable colored = new Hashtable();
        private boolean bDrawCellBackground = true;

        public MyJTable(AttributiveCellTableModel ml) {
            super(ml);
        }

        public void paintComponent(Graphics g) {
            int i;
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getForeground());
            g2.setColor(Color.GRAY);
            g2.setStroke(this.stroke_bold);
            if (this.boldLineRelation != null) {
                for (i = 0; i < this.boldLineRelation.length; ++i) {
                    this.drawLine(g2, this.boldLineRelation[i][0], this.boldLineRelation[i][1]);
                }
            }
            g2.setStroke(this.stroke_normal);
            if (this.normalLineRelation != null) {
                for (i = 0; i < this.normalLineRelation.length; ++i) {
                    this.drawLine(g2, this.normalLineRelation[i][0], this.normalLineRelation[i][1]);
                }
            }
        }

        public void setLineRelationColumn(int c) {
            this.lineColumn = c;
        }

        public void setBordLineRelationList(int[][] b) {
            this.boldLineRelation = b;
        }

        public void setNormalLineRelationList(int[][] b) {
            this.normalLineRelation = b;
        }

        public void drawLine(Graphics g, int fromRow, int toRow) {
            Rectangle r1 = this.getCellRect(fromRow, this.lineColumn - 1, true);
            Rectangle r2 = this.getCellRect(toRow, this.lineColumn + 1, true);
            g.drawLine(r1.x + r1.width, r1.y + r1.height / 2, r2.x - 4, r2.y + r2.height / 2);
        }

        private Color getCellBgColor(int r, int c, Color def) {
            String idx = "" + r + "_" + c;
            if (this.colored.containsKey(idx)) {
                return (Color)this.colored.get(idx);
            }
            return def;
        }

        private void setCellBgColor(int r, int c, Color col) {
            String idx = "" + r + "_" + c;
            this.colored.put(idx, col);
        }

        public void enableDrawCellBackground(boolean a) {
            this.bDrawCellBackground = a;
        }

        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (c instanceof JLabel) {
                ((JLabel)c).setBorder(null);
            }
            boolean selected = this.isCellSelected(rowIndex, vColIndex);
            if (this.bDrawCellBackground) {
                Color cbg = this.getCellBgColor(rowIndex, vColIndex, this.getBackground());
                c.setBackground(cbg);
                c.setForeground(this.getForeground());
            }
            if (selected) {
                Color fg = c.getForeground();
                Color bg = c.getBackground();
                if (bg.equals(Color.white)) {
                    bg = Color.yellow;
                }
                c.setForeground(fg);
                c.setBackground(bg);
            }
            return c;
        }
    }

    public static class Block {
        String sample_type;
        String blkId;
        String[] genotype;
        String[] alleleId;
        boolean[] isTag;
        String[] majorAlleles;
        String[] freq;
    }
}

