/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.tdf;

import com.istech21.snpanalyzer2free.tdf.ThinnerRaisedBevelBorder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class FixedColumnScrollPane
extends JScrollPane {
    public FixedColumnScrollPane(JTable main, int fixedColumns) {
        super(main);
        JTable fixed = new JTable(main.getModel()){
            JLabel labelInstance;
            Color defaultBgColor;
            Color defaultFgColor;
            {
                this.labelInstance = null;
                this.defaultBgColor = null;
                this.defaultFgColor = null;
            }

            private JLabel getJLabelInstance() {
                if (this.labelInstance != null) {
                    return this.labelInstance;
                }
                this.labelInstance = new JLabel();
                this.labelInstance.setOpaque(true);
                this.labelInstance.setBorder(new ThinnerRaisedBevelBorder(0, 1));
                this.defaultBgColor = this.labelInstance.getBackground();
                this.defaultFgColor = this.labelInstance.getForeground();
                return this.labelInstance;
            }

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                JLabel label = this.getJLabelInstance();
                label.setText(this.getValueAt(rowIndex, vColIndex).toString());
                boolean bSelected = this.isRowSelected(rowIndex);
                if (bSelected) {
                    Component c = super.prepareRenderer(renderer, rowIndex, 0);
                    label.setBackground(c.getBackground());
                    label.setForeground(c.getForeground());
                } else {
                    label.setBackground(this.defaultBgColor);
                    label.setForeground(this.defaultFgColor);
                }
                return label;
            }

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
            }
        };
        fixed.setFocusable(true);
        fixed.setCellSelectionEnabled(true);
        fixed.setSelectionModel(main.getSelectionModel());
        fixed.getTableHeader().setReorderingAllowed(false);
        fixed.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        main.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        for (int i = 0; i < fixedColumns; ++i) {
            TableColumnModel columnModel = main.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        while (fixed.getColumnCount() > fixedColumns) {
            TableColumnModel columnModel = fixed.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(fixedColumns));
        }
        fixed.setPreferredScrollableViewportSize(fixed.getPreferredSize());
        if (fixedColumns > 1) {
            fixed.getColumnModel().getColumn(0).setWidth(50);
            fixed.getColumnModel().getColumn(0).setPreferredWidth(50);
            fixed.getColumnModel().getColumn(0).setMaxWidth(50);
        }
        this.setRowHeaderView(fixed);
        this.setCorner("UPPER_LEFT_CORNER", fixed.getTableHeader());
    }

    public static void main(String[] args) {
        JTable table = new JTable(10, 8);
        table.setAutoResizeMode(0);
        FixedColumnScrollPane scrollPane = new FixedColumnScrollPane(table, 1);
        JFrame frame = new JFrame("Table Fixed Column Demo");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(scrollPane);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }
}

