/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.tdf;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableModel;

public class MenuPaneHyperlinkListener
implements HyperlinkListener {
    private static MenuPaneHyperlinkListener instance = null;

    private MenuPaneHyperlinkListener() {
    }

    public static MenuPaneHyperlinkListener getInstance() {
        if (instance == null) {
            instance = new MenuPaneHyperlinkListener();
        }
        return instance;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            this.navigateTo(url.toString());
        }
    }

    public boolean navigateTo(String url) {
        try {
            Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + url + "\"");
            return true;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    public static class MyHyperlinkJTable
    extends JTable {
        public MyHyperlinkJTable(TableModel model) {
            super(model);
            this.setCellSelectionEnabled(true);
            this.registerHyperlinkListener();
            this.setSelectionBackground(Color.LIGHT_GRAY);
            this.setSelectionForeground(Color.black);
        }

        public boolean isCellEditable(int r, int c) {
            return false;
        }

        private void navigateTo(String url) {
            MenuPaneHyperlinkListener.getInstance().navigateTo(url);
        }

        protected static String getTextFromHMTL(String html) {
            if (html == null) {
                return null;
            }
            int start = html.indexOf("href=");
            if (start < 0) {
                return null;
            }
            int end = html.indexOf(">", start += 5);
            if (end < 0) {
                return null;
            }
            String url = html.substring(start, end);
            if (url.charAt(0) == '\'' || url.charAt(0) == '\"') {
                url = url.substring(1);
            }
            if (url.charAt(url.length() - 1) == '\'' || url.charAt(url.length() - 1) == '\"') {
                url = url.substring(0, url.length() - 1);
            }
            return url;
        }

        private void registerHyperlinkListener() {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JTable table = (JTable)e.getComponent();
                    int col = table.columnAtPoint(e.getPoint());
                    int row = table.rowAtPoint(e.getPoint());
                    String value = table.getValueAt(row, col).toString();
                    final String url = MyHyperlinkJTable.getTextFromHMTL(value);
                    if (url == null) {
                        return;
                    }
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("open hyperlink");
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            MyHyperlinkJTable.this.navigateTo(url);
                        }
                    });
                    menu.add(item);
                    menu.show((Component)e.getSource(), e.getX(), e.getY());
                }
            });
        }
    }
}

