/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.tdf;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TableSearchService {
    private JTable table = null;
    Container evtParent = null;
    private Point found = new Point();
    private JTextField text = null;
    private JButton btnSearch = null;
    private JButton btnNext = null;

    public TableSearchService(Container evtParent, JTable table) {
        this.evtParent = evtParent;
        this.table = table;
    }

    protected void finalize() throws Throwable {
        this.disconnectData();
        super.finalize();
        System.out.println("TableSearchService.finalize()");
    }

    public void disconnectData() {
        this.evtParent = null;
        this.table = null;
    }

    public JTextField getSearchTextField() {
        if (this.text == null) {
            this.text = new JTextField();
            this.text.setColumns(10);
        }
        return this.text;
    }

    public JButton getSearchButton() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton("Search");
            this.btnSearch.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String key = TableSearchService.this.getSearchTextField().getText();
                    if (key.length() == 0) {
                        return;
                    }
                    int[] loc = TableSearchService.this.Run_Search(key);
                    if (loc == null) {
                        ((TableSearchService)TableSearchService.this).found.x = 0;
                        ((TableSearchService)TableSearchService.this).found.y = 0;
                    } else {
                        ((TableSearchService)TableSearchService.this).found.x = loc[0];
                        ((TableSearchService)TableSearchService.this).found.y = loc[1];
                    }
                }
            });
        }
        return this.btnSearch;
    }

    public JButton getNextButton() {
        if (this.btnNext == null) {
            this.btnNext = new JButton("Next");
            this.btnNext.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String key = TableSearchService.this.getSearchTextField().getText();
                    if (key.length() == 0) {
                        return;
                    }
                    int[] loc = TableSearchService.this.Run_Search(key, ((TableSearchService)TableSearchService.this).found.x, ((TableSearchService)TableSearchService.this).found.y);
                    if (loc == null) {
                        ((TableSearchService)TableSearchService.this).found.x = 0;
                        ((TableSearchService)TableSearchService.this).found.y = 0;
                    } else {
                        ((TableSearchService)TableSearchService.this).found.x = loc[0];
                        ((TableSearchService)TableSearchService.this).found.y = loc[1];
                    }
                }
            });
        }
        return this.btnNext;
    }

    private int[] Run_Search(String key) {
        return this.Run_Search(key, -1, -1);
    }

    private int[] Run_Search(String key, int searchStartRow, int searchStartCol) {
        try {
            this.table.setColumnSelectionAllowed(true);
            this.table.setRowSelectionAllowed(true);
            int nR = this.table.getRowCount();
            int nC = this.table.getColumnCount();
            int foundR = -1;
            int foundC = -1;
            for (int i = 0; i < nR; ++i) {
                for (int k = 0; k < nC; ++k) {
                    Object value;
                    if (i < searchStartRow || i == searchStartRow && k < searchStartCol || (value = this.table.getValueAt(i, k)) == null || ((String)value).length() == 0 || ((String)value).indexOf(key) < 0) continue;
                    foundR = i;
                    foundC = k;
                    break;
                }
                if (foundR >= 0 && foundC >= 0) break;
            }
            if (foundR >= 0 && foundC >= 0) {
                searchStartRow = foundR;
                searchStartCol = foundC;
                if (searchStartCol == nC - 1) {
                    searchStartCol = 0;
                }
                final Rectangle rect = this.table.getCellRect(foundR, foundC, true);
                final Point found = new Point(foundR, foundC);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TableSearchService.this.table.scrollRectToVisible(rect);
                        int row = found.x;
                        int col = found.y;
                        boolean toggle = false;
                        boolean extend = false;
                        TableSearchService.this.table.changeSelection(row, col, toggle, extend);
                    }
                });
                return new int[]{++searchStartRow, ++searchStartCol};
            }
            JOptionPane.showMessageDialog(this.evtParent, "Not found :" + key);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.evtParent, "Error :" + e.toString());
            return null;
        }
    }
}

