/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.tdf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ThinnerRaisedBevelBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected int bevelWidth;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;

    public ThinnerRaisedBevelBorder(int bevelType, int bevelWidth) {
        this.bevelWidth = bevelWidth;
        this.bevelType = bevelType;
    }

    public ThinnerRaisedBevelBorder(int bevelType) {
        this(bevelType, 2);
    }

    public ThinnerRaisedBevelBorder(int bevelType, int bevelWidth, Color highlight, Color shadow) {
        this(bevelType, bevelWidth, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public ThinnerRaisedBevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, 2, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public ThinnerRaisedBevelBorder(int bevelType, int bevelWidth, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType, bevelWidth);
        this.highlightOuter = highlightOuterColor;
        this.highlightInner = highlightInnerColor;
        this.shadowOuter = shadowOuterColor;
        this.shadowInner = shadowInnerColor;
    }

    public ThinnerRaisedBevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType, 2, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBevel(this.bevelType, c, g, x, y, width, height);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.bevelWidth, this.bevelWidth, this.bevelWidth, this.bevelWidth);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.bevelWidth;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getHighlightOuterColor(Component c) {
        Color highlight = this.getHighlightOuterColor();
        return highlight != null ? highlight : c.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component c) {
        Color highlight = this.getHighlightInnerColor();
        return highlight != null ? highlight : c.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component c) {
        Color shadow = this.getShadowInnerColor();
        return shadow != null ? shadow : c.getBackground().darker();
    }

    public Color getShadowOuterColor(Component c) {
        Color shadow = this.getShadowOuterColor();
        return shadow != null ? shadow : c.getBackground().darker().darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public int getBevelWidth() {
        return this.bevelWidth;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintBevel(int bevelType, Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(bevelType == 0 ? this.getHighlightOuterColor(c) : this.getShadowInnerColor(c));
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        if (this.bevelWidth > 1) {
            for (i = 1; i < this.bevelWidth - 1; ++i) {
                g.drawLine(i, i, i, h - i);
                g.drawLine(i + 1, i, w - i, i);
            }
            g.setColor(bevelType == 0 ? this.getHighlightInnerColor(c) : this.getShadowOuterColor(c));
            g.drawLine(this.bevelWidth - 1, this.bevelWidth - 1, this.bevelWidth - 1, h - this.bevelWidth);
            g.drawLine(this.bevelWidth - 1, this.bevelWidth - 1, w - this.bevelWidth, this.bevelWidth - 1);
        }
        g.setColor(bevelType == 0 ? this.getShadowOuterColor(c) : this.getHighlightOuterColor(c));
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        if (this.bevelWidth > 1) {
            for (i = 1; i < this.bevelWidth - 1; ++i) {
                g.drawLine(w - 1 - i, i + 1, w - 1 - i, h - 1 - i);
                g.drawLine(i + 1, h - 1 - i, w - 2 - i, h - 1 - i);
            }
            g.setColor(bevelType == 0 ? this.getShadowInnerColor(c) : this.getHighlightInnerColor(c));
            g.drawLine(this.bevelWidth, h - this.bevelWidth, w - this.bevelWidth, h - this.bevelWidth);
            g.drawLine(w - this.bevelWidth, this.bevelWidth, w - this.bevelWidth, h - this.bevelWidth);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

