/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.snpanalyzer2free.tdf;

import com.istech21.snpanalyzer2free.Snpanalyzer2;
import com.istech21.snpanalyzer2free.tdf.FixedColumnScrollPane;
import com.istech21.snpanalyzer2free.tdf.MenuPaneHyperlinkListener;
import com.istech21.snpanalyzer2free.tdf.TableSearchService;
import com.istech21.widget.indexer.IndexedReadonlyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;

public class ViewTDF
extends JPanel {
    IndexedReadonlyTableModel model = null;
    JTable table = null;
    JPanel ctrl = null;
    private String filePath = null;
    int fileExtType = 0;

    public IndexedReadonlyTableModel getModel() {
        return this.model;
    }

    public JTable getTable() {
        return this.table;
    }

    public JPanel getCtrlPanel() {
        return this.ctrl;
    }

    public void CancelIndexing() {
        if (this.model.isComplete()) {
            return;
        }
        this.model.InterruptIndexingThread();
    }

    public ViewTDF(String fpath) {
        this(fpath, true);
    }

    public ViewTDF(String fpath, boolean enableHTML) {
        super(new BorderLayout());
        this.filePath = fpath;
        this.model = new IndexedReadonlyTableModel(fpath);
        this.table = new MenuPaneHyperlinkListener.MyHyperlinkJTable(this.model);
        this.table.setAutoResizeMode(0);
        int fixWhich = 1;
        if (fpath.endsWith(".geno")) {
            fixWhich = 2;
        }
        if (fpath.endsWith(".geno.src")) {
            fixWhich = 2;
        }
        this.add((Component)new FixedColumnScrollPane(this.table, fixWhich), "Center");
        this.ctrl = new JPanel(new FlowLayout(2));
        this.add((Component)new JScrollPane(this.ctrl), "North");
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTDF.this.getParent().remove(ViewTDF.this);
            }
        });
        JButton btnSaveAs = new JButton("Save");
        btnSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTDF.this.saveAs();
            }
        });
        this.ctrl.add(btnSaveAs);
        final JProgressBar progrss = new JProgressBar(0, 100);
        final JButton btnCancel = new JButton("Cancel Loading");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTDF.this.CancelIndexing();
                ViewTDF.this.ctrl.remove(btnCancel);
                ViewTDF.this.ctrl.remove(progrss);
                ViewTDF.this.ctrl.updateUI();
            }
        });
        if (!this.model.isComplete()) {
            this.ctrl.add(btnCancel);
            this.ctrl.add(progrss);
            final long fsize = new File(fpath).length();
            this.model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    int type = e.getType();
                    if (ViewTDF.this.model.isComplete()) {
                        ViewTDF.this.ctrl.remove(btnCancel);
                        ViewTDF.this.ctrl.remove(progrss);
                        ViewTDF.this.ctrl.updateUI();
                    } else {
                        int percentage = (int)(100L * ViewTDF.this.model.getNumRead() / fsize);
                        progrss.setValue(percentage);
                    }
                }
            });
        }
        TableSearchService search = new TableSearchService(this, this.table);
        JTextField text = search.getSearchTextField();
        JButton btnSearch = search.getSearchButton();
        JButton btnNext = search.getNextButton();
        this.ctrl.add(text);
        this.ctrl.add(btnSearch);
        this.ctrl.add(btnNext);
    }

    private void saveAs() {
        final String ext = this.filePath.substring(this.filePath.lastIndexOf("."));
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                ViewTDF.this.fileExtType = 1;
                String filename = file.getName();
                return filename.endsWith(".txt");
            }

            public String getDescription() {
                return "*.txt";
            }
        });
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                ViewTDF.this.fileExtType = 0;
                String filename = file.getName();
                return filename.endsWith(ext);
            }

            public String getDescription() {
                return "*" + ext;
            }
        });
        int res = fc.showSaveDialog(SwingUtilities.getWindowAncestor(this));
        if (res != 0) {
            return;
        }
        try {
            String newExt;
            String newFile = fc.getSelectedFile().getCanonicalPath();
            String string = newExt = this.fileExtType == 0 ? ext : ".txt";
            if (!newFile.endsWith(newExt)) {
                newFile = newFile + newExt;
            }
            Snpanalyzer2.CopyFile(this.filePath, newFile);
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), "File Saved as " + newFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), "Cannot Save : " + e.toString());
        }
    }

    public static void main(String[] args) {
        ViewTDF.MakeReadonlyWindow("H:/22.anno", null);
    }

    public static void MakeReadonlyWindow(String fpath, Component parent) {
        final long fsize = new File(fpath).length();
        final ViewTDF view = new ViewTDF(fpath);
        view.table.setCellSelectionEnabled(true);
        Frame parentFrame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        final JDialog f = new JDialog(parentFrame);
        f.setDefaultCloseOperation(2);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                view.CancelIndexing();
                view.model.close();
                view.removeAll();
                f.removeAll();
            }
        });
        f.setContentPane(view);
        Dimension dm = new Dimension(600, 400);
        f.setPreferredSize(dm);
        f.setSize(dm);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        final String fname = new File(fpath).getName();
        if (view.model.isComplete()) {
            f.setTitle(fname + " " + view.model.getRowCount() + "  Lines X " + view.model.getColumnCount() + " Columns");
        } else {
            view.model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    int type = e.getType();
                    if (view.model.isComplete()) {
                        f.setTitle(fname + " " + view.model.getRowCount() + "  Lines X " + view.model.getColumnCount() + " Columns");
                    } else {
                        f.setTitle("Loading " + fname + " " + view.model.getRowCount() + "  Lines (" + 100L * view.model.getNumRead() / fsize + "%)");
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                f.requestFocus();
            }
        });
    }
}

