/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.chart;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JPanel;

public class Chart
extends JPanel {
    private static final String TEMP_STR_FOR_HEIGHT = "MM";
    private static final String TEMP_STR_FOR_WIDTH = "8.888";
    private static final String TEMP_STR_MIN_X_RULE = "M";
    private static final String TEMP_STR_MIN_Y_RULE = "MMMMMMMMMMMM";
    protected static final int DEFAULT_X_INDEX = 0;
    protected static final int DEFAULT_X_NUM = 20;
    public static final int LINE = 124;
    private static final long serialVersionUID = 342623462346L;
    protected double xAxisLen;
    protected double yAxisLen;
    protected double xOrigin;
    protected double yOrigin;
    protected double maxY;
    protected double minY;
    protected double leftMargin;
    protected double rightMargin;
    protected double upMargin;
    protected double bottomMargin;
    protected double[] yValues;
    protected double lastY;
    protected double lastYDot;
    protected double height_temp_str;
    protected double width_big_x_rule;
    protected double baseLineValue;
    protected double userMinY = 0.0;
    protected double userMaxY = 1.0;
    protected int panelHeight;
    protected int panelWidth;
    protected int numToShow;
    protected int xValueFirstIndex;
    protected int debugLine;
    protected int min_x_rule_len;
    protected String title = "No title";
    protected String[] xValues;
    protected String yTitle = "No Y title";
    protected String xTitle = "No X title";
    DecimalFormat formatter = new DecimalFormat("#.###");
    Vector etc = new Vector();
    protected boolean isShowAll = false;
    protected boolean isUpSpecial = true;
    protected int smallArraySize;
    private Vector toolTipVector;
    ToolTipInterface toolTiper = null;
    private double slop = 15.0;
    int xBaseIndex = Integer.MAX_VALUE;

    public Chart(String[] xValues, double[] yValues) {
        this(xValues, yValues, 0, 20);
    }

    public Chart(String[] xValues, double[] yValues, int xValueFirstIndex) {
        this(xValues, yValues, xValueFirstIndex, 20);
    }

    public Chart(String[] xValues, double[] yValues, int xValueFirstIndex, int numToShow) {
        this.initialize(xValues, yValues, xValueFirstIndex, numToShow);
    }

    protected void initialize(String[] xValues, double[] yValues, int xValueFirstIndex, int numToShow) {
        this.xValues = xValues;
        this.yValues = yValues;
        int n = this.smallArraySize = xValues.length < yValues.length ? xValues.length : yValues.length;
        this.xValueFirstIndex = xValueFirstIndex < 0 ? 0 : (xValueFirstIndex < this.smallArraySize ? xValueFirstIndex : 0);
        this.numToShow = this.xValueFirstIndex + numToShow > this.smallArraySize ? this.smallArraySize - this.xValueFirstIndex : numToShow;
        this.setMaxYMinY(this.smallArraySize);
        this.setBackground(new Color(255, 255, 255));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                Chart.this.processMouseMotion(evt.getPoint());
            }
        });
    }

    protected String getXvalue(int index) {
        try {
            return this.xValues[index];
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            return "";
        }
    }

    protected void processMouseMotion(Point point) {
        if (this.getClickableAt(point) < 0) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (this.getToolTipVector().size() == 0) {
            this.setToolTipText("");
            return;
        }
        for (Object[] posInfo : this.getToolTipVector()) {
            double leftXPos = (Double)posInfo[0];
            double rightYPos = (Double)posInfo[1];
            if (!(leftXPos <= (double)point.x) || !((double)point.x <= rightYPos)) continue;
            if (this.toolTiper == null) {
                this.setToolTipText((String)posInfo[2] + " : " + ((Double)posInfo[3]).toString());
                break;
            }
            this.setToolTipText(this.toolTiper.process(new Object[]{(String)posInfo[2], (Double)posInfo[3]}));
            break;
        }
    }

    public void setToolTiper(ToolTipInterface toolTiper) {
        this.toolTiper = toolTiper;
    }

    public void setMaxY(double maxY) {
        if (maxY != Double.MIN_VALUE) {
            this.maxY = maxY;
        }
    }

    private void setMaxYMinY(int smallArraySize) throws ArrayIndexOutOfBoundsException {
        double big = Double.MIN_VALUE;
        double small = Double.MAX_VALUE;
        for (int i = 0; i < smallArraySize; ++i) {
            if (this.yValues[i] > big && this.yValues[i] != Double.POSITIVE_INFINITY) {
                big = this.yValues[i];
            }
            if (!(this.yValues[i] < small) || this.yValues[i] == Double.NEGATIVE_INFINITY) continue;
            small = this.yValues[i];
        }
        if (this.baseLineValue > big && this.baseLineValue != Double.POSITIVE_INFINITY) {
            big = this.baseLineValue;
        }
        if (this.userMaxY > big && this.userMaxY != Double.POSITIVE_INFINITY) {
            big = this.userMaxY;
        }
        if (this.baseLineValue < small && this.baseLineValue != Double.NEGATIVE_INFINITY) {
            small = this.baseLineValue;
        }
        if (this.userMinY < small && this.userMinY != Double.NEGATIVE_INFINITY) {
            small = this.userMinY;
        }
        this.maxY = big;
        this.minY = small;
        double delta = this.maxY - this.minY;
        this.maxY += delta * 0.1;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.panelHeight = this.getSize().height;
        this.panelWidth = this.getSize().width;
        this.getToolTipVector().clear();
        if (this.panelWidth < 50 || this.panelHeight < 70) {
            return;
        }
        this.debugLine = (int)((double)this.panelHeight * 0.3);
        this.rightMargin = this.leftMargin = (double)this.panelWidth * 0.01;
        this.upMargin = this.bottomMargin = (double)this.panelHeight * 0.01;
        this.height_temp_str = this.getBound(g2, TEMP_STR_FOR_HEIGHT).getHeight();
        this.width_big_x_rule = this.getBound(g2, TEMP_STR_FOR_WIDTH).getWidth();
        this.min_x_rule_len = (int)this.getBound(g2, TEMP_STR_MIN_X_RULE).getHeight();
        this.drawTitleSetUpMargin(g2);
        this.drawYTitleSetLeftMargin(g2);
        this.drawXTitleSetBottomMargin(g2);
        this.setYoriginLen(g2);
        this.setXoriginLen(g2);
        this.drawAxis(g2);
        g2.setFont(new Font("verdana", 2, 9));
        if (this.xValues.length < 1 || this.yValues.length < 1) {
            return;
        }
        this.drawYrules(g2);
        this.drawXPart(g2);
        this.drawBaseLine(g2);
    }

    private void drawTitleSetUpMargin(Graphics2D g2) {
        Rectangle2D bounds = this.getBound(g2, this.title);
        float titleWidth = (float)bounds.getWidth();
        float titleHeight = (float)bounds.getHeight();
        g2.drawString(this.title, (float)(this.getSize().width / 2) - titleWidth / 2.0f, titleHeight);
        this.upMargin += (double)(titleHeight * 2.0f);
    }

    private void drawYTitleSetLeftMargin(Graphics2D g2) {
        Rectangle2D bound = this.getBound(g2, this.yTitle);
        double x = this.leftMargin + bound.getHeight();
        double y = (double)(this.panelHeight / 2) + bound.getWidth() / 2.0;
        g2.translate(x, y);
        g2.rotate(-this.getRadian(90.0));
        g2.drawString(this.yTitle, 0, 0);
        g2.rotate(this.getRadian(90.0));
        g2.translate(-x, -y);
        this.leftMargin += bound.getHeight();
        this.leftMargin += this.getMaxLength(g2, this.xValues) * Math.cos(this.getRadian(this.getSlope())) * 0.5;
    }

    private double getSlope() {
        return this.slop;
    }

    private double getMaxLength(Graphics2D g2, String[] values) {
        double max = 0.0;
        for (int i = this.xValueFirstIndex; i < this.xValueFirstIndex + this.numToShow; ++i) {
            if (!(max < this.getBound(g2, values[i]).getWidth())) continue;
            max = this.getBound(g2, values[i]).getWidth();
        }
        return max;
    }

    private void drawXTitleSetBottomMargin(Graphics2D g2) {
        Rectangle2D bounds = this.getBound(g2, this.xTitle);
        float titleWidth = (float)bounds.getWidth();
        float titleHeight = (float)bounds.getHeight();
        titleHeight = (float)((double)titleHeight + this.padding(titleHeight));
        g2.drawString(this.xTitle, (float)(this.getSize().width / 2) - titleWidth / 2.0f, (float)((double)this.panelHeight - this.bottomMargin));
        this.bottomMargin += (double)titleHeight;
        this.bottomMargin += this.getMaxLength(g2, this.xValues) * Math.sin(this.getRadian(this.getSlope()));
    }

    private void setYoriginLen(Graphics2D g2) {
        this.yOrigin = (double)this.panelHeight - this.bottomMargin - this.height_temp_str;
        this.yAxisLen = this.yOrigin - this.upMargin;
        this.lastYDot = this.upMargin + this.upMargin * 0.1;
    }

    private void setXoriginLen(Graphics2D g2) {
        this.xOrigin = this.leftMargin + this.width_big_x_rule + this.width_big_x_rule * 0.5;
        this.xAxisLen = (double)this.panelWidth - this.xOrigin - this.rightMargin;
    }

    private void drawAxis(Graphics2D g2) {
        Line2D.Double xAxis = new Line2D.Double(this.xOrigin, this.yOrigin, this.xOrigin + this.xAxisLen, this.yOrigin);
        Line2D.Double yAxis = new Line2D.Double(this.xOrigin, this.yOrigin, this.xOrigin, this.yOrigin - this.yAxisLen);
        g2.draw(xAxis);
        g2.draw(yAxis);
    }

    private void drawYrules(Graphics2D g2) {
        double[] yruleNames = Chart.recalcRule(this.minY, this.maxY);
        int ypos = 0;
        try {
            this.lastY = yruleNames[yruleNames.length - 2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < yruleNames.length - 1; ++i) {
            String currYstr = this.formatter.format(yruleNames[i]);
            double width = this.getBound(g2, currYstr).getWidth();
            ypos = (int)(this.yOrigin - this.getPhysicalYvalue(Double.parseDouble(currYstr)));
            g2.drawString(currYstr, (int)(this.xOrigin - width), ypos);
            g2.drawLine((int)this.xOrigin, ypos, (int)(this.xOrigin + 5.0), ypos);
        }
    }

    private void drawXPart(Graphics2D g2) {
        Shape oldClip = g2.getClip();
        g2.clip(new Rectangle2D.Double(this.xOrigin, this.upMargin, this.xAxisLen, this.yAxisLen));
        if (this.isShowAll) {
            this.showAll(g2);
            return;
        }
        if ((double)this.numToShow > this.xAxisLen) {
            this.drawLineGraph(g2);
            return;
        }
        this.drawBarGraph(g2);
        g2.setClip(oldClip);
        this.drawXRule(g2);
    }

    private void drawBarGraph(Graphics2D g2) {
        double xRuleWidth = this.xAxisLen / (double)this.numToShow;
        double currXpos = this.xOrigin;
        double xruleYpos = this.yOrigin + (double)this.getXrulHeight(g2) + this.padding(this.getXrulHeight(g2));
        if (this.getXBaseIndex() < this.xValueFirstIndex) {
            this.drawBackgroundBox(g2, currXpos);
        }
        int relativeIndex = 0;
        while (relativeIndex < this.numToShow) {
            if (this.getXBaseIndex() == this.xValueFirstIndex + relativeIndex) {
                this.drawBackgroundBox(g2, currXpos);
            }
            if (this.getXBaseIndex() <= this.xValueFirstIndex + relativeIndex) {
                this.setIsUpSpecial(false);
            } else {
                this.setIsUpSpecial(true);
            }
            this.drawBar(g2, xRuleWidth, currXpos, relativeIndex);
            ++relativeIndex;
            currXpos += xRuleWidth;
        }
    }

    private void drawXRule(Graphics2D g2) {
        int relativeIndex;
        double xRuleWidth = this.xAxisLen / (double)this.numToShow;
        double currXpos = this.xOrigin;
        double xruleYpos = this.yOrigin + (double)this.getXrulHeight(g2) + this.padding(this.getXrulHeight(g2));
        boolean bSkewedText = false;
        for (relativeIndex = 0; relativeIndex < this.numToShow; ++relativeIndex) {
            if (xRuleWidth < (double)this.min_x_rule_len || !(this.getBound(g2, this.xValues[this.xValueFirstIndex + relativeIndex]).getWidth() < xRuleWidth)) continue;
            bSkewedText = true;
            break;
        }
        relativeIndex = 0;
        while (relativeIndex < this.numToShow) {
            this.drawRedIfSpecial(g2, null, relativeIndex);
            if (!(xRuleWidth < (double)this.min_x_rule_len)) {
                if (bSkewedText) {
                    g2.drawString(this.xValues[this.xValueFirstIndex + relativeIndex], (int)currXpos, (int)xruleYpos);
                } else {
                    this.drawLeanString(g2, this.xValues[this.xValueFirstIndex + relativeIndex], new Point((int)currXpos, (int)xruleYpos), 23);
                }
            }
            ++relativeIndex;
            currXpos += xRuleWidth;
        }
    }

    private void drawBackgroundBox(Graphics2D g2, double xpos) {
        Shape oldClip = g2.getClip();
        double clipHeight = 15.0;
        Rectangle2D.Double z = new Rectangle2D.Double(xpos, this.yOrigin, (double)this.panelWidth - xpos - this.rightMargin, clipHeight);
        g2.setClip(z);
        Color currColor = g2.getColor();
        g2.setColor(Color.lightGray);
        g2.fill(z);
        g2.setColor(currColor);
        g2.setClip(oldClip);
    }

    public int getXBaseIndex() {
        return this.xBaseIndex;
    }

    public void setXBaseIndex(int baseIndex) {
        this.xBaseIndex = baseIndex;
    }

    public double getRadian(double angle) {
        return angle / 180.0 * Math.PI;
    }

    public void drawLeanString(Graphics2D g2, String string, Point point, int angle) {
        Rectangle2D bound = this.getBound(g2, "X");
        point.x = (int)((double)point.x + bound.getWidth());
        point.y = (int)((double)point.y - bound.getHeight() * 0.3);
        bound = this.getBound(g2, string);
        g2.translate(point.x, point.y);
        g2.rotate(-this.getRadian(angle));
        g2.drawString(string, -((int)bound.getWidth()), 0);
        g2.rotate(this.getRadian(angle));
        g2.translate(-point.x, -point.y);
    }

    private int getXrulHeight(Graphics2D g2) {
        return (int)this.getBound(g2, TEMP_STR_FOR_HEIGHT).getHeight();
    }

    protected void drawBar(Graphics2D g2, double widthLimit, double xPos, int relativeYvalueIndex) {
        double barLen = this.getBarLen(this.xValueFirstIndex + relativeYvalueIndex);
        if (barLen > this.yAxisLen) {
            barLen = this.yAxisLen;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xPos + widthLimit * 0.1, this.yOrigin - barLen, widthLimit * 0.5, barLen);
        this.getToolTipVector().add(new Object[]{new Double(xPos + widthLimit * 0.1), new Double(xPos + widthLimit * 0.1 + widthLimit * 0.5), this.xValues[this.xValueFirstIndex + relativeYvalueIndex], new Double(this.yValues[this.xValueFirstIndex + relativeYvalueIndex])});
        this.drawRedIfSpecial(g2, rect, relativeYvalueIndex);
    }

    public void drawRedIfSpecial(Graphics2D g2, Shape shape, int relativeYvalueIndex) {
        if (this.isSpecial(this.yValues[this.xValueFirstIndex + relativeYvalueIndex])) {
            g2.setColor(Color.red);
            if (shape != null) {
                g2.fill(shape);
            }
        } else {
            g2.setColor(new Color(0, 128, 128));
            if (shape != null) {
                g2.fill(shape);
            }
            g2.setColor(Color.black);
        }
    }

    protected Vector getToolTipVector() {
        if (this.toolTipVector == null) {
            this.toolTipVector = new Vector();
        }
        return this.toolTipVector;
    }

    protected boolean isSpecial(double value) {
        if (this.isUpSpecial && value > this.baseLineValue) {
            return true;
        }
        return !this.isUpSpecial && value < this.baseLineValue;
    }

    protected void drawLineGraph(Graphics2D g2) {
        double x = this.xOrigin;
        double sum = 0.0;
        if (this.xAxisLen < 1.0) {
            return;
        }
        int firstIndex = this.xValueFirstIndex;
        int lastIndex = this.xValueFirstIndex + this.numToShow;
        int group_size = (int)Math.round((double)this.numToShow / this.xAxisLen) + 1;
        int count = 0;
        this.getToolTipVector().clear();
        int i = firstIndex;
        while (i < lastIndex) {
            sum = 0.0;
            int lastGroupIndex = i + group_size;
            if (lastGroupIndex > lastIndex) {
                lastGroupIndex = lastIndex;
                group_size = lastIndex - i;
            }
            while (i < lastGroupIndex) {
                sum += this.getBarLen(i);
                ++i;
            }
            double average = sum / (double)group_size;
            if (average > this.yAxisLen) {
                average = this.yAxisLen;
            }
            g2.draw(new Line2D.Double(x += 1.0, this.yOrigin - average, x, this.yOrigin));
            ++count;
        }
    }

    public boolean isSpecialIdx(int idx) {
        return this.isSpecial(this.yValues[idx]);
    }

    protected void showAll(Graphics2D g2) {
        int smallArraySize = this.xValues.length < this.yValues.length ? this.xValues.length : this.yValues.length;
        double group_size = this.xAxisLen / (double)smallArraySize;
        double x = this.xOrigin + group_size * 0.5;
        this.getToolTipVector().clear();
        g2.setColor(Color.darkGray);
        for (int i = 0; i < smallArraySize; ++i) {
            if (this.getXBaseIndex() == i) {
                this.drawBackgroundBox(g2, x);
            }
            if (this.isSpecialIdx(i)) {
                g2.setColor(Color.red);
            }
            g2.draw(new Line2D.Double(x, this.yOrigin - this.getBarLen(i), x, this.yOrigin));
            g2.setColor(Color.darkGray);
            x += group_size;
        }
    }

    private void drawBaseLine(Graphics2D g2) {
        double y = this.getPhysicalYvalue(this.baseLineValue);
        if (this.baseLineValue > Double.MAX_VALUE) {
            y = this.yAxisLen;
        } else if (this.baseLineValue < Double.MIN_VALUE) {
            y = 0.0;
        }
        Line2D.Double line = new Line2D.Double(this.xOrigin, this.yOrigin - y, (double)this.panelWidth - this.rightMargin, this.yOrigin - y);
        g2.setColor(Color.GREEN);
        g2.draw(line);
    }

    protected double getBarLen(int index) {
        double value = this.yValues[index] - this.minY;
        double ratio = value / (this.lastY - this.minY);
        double result = (this.yOrigin - this.lastYDot) * ratio;
        if (result > this.yAxisLen) {
            result = this.yAxisLen;
        }
        return result;
    }

    private double padding(double value) {
        return value * 0.1;
    }

    private Rectangle2D getBound(Graphics2D g2, String string) {
        return g2.getFont().getStringBounds(string, g2.getFontRenderContext());
    }

    protected void redraw(int value) {
        if (value >= 0 && value <= this.xValues.length - this.numToShow) {
            this.xValueFirstIndex = value;
            this.repaint();
        }
    }

    void setIsShowAll_InternalUseOnly(boolean b) {
        this.isShowAll = b;
    }

    public void setXYvalues(String[] xvalues, double[] yvalues) {
        this.setXYvalues(xvalues, yvalues, 0);
    }

    public void setXYvalues(String[] xvalues, double[] yvalues, int firstXindex) {
        this.initialize(xvalues, yvalues, firstXindex, 20);
        this.repaint();
    }

    public void setXTitle(String xTitle) {
        this.setXTitle(xTitle, true);
    }

    public void setXTitle(String xTitle, boolean isRepaint) {
        this.xTitle = xTitle;
        if (isRepaint) {
            this.repaint();
        }
    }

    public void setYTitle(String yTitle) {
        this.setYTitle(yTitle, true);
    }

    public void setYTitle(String yTitle, boolean isRepaint) {
        this.yTitle = yTitle;
        if (isRepaint) {
            this.repaint();
        }
    }

    public void setTitle(String title) {
        this.setTitle(title, true);
    }

    public void setTitle(String title, boolean isRepaint) {
        this.title = title;
        if (isRepaint) {
            this.repaint();
        }
    }

    private double getPhysicalYvalue(double realValue) {
        double value = realValue - this.minY;
        double ratio = value / (this.lastY - this.minY);
        double result = (this.yOrigin - this.lastYDot) * ratio;
        return result;
    }

    public void setBaseLineValue(double d) {
        this.baseLineValue = d;
        this.setMaxYMinY(this.smallArraySize);
    }

    public void setFirstIndex(int index) {
        if (index > -1 && index < this.smallArraySize) {
            this.xValueFirstIndex = index;
        }
    }

    public static double[] recalcRule(double min, double max) {
        double unit;
        int _10over;
        double[] res = null;
        double gap = max - min;
        if (gap <= 0.0 || gap > 10000.0) {
            max = min + 1.0;
            gap = 1.0;
        }
        if ((_10over = (int)(Math.log(gap) / Math.log(10.0) - 0.5)) < -100) {
            System.out.println("_10over < -100");
        }
        if (gap / (unit = Math.pow(10.0, _10over)) < 5.0) {
            unit /= 2.0;
        }
        if (gap / unit < 5.0) {
            unit = unit * 2.0 / 5.0;
        }
        if (gap / unit < 5.0) {
            unit = Math.pow(10.0, --_10over);
        }
        double from = (double)((int)((min - unit / 2.0) / unit)) * unit;
        double to = (double)((int)((max + 6.0 * unit / 5.0) / unit)) * unit;
        if (to < 0.0) {
            to = (double)((int)((max + unit / 2.0) / unit)) * unit;
            from = (double)((int)((min - 6.0 * unit / 5.0) / unit)) * unit;
        }
        int cnt = 0;
        for (double i = from; i <= to + unit / 2.0; i += unit) {
            if (++cnt <= 1000) continue;
            System.out.println(" from = " + from + "  :  to+unit/2 = " + (to + unit / 2.0));
        }
        if (cnt >= 10) {
            int newCnt = 5;
            int rate = (int)Math.ceil((double)cnt / (double)newCnt);
            unit *= (double)rate;
            cnt = newCnt;
            ++cnt;
        }
        res = new double[cnt];
        for (int i = 0; i < res.length; ++i) {
            res[i] = from + (double)i * unit;
        }
        return res;
    }

    public void setIsUpSpecial(boolean bool) {
        this.isUpSpecial = bool;
    }

    public int getClickableAt(int x, int y) {
        return this.getClickableAt(new Point(x, y));
    }

    public int getClickableAt(Point point) {
        if (this.getToolTipVector().size() == 0) {
            return -1;
        }
        int index = 0;
        for (Object[] posInfo : this.getToolTipVector()) {
            double leftXPos = (Double)posInfo[0];
            double rightYPos = (Double)posInfo[1];
            if (leftXPos <= (double)point.x && (double)point.x <= rightYPos) {
                return this.xValueFirstIndex + index;
            }
            ++index;
        }
        return -1;
    }

    public static interface ToolTipInterface {
        public String process(Object[] var1);
    }
}

