/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.chart;

import com.istech21.widget.chart.Chart;
import com.istech21.widget.chart.MyScrollPositionListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.HashSet;
import java.util.Random;
import javax.swing.BoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class ChartWithScrollBar
extends JPanel
implements MyScrollPositionListener {
    protected static final int DEFAULT_NUM_TO_SHOW = 20;
    protected Chart chart;
    protected JScrollBar scrollbar;
    HashSet scrollPositionListeners = new HashSet();
    static Random random = new Random();

    public ChartWithScrollBar(String[] xvalues, double[] yvalues) {
        this(xvalues, yvalues, 0, xvalues.length > 20 ? 20 : xvalues.length);
    }

    public ChartWithScrollBar(String[] xvalues, double[] yvalues, int firstIndex) {
        this(xvalues, yvalues, firstIndex, xvalues.length > 20 ? 20 : xvalues.length);
    }

    public ChartWithScrollBar(String[] xvalues, double[] yvalues, int firstIndex, int numToShow) {
        this.init(xvalues, yvalues, firstIndex, numToShow);
    }

    protected void init(String[] xvalues, double[] yvalues, int firstIndex, int numToShow) {
        this.setLayout(new GridBagLayout());
        this.setChart(xvalues, yvalues, firstIndex, numToShow);
        this.chart.setBaseLineValue(0.5);
        GridBagConstraints chartConstraints = new GridBagConstraints();
        chartConstraints.gridx = 0;
        chartConstraints.gridy = 0;
        chartConstraints.gridwidth = 2;
        chartConstraints.weightx = 1.0;
        chartConstraints.weighty = 1.0;
        chartConstraints.fill = 1;
        this.add((Component)this.chart, chartConstraints);
        int maxOfScrollBar = xvalues.length < yvalues.length ? xvalues.length : yvalues.length - numToShow + 1;
        GridBagConstraints scrollbarConstraints = new GridBagConstraints();
        scrollbarConstraints.gridx = 0;
        scrollbarConstraints.gridy = 1;
        scrollbarConstraints.weightx = 1.0;
        scrollbarConstraints.fill = 2;
        this.add((Component)this.getScrollbar(maxOfScrollBar), scrollbarConstraints);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(false);
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                ChartWithScrollBar.this.chart.setIsShowAll_InternalUseOnly(source.isSelected());
                ChartWithScrollBar.this.chart.redraw(0);
            }
        });
        GridBagConstraints checkBoxConstraints = new GridBagConstraints();
        checkBoxConstraints.gridx = 1;
        checkBoxConstraints.gridy = 1;
    }

    protected void setChart(String[] xvalues, double[] yvalues, int firstIndex, int numToShow) {
        this.chart = new Chart(xvalues, yvalues, firstIndex, numToShow);
    }

    public void positionChanged(int newValue) {
        int oldValue = this.scrollbar.getValue();
        if (oldValue == newValue) {
            return;
        }
        this.scrollbar.setValue(newValue);
        this.chart.redraw(newValue);
    }

    public void addScrollbarValueChangeListener(MyScrollPositionListener listener) {
        this.scrollPositionListeners.add(listener);
    }

    public void clearScrollbarValueChangeListener() {
        this.scrollPositionListeners.clear();
    }

    private void notifyScolbarValueChanged() {
        if (this.scrollPositionListeners == null || this.scrollPositionListeners.size() == 0) {
            return;
        }
        int newPos = this.scrollbar.getValue();
        MyScrollPositionListener[] list = new MyScrollPositionListener[this.scrollPositionListeners.size()];
        this.scrollPositionListeners.toArray(list);
        for (int i = 0; i < list.length; ++i) {
            list[i].positionChanged(newPos);
        }
    }

    private JScrollBar getScrollbar(int maxOfScrollBar) {
        if (this.scrollbar == null) {
            this.scrollbar = new JScrollBar();
            this.scrollbar.setOrientation(0);
            BoundedRangeModel scrollbarModel = this.scrollbar.getModel();
            scrollbarModel.setExtent(1);
            this.scrollbar.setMinimum(0);
            this.scrollbar.setMaximum(maxOfScrollBar);
            this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    ChartWithScrollBar.this.chart.redraw(ChartWithScrollBar.this.scrollbar.getValue());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ChartWithScrollBar.this.notifyScolbarValueChanged();
                        }
                    });
                }
            });
        }
        return this.scrollbar;
    }

    public void setEnabledScrollbar(boolean isEnabled) {
        this.scrollbar.setEnabled(isEnabled);
    }

    private static String[] makeXvalues(int size) {
        String[] xvalues = new String[size];
        for (int i = 0; i < size; ++i) {
            xvalues[i] = Integer.toString(i);
        }
        return xvalues;
    }

    private static double[] makeYvalues(int size) {
        Random random = new Random();
        double[] yvalues = new double[size];
        for (int i = 0; i < size; ++i) {
            yvalues[i] = (double)i / (double)size;
        }
        return yvalues;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setMaxScrollbar(String[] xvalues, double[] yvalues) {
        int maxOfScrollBar;
        int n = maxOfScrollBar = xvalues.length < yvalues.length ? xvalues.length : yvalues.length - 20 + 1;
        if (maxOfScrollBar < 0) {
            maxOfScrollBar = 0;
        }
        this.scrollbar.setMaximum(maxOfScrollBar);
    }

    public void setScrollbarValue(int value) {
        if (this.scrollbar.getMaximum() >= value && this.scrollbar.getMinimum() <= value) {
            this.scrollbar.setValue(value);
        }
    }

    public int getScrollbarValue() {
        return this.scrollbar.getValue();
    }

    public static void main(String[] args) {
        int size = 300000;
        int numToShow = 50;
        String[] xvalues = ChartWithScrollBar.makeXvalues(size);
        double[] yvalues = ChartWithScrollBar.makeYvalues(size);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        int firstIndex = size - numToShow;
        frame.setContentPane(new ChartWithScrollBar(xvalues, yvalues, 0, numToShow));
        frame.setSize(600, 300);
        frame.setVisible(true);
    }

    public void setIsShowAll(boolean isShowAll) {
        this.getChart().setIsShowAll_InternalUseOnly(isShowAll);
        if (isShowAll) {
            this.scrollbar.setVisible(false);
        } else {
            this.scrollbar.setVisible(true);
        }
    }
}

