/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.indexer;

import com.istech21.widget.indexer.Indexer;
import com.istech21.widget.indexer.ValueReader;
import com.istech21.widget.indexer.ValueReaderLRULineCacheImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.table.AbstractTableModel;

public class IndexedReadonlyTableModel
extends AbstractTableModel
implements Indexer.IndexerChangedListener {
    Indexer idx = null;
    ValueReader value = null;
    int rowCount = 0;
    int colCount = 0;
    private boolean fileIsGenoSpecial = false;
    Thread indexingThread = null;

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        this.InterruptIndexingThread();
        this.value.close();
        this.idx.close();
        System.gc();
        System.runFinalization();
    }

    private String autoDetectColumnSeparator(String fpath) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(fpath));
            String line = null;
            while ((line = r.readLine()) != null && (line.length() == 0 || line.charAt(0) == '!' || line.charAt(0) == '#')) {
            }
            r.close();
            int c = 0;
            int t = 0;
            for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) == '\t') {
                    ++t;
                    continue;
                }
                if (line.charAt(i) != ',') continue;
                ++c;
            }
            if (c == 0 && t == 0) {
                System.out.println("Cannot autodetect column separator");
                return "\t";
            }
            if (t >= c) {
                return "\t";
            }
            return ",";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\t";
        }
    }

    public IndexedReadonlyTableModel(String fpath) {
        File thisFile = new File(fpath);
        if (!thisFile.exists()) {
            System.out.println("File not exist: " + fpath);
            return;
        }
        if (thisFile.length() == 0L) {
            System.out.println("File contents is empty: " + fpath);
            return;
        }
        if (fpath.toLowerCase().endsWith(".geno") || fpath.toLowerCase().endsWith(".geno.src")) {
            this.fileIsGenoSpecial = true;
        }
        String separator = this.autoDetectColumnSeparator(fpath);
        this.idx = new Indexer(fpath);
        this.idx.setColumnSeparator(separator);
        this.idx.makePartialIndex();
        this.rowCount = this.idx.getRowCount();
        this.colCount = this.idx.getColumnCount();
        this.value = new ValueReaderLRULineCacheImpl(this.idx);
        this.value.setColumnSeparator(separator);
        if (!this.idx.isComplete()) {
            this.idx.addIndexerChangedListener(this);
            this.indexingThread = new Thread(new Runnable(){

                public void run() {
                    IndexedReadonlyTableModel.this.idx.makeIndex();
                }
            }, "IndexReadonlyTableModel-makeIndex");
            this.indexingThread.setDaemon(true);
            this.indexingThread.start();
        }
    }

    public void InterruptIndexingThread() {
        if (this.indexingThread != null) {
            this.indexingThread.interrupt();
        }
    }

    public boolean isCellEditable(int r, int c) {
        return false;
    }

    public String getValueAt(int r, int c) {
        if (this.fileIsGenoSpecial) {
            return this.getValutAtSpecialForGeno(r, c);
        }
        if (c == 0) {
            return String.valueOf(r + 1);
        }
        if (this.value == null) {
            return "*";
        }
        String res = this.value.getValueAt(r, c - 1);
        if (res == null) {
            return res;
        }
        if (res.startsWith("<a")) {
            return "<html>" + res + "</html>";
        }
        return res;
    }

    private String getValutAtSpecialForGeno(int r, int c) {
        if (c == 0) {
            if (r == 0) {
                return "A";
            }
            if (r == 1) {
                return "B";
            }
            return String.valueOf(r + 1 - 2);
        }
        if (this.value == null) {
            return "*";
        }
        String res = this.value.getValueAt(r, c - 1);
        if (res == null) {
            return res;
        }
        if (res.startsWith("<a")) {
            return "<html>" + res + "</html>";
        }
        return res;
    }

    public int getColumnCount() {
        return this.colCount + 1;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public final String getColumnName(int c) {
        if (this.fileIsGenoSpecial) {
            return this.getColumnNameSpecialForGeno(c);
        }
        if (c == 0) {
            return "*";
        }
        return String.valueOf(c);
    }

    private final String getColumnNameSpecialForGeno(int c) {
        if (c == 0) {
            return "*";
        }
        if (c <= 4) {
            return "Header " + String.valueOf(c);
        }
        return String.valueOf(c - 4);
    }

    public void IndexerChanged() {
        this.rowCount = this.idx.getRowCount();
        int oldColCount = this.colCount;
        this.colCount = this.idx.getColumnCount();
        if (oldColCount != this.colCount) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public boolean isComplete() {
        return this.idx.isComplete();
    }

    public long getNumRead() {
        return this.idx.getNumRead();
    }
}

