/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Indexer {
    HashSet listeners = new HashSet();
    protected String fpath = null;
    protected long fsize = 0L;
    protected boolean bComplete = false;
    Map idxValues = new HashMap();
    boolean bIndexingNow = false;
    long numRead = 0L;
    private int maxColCount = 0;
    private int lineCount = 0;
    boolean bThisIsPartialStep = false;
    private Thread indexingThread = null;
    static final String LSS = System.getProperty("line.separator", "\n");
    static final char LS = LSS.charAt(0);
    private String TSS = "\t";
    private char TS = this.TSS.charAt(0);

    public void addIndexerChangedListener(IndexerChangedListener l) {
        this.listeners.add(l);
    }

    public void notifyIndexerChangedLister() {
        IndexerChangedListener[] ls = new IndexerChangedListener[this.listeners.size()];
        this.listeners.toArray(ls);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].IndexerChanged();
        }
    }

    public void close() {
        this.idxValues.clear();
        this.idxValues = null;
        this.listeners.clear();
        this.listeners = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public Indexer(String fpath) {
        this.fpath = fpath;
    }

    public void makePartialIndex() {
        this.makeIndex(true);
    }

    public void makeIndex() {
        this.makeIndex(false);
    }

    public void makeIndex(boolean isPartial) {
        block8: {
            this.bThisIsPartialStep = isPartial;
            this.bComplete = false;
            this.fsize = new File(this.fpath).length();
            if (this.fsize == 0L) {
                this.bIndexingNow = false;
                this.maxColCount = 0;
                this.lineCount = 0;
                this.bComplete = true;
                System.out.println("file is empty");
                return;
            }
            try {
                this.bIndexingNow = true;
                this.numRead = 0L;
                this.maxColCount = 0;
                this.lineCount = 0;
                Runnable r = new Runnable(){

                    public void run() {
                        try {
                            Indexer.this.makeIndexCustomBufferedIStreamReadImpl();
                            Indexer.this.bIndexingNow = false;
                        }
                        catch (Exception ig) {
                            ig.printStackTrace();
                            Indexer.this.bIndexingNow = false;
                        }
                    }
                };
                if (isPartial) {
                    r.run();
                    break block8;
                }
                this.indexingThread = new Thread(r, "Indexer-makeIndexCustomBufferedIStreamReadImpl");
                this.indexingThread.setDaemon(true);
                this.indexingThread.start();
                while (this.bIndexingNow) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.InterruptIndexingThread();
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        this.InterruptIndexingThread();
                        return;
                    }
                    this.notifyIndexerChangedLister();
                }
                this.notifyIndexerChangedLister();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void InterruptIndexingThread() {
        this.indexingThread.interrupt();
    }

    public void setColumnSeparator(String newSep) {
        this.TSS = newSep;
        this.TS = this.TSS.charAt(0);
    }

    protected void makeIndexCustomBufferedIStreamReadImpl() throws Exception {
        int n;
        Object line = null;
        this.lineCount = 0;
        this.maxColCount = 1;
        boolean pstart = false;
        boolean pstop = false;
        int colCount = 0;
        FileInputStream fis = new FileInputStream(this.fpath);
        byte[] buf = new byte[20];
        boolean cnt = false;
        boolean bWritePos = true;
        this.numRead = 0L;
        int loopMonitor = 0;
        while ((n = fis.read(buf)) != -1) {
            if (++loopMonitor > 1000) {
                loopMonitor = 0;
            }
            if (loopMonitor == 1000 && Thread.currentThread().isInterrupted()) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                if (bWritePos) {
                    if (buf[i] == LS || buf[i] == 10 || buf[i] == 13) continue;
                    this.idxValues.put(this.lineCount, this.numRead + (long)i);
                    bWritePos = false;
                    ++this.lineCount;
                    this.maxColCount = Math.max(this.maxColCount, colCount + 1);
                    colCount = 0;
                    if (this.bThisIsPartialStep && this.lineCount == 300) {
                        fis.close();
                        this.bComplete = false;
                        return;
                    }
                }
                if (buf[i] == LS || buf[i] == 10 || buf[i] == 13) {
                    bWritePos = true;
                    continue;
                }
                if (buf[i] != this.TS) continue;
                ++colCount;
            }
            this.numRead += (long)n;
        }
        fis.close();
        this.bComplete = true;
        System.out.println("indexing completed:" + this.fpath);
    }

    public long getNumRead() {
        return this.numRead;
    }

    public boolean isComplete() {
        return this.bComplete;
    }

    public int getRowCount() {
        return this.lineCount;
    }

    public int getColumnCount() {
        return this.maxColCount;
    }

    public long getLineStart(int whichLine) {
        Object res = this.idxValues.get(whichLine);
        if (res == null) {
            return -1L;
        }
        return (Long)res;
    }

    public static void main(String[] args) {
        String file = "c:\\large108.txt";
        Indexer idx = new Indexer(file);
        idx.makePartialIndex();
        idx.makeIndex();
    }

    public static interface IndexerChangedListener {
        public void IndexerChanged();
    }
}

