/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.indexer;

import com.istech21.widget.indexer.Indexer;
import com.istech21.widget.indexer.ValueReader;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValueReaderLRULineCacheImpl
implements ValueReader {
    public Indexer idx = null;
    private String fpath = null;
    RandomAccessFile raf = null;
    static final String STR_NO = "?";
    static final String STR_ERR = "";
    static final int MAX_POOL_SIZE = 200;
    Map cache = null;
    int oldR = -1;
    String[] oldTok = null;
    static final String LSS = System.getProperty("line.separator", "\n");
    static final char LS = LSS.charAt(0);
    private String TSS = "\t";
    private char TS = this.TSS.charAt(0);
    boolean bThisLineIsNotPrepared = false;

    public ValueReaderLRULineCacheImpl(Indexer idx) {
        this.idx = idx;
        this.fpath = idx.fpath;
        if (new File(this.fpath).exists()) {
            try {
                this.initCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.raf = null;
        }
    }

    public String getValueAt(int r, int c) {
        try {
            int whichR = r;
            if (whichR == this.oldR) {
                return new String(this.oldTok[c]);
            }
            Integer key = whichR;
            Object o = this.cache.get(key);
            if (o == null) {
                this.rawReadLine(whichR);
                this.cache.put(key, this.oldTok);
            } else {
                this.oldR = whichR;
                this.oldTok = (String[])o;
            }
            return new String(this.oldTok[c]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return STR_ERR;
        }
        catch (Exception e) {
            e.printStackTrace();
            return STR_ERR;
        }
    }

    private void initCache() {
        this.cache = new LinkedHashMap(201, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 200;
            }
        };
    }

    public void setColumnSeparator(String newSep) {
        this.TSS = newSep;
        this.TS = this.TSS.charAt(0);
    }

    private void rawReadLine(int r) throws Exception {
        long fp = this.idx.getLineStart(r);
        this.bThisLineIsNotPrepared = false;
        if (fp < 0L) {
            this.bThisLineIsNotPrepared = true;
            return;
        }
        this.raf = new RandomAccessFile(new File(this.fpath), "r");
        this.raf.seek(fp);
        String line = this.raf.readLine();
        this.oldTok = line.split(this.TSS);
        this.oldR = r;
        this.raf.close();
        this.raf = null;
    }
}

