/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.indexer;

import com.istech21.widget.indexer.Indexer;
import com.istech21.widget.indexer.ValueReader;
import java.io.File;
import java.io.RandomAccessFile;

public class ValueReaderLineCacheImpl
implements ValueReader {
    public Indexer idx = null;
    private String fpath = null;
    RandomAccessFile raf = null;
    static final String STR_NO = "?";
    static final String STR_ERR = "";
    static final int MAX_POOL_SIZE = 200;
    int nextSlotNo = 0;
    int[] lineNumberPool = new int[200];
    String[][] tokenPool = new String[200][];
    int oldR = -1;
    String[] oldTok = null;
    static final String LSS = System.getProperty("line.separator", "\n");
    static final char LS = LSS.charAt(0);
    private String TSS = "\t";
    private char TS = this.TSS.charAt(0);
    boolean bThisLineIsNotPrepared = false;

    public ValueReaderLineCacheImpl(Indexer idx) {
        this.idx = idx;
        this.fpath = idx.fpath;
        if (new File(this.fpath).exists()) {
            try {
                this.raf = new RandomAccessFile(new File(this.fpath), "r");
                this.initPool();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.raf = null;
        }
    }

    public String getValueAt(int r, int c) {
        try {
            int whichR = r;
            if (whichR == this.oldR) {
                return new String(this.oldTok[c]);
            }
            int found = this.findLineInPool(whichR);
            if (found < 0) {
                this.rawReadLine(whichR);
                int addedPoolIdx = this.PushLineToPool(whichR, this.oldTok);
                this.oldR = whichR;
            } else {
                this.oldR = found;
                this.oldTok = this.tokenPool[found];
            }
            return new String(this.oldTok[c]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return STR_ERR;
        }
        catch (Exception e) {
            e.printStackTrace();
            return STR_ERR;
        }
    }

    private void initPool() {
        for (int i = 0; i < 200; ++i) {
            this.lineNumberPool[i] = -1;
            this.tokenPool[i] = null;
        }
        this.nextSlotNo = 0;
    }

    private int findLineInPool(int r) {
        for (int i = 0; i < 200; ++i) {
            if (this.lineNumberPool[i] < 0 || this.lineNumberPool[i] != r) continue;
            return i;
        }
        return -1;
    }

    private int PushLineToPool(int lineNo, String[] tok) {
        int thisSlotNo = this.nextSlotNo++;
        this.lineNumberPool[thisSlotNo] = lineNo;
        this.tokenPool[thisSlotNo] = tok;
        if (this.nextSlotNo >= 200) {
            this.nextSlotNo = 0;
        }
        return thisSlotNo;
    }

    public void setColumnSeparator(String newSep) {
        this.TSS = newSep;
        this.TS = this.TSS.charAt(0);
    }

    private void rawReadLine(int r) throws Exception {
        long fp = this.idx.getLineStart(r);
        this.bThisLineIsNotPrepared = false;
        if (fp < 0L) {
            this.bThisLineIsNotPrepared = true;
            return;
        }
        this.raf.seek(fp);
        String line = this.raf.readLine();
        this.oldTok = line.split(this.TSS);
        this.oldR = r;
    }
}

