/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.indexer;

import com.istech21.widget.indexer.Indexer;
import com.istech21.widget.indexer.ValueReader;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;

public class ValueReaderOnlineImpl
implements ValueReader {
    public Indexer idx = null;
    private String fpath = null;
    private long fsize = 0L;
    RandomAccessFile raf = null;
    FileChannel roChannel = null;
    ByteBuffer buf = null;
    final int BufSize = 102400;
    int MAX_LINE_SIZE = 10240;
    final int MAX_TOK_SIZE = 1024;
    char[] cBuff = new char[1024];
    long bufBegin = 0L;
    long bufEnd = 102400L;
    static final String STR_NO = "?";
    static final String STR_ERR = "";
    int oldR = -1;
    String[] oldTok = null;
    static final String LSS = System.getProperty("line.separator", "\n");
    static final char LS = LSS.charAt(0);
    private String TSS = "\t";
    private char TS = this.TSS.charAt(0);
    boolean bThisLineIsNotPrepared = false;

    public ValueReaderOnlineImpl(Indexer idx) {
        this.idx = idx;
        this.fpath = idx.fpath;
        if (new File(this.fpath).exists()) {
            try {
                this.fsize = new File(this.fpath).length();
                this.raf = new RandomAccessFile(new File(this.fpath), "r");
                this.roChannel = this.raf.getChannel();
                this.rawReadBuffer(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.buf != null) {
                this.buf.clear();
            }
            if (this.roChannel != null) {
                this.roChannel.close();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.roChannel = null;
            this.raf = null;
            this.buf = null;
        }
    }

    private void rawReadBuffer(long startFp) throws Exception {
        long newBufSize = this.fsize - startFp;
        newBufSize = Math.min(newBufSize, 102400L);
        this.buf = this.roChannel.map(FileChannel.MapMode.READ_ONLY, startFp, (int)newBufSize);
        this.bufBegin = startFp;
        this.bufEnd = startFp + newBufSize;
    }

    public String getValueAt(int r, int c) {
        try {
            int whichR = r;
            if (whichR != this.oldR) {
                this.rawReadLine(whichR);
            }
            if (this.bThisLineIsNotPrepared) {
                return STR_NO;
            }
            return new String(this.oldTok[c]);
        }
        catch (Exception e) {
            return STR_ERR;
        }
    }

    public void setColumnSeparator(String newSep) {
        this.TSS = newSep;
        this.TS = this.TSS.charAt(0);
    }

    private void rawReadLine(int r) throws Exception {
        long fp = this.idx.getLineStart(r);
        this.bThisLineIsNotPrepared = false;
        if (fp < 0L) {
            this.bThisLineIsNotPrepared = true;
            return;
        }
        if (fp < this.bufBegin || fp >= this.bufEnd) {
            this.rawReadBuffer(fp);
        }
        int posInBuffer = (int)(fp - this.bufBegin);
        this.buf.position(posInBuffer);
        Vector<String> tokVector = new Vector<String>();
        int cBuffPos = 0;
        int nReadBytes = 0;
        boolean bFoundCR = false;
        try {
            while (true) {
                String tok;
                byte b;
                char c;
                if ((c = (char)(b = this.buf.get())) == LS || c == '\n' || c == '\r') {
                    tok = new String(this.cBuff, 0, cBuffPos);
                    tokVector.add(tok);
                    bFoundCR = true;
                    ++nReadBytes;
                    break;
                }
                if (c == this.TS) {
                    tok = new String(this.cBuff, 0, cBuffPos);
                    tokVector.add(tok);
                    cBuffPos = 0;
                    ++nReadBytes;
                    continue;
                }
                this.cBuff[cBuffPos] = c;
                ++cBuffPos;
                ++nReadBytes;
            }
        }
        catch (BufferUnderflowException neb) {
            bFoundCR = false;
        }
        if (!bFoundCR) {
            if ((long)nReadBytes + fp == this.fsize) {
                bFoundCR = true;
                String tok = new String(this.cBuff, 0, cBuffPos);
                tokVector.add(tok);
            } else {
                this.rawReadBuffer(fp);
                this.rawReadLine(r);
                return;
            }
        }
        this.oldTok = new String[tokVector.size()];
        tokVector.toArray(this.oldTok);
        this.oldR = r;
    }
}

