/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.logtextarea;

import com.istech21.widget.logtextarea.AbstractLogComponent;
import com.istech21.widget.logtextarea.LogComponentOutputStream;
import com.istech21.widget.logtextarea.TeeStream;
import java.awt.Color;
import java.io.PrintStream;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class LogEditorPane
extends JEditorPane
implements AbstractLogComponent {
    private PrintStream logStream = null;
    public PrintStream[] old_out = null;
    boolean isOn = false;
    private String savedLogFilePath = null;

    public void clear() {
        super.setText("");
    }

    public void setLogStram(PrintStream _ls) {
        if (this.isOn) {
            this.off();
        }
        this.logStream = _ls;
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public LogEditorPane(String logPath) {
        this.setContentType("text/html");
        this.old_out = LogEditorPane.register(this, logPath);
        this.savedLogFilePath = logPath;
    }

    public void append(String s) {
        if (s != null && s.startsWith("#")) {
            this.append(Color.blue, s);
        } else {
            this.append(Color.black, s);
        }
    }

    public int scroll2last() {
        int len = this.getDocument().getLength();
        this.setCaretPosition(len);
        return len;
    }

    public void append(Color c, String s) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        int len = this.scroll2last();
        try {
            this.getDocument().insertString(len, s, aset);
        }
        catch (Exception e) {
            System.out.println("err");
        }
    }

    public LogEditorPane() {
        this((String)null);
    }

    public void on() {
        if (!this.isOn) {
            PrintStream[] out_oldnew = LogEditorPane.register(this, this.savedLogFilePath);
            this.old_out = new PrintStream[]{out_oldnew[0], out_oldnew[1]};
            this.logStream = out_oldnew[2];
            this.isOn = true;
        }
    }

    private static PrintStream[] register(LogEditorPane txtConsole, String logFilePath) {
        TeeStream out = new TeeStream(new PrintStream(new LogComponentOutputStream(txtConsole, logFilePath)), new PrintStream(System.out));
        PrintStream[] old = new PrintStream[3];
        old[0] = System.out;
        System.setOut(out);
        old[1] = System.err;
        System.setErr(out);
        System.err.println("#Start dumping STDIO/STDERR");
        old[2] = out;
        old[1].println("Successfully redirected output to " + txtConsole);
        return old;
    }

    private static void restore(PrintStream[] old) {
        System.setOut(old[0]);
        System.setErr(old[1]);
    }

    public void off() {
        if (this.isOn) {
            LogEditorPane.restore(this.old_out);
            this.isOn = false;
        }
    }
}

