/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.logtextarea;

import com.istech21.widget.logtextarea.AbstractLogComponent;
import com.istech21.widget.logtextarea.LogComponentOutputStream;
import com.istech21.widget.logtextarea.TeeStream;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JTextArea;

public class LogTextArea
extends JTextArea
implements AbstractLogComponent {
    private PrintStream logStream = null;
    public PrintStream[] old_out = null;
    boolean isOn = false;
    private String savedLogFilePath = null;

    public void clear() {
        super.setText("");
    }

    public void setLogStram(PrintStream _ls) {
        if (this.isOn) {
            this.off();
        }
        this.logStream = _ls;
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public LogTextArea(String logPath) {
        this.old_out = LogTextArea.register(this, logPath);
        this.savedLogFilePath = logPath;
    }

    public void append(Color c, String s) {
        this.append(s);
    }

    public int scroll2last() {
        int len = this.getDocument().getLength();
        try {
            this.scrollRectToVisible(this.modelToView(this.getRows()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return len;
    }

    public LogTextArea() {
        this((String)null);
    }

    public void on() {
        if (!this.isOn) {
            PrintStream[] out_oldnew = LogTextArea.register(this, this.savedLogFilePath);
            this.old_out = new PrintStream[]{out_oldnew[0], out_oldnew[1]};
            this.logStream = out_oldnew[2];
            this.isOn = true;
        }
    }

    private static PrintStream[] register(LogTextArea txtConsole, String logFilePath) {
        TeeStream out = new TeeStream(new PrintStream(new MyTextAreaOutputStream(txtConsole, logFilePath)), new PrintStream(System.out));
        PrintStream[] old = new PrintStream[3];
        old[0] = System.out;
        System.setOut(out);
        old[1] = System.err;
        System.setErr(out);
        System.err.println("#Start dumping STDIO/STDERR");
        old[2] = out;
        return old;
    }

    private static void restore(PrintStream[] old) {
        System.setOut(old[0]);
        System.setErr(old[1]);
    }

    public void off() {
        if (this.isOn) {
            LogTextArea.restore(this.old_out);
            this.isOn = false;
        }
    }

    private static class MyTextAreaOutputStream
    extends LogComponentOutputStream {
        private AbstractLogComponent textControl;

        public MyTextAreaOutputStream(LogTextArea control, String _logFilePath) {
            super(control, _logFilePath);
        }

        public void write(byte m) throws IOException {
            super.write(m);
            this.textControl.scroll2last();
        }

        public void write(byte[] m, int f, int t) throws IOException {
            super.write(m, f, t);
            this.textControl.scroll2last();
        }
    }
}

