/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.logtextarea;

import com.istech21.widget.logtextarea.AbstractLogComponent;
import com.istech21.widget.logtextarea.LogComponentOutputStream;
import com.istech21.widget.logtextarea.TeeStream;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class LogTextPane
extends JTextPane
implements AbstractLogComponent {
    private PrintStream logStream = null;
    public PrintStream[] old_out = null;
    boolean isOn = false;
    private String savedLogFilePath = null;
    static final int CHARACTER = 1;
    static final int PARAGRAPH = 2;
    static final int LOGICAL = 3;

    public void clear() {
        super.setText("");
    }

    public void setLogStram(PrintStream _ls) {
        if (this.isOn) {
            this.off();
        }
        this.logStream = _ls;
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public LogTextPane(String logPath) {
        this.setContentType("text/html");
        this.old_out = LogTextPane.register(this, logPath);
        this.savedLogFilePath = logPath;
    }

    public int scroll2last() {
        int len = this.getDocument().getLength();
        this.setCaretPosition(len);
        return len;
    }

    public void append(String s) {
        this.append(Color.red, s);
    }

    public void append(Color c, String s) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        int len = this.scroll2last();
        this.setCharacterAttributes(aset, false);
        this.replaceSelection(s);
    }

    public LogTextPane() {
        this((String)null);
    }

    public void on() {
        if (!this.isOn) {
            PrintStream[] out_oldnew = LogTextPane.register(this, this.savedLogFilePath);
            this.old_out = new PrintStream[]{out_oldnew[0], out_oldnew[1]};
            this.logStream = out_oldnew[2];
            this.isOn = true;
        }
    }

    private static void registerPopup(JTextPane textPane) {
        int i;
        Style style = textPane.addStyle("Red", null);
        StyleConstants.setForeground(style, Color.red);
        style = textPane.addStyle("Red Underline", style);
        StyleConstants.setUnderline(style, true);
        style = textPane.addStyle("24pts", null);
        StyleConstants.setFontSize(style, 24);
        style = textPane.addStyle("12pts", null);
        StyleConstants.setFontSize(style, 12);
        style = textPane.addStyle("Italics", null);
        StyleConstants.setItalic(style, true);
        style = textPane.addStyle("Bold", null);
        StyleConstants.setBold(style, true);
        JTextPane c = textPane;
        DefaultStyledDocument doc = (DefaultStyledDocument)textPane.getDocument();
        ArrayList l = new ArrayList();
        Enumeration<?> _enum = doc.getStyleNames();
        while (_enum.hasMoreElements()) {
            l.add(_enum.nextElement());
        }
        Collections.sort(l);
        final JPopupMenu menu = new JPopupMenu();
        JMenu submenu = new JMenu("Character");
        for (i = 0; i < l.size(); ++i) {
            submenu.add(new JMenuItem(new DoStyleAction((String)l.get(i), 1)));
        }
        menu.add(submenu);
        submenu = new JMenu("Paragraph");
        for (i = 0; i < l.size(); ++i) {
            submenu.add(new JMenuItem(new DoStyleAction((String)l.get(i), 2)));
        }
        menu.add(submenu);
        submenu = new JMenu("Logical");
        for (i = 0; i < l.size(); ++i) {
            submenu.add(new JMenuItem(new DoStyleAction((String)l.get(i), 3)));
        }
        menu.add(submenu);
        textPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }

    private static PrintStream[] register(LogTextPane txtConsole, String logFilePath) {
        TeeStream out = new TeeStream(new PrintStream(new MyTextPaneOutputStream(txtConsole, logFilePath)), new PrintStream(System.out));
        PrintStream[] old = new PrintStream[3];
        old[0] = System.out;
        System.setOut(out);
        old[1] = System.err;
        System.setErr(out);
        System.err.println("#Start dumping STDIO/STDERR");
        old[2] = out;
        old[1].println("Successfully redirected output to " + txtConsole);
        return old;
    }

    private static void restore(PrintStream[] old) {
        System.setOut(old[0]);
        System.setErr(old[1]);
    }

    public void off() {
        if (this.isOn) {
            LogTextPane.restore(this.old_out);
            this.isOn = false;
        }
    }

    private static class MyTextPaneOutputStream
    extends LogComponentOutputStream {
        private AbstractLogComponent textControl;

        public MyTextPaneOutputStream(LogTextPane control, String _logFilePath) {
            super(control, _logFilePath);
        }

        public void write(byte m) throws IOException {
            super.write(m);
            this.textControl.scroll2last();
        }

        public void write(byte[] m, int f, int t) throws IOException {
            super.write(m, f, t);
            this.textControl.scroll2last();
        }
    }

    public static class DoStyleAction
    extends StyledEditorKit.StyledTextAction {
        int type;

        public DoStyleAction(String styleName, int type) {
            super(styleName);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            JTextPane c = (JTextPane)this.getEditor(e);
            if (c != null) {
                String styleName = e.getActionCommand();
                StyledDocument doc = (StyledDocument)c.getDocument();
                switch (this.type) {
                    case 1: {
                        c.setCharacterAttributes(doc.getStyle(styleName), true);
                        break;
                    }
                    case 2: {
                        c.setParagraphAttributes(doc.getStyle(styleName), true);
                        break;
                    }
                    case 3: {
                        c.setLogicalStyle(doc.getStyle(styleName));
                    }
                }
            }
        }
    }
}

