/*
 * Decompiled with CFR 0.152.
 */
package com.istech21.widget.logtextarea;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;

public class TextAreaOutputStream
extends OutputStream {
    private JTextArea textControl;
    private String logFilePath = null;
    private BufferedWriter logFileOut = null;

    public TextAreaOutputStream(JTextArea control, String _logFilePath) {
        System.out.println("DEPRECATED");
        this.textControl = control;
        this.logFilePath = _logFilePath;
        try {
            if (this.logFilePath != null) {
                this.logFileOut = new BufferedWriter(new FileWriter(this.logFilePath, true));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(byte[] m, int f, int t) throws IOException {
        String line = new String(m, f, t);
        this.textControl.append(line);
        if (this.logFileOut != null) {
            this.logFileOut.write(line);
        }
        line = null;
    }

    public void write(byte[] m) throws IOException {
        this.write(m, 0, m.length);
    }

    public void write(int b) throws IOException {
        this.textControl.append(String.valueOf((char)b));
        if (this.logFileOut != null) {
            this.logFileOut.write(b);
        }
    }

    public void flush() throws IOException {
        super.flush();
        if (this.logFileOut != null) {
            this.logFileOut.flush();
        }
    }

    public void close() throws IOException {
        super.close();
        try {
            System.out.println("will close");
            if (this.logFileOut != null) {
                this.logFileOut.newLine();
                this.logFileOut.write("#Terminate dumping STDIO/STDERR");
                this.logFileOut.newLine();
                this.logFileOut.flush();
                this.logFileOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

