package com.istech21.snpanalyzer2free.deskapp;



import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;

import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import com.istech21.snpanalyzer2free.AppletViewer;
import com.istech21.snpanalyzer2free.ExternalFilePathProvider;
import com.istech21.snpanalyzer2free.Snpanalyzer2;



public class StandaloneMain {
	
	public static void InitProgramFolder(){
		ExternalFilePathProvider.SetEnforedRuntimeBase(new File("runtime").getAbsolutePath());
	}
	

	public static void main(String []args){
		System.err.println("StandaloneMain.main");
		
		
		if(!new File("temp").exists()) new File("temp").mkdirs();
		System.setProperty("java.io.tmpdir",new File("temp").getAbsolutePath()+"/");
		
		
		InitProgramFolder();
		

		AppletViewer.main(args);
		
		System.err.println("StandaloneMain:replace temp directory to " + new File("temp").getAbsolutePath());
		System.err.println("StandaloneMain:replace Runtime directory to " + new File("runtime").getAbsolutePath());
		
		Frame [] allFrames = Frame.getFrames();
		AppletViewer avInstance = null;
		Snpanalyzer2 asInstance = null;
		for (Frame frame : allFrames) {
//			System.out.println(frame);
			if(frame instanceof AppletViewer){
				avInstance = (AppletViewer) frame;
				System.out.println("StandaloneMain:Found 1.av");
			}
		}

		
		if(avInstance!=null)
		for (Component cmp : avInstance.getContentPane().getComponents()) {
			if(cmp instanceof Snpanalyzer2){
				asInstance = (Snpanalyzer2) cmp;
				System.out.println("StandaloneMain:Found 2.as");
			}
		}
		
		
		if(asInstance!=null){
			System.out.println("StandaloneMain:Replacing help click listener");
			asInstance.hLinkManger = new HyperlinkListener(){
				public void hyperlinkUpdate(HyperlinkEvent evt){
				    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				      try {
	//			    	  System.out.println(evt.getURL().toURI());
	//			        	JOptionPane.showMessageDialog(null,
	//					              "open " + evt.getURL().toURI());
	
				      	Desktop.getDesktop().browse(evt.getURL().toURI());
				      }
				      catch (Exception e) {      
				      	e.printStackTrace();
			        	JOptionPane.showMessageDialog(null,
					              "Could not open URL " + evt.getURL());
				      } 
				    }
				}
			};
			
			String demoUrl = htmlBase +  "/intro.html";
			asInstance.ShowHTML(demoUrl);
		}
		_RemoteLog();
	}
	
	
	private static void _RemoteLog(){
		try {
			new Thread(){
				@Override
				public void run() {
					System.out.println("StandaloneMain:Sending execution log to http://snp.istech21.com");
					String userName = System.getProperty("user.name");
					String userCountry = System.getProperty("user.country");
					HTTP.send(userName,userCountry);
				}
			}.start();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	//http://snp.istech21.com/snpanalyzer/2.0/webstart/exelog.do?user=Lee.YB&country=KR

	private static String htmlBase = 	"http://snp.istech21.com/snpanalyzer/2.0/webstart";
	public static class HTTP {
		//fail safe. just log exe frequency
		static boolean send(String userName,String userCountry){
			try{
				
				String logBase = htmlBase + "/exelog.do";
				
				if(userName==null || userName.length()==0) userName = "guest";
				userName = URLEncoder.encode(userName, "UTF-8");
				
				if(userCountry==null || userCountry.length()==0) userCountry = "unknown";
				userCountry = URLEncoder.encode(userCountry, "UTF-8");
				
				//HTTP-GET  α . ȭ迡 ̵ raw  
				String fullServletUrl = logBase + "?user=" + userName + "&country="+userCountry;
				System.out.println(fullServletUrl);
				
				URL url = new URL(fullServletUrl);
				BufferedReader in = new BufferedReader(new     InputStreamReader(url.openStream()));
	            String str;
	            StringBuilder sb = new StringBuilder(100);
	            while ((str = in.readLine()) != null) {
	                sb.append(str);
	            }
	            in.close();
	            //System.out.println(sb);
	            return true;
			}catch(Exception ig){
				//ig.printStackTrace();
				return false;
			}
	            
		}
	}	
}
